// Filename:	bbsmon.h
// Contents:	the object definition for the bbsmon object
// Author:	Greg Shaw
// Created:	5/22/95

#ifndef _BBSMON_H_
#define _BBSMON_H_

#include "bbshdr.h"		// other definitions


// definitions
#define BBSMON_REFRESH		10	// 10 seconds
#define BBSMON_LASTTIMEOUT	30	// higher priority messages are
					// timed out in 30 seconds

// message definitions
#define BBSMON_POLL		"1"	// normal 'poll'

// Structure:  BBSUser
// Contents:   data structure to record the valid information for a user
//		while in 'bbsmon' mode.
// Author:     Gregory Shaw
// Created:    5/22/95

typedef struct bbsuser
{
	char 	user[MAX_LOGIN_LENGTH];		// login name
	char	ttyname[50];			// tty name
	char	doing[40];			// what the user is doing
	char	host[20];			// host the user is on
	int	timelimit;			// timelimit for user
	time_t	logon;				// logon time
	time_t	last_report;			// last report time
	struct bbsuser *next;			// next record in list
} BBSUser;

// Object:	bbsmon
// Purpose:	encapsulate the sysop bbsmoning functions
// Attributes:	userlist - list of users on the BBS at this time
// Methods:	line_bbsmon 	- display a bbsmoning screen.  Updated
//			periodically.
//		boot_user	- log a user out of the BBS
// Author:	Gregory Shaw
// Created:	5/22/95

class bbsmon:public language
{
	BBSUser	*userlist;	//	list of users
	bbsipc	broadipc;		// broadcast IPC receiver
	bbsipc	ipcobj;          // bbsmon IPC object
	double	lnow,l5min,l15min;	// load average information
	long	uptime;			// system uptime
	int	add_user(BBSUser *user);	// add a user to the list
	int	del_user(BBSUser *old);	// delete a user from the list
	int	expire_users(void);		// expire users from the list
	int	get_load(void);		// get system load
	int	get_uptime(void);		// get system uptime
	char	*check_broadcast(void);	// check for broadcasts
	int	check_private(char *msg, int respond);	// check for private chat
public:
	bbsmon();		//	constructor
	~bbsmon();		//	destructor
	int	boot_user(int how);	// nuke a user
	int	line_bbsmon(void);	// watch the bbs in action
	int	nuke_list(void);	// delete entire list
	int	update_rec(BBSUser *rec);	// update/add a record to the list
};

#endif	// _BBSMON_H_
