// Filename:   bbsint.h
// Contents:   the bbs interface object definition
// Author:     Greg Shaw
// Created:        7/12/93

/*
This file is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option) any
later version.

In addition to the permissions in the GNU General Public License, the
Free Software Foundation gives you unlimited permission to link the
compiled version of this file with other programs, and to distribute
those programs without any restriction coming from the use of this
file.  (The General Public License restrictions do apply in other
respects; for example, they cover modification of the file, and
distribution when not linked into another program.)

This file is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef _BBSINT_H_
#define _BBSINT_H_

// Object:     bbsint
// Purpose:        interface the bbs to the user.  Input/output.
// Attributes:
//     cur_colors[2];       current screen colors (0 - fore, 1 - back)
//     cur_pos[2];      current position of cursor
// Methods:        gstr - get a string from the user
//             gch - get a character from the user
//                 sstr - send a string to the user
//                 sstrcr - send a string to the user (with cr)
//             char_avail - is a character available for reading?
//             redf - go to red foreground
//             bluef - go to blue foreground
//                 greenf - go to green foreground
//             redb - go to red background
//             blueb - go to blue background
//             greenb - go to green background
//             cr - just send carriage return
//             connect_monitor - try to connect to monitor
// Author:     Greg Shaw
// Created:        7/12/93

class bbsint: public sysexec
{
	struct termios rbuf;        // termio settings (for regular io)
	char   tstate;              // terminal state - char or reg.
	public:

		bbsint();               // constructor
		// poll for character available
	int	char_avail(int who, int wait);
	int	connect_monitor(void);  // attempt to connect to monitor process
	void 	cr(void);          // send carriage return to user
	char 	gch(int wait);     // get a character from user
	void 	sch(char ch);      // send character to user
		// get a string from the user
	int	gstr(char *str, int maxlen);
	int	gstr_starsecho(char *str, int maxlen);
	int	sstr(char *str);        // send character
	int	sstrcr(char *str);      // send character with cr
	int	sysopstrcr(char *str);  // send character with cr to sysop only.
		// setup terminal mode for nonblock reads
	void	term_mode(int type);
};


#endif                          // _BBSINT_H_







