/* From iioobj.gstr file "spells.pas" */

#ifndef _SPELLS_C_
#define _SPELLS_C_

#include "bf.h"

void destroy_castle_spell()
{
  Castle *cptr, *cptr2, *cptr1;
  Player *uptr;
  long dum;
  char name[32];
  boolean found;
  char STR3[256];


  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  if (uptr->descas < 1) {
    ioobj.sstrcr("Milord!  You do not have any destroy castle scrolls");
    ioobj.sstrcr("You must get some before the spell may be used.");
  } else {
    uptr->descas--;
    if (abs(rand() % 100) < 20*(theoptions.difficulty/4+1)) {
      ioobj.sstrcr("Your mages struggle to complete the spell.");
      ioobj.sstrcr("but it is too difficult for them.  The spell");
      dum = abs(rand() % uptr->armysize) + 1;
      sprintf(STR3, "backfires.  In the backlash, you lose %ld men.", dum);
      ioobj.sstrcr(STR3);
      uptr->armysize -= dum;
    } else {
      ioobj.sstrcr("Your mages struggle with the very difficult spell..");
      ioobj.sstrcr("They succeed. ");
      ioobj.sstrcr("An entire host of daemons appears in front of you.");
      ioobj.sstrcr("The leader, the meanest daemon you've ever seen, steps up to you.");
      ioobj.sstrcr(
	"due to the spell, we will not attack you.  Count yourself lucky, adventurous scum.");
      ioobj.sstrcr("What is the name of the foul castle you wish destroyed?");
      ioobj.sstr(":");
      strcpy(name,"");
      ioobj.gstr(name, 31L);
      if (!find_castle_by_n(name, &cptr))
	ioobj.sstrcr("Milord, there is no castle by that name.");
      else {
	if (cptr->alliance != 99) {
	  found = false;
	  cptr1 = castles;
	  while (cptr1 != NULL && strcmp(cptr1->name, name)) {
	    cptr2 = cptr1;
	    cptr1 = cptr1->next;
	  }
	  if (cptr1 == NULL)
	    ioobj.sstrcr("The daemons were unable to find the castle.");
	  else {
	    if (cptr1 == castles)
	      castles = cptr1->next;
	    cptr2->next = cptr1->next;
	    free(cptr1);
	    ioobj.sstrcr("The daemons march away.   After three days and three nights,");
	    ioobj.sstrcr("you see the host of daemons returning.  It has less than half of");
	    ioobj.sstrcr("the original troops.  The leader comes up to you curtly.");
	    ioobj.sstrcr("\"Your enemies' castle has been razed to the ground.\"");
	    ioobj.sstrcr(
	      "The spell ends at that point, and the entire host fades before your eyes.");
	  }
	  ioobj.waitcr();
	} else {
	  ioobj.sstrcr("You see a bright band of blue appear in front of you.");
	  ioobj.sstrcr("It absorbs the power of the spell.");
	  ioobj.sstrcr("You hear a disembodied voice say: \"Keeper castles are forbidden.\"");
	  ioobj.sstrcr("The light and the voice both leave.");
	}
      }
    }
  }
  ioobj.waitcr();
}

void do_spell(Player **uptr)
{
  char c[256];

  ioobj.clear_scr();
  if ((*uptr)->teleport <= 0 && (*uptr)->map <= 0 &&
      (*uptr)->killer <= 0 && (*uptr)->steal <= 0 &&
      (*uptr)->descas <= 0) {
    ioobj.sstrcr("Milord!  Your mages have no spells to work with.");
    ioobj.sstrcr("You must purchase some spells before you can use them.");
    ioobj.waitcr();
    return;
  }
  ioobj.sstrcr("Your mages have the following spells.");
  ioobj.sstrcr("Choose the number of the spell to cast it.");
  ioobj.sstrcr("Press return to exit");
  if ((*uptr)->teleport > 0)
    ioobj.sstrcr("1. Teleport");
  if ((*uptr)->map > 0)
    ioobj.sstrcr("2. Magic Map");
  if ((*uptr)->killer > 0)
    ioobj.sstrcr("3. Dark Assassin");
  if ((*uptr)->descas > 0)
    ioobj.sstrcr("4. Destroy Castle");
  if ((*uptr)->steal > 0)
    ioobj.sstrcr("5. Steal Castle");
  ioobj.sstr("Your Choice? ");
      strcpy(c,"");
  ioobj.gstr(c, 1L);
  switch (c[0]) {

  case '1':
    teleport_spell(*uptr);
    break;

  case '2':
    map(uptr);
    break;

  case '3':
    kill_prince(uptr);
    break;

  case '4':
    destroy_castle_spell();
    break;

  case '5':
    steal_castle();
    break;
  }
}


void kill_prince(Player **player)
{
  Player *uptr;
  char s[256], STR1[256];
  char STR3[256];
  int count;

  ioobj.clear_scr();
  if ((*player)->killer <= 0) {
    ioobj.sstrcr("Milord!  You are completely out of kill");
    ioobj.sstrcr("scrolls.  You may pick some up at the nearest friendly castle");
    ioobj.waitcr();
    return;
  }
  if (abs(rand() % 100) < 20*(theoptions.difficulty/4+1)) {
    ioobj.sstrcr("When your mages read the spell, nothing happens.");
    ioobj.sstrcr("Maybe you won't buy the next one at a bargain spell store.");
    (*player)->killer--;
    ioobj.waitcr();
    return;
  }
  ioobj.sstrcr("When your mages read the spell, a dark demon teleports ");
  ioobj.sstrcr("to right in front of you with a large explosion.  The demon is the ");
  ioobj.sstrcr("largest, meanest looking creature you've ever seen.  You're glad ");
  ioobj.sstrcr("you've got mages to protect you from such creatures.");
  ioobj.sstrcr("the demon looks at you, and says:  Who is it that I am supposed to kill?");
  ioobj.sstr(":");
      strcpy(s,"");
  ioobj.gstr(s, 31L);
  sprintf(s, "%.30s", strcpy(STR1, s));
  if (!find_player_by_alias(s, &uptr)) {
    ioobj.sstrcr("The demon's eyes lose focus.  He says:  there is nobody by that");
    ioobj.sstrcr("name on this plane.  Call me when you've got a real mission for");
    ioobj.sstrcr("one such as me.");
    (*player)->killer--;
    ioobj.waitcr();
    return;
  }
  sprintf(STR3, "The demon asks:  are you sure you would like me to destroy %s? ", s);
  ioobj.sstr(STR3);
  if (yesno()) {
    count = abs(rand() % 50*(theoptions.difficulty/4+1));
    if (count > 25) {
      ioobj.sstrcr("The demon quickly teleports.  After just a few seconds, he pops back ");
      ioobj.sstrcr("into existence right in front of you.  He says:  It has been done.  ");
      ioobj.sstrcr("Your mages then say as one: \"Begone, demon, your work is done\".");
      ioobj.sstrcr("The demon disappears.");
      (*player)->killer--;
      uptr->killed = uptr->armysize;
      uptr->dead = true;
      uptr->armysize = 1;
      strcpy(uptr->killedby, (*player)->alias);
    } else {
      ioobj.sstrcr("The demon's eyes lose focus.  ");
      ioobj.sstrcr("He says: that is too much work.  Instead, how about I kill you!");
      ioobj.sstrcr("You never had a chance.  You are dead.  ");
      ioobj.sstrcr("Perhaps next time, you will think twice before calling demons.");
      (*player)->killed = (*player)->armysize;
      (*player)->dead = true;
      (*player)->armysize = 1;
      strcpy((*player)->killedby, "Etrigan");
    }
  }
  ioobj.waitcr();
}

void mage_guild(boolean castle, Player **player)
{
  char s[256], c[256], totalstr[256];
  long chose, numspells, totalchoices;
  char STR2[256], STR3[256];


  ioobj.clear_scr();
  if (castle) {
    ioobj.sstrcr("You stand in front of a large, heavily built building.  Amber ");
    ioobj.sstrcr("smoke rolls from the front door of the building. ");
    ioobj.sstrcr("Strange.  But, you have heard of the wondrous spells");
    ioobj.sstrcr("to be found in the building.");
    ioobj.sstrcr("You enter, to be confronted by a red-robed mage.");
    ioobj.sstrcr("from the deferance your journeyman mages give ");
    ioobj.sstrcr("this man, you can tell he is a high mage.  ");
    ioobj.sstrcr("He speaks:  Welcome, your highness, to the dark grotto,");
    ioobj.sstrcr("You think to yourself:  yet another outpost of the Magi..");
    ioobj.sstrcr("The mage continues to speak");
    ioobj.sstrcr("Here you may buy spells of wondrous nature.");
    ioobj.sstrcr("He hands you a paper:  Here are the available spells.");
    sprintf(STR3, "You have %ld gold pieces.", (*player)->gold);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr("And the following spells:   ");
    sprintf(totalstr, "%d/%d/%d/%d/%d/%d/%d", (*player)->map,(*player)->dmons,
    	(*player)->mweapon,(*player)->descas,(*player)->mwarriors,
	(*player)->killer,(*player)->steal);
    ioobj.sstrcr(totalstr);
    ioobj.sstrcr("Spell                                     Price (in g.p.)");
    ioobj.sstrcr("_________________________________________________________");
    ioobj.sstrcr("<cr> no sale");
    sprintf(STR3,"1. Teleport         %30ld",(long)300*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"2. Magic Map        %30ld",(long)1000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"3. Destroy Monsters %30ld",(long)1500*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    totalchoices = 5;
    sprintf(STR3,"4. Magic Weapon     %30ld",(long)2000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"5. Destroy Castle   %30ld",(long)20000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    if ((*player)->level > 11) {
      sprintf(STR3,"6. Magic Warriors %30ld",(long)6000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
      totalchoices++;
    }
    if ((*player)->level > 14) {
      sprintf(STR3,"7. Dark Assassin  %30ld",(long)10000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
      totalchoices++;
    }
    if ((*player)->level > 21) {
      sprintf(STR3,"8. Steal Castle   %30ld",(long)15000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
      totalchoices++;
    }
    ioobj.sstr("Your Choice? ");
      strcpy(c,"");
    ioobj.gstr(c, 1L);
    stringtonum(c, &chose);
    if (chose > totalchoices || chose < 0) {
      ioobj.sstrcr("The mage says:  Sorry, your Highness, but you must choose an ");
      ioobj.sstrcr("item from the list.");
    } else {
      switch (chose) {

      case 1:
	if ((*player)->gold < 500*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  sprintf(STR2, "You currently have %d teleport scrolls", (*player)->teleport);
	  ioobj.sstrcr(STR2);
	  ioobj.cr();
	  ioobj.sstr("How many teleport scrolls would you like, milord? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &numspells);
	  if (numspells * 500*theoptions.difficulty > (*player)->gold)
	    ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	  else {
	    if (numspells < 2) {
	      ioobj.sstrcr("The mage hands you the teleport scroll, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= 500*theoptions.difficulty;
	      (*player)->teleport++;
	    } else {
	      ioobj.sstrcr("The mage hands you the teleport scrolls, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= numspells * 500*theoptions.difficulty;
	      (*player)->teleport += numspells;
	    }
	  }
	}
	break;

      case 2:
	if ((*player)->gold < 1000*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  sprintf(STR3, "You currently have %d mapping scrolls", (*player)->map);
	  ioobj.sstrcr(STR3);
	  ioobj.cr();
	  ioobj.sstr("How many magic map scrolls would you like, milord? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &numspells);
	  if (numspells * 1000*theoptions.difficulty > (*player)->gold)
	    ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	  else {
	    if (numspells < 2) {
	      ioobj.sstrcr("The mage hands you the magic map scroll, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= 1000*theoptions.difficulty;
	      (*player)->map++;
	    } else {
	      ioobj.sstrcr("The mage hands you the magic map scrolls, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= numspells * 1000*theoptions.difficulty;
	      (*player)->map += numspells;
	    }
	  }
	}
	break;

      case 3:
	if ((*player)->gold < 1500*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  sprintf(STR2, "You currently have %d destroy monster scrolls", (*player)->dmons);
	  ioobj.sstrcr(STR2);
	  ioobj.cr();
	  ioobj.sstr("How many destroy monsters scrolls would you like, milord? ");
      strcpy(s,"");
	  ioobj.gstr(s, 5L);
	  stringtonum(s, &numspells);
	  if (numspells * 1500*theoptions.difficulty > (*player)->gold)
	    ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	  else {
	    if (numspells < 2) {
	      ioobj.sstrcr("The mage hands you the destroy monsters scroll, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= 5000*theoptions.difficulty;
	      (*player)->dmons++;
	    } else {
	      ioobj.sstrcr("The mage hands you the destroy monsters scrolls, and thanks you");
	      ioobj.sstrcr("for your business.");
	      (*player)->gold -= numspells * 1500*theoptions.difficulty;
	      (*player)->dmons += numspells;
	    }
	  }
	}
	break;

      case 4:
	if ((*player)->gold < 2000*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  ioobj.sstrcr("The mage hands you a magic weapon scroll, and thanks you");
	  ioobj.sstrcr("for your business.");
	  (*player)->gold -= 2000*theoptions.difficulty;
	  (*player)->mweapon++;
	}
	break;

      case 5:
	if ((*player)->gold < 20000*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  ioobj.sstrcr("The mage hands you a destroy castle scroll, and thanks you");
	  ioobj.sstrcr("for your business.");
	  (*player)->gold -= 20000L*theoptions.difficulty;
	  (*player)->descas++;
	}
	break;

      case 6:
	if ((*player)->gold < 6000*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  ioobj.sstrcr("The mage hands you a magic warriors scroll, and thanks you");
	  ioobj.sstrcr("for your business.");
	  (*player)->gold -= 6000*theoptions.difficulty;
	  (*player)->mwarriors++;
	}
	break;

      case 7:
	if ((*player)->gold < 10000*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  ioobj.sstrcr("The mage hands you a kill scroll, and thanks you");
	  ioobj.sstrcr("for your business.");
	  (*player)->gold -= 10000*theoptions.difficulty;
	  (*player)->killer++;
	}
	break;

      case 8:
	if ((*player)->gold < 15000L*theoptions.difficulty)
	  ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	else {
	  ioobj.sstrcr("The mage hands you a steal castle scroll, and thanks you");
	  ioobj.sstrcr("for your business.");
	  (*player)->gold -= 15000L*theoptions.difficulty;
	  (*player)->steal++;
	}
	break;

      default:
	ioobj.sstrcr("You don't feel like buying any spells. ");
	break;
      }
    }
  } else {
    ioobj.sstrcr("You walk up to a small shop, over which hangs the pentagram");
    ioobj.sstrcr("of the magi.  You think to yourself:  Those magi are everywhere.");
    ioobj.sstrcr("But, since you need the spells that may be purloined within, ");
    ioobj.sstrcr("you enter the small building.");
    ioobj.sstrcr("Inside the building is all sorts of arcane machinery, and strange ");
    ioobj.sstrcr("concoctions.  Strange stuff.  You walk up to the counter, and a small");
    ioobj.sstrcr("Mage speaks: Welcome your highness, to the Dark Cavern, ");
    ioobj.sstrcr("purveyers of magic.  Because of the small nature of ");
    ioobj.sstrcr("establishment, we only offer a few spells for the common folk.");
    ioobj.sstrcr("He hands you a paper:  Here are the available spells.");
    sprintf(STR3, "You have %ld gold pieces.", (*player)->gold);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr("And the following spells:   ");
    sprintf(totalstr, "%d/%d/%d/%d/%d/%d/%d", (*player)->map,(*player)->dmons,
    	(*player)->mweapon,(*player)->descas,(*player)->mwarriors,
	(*player)->killer,(*player)->steal);
    ioobj.sstrcr(totalstr);
    ioobj.sstrcr("Spell                                     Price (in g.p.)");
    ioobj.sstrcr("_________________________________________________________");
    ioobj.sstrcr("<cr> no sale");
    sprintf(STR3,"1. Teleport          %30ld",(long)400*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"2. Magic map         %30ld",(long)750*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    sprintf(STR3,"3. Destroy monsters  %30ld",(long)1000*theoptions.difficulty);
    ioobj.sstrcr(STR3);
    totalchoices = 3;
    if ((*player)->level > 11) {
      sprintf(STR3,"4. magic weapon    %30ld",(long)1500*theoptions.difficulty);
    ioobj.sstrcr(STR3);
      totalchoices++;
    }
    ioobj.sstr("Your choice? ");
      strcpy(c,"");
    ioobj.gstr(c, 1L);
    if (*c != '\0') {
      stringtonum(c, &chose);
      if (chose > totalchoices || chose < 0) {
	ioobj.sstrcr("The mage says:  I am sorry, your highness, but you must choose an ");
	ioobj.sstrcr("item from the list.");
      } else {
	switch (chose) {

	case 1:
	  if ((*player)->gold < 400*theoptions.difficulty)
	    ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	  else {
	    sprintf(STR2, "You currently have %d teleport scrolls", (*player)->teleport);
	    ioobj.sstrcr(STR2);
	    ioobj.cr();
	    ioobj.sstr("How many teleport scrolls would you like, milord? ");
      strcpy(s,"");
	    ioobj.gstr(s, 2L);
	    stringtonum(s, &numspells);
	    if (numspells * 400*theoptions.difficulty > (*player)->gold)
	      ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	    else {
	      if (numspells < 2) {
		ioobj.sstrcr("The mage hands you the teleport scroll, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= 400*theoptions.difficulty;
		(*player)->teleport++;
	      } else {
		ioobj.sstrcr("The mage hands you the teleport scrolls, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= numspells * 400*theoptions.difficulty;
		(*player)->teleport += numspells;
	      }
	    }
	  }
	  break;

	case 2:
	  if ((*player)->gold < 750*theoptions.difficulty)
	    ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	  else {
	    sprintf(STR3, "You currently have %d mapping scrolls", (*player)->map);
	    ioobj.sstrcr(STR3);
	    ioobj.cr();
	    ioobj.sstr("How many magic map scrolls would you like, milord? ");
      strcpy(s,"");
	    ioobj.gstr(s, 2L);
	    stringtonum(s, &numspells);
	    if (numspells * 750*theoptions.difficulty > (*player)->gold)
	      ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	    else {
	      if (numspells < 2) {
		ioobj.sstrcr("The mage hands you the magic map scroll, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= 750*theoptions.difficulty;
		(*player)->map++;
	      } else {
		ioobj.sstrcr("The mage hands you the magic map scrolls, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= numspells * 750*theoptions.difficulty;
		(*player)->map += numspells;
	      }
	    }
	  }
	  break;

	case 3:
	  if ((*player)->gold < 1000*theoptions.difficulty)
	    ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	  else {
	    sprintf(STR2, "You currently have %d destroy monsters scrolls", (*player)->dmons);
	    ioobj.sstrcr(STR2);
	    ioobj.cr();
	    ioobj.sstr("How many destroy monsters scrolls would you like, milord? ");
      strcpy(s,"");
	    ioobj.gstr(s, 5L);
	    stringtonum(s, &numspells);
	    if (numspells * 1000*theoptions.difficulty > (*player)->gold)
	      ioobj.sstrcr("Sorry, milord, but you do not have the gold for that many items.");
	    else {
	      if (numspells < 2) {
		ioobj.sstrcr("The mage hands you the destroy monsters scroll, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= 1000*theoptions.difficulty;
		(*player)->dmons++;
	      } else {
		ioobj.sstrcr(
		  "The mage hands you the destroy monsters scrolls, and thanks you");
		ioobj.sstrcr("for your business.");
		(*player)->gold -= numspells * 1000*theoptions.difficulty;
		(*player)->dmons += numspells;
	      }
	    }
	  }
	  break;

	case 4:
	  if ((*player)->gold < 1500*theoptions.difficulty)
	    ioobj.sstrcr("Sorry, milord, but you cannot afford this item.");
	  else {
	    ioobj.sstrcr("The mage hands you a magic weapon scroll, and thanks you");
	    ioobj.sstrcr("for your business.");
	    (*player)->gold -= 1500*theoptions.difficulty;
	    (*player)->mweapon++;
	  }
	  break;

	default:
	  ioobj.sstrcr("You don't feel like buying any spells. ");
	  break;
	}
      }
    }
  }
  ioobj.sstrcr("You leave the shop.");
  ioobj.waitcr();
}

void map(Player **player)
{
  long row, column, col;
  Player *uptr;
  char s[256];
  char tmpstr[10];
  Castle *cptr;
  Village *vptr;
  Army *arptr;
  int found;

  ioobj.clear_scr();
  if ((*player)->map <= 0) {
    ioobj.sstrcr("Milord!  You do not have the neccesary scroll for this ");
    ioobj.sstrcr("spell.  Magic mapping requires a scroll.");
    ioobj.waitcr();
    return;
  }
  (*player)->map--;
  if (abs(rand() % 100) < 15*(theoptions.difficulty/2+1)) {
    ioobj.sstrcr("Your mages read the scroll, but, sadly, nothing happens.");
    ioobj.waitcr();
    return;
  }
  row = currentsector - (long)floor(4 * (sqrt((double)boardsize) + 1) + 0.5);
  do {
    for (column = row; column <= row + 8; column++) {
      col = column;
      if (col < 0)
	col += boardsize;
      if (col > boardsize)
	col -= boardsize;
      tmpstr[0] = 0;
      found = 0;
      uptr = players;
      while (uptr != NULL)
      {
      	if (uptr->sector == col && !uptr->dead)
		found++;
      	uptr = uptr->next;
      }
      if (found) {
	strcat(tmpstr, "r");
      }
      if (find_castle_in_sector(col, &cptr)) {
	strcat(tmpstr, "c");
      }
      if (find_village_in_sector(col, &vptr)) {
	strcat(tmpstr, "v");
      }
      if (find_army_in_sector(col, &arptr)) {
	strcat(tmpstr, "a");
      }
      sprintf(s, "%3ld:%-4s", col,tmpstr);
      ioobj.sstr(s);
    }
    ioobj.cr();
    row += (long)floor(sqrt((double)boardsize) + 0.5);
  } while (row <=
	   currentsector + (long)floor(4 * (sqrt((double)boardsize) - 1) + 0.5));
  ioobj.sstrcr("legend:");
  ioobj.sstrcr("r : royalty            c: castle          v : village         a: army");
  ioobj.waitcr();
}

void steal_castle()
{
  Castle *cptr;
  Player *uptr, *player;
  long dum;
  char name[32];
  char STR2[256], STR3[256];


  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  if (uptr->steal < 1) {
    ioobj.sstrcr("Milord!  You do not have any steal scrolls");
    ioobj.sstrcr("You must get some before the spell may be used.");
  } else {
    uptr->steal--;
    if (abs(rand() % 100) < 33*(theoptions.difficulty/2+1)) {
      ioobj.sstrcr("Your journeyman mages struggle with the complex spell");
      ioobj.sstrcr("but, it is to no avail.  Something has gone wrong, and the spell ");
      dum = abs(rand() % uptr->armysize) + 1;
      sprintf(STR3, "backfires.  in the backlash, you lose %ld men.", dum);
      ioobj.sstrcr(STR3);
      uptr->armysize -= dum;
    } else {
      ioobj.sstrcr("What is the name of the castle that you so desire, milord?");
      ioobj.sstr(":");
      strcpy(name,"");
      ioobj.gstr(name, 31L);
      if (!find_castle_by_n(name, &cptr))
	ioobj.sstrcr("Milord, there is no castle by that name.");
      else {
	if (cptr->alliance != 99) {
	  if (find_player_by_alias(cptr->alias, &player) &&
	      player->sector == cptr->sector && player->incastle) {
	    ioobj.sstrcr("Your mages struggle with the spell.");
	    ioobj.sstrcr("To no avail! ");
	    ioobj.sstrcr("The spell sends to its target only to shatter on the wards of");
	    ioobj.sstrcr(
	      "the castle.  It appears the owner of the castle is inside, guarding");
	    ioobj.sstrcr("his castle with his mages.");
	    ioobj.sstrcr("Maybe some other time.");
	  } else {
	    strcpy(cptr->oldowner, cptr->alias);
	    strcpy(cptr->alias, uptr->alias);
	    cptr->alliance = uptr->alliance;
	    sprintf(STR2, "Sire, the men of the castle %s wish to ally ", name);
	    ioobj.sstrcr(STR2);
	    ioobj.sstrcr("with you. ");
	    ioobj.sstrcr("You take their offer with a evil grin.");
	  }
	} else {
	  ioobj.sstrcr("You see a bright band of blue appear in front of you.");
	  ioobj.sstrcr("It absorbs the power of the spell.");
	  ioobj.sstrcr("You hear a disembodied voice say: \"Keeper castles are forbidden.\"");
	  ioobj.sstrcr("the light and the voice both leave.");
	}
      }
    }
  }
  ioobj.waitcr();
}

void teleport_spell(Player *uptr)
{
  char c[256];
  long sector;

  ioobj.clear_scr();
  if (uptr->teleport < 1) {
    ioobj.sstrcr("Milord!  your mages do not have the necessary items");
    ioobj.sstrcr("to do a teleport scroll!");
    ioobj.sstrcr("Pick some up when you're in town.");
    ioobj.waitcr();
    return;
  }
  uptr->teleport--;
  if (abs(rand() % 100) < 5*(theoptions.difficulty/2+1)) {
    ioobj.sstrcr("Your journeyman mages attempt to cast");
    ioobj.sstrcr("the spell, but due to some magical interferance,");
    ioobj.sstrcr("the spell fizzles.");
  } else {
    ioobj.sstrcr("Your mages work together to cast the spell.");
    ioobj.sstrcr("They succeed!");
    ioobj.sstrcr("A faerie appears right in front of you.");
    ioobj.sstr("she asks:  where would you like to be taken, milord? ");
      strcpy(c,"");
    ioobj.gstr(c, 5L);
    stringtonum(c, &sector);
    if (sector <= 0 || sector > boardsize) {
      ioobj.sstrcr("She replies:  Milord, you have chosen a sector that");
      ioobj.sstrcr("is not of this plane.  I am not capable of transporting");
      ioobj.sstrcr("you there.");
      ioobj.sstrcr("with that, she pops out of sight. ");
    } else {
      ioobj.sstrcr("The faerie opens a magical portal to another part of ");
      ioobj.sstrcr("the world.  Your army passes through the portal. ");
      ioobj.sstrcr("Exhausted, the faerie vanishes.");
      uptr->sector = sector;
      currentsector = sector;
    }
  }
  ioobj.waitcr();
}

void trap()
{
  long whichtrap;
  Player *uptr;
  long numlost, tmp;
  char STR2[256];
  char STR3[42];
  char STR4[40];
  char STR5[256];
  char c[256];

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  whichtrap = abs(rand() % 10);
  switch (whichtrap) {

  case 0:
    ioobj.sstrcr("Sire!  some of your men found a small cave in this sector.");
    ioobj.sstrcr("While exploring it, they got ambushed by carrion crawlers.");
    ioobj.sstr("I am sorry to report that you lost ");
    numlost = abs(rand() % uptr->armysize / 2) + 1;
    sprintf(STR2, "%ld men.", numlost);
    ioobj.sstrcr(STR2);
    uptr->armysize -= numlost;
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 1:
    ioobj.sstrcr("Sire!  I have grave news!  During our recent journey through");
    ioobj.sstrcr("the swamps, a group of swamp lurkers attacked those men");
    ioobj.sstrcr("in the back of our column.");
    ioobj.sstr("i am sorry to report that you lost ");
    numlost = abs(rand() % uptr->armysize / 2) + 1;
    sprintf(STR2, "%ld men.", numlost);
    ioobj.sstrcr(STR2);
    uptr->armysize -= numlost;
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 2:
    ioobj.sstrcr("You walk into a group of smoky holes in the ground.");
    ioobj.sstrcr("You marvel at the colors in the waters oozing from the ground.");
    ioobj.sstrcr("While you're in your reverie, a volcano chooses this time to erupt.");
    ioobj.sstr("burning lava scorches ");
    numlost = abs(rand() % uptr->armysize / 2) + 1;
    sprintf(STR2, "%ld men.", numlost);
    ioobj.sstrcr(STR2);
    uptr->armysize -= numlost;
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 3:
    ioobj.sstrcr("Upon entering this sector, you find a large group of cannibals.  ");
    ioobj.sstrcr("Being mountainous territory, you'd rather not tangle with them.");
    ioobj.sstrcr("While going around the cannibal group, your men fall into a set of");
    ioobj.sstrcr("people snares.");
    ioobj.sstr("I am sorry to report that you lost ");
    numlost = abs(rand() % uptr->armysize / 2) + 1;
    sprintf(STR2, "%ld men.", numlost);
    ioobj.sstrcr(STR2);
    ioobj.sstrcr("the cannibals will eat good tonight.");
    uptr->armysize -= numlost;
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 4:
    ioobj.sstrcr("You enter a sector of mountainous territory.");
    ioobj.sstrcr("While going through a pass to the other side of the mountains,");
    ioobj.sstrcr("you are attacked by rocs.");
    ioobj.sstr("your men fight off the hungry rocs, but ");
    numlost = abs(rand() % uptr->armysize / 4) + 1;
    sprintf(STR2, "%ld men were stolen to feed the roc chicks.", numlost);
    ioobj.sstrcr(STR2);
    uptr->armysize -= numlost;
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 5:
    ioobj.sstrcr("While traveling through the plains, you encounter a small hut");
    ioobj.sstrcr("a witch walks out of the hut.");
    ioobj.sstrcr("She cackles and says:  Oh, great highness, may I help your ");
    ioobj.sstrcr("men along their way???");
    ioobj.sstr("She casts a small spell which takes ");
    numlost = abs(rand() % uptr->armysize / 4) + 1;
    sprintf(STR2, "%ld men and teleports them to the 193rd dimension.", numlost);
    ioobj.sstrcr(STR2);
    ioobj.sstrcr("Where they are quickly eaten by some REAL monsters.");
    ioobj.sstrcr("You're glad you're not with them.");
    uptr->armysize -= numlost;
    ioobj.sstrcr("She cackles and cackles.  She says:  I am so glad to be of service!");
    ioobj.sstrcr("She disappears along with her shack before you get close enough to");
    ioobj.sstrcr("impale her.");
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    break;

  case 6:
    ioobj.sstrcr("Sire, while we went through that last sector, something");
    ioobj.sstrcr("Happened to our weapons!");
    ioobj.sstrcr("You pull your weapons from their sheaths. indeed, they ");
    ioobj.sstrcr("are in bad shape.  In fact, they dissolve in your hands..");
    ioobj.sstrcr("You hear a demonic voice laugh in the back of your head.");
    ioobj.sstrcr("Damn demons...");
    uptr->weapon = 1;
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->weapon = 1;
      cptr = cptr->next;
    }
    break;

  case 7:
    ioobj.sstrcr("A strange looking private runs up to you..");
    ioobj.sstrcr("Sire, while going through that last stretch of mountains,");
    ioobj.sstrcr("We found a strange pool.  One of the men threw a rock into it, and");
    ioobj.sstrcr("a cloud sprung from it.");
    ioobj.sstrcr("The cloud got bigger and bigger, and then it rained on us!");
    ioobj.sstrcr("Our armor dissolved in the cloud!  ");
    ioobj.sstrcr("You notice that a small cloud follows him.");
    ioobj.sstrcr("Then you notice that all the armor has dissolved from");
    ioobj.sstrcr("the bodies of your warriors.  You have the idiot private ");
    ioobj.sstrcr("whipped for his stupidity, but.. you still have no armor.");
    uptr->armor = 1;
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->armor = 1;
      cptr = cptr->next;
    }
    break;

  case 8:
    ioobj.sstrcr("Sire!");
    ioobj.sstrcr("You notice a tired lieutenant running up to you.");
    ioobj.sstrcr("\"We have found something of interest up ahead.\"");
    ioobj.sstrcr("You follow him up to a crude cross made of some ");
    ioobj.sstrcr("very strange wood.  It seems to be alive. ");
    ioobj.sstrcr("You walk up to the structure.  It has a skull of some creature");
    ioobj.sstrcr("that you can't recognize at its top.  At the juncture of the cross");
    ioobj.sstrcr("is a parchment. ");
    ioobj.sstrcr("You pick up the parchment and start reading..");
    ioobj.sstrcr("It reads:");
    ioobj.sstrcr("To whomever reads this.");
    ioobj.waitcr();
    ioobj.sstrcr("Ha!  Gotcha, you bastard!");
    ioobj.sstrcr("            Sincerely,");
    if (strcmp(players->name, uptr->name)) {
      sprintf(STR3, "          %s", players->name);
      ioobj.sstrcr(STR3);
    } else {
      sprintf(STR4, "        %s", players->next->name);
      ioobj.sstrcr(STR4);
    }
    ioobj.sstrcr("A ring of fire explodes into everything around you.");
    ioobj.sstrcr("You start to feel very strange..");
    ioobj.sstrcr("Then, pop, you find a head upon your shoulders.");
    ioobj.sstrcr("Not normally unusual, but now you've got two!");
    ioobj.sstrcr("Pop! Pop! Pop!");
    ioobj.sstrcr("You've now got five heads, all in a very stylish daisy pattern.");
    ioobj.sstrcr("You look around you, and all of your men are in the same situation.");
    ioobj.sstrcr("You can't decide what to do!  You've got too many heads; ");
    ioobj.sstrcr("None of which has total control.");
    ioobj.sstrcr("Each tries to do it's own thing..");
    ioobj.sstrcr("You fall to the earth, as does your army.");
    ioobj.sstrcr(
      "After three weeks of indecision, you finally figure out what you're going to do.");
    ioobj.waitcr();
    ioobj.sstrcr("You're going to die.");
    ioobj.sstrcr("Your army dies with you.");
    uptr->dead = true;
    uptr->armysize = 1;
    break;

  case 9:
    ioobj.sstrcr("As you move into a mountainous sector, you come through a");
    ioobj.sstrcr("mountain pass.  At the bottom of the pass is a very lush, green valley.");
    ioobj.sstrcr("Looking completely untouched, you see no animals, only green plants.");
    ioobj.sstrcr("There is a sense of serenity in this place.  In fact, it is so serene");
    ioobj.sstrcr("that you fail to notice a monstrous figure to your right.");
    ioobj.sstrcr("When you do notice it, it speaks:");
    ioobj.sstrcr("\"Lowly adventurer, I am Atha, the supreme being on this plane.");
    ioobj.sstrcr("and many others.\" He continues, \"Bow before the might of your master!\"");
    ioobj.sstrcr("What do you do? ");
    ioobj.sstrcr("1.  Run up, bow low, and kiss his feet.");
    ioobj.sstrcr("2.  Plead your case with atha.");
    ioobj.sstrcr("3.  Scream your defiance, and attack atha.");
    ioobj.sstrcr("4.  Retreat, and run like hell.");
    ioobj.sstr("Which? ");
      strcpy(c,"");
    ioobj.gstr(c, 1L);
    switch (c[0]) {

    case '1':
      ioobj.sstrcr("Atha speaks again; \"Scum!  spineless worm!  I stomp on worms!\"");
      ioobj.sstrcr(
	"Which he does.  His giant foot makes a great shadow as it plunges toward you.");
      ioobj.sstrcr("He is far too fast for you.  You become worm food.");
      ioobj.sstrcr("Atha then turns to your army.  he speaks four great words:");
      ioobj.sstrcr("Pionqua, Menaianale, Midlsoen, Yielsidgh!");
      ioobj.sstrcr("Your entire army turns to worms, and slowly crawls away.");
      ioobj.sstrcr("Atha laughs a great laugh, and returns to his business.");
      uptr->dead = true;
      uptr->armysize = 1;
      break;

    case '2':
      ioobj.sstrcr("You beg atha to allow you access to his valley.");
      ioobj.sstrcr("Atha hears your pleas, and speaks:");
      ioobj.sstrcr("\"Bah!  I tire of this game!\"");
      ioobj.sstrcr("He looks at you, and you feel him peering far behind you.");
      ioobj.sstrcr("You feel very strange.  Atha speaks again:");
      ioobj.sstrcr("\"I shall end this game now!\"");
      ioobj.sstrcr("He waves his arms, and you feel the earth shake.");
      ioobj.waitcr();
      save_game();
      exit_game(0);
      break;

    case '3':
      ioobj.sstrcr("You scream your defiance, and order your army to attack");
      ioobj.sstrcr(
	"Atha smiles, and doesn't move.  When you are very close, atha reaches out, ");
      ioobj.sstrcr("and plucks you from the ranks.  Your men are held in stasis");
      ioobj.sstrcr("He speaks: \"Puny creature.  You think you can harm me?\"");
      ioobj.sstrcr("With that he speaks a short spell.");
      ioobj.sstrcr("\"Agmian Tielsid Uidoak Kdlei\"");
      ioobj.sstrcr("You feel him tearing at your soul.");
      ioobj.sstrcr("Your strength disappears, as does your luck, and agility.");
      ioobj.sstrcr("Atha screams \"Now you shall fight just like the puppet you are!\"");
      uptr->str = 1;
      uptr->agi = 1;
      uptr->experience = 0;
      ioobj.sstrcr("Atha then laughs a cruel laugh.  He proceeds to grab a wrinkle suspended");
      ioobj.sstrcr(
	"in space.  He pulls open a dimensional door, and throws your entire army ");
      ioobj.sstrcr("into it.  Sounds of bones snapping, armor rending, and a horrid ");
      ioobj.sstrcr("slurping can be heard.  The strange part is no sound came from");
      ioobj.sstrcr("Your army.");
      ioobj.sstrcr("You have no doubt that your army is beyond dead.");
      uptr->armysize = 1;
      break;

    case '4':
      ioobj.sstrcr("Your army runs as fast as it can back out of the valley.");
      ioobj.sstrcr("You hear atha laugh a deep, and evil laugh.");
      ioobj.sstrcr("His minions, unseen until now, rend your troops.");
      ioobj.sstrcr("You retreat as fast as possible, but");
      ioobj.sstrcr("It is not enough to save your rear guard.");
      tmp = abs(rand() % uptr->armysize);
      sprintf(STR5, "You've lost %ld men.", tmp);
      ioobj.sstrcr(STR5);
      ioobj.sstrcr("But you consider yourself lucky.");
      uptr->armysize -= tmp;
      break;

    default:
      ioobj.sstrcr("Atha takes your indecision as an insult.");
      ioobj.sstrcr("He speaks: \"Lowly creatues, when will you understand");
      ioobj.sstrcr("that you are not the owner of this world?\"");
      ioobj.sstrcr("\"I am!\"");
      ioobj.sstrcr("You are doubtful . ");
      ioobj.sstrcr("Atha reads your mind; \"Ha!  You feel you are above my power!\"");
      ioobj.sstrcr("Atha then lifts your entire army.  He proceeds to take out a knife, and ");
      ioobj.sstrcr(
	"After freezing each member in turn with his frosty breath, whittles each one");
      ioobj.sstrcr("into strange pieces.");
      ioobj.sstrcr("You do not understand his making until he ");
      ioobj.sstrcr("begins assembling the peices.  Atha assembles them into a wall");
      ioobj.sstrcr("of perfectly matching body parts.");
      ioobj.sstrcr("Atha then takes a great breath.  He breathes on the wall,");
      ioobj.sstrcr("instilling life to the entire structure.");
      ioobj.sstrcr( "You do not have time to mourn your men;"); 
      ioobj.sstrcr("as Atha installs you at the top of the wall.");
      ioobj.sstrcr("Atha then puts a scrap of paper on the wall, saying");
      ioobj.sstrcr("\"Beware.  this could be you.\"");
      ioobj.sstrcr("After a time, Atha allows your army, and yourself, to die.");
      ioobj.sstrcr("Indecision is the death of us all.");
      uptr->armysize = 1;
      uptr->dead = true;
      break;
    }
    break;
  }
  ioobj.waitcr();
  ioobj.clear_scr();
}


#endif // _SPELLS_C_
