#ifndef _MISC_C_
#define _MISC_C_

#include "bf.h"


void check_boundaries(int *sector)
{
  if (inmountains) {
    inmountains = !inmountains;
    *sector -= boardsize;
  } else if (*sector > boardsize)
    *sector -= boardsize;
  if (*sector < 1)
    *sector += boardsize;
}

void display_header(void)
{
  long count;
  Player *gptr;
  Army *arptr;
  Player *uptr;
  long d;
  long dum;
  char s[256];
  char STR1[256], STR2[256], STR3[256], STR4[256], STR5[256], STR6[256];
  char STR8[38];

  ioobj.clear_scr();
  check_boundaries(&currentsector);
  // find current player
  if (!find_player_by_name(playername, &player))
    exit_game(0);

  // get current sector information and check for pending battles
  get_sector(currentsector, &players, justentered);

  // update location
  player->sector = currentsector;
  player->region = sector.region;
  player->region_sub = sector.region_sub;

  // clear entry flag
  if (justentered)
    justentered = false;

  // display correct header
  if (outside) {
    // in the out-of-bounds mountain range?
    if (inmountains)
      ioobj.sstr("Sector: ????");
    else {
      sprintf(STR3, "Sector: %d(%d,%d)", currentsector, sector.region, sector.region_sub);
      ioobj.sstr(STR3);
    }
    ioobj.sstr("                               Type: ");
    switch (sector.sectype) {

    case 1:
      ioobj.sstrcr("Mountains");
      break;

    case 2:
      ioobj.sstrcr("Hills");
      break;

    case 3:
      ioobj.sstrcr("Plains");
      break;

    case 4:
      ioobj.sstrcr("Moors");
      break;

    case 5:
      ioobj.sstrcr("Swamps");
      break;

    case 6:
      ioobj.sstrcr("Lakes");
      break;

    case 7:
      ioobj.sstrcr("River");
      break;

    case 8:
      ioobj.sstrcr("Forest");
      break;

    case 9:
      ioobj.sstrcr("Taramon");
      break;
    }
    ioobj.sstrcr("Royalty");
    ioobj.sstrcr("------------------");

    // check for persons in this area
    gptr = players;
    usr = false;
    while (gptr != NULL) {
      if (gptr->sector == currentsector && gptr->dead == false &&
	  gptr->armysize > 0) {
	ioobj.sstr(gptr->alias);
	ioobj.sstr(" with ");
	sprintf(STR1,"%ld warriors.",gptr->armysize) ;
	ioobj.sstrcr(STR1);
	usr = true;
      }
      gptr = gptr->next;
    }
    if (!usr)
      ioobj.sstrcr("none");

    // now look for castles
    count = 1;
    ioobj.sstrcr("Sector Contents");
    ioobj.sstrcr("------------------");
    if (find_castle_in_sector(currentsector, &cptr)) {
      get_castle_type(cptr, s, &d);
      sprintf(STR3, "%s %s", s, cptr->name);
      ioobj.sstr(STR3);
      sprintf(STR6, " with %ld/%ld/%ld/%ld",cptr->defend,cptr->wall,cptr->towers,cptr->moat);
      ioobj.sstrcr(STR6);
      if (!find_player_by_name(cptr->alias, &uptr)) {
	sprintf(STR4, "Owned by %s", cptr->alias);
	ioobj.sstrcr(STR4);
      } else {
	sprintf(STR5, "Owned by %s of the %s",
		cptr->alias,
		uptr->alliancename);
	ioobj.sstrcr(STR5);
      }
      nocas = false;
    } else
      nocas = true;
    // village available?
    if (find_village_in_sector(currentsector, &vptr)) {
      sprintf(STR4, "Village %s", vptr->name);
      ioobj.sstrcr(STR4);
      nocas = false;
    }
    // army(s) in sector?
    if (find_army_in_sector(currentsector, &arptr)) {
      nocas = false;
      sprintf(STR4, "%ld men of %s's army", arptr->men, arptr->owner);
      ioobj.sstrcr(STR4);
    } else if (nocas)
      ioobj.sstrcr("none");
  // inside castle  -- display castle information
  } else if (incastle) {
    if (!find_castle_in_sector(currentsector, &cptr))
    {
    	ioobj.sstrcr("error!");
	return;
    }
    get_castle_type(cptr, s, &d);
    sprintf(STR2, "%s %s owned by %s", s, cptr->name,cptr->alias);
    ioobj.sstrcr(STR2);
    ioobj.cr();
    sprintf(s,"Number of warriors in residence: %ld",cptr->defend);
    ioobj.sstrcr(s);
    get_armor(cptr->armor, nme, &dum);
    sprintf(STR4, "with %s", nme);
    ioobj.sstr(STR4);
    get_weapon(cptr->weapon, nme, &dum);
    sprintf(STR8, " and %s", nme);
    ioobj.sstrcr(STR8);
    ioobj.sstrcr("Castle Fortifications:");
    sprintf(STR4, "Oil:   %-10ld", cptr->oil);
    ioobj.sstr(STR4);
    sprintf(STR4, "Moat:   %-5ld", cptr->moat);
    ioobj.sstrcr(STR4);
    sprintf(STR1, "Walls: %-10ld", cptr->wall);
    ioobj.sstr(STR1);
    sprintf(STR1, "Towers: %-5ld", cptr->towers);
    ioobj.sstrcr(STR1);
    ioobj.cr();
  } else {
    ioobj.sstr("Welcome to the ");
    if (!find_village_in_sector(currentsector, &vptr))
      ioobj.sstrcr("error!");
    sprintf(STR4, "Village %s", vptr->name);
    ioobj.sstrcr(STR4);
    ioobj.cr();
  }
}

boolean find_teleporter_in_sector(long sector)
{
  telerec *gptr;
  boolean found;

  gptr = teleporters;
  found = false;
  while (gptr != NULL && !found) {
    if (gptr->sector == sector)
      found = true;
    else
      gptr = gptr->next;
  }
  return found;
}

void found_item()
{
  Player *uptr;
  boolean found;
  long whatfound, numfound;
  Castle *cptr;
  long numgained;
  char STR2[256], STR3[256];

  found = true;
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("you're a pud!");
  whatfound = abs(rand() % 6);
  switch (whatfound) {

  case 0:
    ioobj.sstrcr("Sire!  While traveling through native Bargonian territory, ");
    ioobj.sstrcr("We happened across this helm.  It is solid gold, and almost new!");
    ioobj.sstrcr("You put on the helm, and instantly, a great centurian appears in");
    ioobj.sstrcr("front of you.  He says:  Sire!  Thank you for releasing my legion");
    ioobj.sstrcr("from this helm where we have been imprisoned by an ");
    ioobj.sstrcr("evil wizard.  I promise myself, and my legions toward");
    ioobj.sstrcr("whatever cause you may name.");
    ioobj.sstrcr("The centurian joins your army, along with");
    if (uptr->armysize < 15000) {
      numgained = abs(rand() % 15000);
    } else {
      numgained = abs(rand() % uptr->armysize) + 1;
    }
    sprintf(STR2, "%ld of his legion.", numgained);
    ioobj.sstrcr(STR2);
    uptr->armysize += numgained;
    break;

  case 1:
    ioobj.sstrcr("Sire!  While traveling through a mountainous sector, we found");
    ioobj.sstrcr("a hermit.  He claims to be a great wizard!");
    ioobj.sstrcr("The crochety old man hobbles up to you.");
    ioobj.sstrcr("He speaks:  Your highness, I am a great wizard!");
    ioobj.sstr("Could you possibly spare some gold for an old man? ");
    if (abs(rand() % 10) < 5) {
      if (yesno())
	ioobj.sstrcr("The old man says thanks! ");
      else
	ioobj.sstrcr("The old man says: Thanks for NOTHING!");
      ioobj.sstrcr("He then attempts a spell on you.");
      ioobj.sstrcr("But, he is not the great wizard he would seem.");
      ioobj.sstrcr("The spell goes awry, and you end up as a toad.");
      uptr->race = 0;
      ioobj.sstrcr("CRROOOOOAAAAK!!!");
      ioobj.sstrcr("Funny, but that's exactly what the old man said");
      ioobj.sstrcr("As you had him nailed to a tree.");
      ioobj.sstrcr("But, he teleports away from your grasp.");
      ioobj.sstrcr("You hop around and croak in frustration.");
    } else {
      if (yesno())
	ioobj.sstrcr("The old man says thanks! ");
      else
	ioobj.sstrcr("The old man says: Thanks for NOTHING!");
      ioobj.sstrcr("He then attempts a spell on you.");
      ioobj.sstrcr("He is not the most impressive wizard you've ever seen.");
      ioobj.sstrcr("But, he does come through.");
      ioobj.sstrcr("You mutate in front of everybody's eyes.");
      ioobj.sstrcr("You are now of a different race!");
      uptr->race++;
    }
    break;

  case 2:
    ioobj.sstrcr("A colonel runs up to you..");
    ioobj.sstrcr("Sire, while exploring an abandoned shack in this sector,");
    ioobj.sstrcr("the men found this scroll.  It has your name on it!");
    ioobj.sstrcr("He gives the scroll to you.");
    ioobj.sstr("Do you read it? ");
    if (yesno()) {
      sprintf(STR2, "Dear %s", uptr->alias);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("Due to your help in the battle for our enemies castle, I have ");
      ioobj.sstrcr("sent this scroll by courier to you.");
      ioobj.sstrcr("May it help you immensely.");
      ioobj.sstrcr("You feel a tingling as you read the name at the bottom.");
      ioobj.sstrcr("It says: Zeus");
      ioobj.sstrcr("If you had known you were fighting next to a god, you would");
      ioobj.sstrcr("have acted differently.  But you find that");
      ioobj.sstrcr("your strength has been increased!");
      uptr->str += 10;
      sprintf(STR2, "Your strength is now %ld", uptr->str);
      ioobj.sstrcr(STR2);
    } else {
      ioobj.sstrcr("You burn the scroll.");
      ioobj.sstrcr("But you have a funny feeling that you should have read it.");
    }
    break;

  case 3:
    ioobj.sstrcr("A major runs up to you..");
    ioobj.sstrcr("Sire, while exploring an abandoned shack in this sector,");
    ioobj.sstrcr("The men found this scroll.  It has your name on it!");
    ioobj.sstrcr("He gives the scroll to you.");
    ioobj.sstr("Do you read it? ");
    if (yesno()) {
      sprintf(STR2, "Dear %s", uptr->name);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("Due to your help in the battle for our enemies castle, I have ");
      ioobj.sstrcr("sent this scroll by courier to you.");
      ioobj.sstrcr("May it help you immensely.");
      ioobj.sstrcr("You feel a tingling as you read the name at the bottom.");
      if (uptr->male)
	ioobj.sstrcr("It says: Dian, the hunter");
      else
	ioobj.sstrcr("It says: Apollo");
      ioobj.sstrcr("If you had known you were fighting next to a god, you would");
      ioobj.sstrcr("have acted differently.  But you find that");
      ioobj.sstrcr("A monstrous pile of weapons appears in front of you.");
      ioobj.sstrcr("Enough for your whole army!");
      uptr->weapon+=5;
      if (uptr->weapon > 20)
	uptr->weapon = 20;
      cptr = castles;
      while (cptr != NULL) {
	if (!strcmp(cptr->alias, uptr->alias))
	  cptr->weapon = uptr->weapon;
	cptr = cptr->next;
      }
    } else {
      ioobj.sstrcr("You burn the scroll.");
      ioobj.sstrcr("But you have a funny feeling that you should have read it.");
    }
    break;

  case 4:
    ioobj.sstrcr("A general runs up to you..");
    ioobj.sstrcr("Sire, while exploring a large cave in this sector,");
    ioobj.sstrcr("the men found this scroll.  It has your name on it!");
    ioobj.sstrcr("He gives the scroll to you.");
    ioobj.sstr("Do you read it? ");
    if (yesno()) {
      sprintf(STR2, "Dear %s", uptr->name);
      ioobj.sstrcr(STR2);
      ioobj.sstrcr("Due to your help in the battle for our enemies castle, I have ");
      ioobj.sstrcr("sent this scroll by courier to you.");
      ioobj.sstrcr("May it help you immensely.");
      ioobj.sstrcr("You feel a tingling as you read the name at the bottom.");
      if (uptr->male)
	ioobj.sstrcr("it says: Aphrodite");
      else
	ioobj.sstrcr("it says: Herakles");
      ioobj.sstrcr("if you had known you were fighting next to a god, you would");
      ioobj.sstrcr("have acted differently.  But you find that");
      ioobj.sstrcr("a monstrous pile of armor appears in front of you.");
      ioobj.sstrcr("Enough for your whole army!");
      uptr->armor+=5;
      if (uptr->armor > 20)
	uptr->armor = 20;
      cptr = castles;
      while (cptr != NULL) {
	if (!strcmp(cptr->alias, uptr->alias))
	  cptr->armor = uptr->armor;
	cptr = cptr->next;
      }
    } else {
      ioobj.sstrcr("You burn the scroll.");
      ioobj.sstrcr("But you have a funny feeling that you should have read it.");
    }
    break;

  case 5:
    ioobj.sstrcr("You find a high tower in this sector..");
    ioobj.sstrcr("It is all of ebony stone, and has no entrance.");
    ioobj.sstrcr("Curiosity gets the best of you, so you send men up ");
    ioobj.sstrcr("the tower.  On the inside, you find a bunch of parchments.");
    ioobj.sstrcr("and the decomposing body of a sorcerer.");
    ioobj.sstrcr("His body was attacked by something not of this world.");
    ioobj.sstrcr("Powerful people breed powerful enemies.");
    ioobj.sstrcr("undaunted, you \"Borrow\" the scrolls.");
    ioobj.sstrcr("and run from the tower.");
    ioobj.sstrcr("When you have time to examine the scrolls, you find");
    ioobj.sstrcr("they are all magic map scrolls!");
    numfound = abs(rand() % 250);
    sprintf(STR3, "in all, they number %ld scrolls!", numfound);
    ioobj.sstrcr(STR3);
    uptr->map += numfound;
    break;

  default:
    found = false;
    break;
  }
  if (found)
    ioobj.waitcr();
}

void getout(int sig)
{
	char tmpstr[100];
	static int inalready = 0;
	
	if (!inalready)
	{
		if (sig != SIGHUP)	// not a hangup?
		{
			sprintf(tmpstr,"bf: got %d",sig);	
			ioobj.ap_log(tmpstr);
		}
		remove_busy();
		if (havedata)	// don't save if no data
			save_game();
		exit(1);
	}
}

void get_monster_name(long monsters, char *name)
{
  switch (monsters) {

  case 1:
    strcpy(name, "Giant Ants");
    break;

  case 2:
    strcpy(name, "Kobolds");
    break;

  case 3:
    strcpy(name, "Killer Bees");
    break;

  case 4:
    strcpy(name, "Goblins");
    break;

  case 5:
    strcpy(name, "Giant Bats");
    break;

  case 6:
    strcpy(name, "barbarians");
    break;

  case 7:
    strcpy(name, "Orcs");
    break;

  case 8:
    strcpy(name, "Hobgoblins");
    break;

  case 9:
    strcpy(name, "Elves");
    break;

  case 10:
    strcpy(name, "Dwarves");
    break;

  case 11:
    strcpy(name, "Werewolves");
    break;

  case 12:
    strcpy(name, "Werebears");
    break;

  case 13:
    strcpy(name, "Berserkers");
    break;

  case 14:
    strcpy(name, "Amazons");
    break;

  case 15:
    strcpy(name, "Magicians");
    break;

  case 16:
    strcpy(name, "Cave Bears");
    break;

  case 17:
    strcpy(name, "Skeletons");
    break;

  case 18:
    strcpy(name, "Zombies");
    break;

  case 19:
    strcpy(name, "Arakon");
    break;

  case 20:
    strcpy(name, "Hill Giants");
    break;

  case 21:
    strcpy(name, "Mountain Giants");
    break;

  case 22:
    strcpy(name, "Frost Giants");
    break;

  case 23:
    strcpy(name, "Flame Giants");
    break;

  case 24:
    strcpy(name, "Cave Giants");
    break;

  case 25:
    strcpy(name, "Ghouls");
    break;

  case 26:
    strcpy(name, "Fire Salamanders");
    break;

  case 27:
    strcpy(name, "Ice Salamanders");
    break;

  case 28:
    strcpy(name, "Furies");
    break;

  case 29:
    strcpy(name, "Black Dragons");
    break;

  case 30:
    strcpy(name, "Blue Dragons");
    break;

  case 31:
    strcpy(name, "Green Dragons");
    break;

  case 32:
    strcpy(name, "Plaid Dragons");
    break;

  case 33:
    strcpy(name, "Red Dragons");
    break;

  case 34:
    strcpy(name, "Purple Dragons");
    break;

  case 35:
    strcpy(name, "Daemons");
    break;

  case 36:
    strcpy(name, "Sorcerors");
    break;

  case 37:
    strcpy(name, "Mudworts");
    break;

  case 38:
    strcpy(name, "Witches");
    break;

  case 39:
    strcpy(name, "Medusas");
    break;

  case 40:
    strcpy(name, "Tricksters");
    break;

  case 41:
    strcpy(name, "Shape Changing Demons");
    break;

  case 42:
    strcpy(name, "River Guardians");
    break;

  case 43:
    strcpy(name, "Talons");
    break;

  case 44:
    strcpy(name, "Balrons");
    break;

  case 45:
    strcpy(name, "Treants");
    break;

  case 46:
    strcpy(name, "Jags");
    break;

  case 47:
    strcpy(name, "Balrogs");
    break;

  case 48:
    strcpy(name, "Greater Demons");
    break;

  case 49:
    strcpy(name, "Earth Gods");
    break;

  case 50:
    strcpy(name, "Greek Gods");
    break;

  default:
    strcpy(name, "Wil'O'Wisps");
    break;
  }
}

void get_sector( int sectornumber, Player **players, boolean new_)
{
  Army *arptr;
  boolean flee;
  long armysave, tmpvalue, tmp2;
  boolean misty;
  long nummonsters;
  Castle *cptr;
  telerec *tele;
  Player *uptr1, *uptr2;
  boolean found;


  flee = false;
  found = false;
  if (sectornumber == lastsector)
    timesinsector++;
  else
    timesinsector = 1;
  lastsector = sectornumber;

  memcpy(&sector,&sectors[sectornumber], sizeof(sectorrec));

  // find any teleporters that might be in sector
  tele = teleporters;
  while (tele != NULL) {
    if (tele->sector == currentsector)
      found = true;
    tele = tele->next;
  }

  // teleport user
  if (found)
    teleporter();
  else 
  {	// look for other events
    // random chance of finding something
    tmpvalue = abs(rand() % 20000);
    if (tmpvalue < 8*(theoptions.difficulty/2+1))
      trap();
    else if (tmpvalue < 16/(theoptions.difficulty/2+1))
      found_item();
    misty = false;

    // any keeper castles?
    cptr = castles;
    while (cptr != NULL) {
      if (cptr->sector == sectornumber && cptr->alliance == 100)
	misty = true;
      cptr = cptr->next;
    }
    if (misty)
      sector.sectype = 4;
    found = false;
    find_player_by_name(playername, &uptr1);

    // random chance of monster attack
    tmp2 = abs(rand() % 100);
    if (!new_ && tmp2 < 18*theoptions.difficulty && outside) {
      found = true;
      nummonsters = abs(rand() % ((uptr1->armysize * 5 + 1) / 10 + 1)*theoptions.difficulty);
      if (nummonsters <= 0) {
	nummonsters = abs(rand() % 5000) + 1;
      }
      if (timesinsector > 30) {
	sector.monsters = abs(rand()%50)+25;
	nummonsters = (500093L + lrand48() % 12000)*theoptions.difficulty;
      }
      if (!monsfight(uptr1, sector.monsters, &nummonsters))
	flee = true;
    }

    // check for any players in this sector
    uptr2 = *players;
    while (uptr2 != NULL && !uptr1->dead) {
      if (uptr2->sector == sectornumber &&
	  (uptr2->alliance != uptr1->alliance ||
	   uptr1->alliance == 0) && strcmp(uptr2->name, uptr1->name) &&
	  !uptr2->dead && !incastle) {
	if (!playerfight(uptr1, uptr2, false))
	  flee = true;
      }
      uptr2 = uptr2->next;
    }

    // check for any armies in this sector
    arptr = armies;
    while (arptr != NULL && !uptr1->dead) {
      // if nobody owns this army, then delete the army
      if (!find_player_by_alias(arptr->owner, &uptr2) || arptr->men <= 0)
	delete_army(arptr);
      else if (arptr->sector == currentsector && arptr->men > 1 &&
	       (uptr2->alliance != uptr1->alliance ||
		uptr1->alliance == 0) &&
	       strcmp(uptr2->name, uptr1->name)) {
	armysave = uptr2->armysize;
	uptr2->armysize = arptr->men;
	if (playerfight(uptr1, uptr2, true))
	  flee = true;
	arptr->men = uptr2->armysize;
	uptr2->armysize = armysave;
	if (arptr->men <= 1) {
	  delete_army(arptr);
	}  /*if*/
      }
      arptr = arptr->next;
    }  /*while*/
  }
}

void neat()
{
  Player *uptr, *uptr2;
  char c[256];
  long choice;
  Castle *cptr;
  boolean found;
  char STR1[256];

  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  ioobj.sstrcr("You feel a strange tingling..");
  ioobj.sstrcr("A god floats down from the roof!");
  if (uptr->race == 0) {
    ioobj.sstrcr("We feel pitied that the demon artagean turned you into a toad.");
    ioobj.sstrcr("We have decided to repeal his spell, and turn you into a worthwhile");
    ioobj.sstrcr("creature.  ");
    ioobj.sstrcr("poof!!!!!");
    ioobj.sstrcr("You look different than you did.");
    ioobj.sstrcr("But what a relief!");
    if (uptr->alignment) {
      uptr->race = abs(rand() % 5) + 1;
    } else {
      uptr->race = abs(rand() % 5) + 6;
    }
    return;
  }
  choice = abs(rand() % 15);
  switch (choice) {

  case 1:
    ioobj.sstrcr("The god says:  since you have been so diligent in ");
    ioobj.sstrcr("trying to unite the kingdom, we have deemed to give you");
    ioobj.sstrcr("1 million men.");
    uptr->armysize += 1000000L;
    break;

  case 2:
    ioobj.sstrcr("He says:  We have had a council, and have decided to give you ");
    ioobj.sstrcr("another castle.");
    give_castle(&castles, currentsector);
    break;

  case 3:
    ioobj.sstrcr("We have deemed, in our infinite grace, to increase your strength.");
    ioobj.sstr("your strength is now ");
    uptr->str += 5;
    sprintf(c,"%ld",uptr->str);
    ioobj.sstrcr(c);
    break;

  case 4:
    ioobj.sstrcr("We have deemed, in our infinite grace, to increase your intelligence.");
    ioobj.sstr("Your intelligence is now ");
    uptr->int_ += 2;
    sprintf(c,"%ld",uptr->int_);
    ioobj.sstrcr(c);
    break;

  case 5:
    if (uptr->race % 6 == 0 && uptr->race != 0) {
      ioobj.sstrcr("We may not increase your race any more.");
    } else {
      if (uptr->alignment) {
	uptr->race++;
	ioobj.sstrcr("Your race has been changed.");
      } else {
	uptr->race++;
	ioobj.sstrcr("Your race has been changed.");
      }
    }
    break;

  case 6:
    ioobj.sstrcr("We have deemed give you better weapons.");
    ioobj.sstrcr("A huge pile of weapons appears in front of you.");
    uptr->weapon += 2;
    if (uptr->weapon > 20)
      uptr->weapon = 20;
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->weapon = uptr->weapon;
      cptr = cptr->next;
    }
    break;

  case 7:
    ioobj.sstrcr("We have deemed to change your armor.");
    uptr->armor += 3;
    if (uptr->armor > 20)
      uptr->armor = 20;
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->armor = uptr->armor;
      cptr = cptr->next;
    }
    break;

  case 8:
    ioobj.sstrcr("We will kill a rival of your choice.");
    ioobj.sstrcr(" 1-------10--------20--------30");
    ioobj.sstr("|");
    strcpy(c,"");
    ioobj.gstr(c, 31L);
    sprintf(c, "%.30s", strcpy(STR1, c));
    uptr2 = players;
    found = false;
    while (uptr2 != NULL && !found) {
      if (!strcmp(uptr2->alias, c))
	found = true;
      else
	uptr2 = uptr2->next;
    }
    if (!found)
      ioobj.sstrcr("Enemy not found!  The gods leave after witnessing your horrible memory.");
    else {
      uptr2->dead = true;
      strcpy(uptr2->killedby, uptr->alias);
    }
    break;

  case 9:
    ioobj.sstrcr("We have decided to give you a rival's castle.");
    ioobj.sstrcr("What is your hated rival's name?");
    ioobj.sstrcr(" 1-------10--------20--------30");
    ioobj.sstr("|");
    strcpy(c,"");
    ioobj.gstr(c, 31L);
    sprintf(c, "%.30s", strcpy(STR1, c));
    uptr2 = players;
    found = false;
    while (uptr2 != NULL && !found) {
      if (!strcmp(uptr2->alias, c))
	found = true;
      else
	uptr2 = uptr2->next;
    }
    if (!found)
      ioobj.sstrcr("Enemy not found!  Castle not given!");
    else {
      if (!find_castle_by_o_a(uptr2->alias, &cptr))
	ioobj.sstrcr("That person has no castle.  Castle not given!");
      else {
	strcpy(cptr->oldowner, cptr->alias);
	strcpy(cptr->alias, uptr->alias);
	cptr->weapon = uptr->weapon;
	cptr->armor = uptr->armor;
	cptr->alliance = uptr->alliance;
      }
    }
    break;

  default:
    ioobj.sstrcr("The gods are not in the mood for helping you.  Try ");
    ioobj.sstrcr("on a day when we're less busy.  ");
    break;
  }
}

void remove_busy(void)
{
  char tmpstr[255];

  /* delete battlefield busy file */
  sprintf(tmpstr,"%s/BattleField Busy",CONFDIR);
  unlink(tmpstr);
}

int set_busy(void)
{
  char tmpstr[255];

  /* delete battlefield busy file */
  sprintf(tmpstr,"%s/BattleField Busy",CONFDIR);
  if (creat(tmpstr,0775) == -1)
	return(1);
  return(0);
}


boolean search(char *name, char *s)
{
  return(strstr(name,s)!=NULL);
}


void teleporter()
{
  Player *uptr;
  char c[256];
  long sector;

  ioobj.clear_scr();
  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  ioobj.sstrcr("You enter a small, ancient building.  The workmanship is easy to");
  ioobj.sstrcr("distinguish.  It is from the high tech age.  ");
  ioobj.sstrcr("This building is one of the travel centers for the old world.");
  ioobj.sstrcr("You don't encounter these much, so you look around quite extensively.");
  ioobj.sstrcr("You find a control panel with a lot of buttons on it.");
  ioobj.sstrcr("You find one that says: power");
  ioobj.sstrcr("Being power hungry, you push it.");
  ioobj.sstrcr("The machine comes on and asks you for a sector.");
  ioobj.sstr("What sector would you like to go to? ");
    strcpy(c,"");
  ioobj.gstr(c, 5L);
  stringtonum(c, &sector);
  if (sector <= 0 || sector > boardsize || abs(rand() % 50) > 40) {
    ioobj.sstrcr("The machine whirrs for while, and says:");
    ioobj.sstrcr("invalid option.  Then, it gives a bang, and ");
    ioobj.sstrcr("transports you!");
    sector = abs(rand() % boardsize) + 1;
  }
  if (abs(rand() % 5*theoptions.difficulty) < 1) {
    inmountains = true;
    sector = boardsize + uptr->castaken + 1;
  }
  uptr->sector = sector;
  currentsector = sector;
  ioobj.sstrcr("You find yourself in another part of the world!");
  ioobj.waitcr();
  ioobj.clear_scr();
}

void uh_oh()
{
  Player *uptr;
  Castle *cptr;
  long choice, int_;
  char STR3[256];

  if (!find_player_by_name(playername, &uptr))
    ioobj.sstrcr("error!");
  ioobj.sstrcr("You have a sinking feeling in your stomach..");
  ioobj.sstrcr("Your fears have been confirmed.  A demon rises through the floor!");
  choice = abs(rand() % 12);
  switch (choice) {

  case 1:
    ioobj.sstrcr("The demon looks at you..");
    ioobj.sstrcr("Then the demon snaps his fingers.");
    ioobj.sstrcr("At which, a lesser demon appears.");
    ioobj.sstrcr("The major demon whispers to the lesser, seeming to give instructions.");
    ioobj.sstrcr("The lesser demon disappears.");
    ioobj.sstrcr("And, after a satisfied grin on his face, the demon does too.");
    ioobj.sstrcr("You begin to wonder at this strange turn of events..");
    ioobj.sstrcr("Then you hear the screams of your men.");
    ioobj.sstrcr("a lieutenant runs in and says:  'Sire!  a demon has attacked the men!'");
    ioobj.sstrcr("You rush from the church, just as your men fight off the demon.");
    int_ = abs(rand() % (uptr->armysize + 1));
    sprintf(STR3, "You have lost %ld men.", int_);
    ioobj.sstrcr(STR3);
    ioobj.sstrcr("This has not been your day.");
    outside = true;
    incastle = false;
    break;

  case 2:
    ioobj.sstrcr("The demon sneers in your general direction:");
    ioobj.sstrcr("You are nothing but an insignificant little toad.");
    ioobj.sstrcr("At which point, he turns you into one.");
    ioobj.sstrcr("CRROOOOOOOOAAAAAAAKKK");
    ioobj.sstrcr("You might have lingual problems after this.");
    ioobj.sstrcr("Your men can't stop laughing.");
    uptr->alignment = true;
    uptr->race = 0;
    break;

  case 3:
    ioobj.sstrcr("The demon slavers at you..you are hypnotized by his gaze!");
    ioobj.sstrcr("The demon reads your mind!");
    ioobj.sstr("He says:  I don't think you deserve a castle ");
    if (find_castle_by_o_a(uptr->alias, &cptr)) {
      ioobj.sstrcr(cptr->name);
      ioobj.sstrcr("I have given it to the Magi.  ");
      ioobj.sstrcr("He laughs at you!");
      ioobj.sstrcr("Then he disappears!");
      cptr->alliance = 100;
      strcpy(cptr->alias, "Grod, the Conqueror");
      cptr->defend = 20000;
    } else
      ioobj.sstrcr("The demon laughs at you because of your lack of a castle..");
    break;

  case 4:
    ioobj.sstrcr("The demon looks at you, and says:  i'm hungry. ");
    ioobj.sstrcr("Do you have anything to eat?  ");
    ioobj.sstrcr("Hmmmm.. that gold will do.  Munch!  Burp!");
    ioobj.sstrcr("The demon ate all of your gold!");
    uptr->gold = 0;
    break;

  case 5:
    ioobj.sstrcr("The demon looks at your fine armor, and says:  hmmm.. nice armor");
    ioobj.sstrcr("I'd like to have some like it..Poof!");
    ioobj.sstrcr("He takes your armor.");
    ioobj.sstrcr("You are naked!!!!");
    ioobj.sstrcr("The demon disappears.");
    ioobj.sstrcr("You run from the church into a group of prostitutes.  ");
    ioobj.sstrcr("One remarks...i've never seen one that small!");
    uptr->armor = 1;
    break;

  case 6:
    ioobj.sstrcr("The demon sneers in your general direction.  then, ");
    ioobj.sstrcr("He laughs, and disappears.");
    ioobj.sstrcr("You wonder about that.");
    ioobj.sstrcr("You exit the castle, and find that forty thousand cattle have herded");
    ioobj.sstrcr("around your troops.  Your troops use their weapons to ");
    ioobj.sstrcr("slaughter what they can.");
    ioobj.sstrcr("They have the best meal they've ever had.");
    ioobj.sstrcr("In fact, they eat so much that");
    int_ = abs(rand() % (uptr->armysize + 1));
    if (uptr->armysize <= 0)
      uptr->armysize = 1;
    sprintf(STR3, "%ld men explode in the middle of the night.", int_);
    ioobj.sstrcr(STR3);
    uptr->armysize -= int_;
    break;

  case 7:
    ioobj.sstrcr("The demon says:  you are not fit to live.");
    ioobj.sstrcr("The demon then pulls out his gigantic black sword.");
    ioobj.sstrcr("and calmly lops your head off.");
    ioobj.sstrcr("You are dead.");
    uptr->dead = true;
    strcpy(uptr->killedby, "a demon ");
    quit = true;
    break;

  case 8:
    ioobj.sstrcr("The demon admires your wonderful weapons..");
    ioobj.sstrcr("He says:  I want that!");
    ioobj.sstrcr("And takes it from you.");
    cptr = castles;
    while (cptr != NULL) {
      if (!strcmp(cptr->alias, uptr->alias))
	cptr->weapon = 1;
      cptr = cptr->next;
    }
    uptr->weapon = 1;
    ioobj.sstrcr("You no longer have a weapon.");
    break;

  default:
    ioobj.sstrcr("The demon belches in your general direction, and says:");
    ioobj.sstrcr("You little pond scum.  you're not even worth killing.");
    ioobj.sstrcr("You feel insulted.");
    break;
  }
}

void nw(void)
{
  oldsector = currentsector;
  currentsector += -rowlength - 1;
  check_boundaries(&currentsector);
}


void n(void)
{
  oldsector = currentsector;
  currentsector -= rowlength;
  check_boundaries(&currentsector);
}


void ne(void)
{
  oldsector = currentsector;
  currentsector += 1 - rowlength;
  check_boundaries(&currentsector);
}


void w(void)
{
  oldsector = currentsector;
  currentsector--;
  check_boundaries(&currentsector);
}


void e(void)
{
  oldsector = currentsector;
  currentsector++;
  check_boundaries(&currentsector);
}


void sw(void)
{
  oldsector = currentsector;
  currentsector += rowlength - 1;
  check_boundaries(&currentsector);
}


void south(void)
{
  oldsector = currentsector;
  currentsector += rowlength;
  check_boundaries(&currentsector);
}


void se(void)
{
  oldsector = currentsector;
  currentsector += rowlength + 1;
  check_boundaries(&currentsector);
}

int yesno(void)
{
        struct fd_set fds;
        char   found=0;
        char   c;
        struct timeval waittime;
        char   bsstr[] =            // backspace
        {
                0x8,0x20,0x8, 0
        };
        ioobj.sstr("[Y/N] ");

        waittime.tv_sec = 0;
        waittime.tv_usec = 250;
	FD_ZERO(&fds);
        FD_SET(fileno(stdin), &fds);
        while (!found)
        {
                c = toupper(ioobj.gch(1));
                if (c != 0)
                {
                        if (c == 'Y')
                                found = 1;
                        else if (c == 'N')
                                found = 2;
                        else
                                ioobj.sstr(bsstr);
                }
                select(FD_SETSIZE,&fds,NULL,NULL,&waittime);
        }
        fflush(stdin);
        ioobj.cr();
        return(found==1);
};

#endif // _MISC_C_

