/* From iioobj.gstr file "init.pas" */

#ifndef _INIT_C_
#define _INIT_C_

#include "bf.h"

void create_battlefield(void)
{
  FILE *outfile;
  long count, tmp;
  char path[256];
  sectorrec sector;
  long row, territory, col;
  struct stat buf;
  char STR1[256];


  outfile = NULL;
  strcpy(path, CONFDIR);
  sprintf(STR1, "%s/Sectors", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating battlefield board..");
	  territory = 0;
	  row = 0;
	  sprintf(STR1, "%s/Sectors", CONFDIR);
	  outfile = ioobj.bopen(STR1, "wb");
	  if (outfile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  for (count = 0; count < MAX_SECTOR + KEEPERS; count++) {
	    row = count / rowlength;
	    col = count % rowlength;
	    territory = row / territorysize * territorysize + col / territorysize + 1;
	    sector.region = territory;
	    sector.region_sub = row % territorysize * territorysize + col % territorysize;
	    if (count < boardsize / 4)
	      sector.sectype = 1;
	    else if (count > boardsize / 4 && count < boardsize / 4 + boardsize / 8)
	      sector.sectype = 2;
	    else if (count > boardsize / 4 + boardsize / 8 &&
		     count < boardsize / 4 + boardsize / 8 + boardsize / 2)
	      sector.sectype = 3;
	    else
	      sector.sectype = 2;
	    tmp = abs(rand() % 100);
	    if (tmp < 10)
	      sector.sectype = 5;
	    else if (tmp < 20)
	      sector.sectype = 6;
	    else if (tmp < 30)
	      sector.sectype = 7;
	    else if (tmp < 40)
	      sector.sectype = 8;
	    tmp = abs(rand() % 100);
	    if (tmp < 25) {
	      tmp = abs(rand() % 25) + 25;
	    } else {
	      tmp = abs(rand() % 25) + 1;
	    }
	    if (count > boardsize) {
	      sector.sectype = 9;
	      tmp = abs(rand() % 5) + 46;
	    }
	    sector.monsters = tmp;
	    fwrite(&sector, sizeof(sectorrec), 1, outfile);
	  }
	  ioobj.bclose(outfile);
	  sprintf(STR1, "%s/Sectors", CONFDIR);
	  chmod(STR1,0775);
  }
}

void create_teleporters(void)
{

  char STR1[256];
  struct stat buf;
  FILE *telefile;
  telerec telrec;
  long count, tmp;

  telefile = NULL;
  sprintf(STR1, "%s/Teleporters", CONFDIR);
  if (stat(STR1,&buf) < 0)
  {  /* doesn't exist */
	  ioobj.sstrcr("Creating teleporters..");
	  sprintf(STR1, "%s/Teleporters", CONFDIR);
	  telefile = ioobj.bopen(STR1, "wb");
	  if (telefile == NULL)
	    {
		perror(STR1);
		exit_game(1);
	    }
	  count = 0;
	  while (count < 30) {
	    tmp = abs(rand() % boardsize);
	    telrec.sector = tmp;
	    fwrite(&telrec, sizeof(telerec), 1, telefile);
	    count++;
	  }
	ioobj.bclose(telefile);
  }
  chmod(STR1,0775);

}

void init_options()
{
	struct stat buf;
	char	s[MAXPATHLEN];
	char 	boole;
/* check for options file */
	
	sprintf(s,"%s/Battlefield Options",CONFDIR);
	if (stat(s,&buf) < 0)
	{  /* doesn't exist */
		ioobj.clear_scr();
		ioobj.sstrcr("I am unable to find an options file.");
		ioobj.cr();
		ioobj.sstr("Would you like to configure The BattleField? ");
		if (yesno())
		{
			ioobj.clear_scr();
			ioobj.sstrcr("What is the timelimit for the players to have for one"); 
			ioobj.sstr("session in BattleField? (in minutes) ");
			strcpy(s,"20");
			ioobj.gstr(s,5);
			if (sscanf(s,"%d",&theoptions.timelimit) != 1);
				theoptions.timelimit = 20;
			ioobj.cr();
			ioobj.sstr("How many times may the player enter the game per day? [2] ");
			strcpy(s,"2");
			ioobj.gstr(s,5);
			if (sscanf(s,"%d",&theoptions.entries) != 1);
				theoptions.entries = 2;
			ioobj.cr();
			ioobj.sstrcr("How many days should unread (or not deleted) messages remain");
 			ioobj.sstr("prior to automatic deletion? ");
			strcpy(s,"7");
			ioobj.gstr(s,5);
			if (sscanf(s,"%d",&theoptions.messagelimit) != 1);
				theoptions.messagelimit = 7;
			ioobj.cr();
			ioobj.sstrcr("How many days before the game automatically resets to clear the board? ");
			ioobj.sstr("(0 for no reset) ");
			strcpy(s,"120");
			ioobj.gstr(s,5);
			if (sscanf(s,"%d",&theoptions.daystorun) != 1);
				theoptions.daystorun = 120;
			ioobj.cr();
			ioobj.sstr("Should BattleField create a scores (rankings) file? " );
			if (yesno())
				theoptions.scores = true;
			else
				theoptions.scores = false;
			ioobj.cr();
			if (theoptions.scores)
			{
				ioobj.sstrcr("Please enter an absolute path for the scores file: ");
				strcpy(theoptions.scorespath,"/bbs/admin/bfscores");
				ioobj.gstr(theoptions.scorespath,MAXPATHLEN-1);
				if (strlen(theoptions.scorespath) < 1)
					strcpy(theoptions.scorespath,"/bbs/admin/bfscores");
				ioobj.cr();
			}
			else	// no path
				theoptions.scorespath[0] = 0;
			ioobj.sstrcr("Difficulty: 1 - Easy 10 - Very Hard");
			ioobj.sstr("What difficulty should this game have? ");
			strcpy(s,"1");
			ioobj.gstr(s,5);
			if (sscanf(s,"%d",&theoptions.difficulty) != 1);
				theoptions.difficulty = 1;
			ioobj.cr();
			boole=0;
			while (!boole)
			{
				ioobj.cr();
				ioobj.sstr("Please enter the minimum access level for a SysOp: ");
				strcpy(s,"10000");
				ioobj.gstr(s,10);
				if (sscanf(s,"%d",&theoptions.sysopacl) == 1)
					boole++;
			}
			theoptions.firstime = 1;	// first entry
			time(&theoptions.date);
			save_options();
		}
		else
		{
			ioobj.clear_scr();
			ioobj.sstrcr("BattleField is unable to continue.");
			ioobj.cr();
			ioobj.sstrcr("Press return to exit.");
			ioobj.waitcr();
			exit_game(0);
		}
	}	
	// read the options file
	read_options();
}

#endif // _INIT_C_

