#ifndef _BF_H_ 
#define _BF_H_


#ifdef MAIN
	#define EXTERN 
#else
	#define EXTERN extern
#endif 

#include "bbshdr.h"	// bbs main headers (+ tons of system headers)

#define stringtonum(c,l)	sscanf(c,"%ld",l)
#define uncase(character) tolower(character)

// miscellaneous size definitions
#define MAX_SECTOR	10000	// 10000 sectors at this time
#define KEEPERS		20	// 20 keeper castles
#define INTEREST	16.125	// 16% interest given per week


// most of the below are pascal-isms
typedef unsigned char uchar;

typedef char boolean;

typedef char str255[256];

typedef char stringtype[256];

typedef char nametype[32];

// a single 'sector'
typedef struct sectorrec {
  char sectype; 		// type of sector
  char monsters; 		// type of monsters possible in sector
  char region; 			// region
  char region_sub;		// sub-region
} sectorrec;

#include "alliance.h"	// alliance operations
#include "army.h"	// army operations
#include "castle.h"	// castle operations
#include "load.h"	// load/save the player
#include "messages.h"	// messages
#include "player.h"	// Player
#include "scores.h"	// scores
#include "town.h"	// town operations



/* these variables are used to keep track of what the player is doing */

typedef scorerec scorarray[20];	// high scores storage

// user information
EXTERN char playername[MAX_LOGIN_LENGTH];// player's login name
EXTERN Player *player;			// the current player

EXTERN boolean virgin; 		// first entry?
EXTERN boolean quit;			// main loop exit flag
EXTERN long timeson; 			// number of entries by user
EXTERN long timelimit; 		// user's timelimit (in bbs)
EXTERN long secs; 			// ?
EXTERN time_t startingtime;		// time at logon
EXTERN int currentsector; 		// current sector location
EXTERN int oldsector;			// previous sector
EXTERN boolean enteredbank;		// has user entered bank today?
EXTERN boolean nocas;			// user currently has no castle (on entry)
EXTERN long enteredchurch;		// user entered church today?
EXTERN boolean justentered; 
EXTERN boolean outside; 		// user outside of town/village? 
				// (available for attack)
EXTERN boolean incastle;		// user in castle?
EXTERN boolean rerolledtoday;		// has user rerolled today?  (once per day)
EXTERN boolean inmountains;		// in the mountains?

// game system parameters
EXTERN long dayshad;			// days game has been in operation
EXTERN long timesinsector; 		// number of turns in current sector
EXTERN long daysleft;			// days left in current game
EXTERN long lastsector; 		// 
EXTERN long max;			// 


// data structures (game variable storage)
EXTERN sectorrec sectors[MAX_SECTOR+KEEPERS];	// game sectors
EXTERN Army *armies;
EXTERN Player *players;		// users
EXTERN Castle *castles;		// castles
EXTERN Village *villages;		// villages
EXTERN alliancerec *alliances;		// alliances
EXTERN bfMessage *scrolls;		// messages
EXTERN telerec *teleporters;		// teleporters
EXTERN optionrecord theoptions;	// game options


// miscellaneous information
EXTERN boolean move_castles; 		// move the rogue's castles?
EXTERN boolean gottime;		// 
EXTERN sectorrec sector;		// current sector
EXTERN long boardsize; 		// size of the board (in sectors)
EXTERN long rowlength; 		// length of a row
EXTERN long territorysize;		// 
EXTERN long mem; 
EXTERN long mercprice;			// price of mercenaries
EXTERN long bar;			// bar entries
EXTERN boolean owned;
EXTERN boolean newgame; 
EXTERN boolean firstime; 
EXTERN boolean exited; 
EXTERN boolean havedata;


// variables to be eliminated
EXTERN nametype nme;			// shouldn't be used
EXTERN boolean usr;
EXTERN Castle *cptr;			// castle list iterator
EXTERN Village *vptr;		// village list iterator
//EXTERN stringtype c;
//EXTERN stringtype s;
EXTERN boolean resettourney;

// BBS interface objects
EXTERN color ioobj;			// input/output
EXTERN User user;			// dummy (to satisfy BBS objects)
EXTERN Door doorinfo;			// door read/write 


// Player prototypes

 void addplayer (Player );		// add player to player list
 boolean can_play (char *, Castle **);	// can player play?
 void change_player_name (void);	// change player's name
 void check_for_level (Player *);	// check for a level (after fight)
 void check_for_win (void);		// check for winning situation
 void check_player (Player *, Castle **);	// update player stats
 void delete_player (void);		// delete player (sysop)
 void display_stats (Player , long );	// display user stats
 void edit_player (void);		// edit a player (sysop)
 boolean find_player_in_sector (long , Player **);	// find player
 boolean find_player_by_name (char *, Player **);	// find by (login) name
 boolean find_player_by_alias (char *, Player **);	// find by alias
 void get_armor (long , char *, long *);		// return armor info
 void get_weapon (long , char *, long *);	// return weapon info
 void get_players (void);		// read players from players file
 void give_reward (Player **);		// give a reward
 void list_players (Player *);
 boolean monsfight (Player *, long , long *);
 boolean playerfight (Player *, Player *, boolean);
 char *race(int);			// return name of a race
 void reroll_player (Player **);
 void rollplayer (void);
 void subtract_level (Player *);
 void switcha (Player , Player );
 void switchw (Player , Player );

// armies prototypes
 void create_armies(void);
 void delete_army (Army *);
 boolean find_army_in_sector (long , Army **);
 void get_armies (Army **);
 void station_army (Player **);

// alliance prototypes
 void create_alliances(void);
 void disband_alliance (void);
 void get_alliances (alliancerec **);
 boolean findalliance (char *, alliancerec **);
 void join_alliance (void);
 void kick_out (Player *);
 void lend (void);
 void list_alliances (Player *);
 void new_alliance (void);
 void new_password (Player **);
 void quit_alliance (void);


// castle prototypes  

 void addcastle (Castle , Castle **);
 void add_target_castles (void);
 boolean attack_castle(void);
 void buy_castle (void);
 void castle_name (Castle *);
 void change_castle_name (void);
 void check_castles (Player *);
 void delete_castle (void);
 void destroy_castle (void);
 boolean find_castle_in_sector (long , Castle **);
 boolean find_castle_by_o_a (char *, Castle **);
 boolean find_castle_by_n (char *, Castle **);
 void fortify_castle (void);
 void get_castles (Castle **);
 void get_castle_type (Castle *, char *, long *);
 void give_castle (Castle **, long );
 void major_castles (long , Castle *);
 void move_em (Castle **, boolean );
 void target_castles (long , Castle *);
 void take_men (void);


// init prototypes

 void create_battlefield (void);
 void create_teleporters(void);
 void init_options (void);


// scores prototypes

 void clear_scores (scorerec *);
 void high_scores (boolean , boolean );
 void insert_score (scorerec , scorerec *);


// load/save  prototypes

 void check_for_battlefield (void);
 void exit_game (int );
 void get_sectors(sectorrec *);
 void get_teleporters (telerec **);
 void read_options (void);
 void reset_game (boolean, boolean );
 void save_options (void);
 void save_game (void);
 void dispose_storage (void);


// messages  prototypes

 void add_bfMessage (bfMessage **, bfMessage );
 void check_for_messages (Player *);
 void get_messages(bfMessage **scrolls);
 void create_messages(void);
 void findhighnum (bfMessage *, long *);
 void get_bfMessages (bfMessage **);
 void scribes_guild (bfMessage **, Player **, boolean );


// rogues prototypes

 void check_for_levelr (Player *, boolean );
 void check_rogue (Player **, boolean );
 boolean find_r_castle (char *);
 void give_r_castle (Player **, boolean );
 void move_rem (boolean );
 void move_rogue (Player **, boolean );
 void remove_rogue_castles (Player **, boolean );
 void roguecastle (Player **, Castle **, boolean );
 boolean roguefight (Player *, Player *, boolean , boolean ); 
 void rollrogues (void);
 void subtract_levelr (Player *, boolean );

// spells prototypes

 void destroy_castle_spell (void);
 void do_spell (Player **);
 void kill_prince (Player **);
 void mage_guild (boolean , Player **);
 void map (Player **);
 void steal_castle (void);
 void teleport_spell (Player *);
 void trap (void);


// town prototypes 

 void bank (void);
 void cathedral (boolean );
 void create_villages(void);
 boolean find_village_in_sector (long , Village **);
 void buy_armor (long);
 void buy_weapons (long);
 void get_villages (Village **);
 void mercenaries (boolean , long );
 void rumors (void);
 void teleport (void);
 void update_villages (Village **);
 void villagenames (long , char *);


// misc prototypes 

 void found_item (void);
 void getout (int);
 void check_boundaries (int *);
 boolean find_teleporter_in_sector (long );
 void display_header(void);
 void get_monster_name (long , char *);
 void get_sector (int, Player **, boolean);
 void neat (void);
 void remove_busy (void);	// delete 'busy' lock file
 int  set_busy (void);		// create 'busy' lock file
 boolean search (char *, char *s);
 void teleporter (void);
 void uh_oh (void);

 // directional movement
 void n (void);
 void nw (void);
 void ne (void);
 void e (void);
 void w (void);
 void se (void);
 void south (void);
 void sw (void);
 int yesno(void);





#endif // _BF_H_
