#include <ctype.h>
#include <dirent.h>
#include <fcntl.h>
#include <fnmatch.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include "areas.h"
#include "os.h"
#include "doors.h"
#include "editor.h"
#include "lock.h"
#include "modem.h"
#include "output.h"
#include "status.h"
#include "tokens.h"
#include "varlist.h"

#ifdef __linux__
#include <sys/vfs.h>
#endif

extern varlist list;
extern struct mark_t *first_mark;
extern char token[1024], *out_buf;
extern int node, in_dir;
extern struct line_t *first;
extern vmodem *modem;

int protocol_num = 0, protocols = 0;
struct protocol_t protocol[MAXPROTOCOLS];
static char oldshell[100];

struct archiver_t {
  char *pattern;
  char *cmd;
  struct archiver_t *next;
} *first_archiver = NULL;

#define DESC_FILES 4
char *desc_file[DESC_FILES] = { 
  "file_id.diz", 
  "desc.sdi", 
  "FILE_ID.DIZ", 
  "DESC.SDI" 
};

void init_archivers()
{
  FILE *arch_list;
  int type;
  struct archiver_t *archiver = NULL;
  
  dprintf(">loading archiver list\n");

  arch_list = fopen("/osbbs/data/archivers", "r");
  if(arch_list == NULL)
    init_error("could not open data/archivers");
    
  for(;;) {
    type = read_line(arch_list);
    if(type == TOKEN_EOF)
      break;
      
    if(type != TOKEN_TEXT)
      init_error("error in archiver list");
    
    if(first_archiver) {
      archiver -> next = (struct archiver_t *)malloc(sizeof(struct archiver_t));  
      archiver = archiver -> next;
    } 
    else {
      archiver = first_archiver = 
        (struct archiver_t *)malloc(sizeof(struct archiver_t)); 
    }
    
    archiver -> next = NULL;
    
    archiver -> pattern = (char *)malloc(strlen(token) + 1);
    strcpy(archiver -> pattern, token);
    
    type = read_line(arch_list);
    if(type != TOKEN_TEXT)
      init_error("error in archiver list");
    
    archiver -> cmd = (char *)malloc(strlen(token) + 1);
    strcpy(archiver -> cmd, token);
  }
  
  /*struct archiver_t *tmp = first_archiver;
  while(tmp) {
    dprintf(">%s, %s\n", tmp -> pattern, tmp -> cmd);
    tmp = tmp -> next;
  }*/
  
  fclose(arch_list);
}

void init_protocols()
{
  int type;
  FILE *pfile;
   
  dprintf(">loading protocol list: ");
   
  pfile = fopen("/osbbs/data/protocols", "r");
  if(!pfile) 
    init_error("error opening /osbbs/data/protocols");
   
  for(;;) {
    type = read_line(pfile); // pname
    if(type == TOKEN_EOF)
      break;
     
    if(type != TOKEN_TEXT)
      init_error("error in protocols file: protocol name expected");
    
    protocol[protocols].name = (char *)malloc(strlen(token) + 1);
    strcpy(protocol[protocols].name, token);
    
    type = read_line(pfile);
    if(type != TOKEN_TEXT)
      init_error("error in protocols file: %s upload command expected", 
		 protocol[protocols].name);

    if(!strcmp(token, "none"))
      protocol[protocols].up_cmd = NULL;
    else {
      protocol[protocols].up_cmd = (char *)malloc(strlen(token) + 1);
      strcpy(protocol[protocols].up_cmd, token);
    }
         
    type = read_line(pfile);
    if(type != TOKEN_TEXT)
      init_error("error in protocols file: %s download command expected", 
		 protocol[protocols].name);
    
    if(!strcmp(token, "none"))
      protocol[protocols].down_cmd = NULL;
    else {
      protocol[protocols].down_cmd = (char *)malloc(strlen(token) + 1);
      strcpy(protocol[protocols].down_cmd, token);
    }
  
    if(!protocol[protocols].up_cmd && !protocol[protocols].down_cmd)
      init_error("protocol %s must have either upload or download command", 
		 protocol[protocols].name);

    type = read_line(pfile);
    if(type != TOKEN_TEXT)
      init_error("error in protocols file: batch/single for %s expected",
                  protocol[protocols].name);
  
    if(!strcmp(token, "batch"))
      protocol[protocols].batch = 1;
    else if(!strcmp(token, "single"))
      protocol[protocols].batch = 0;
    else
      init_error("error in protocols file: don't know what \"%s\" means",
                  token);
  
    protocols++;
    if(protocols == MAXPROTOCOLS)
      init_error("too many protocols, increase MAXPROTOCOLS and recompile");
  }
 
  dprintf("%d protocols\n", protocols);

  fclose(pfile);
}

int download()
{
  int result, size, old_busy;
  struct mark_t *tmp;
  char *file_cmd;
  
  old_busy = status_p -> busy;

  if(protocol[protocol_num].down_cmd == NULL)
    return 2;
  
  if(number("marked") == 0 || number("markedsize") == 0)
    return 0;
  
  if(protocol[protocol_num].batch) {
    tmp = first_mark;
    size = strlen(protocol[protocol_num].down_cmd) + 1;
    while(tmp) {
      size += strlen(tmp -> name) + 1;
      tmp = tmp -> next;
    }
    file_cmd = (char *)malloc(size);
    strcpy(file_cmd, protocol[protocol_num].down_cmd);
    tmp = first_mark;
    while(tmp) {
      strcat(file_cmd, " ");
      strcat(file_cmd, tmp -> name);
      tmp = tmp -> next;
    }
    
    // syslog doesn't like messages longer than 4K    
    //log("download started: %s (%d bytes)", strchr(file_cmd, ' ') + 1 
    //                                     , number("markedsize"));
    log("download started: %d files (%d bytes)", number("marked"),
        number("markedsize"));
    
    modem -> clean();
    busy(BUSY_DOWNLOAD);
    result = run_door(file_cmd);
    free(file_cmd);
  }
  else {
    tmp = first_mark;
    while(tmp) {
      file_cmd = (char *)malloc(strlen(protocol[protocol_num].down_cmd)
      				+ strlen(tmp -> name) + 2);
      sprintf(file_cmd, "%s %s", protocol[protocol_num].down_cmd, tmp -> name);
      log("download: %s (%d bytes)", tmp -> name, tmp -> size);
      modem -> clean();
      busy(BUSY_DOWNLOAD);
      result = run_door(file_cmd);
      free(file_cmd);
      if(result != 0)
        break;
      tmp = tmp -> next;
    }
  }
  
  busy(old_busy);
  return result;
}

int send_file(char *file)
{
  char *file_cmd;
  int result;
  
  if(protocol[protocol_num].down_cmd == NULL)
    return 2;
  
  file_cmd = (char *)malloc(strlen(protocol[protocol_num].down_cmd) 
                            + strlen(file) + 1);
  sprintf(file_cmd, "%s %s", protocol[protocol_num].down_cmd, file);
  modem -> clean();
  result = run_door(file_cmd);
  free(file_cmd);
  return result;     
}

void upload_cleanup()
{
  chdir("..");
  in_dir = 0;
  if(*oldshell)
    setenv("SHELL", oldshell, 1); 
}

void get_file(char *file)
{
  int t, lines;
  struct archiver_t *arc = first_archiver;
  char *newname, desc_buf[160];
  FILE *index, *desc = NULL;
  struct line_t *line;
  
  list.add_sys("filename", file);
  
  while(arc) {
    if(!fnmatch(arc -> pattern, file, 0))
      break; 
    arc = arc -> next;
  }
  
  if(!arc) 
    dprintf(">file extension not recognized, may be ARJ :-(\n");
  else { 
    dprintf(">archiver: %s\n", arc -> cmd);
    for(t = 0;t < DESC_FILES;t++) {
      list.add_sys("idname", desc_file[t]);
      cook(arc -> cmd);
      run_door(out_buf);
      desc = fopen(desc_file[t], "r");
      if(desc)
        break;
    }
  }

  newname = (char *)malloc(strlen(file) + 10); 
  sprintf(newname, "/osbbs//uploads/%s", file);
   
  if(rename(file, newname))
    fatal_error("could not rename %s to %s", file, newname);

  free(newname);
  
  if(!desc) {
    char tmp[160];
    strcpy(tmp, "$white$Enter a description for: $yellow$");
    strncat(tmp, file, 150 - strlen(file));  
    list.add_sys("editstatus", tmp);
    edit();
  }
  
  index = fopen("/osbbs/uploads/Index", "a+");
  if(!index)
    fatal_error("could not open /osbbs/uploads/Index");

  //fprintf(index, "%s \"%s\"\n", file, string("user"));
  fprintf(index, "%s\n", file);
  
  if(desc) {
    for(;;) {
      if(!fgets(desc_buf, 160, desc))
        break;
      fprintf(index, "*%s", desc_buf);
      if(desc_buf[strlen(desc_buf) - 1] != '\n')
        fprintf(index, "\n"); 
    }
    fclose(desc);
    remove(string("idname"));
  }
  else {
    line = first;
    lines = 0;
    while(line) {
      if(line -> length) {
        lines++;
        fputc('*', index);
        fwrite(line -> text, 1, line -> length, index);
        fputc('\n', index);
      }
      line = line -> next;
    }
    if(lines == 0)
      fprintf(index, "*No description.\n");
    edit_cleanup();
  }
  
  fclose(index);
}

void get_files()
{
  DIR *dir;
  struct dirent *file;
  struct stat stat_buf;
  variable *size = list["filesize"];
  
  *size = 0;
    
  dir = opendir(".");
  if(!dir)
    return;
    
  while(file = readdir(dir)) {
    if(strncmp(file -> d_name, ".", 1) && strncmp(file -> d_name, "..", 2)) {
      if(stat(file -> d_name, &stat_buf))
        continue;
      size -> i += stat_buf.st_size;
      get_file(file -> d_name);
    }
  }
 
  closedir(dir);
}

int upload()
{
  char tmpdir[20];
  int exit_code, old_busy;
  
  if(protocol[protocol_num].up_cmd == NULL)
    return 2;

#ifdef __linux__
  if(exists("minfree")) {
    struct statfs st;
    if(statfs("uploads", &st))
      return 1;
    if(st.f_bfree < number("minfree"))
      return 3;
  }
#endif

  sprintf(tmpdir, "tmp.%d", node);
  
  if(mkdir(tmpdir, (mode_t)0700) && errno != EEXIST)
    fatal_error("could not create dir \"%s\"", tmpdir);
  
  if(chdir(tmpdir))
    fatal_error("could not change into dir \"%s\"", tmpdir);
    
  in_dir = 1;
    
  if(getenv("SHELL"))
    strncpy(oldshell, getenv("SHELL"), 99);
  else
    *oldshell = 0;

  old_busy = status_p -> busy;
  busy(BUSY_UPLOAD);
    
  /* This should keep rz from remotely executing rm -fR.
   * I can't help thinking a command-line option would have been nice, but, 
   * there we are.
   */    
  setenv("SHELL", "rksh", 1);
   
  cook(protocol[protocol_num].up_cmd);
  modem -> clean();
  exit_code = run_door(out_buf);
  
  dprintf(">exit_code = %d\n", exit_code);
  
  get_files();
  upload_cleanup();
  rmdir(tmpdir);

  busy(old_busy);

  return exit_code;
}


