#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <sys/shm.h>
#include <unistd.h>
#include "inc.h"
#include "status.h"

extern char *msg_buf;

int inc(int n, int cmd, char *par)
{
  struct msgbuf *out_msg, *in_msg;
  struct status_t *sp;
  key_t key;
  int id;

  if(!isanode(n))
    return 1;

  key = ftok(KEYFILE, n);
  id = msgget(key, 0600);
  if(id == -1)
    return 1;
   
  out_msg = (struct msgbuf *)malloc(sizeof(long) + strlen(par) + 1);
  out_msg -> mtype = cmd;
  strcpy(out_msg -> mtext, par);
   
  if(msgsnd(id, out_msg, strlen(par) + 1, 0) == -1) {
    free(out_msg);
    return 1;
  }

  if(!isanode(n))
    return 1;

  sp = &(status_pool -> status[n]);

  while(sp -> flags & SF_INCBUSY) {
    if(!isanode(n))
      return 1;
    usleep(1000);
  }

  kill(sp -> pid, SIGUSR2);

  if(cmd == INC_GET) {
    in_msg = (struct msgbuf *)malloc(sizeof(long) + 1024 + 1);  
    if(msgrcv(id, in_msg, 1024, INC_REPLY, 0) == -1)
      strcpy(msg_buf, "error");
    else
      strncpy(msg_buf, in_msg -> mtext, 1024);
     
    free(in_msg);
  }
   
  free(out_msg);
  return 0;
}

