/*
version:  [$Id: dis_menu.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose:  This is the main bbs program that reads and interpretes the menus for the users.
updates:  All updates are handled by RCS
Author:  The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>

#ifndef __MSDOS__
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */


int             display_menu(_character * Character);
int 
display_menu(_character * Character)
{
	MENU_struct     menu[MAXLINES];	/* I am the menu option from the
					   program */


	/* Work on a portable method of recording the size of the
	   MENU_structure without messing anything up.  This size should be
	   the same for every system, and always allow the read of the
	   datafiles.  So far you have to recompile you menus for a 16bit,
	   32bit, and 64bit machines.  All 16bit machine menus match, and
	   32bits the same.  */
	int             size = sizeof(MENU_struct);

	int             cnt = 0;

	int             skipmenu = FALSE;	/* a flag for skipping the
						   menu in the case of a
						   header containing the menu
						   I want to see.  By default
						   show the menu. */

	int             count = 0;

	FILE           *data_file = NULL;

#ifdef ULTRIX
	char            filename[MAXLENGTH];
#else				/* ULTRIX */
	char            filename[MAXLENGTH] =
	{0};
#endif				/* not_ULTRIX */

/* define some external functions. */
	extern char    *menu_data_filename(const char *);
	extern char    *header_filename(const char *);
	extern char    *header_rnd_filename(const char *);
	extern int      display_file(char *);

#if DEBUG
	fprintf(stderr, "** %s(%d): **\n", __FILE__, __LINE__);
#endif				/* DEBUG */

	/* Get the argument and give it to a variable, point to it then add
	   the rest of the items needed. */
	strcpy(filename, menu_data_filename((char *) Character->Currmenu));	/* Set down the filename */


	/* This is a binary file that will be READ_ONLY.  No writes will come
	   to this file under this program. */
#if DEBUG
	fprintf(stderr, "** %s: filename = %s, Character->Currmenu = %s **\n", __FILE__, filename, Character->Currmenu);
#endif				/* DEBUG  */
	if ((data_file = fopen(filename, "rb")) == NULL)
	{
		/* one day put in some error handleing. */
		fprintf(stderr, "%s: %s(%d): %s: Need read permission\n", PROGRAM, __FILE__, __LINE__, filename);
		exit(EXIT_FAILURE);
	}			/* if_menu_not_readable */

	/* Make sure the file is at the beginning */
	fseek(data_file, 0, SEEK_SET);


	/* Pad the entire block of variables with end of string characters to
	   initialize everything */
#if DEBUG
	fprintf(stderr, "** %s: Initializing the variables with end of string **\n", __FILE__);
#endif				/* DEBUG */
	for (cnt = 0; cnt < MAXLINES; cnt++)
	{
		menu[cnt].index = (int) '\0';
		menu[cnt].keyword[0] = '\0';
		menu[cnt].description[0] = '\0';
		menu[cnt].information[0] = '\0';
		menu[cnt].other[0] = '\0';
	}			/* for_clean_out_menu */


#if DEBUG
	/* header for the below menu showing */
	fprintf(stderr, "** %s: The menu as follows: **\n", __FILE__);
#endif				/* DEBUG */
	/* REad the menu into memory. */
	/* set the count to zero to prevent reading where I left off */
	count = 0;

	while (count < MAXLINES && fread(&menu[count], size, 1, data_file) == 1)
	{
		/* I could put something really fancy in here but it would go
		   so fast that you wouldn't get a chance to see it. */
		/* Increment that thing. */
		count++;

#if DEBUG
		fprintf(stderr, "** %s: menu[%d].index = %c, menu[%d].description = %s **\n", __FILE__, count, menu[count].index, count, menu[count].description);
#endif				/* DEBUG */
	}			/* while_debuging_print */

	rewind(data_file);	/* rewind the data file when done */
	/*** This seems to be the end of getting the menu information ***/


#if DEBUG
	/* yes the menu[].index is a integer, but it is being used as a
	   character.  */
	count = 0;		/* start back at the begining */
	while (count < MAXLINES && fread(&menu[count], size, 1, data_file) == 1)
	{
		fprintf(stderr, "** %s: menu[%d].index = %c,\n", __FILE__, count, menu[count].index);
		fprintf(stderr, "\tmenu[%d].keyword = %s, menu[%d].description = %s  **\n", count, menu[count].keyword, count, menu[count].description);
		count++;	/* increment to the next position. */
	}			/* while_debugging_print_menu */


	/* mention of the files closing */
	fprintf(stderr, "** %s: closing data file next **\n", __FILE__);

#endif				/* DEBUG */
	fclose(data_file);

	/* end of reading menu ----------------------- */

	/* according to the header option on the menu, what do we do */
#if DEBUG
	fprintf(stderr, "** %s: Header: menu[0].index = %c **\n", __FILE__, menu[0].index);

#endif				/* DEBUG */
	switch (menu[0].index)

	{

	case (int) 'H':	/* Always the same header. */

#if DEBUG
		fprintf(stderr, "** %s: Getting ready to display the constant header **\n", __FILE__);

#endif				/* DEBUG */
		strcpy(filename, header_filename(menu[0].information));

		display_file(filename);

		break;


	case (int) 'R':	/* Random header for menu. */

#if DEBUG
		fprintf(stderr, "** %s: Getting ready to display the random header **\n", __FILE__);

#endif				/* DEBUG */
		strcpy(filename, header_rnd_filename(menu[0].information));

		display_file(filename);

		break;		/* menu_random_header */


	case (int) 'B':	/* blank header, no menu is displyed */

#if DEBUG
		fprintf(stderr, "** %s: Getting ready to display a header with menu in it. **\n", __FILE__);

#endif				/* DEBUG */
		strcpy(filename, header_filename(menu[0].information));

		display_file(filename);

		/* set the value of skip menu to TRUE.  I don't want to print
		   out the menu because I have included its information in
		   the header. */
		skipmenu = TRUE;

		break;		/* menu_blank_header */


	default:		/* Any other menu header. */
		puts("--[");
		fprintf(stdout, "--[ %s ]--\n", menu[0].description);
		puts("--[");
		break;		/* menu_default_madeup_header */

	}			/* switch_through_header_types */


	/* Handle Menu: Make sure we leave the main title out of the menu. */
	/* if the menu hasn't been assigned to be skiped take care in
	   printing it out for the user to see */
	if (skipmenu != TRUE)
	{
		for (cnt = 0; cnt < count; cnt++)
		{
			if (cnt == 0)
			{
				fprintf(stdout, "\t\t%s\n\n", menu[cnt].description);
			}	/* if_cnt_eq_zero_print_description */
			else
			{
				fprintf(stdout, "\t(%s)\t%s\n", menu[cnt].keyword, menu[cnt].description);
			}	/* else_not_description_print_menu */
		}		/* for_print_out_menu_options */
	}			/* if_skipmenu_not_TRUE */
	skipmenu = FALSE;	/* automatically reset the menu setting to
				   display all the menus */


	/* add a little space */
	puts("");

	/* end of the menu display */
	return (RET_NORMAL);
}				/* display_menu */
