#!/bin/sh
#
# purpose: Reset the port to what ever it was before you ran a program.
#
# Use this one for the Baseline 5.47 - "Top Down" Program
#PROG=bbs_script
#
# Use this one for the Baseline 6.xx - "Finite State" Program
PROG=bbs_script_fn
SYS_TYPE=`uname -s`

if [ $SYS_TYPE = "HP-UX" ]; then
	echo "HP's don't trap 11..."
	oldparms=`stty -g`
	trap "stty $oldparms" 0 1 2 3 4 5 6 7 8 9 10 12 13 14 15 16
else # HP-UX #
	oldparms=`stty -g`
	trap "stty $oldparms" 0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16
fi # NOT_HP-UX #

# check if program exists
if [ -x $PROG ]; then
	$PROG
	exit 0
else
	echo "PROG = $PROG; Program does not exist.  Please fix."
	exit 1
fi # if_exists_program #
