#!/bin/sh
#
# [$Id: Modify.sh,v 1.4 1995/01/04 02:23:19 hitman Exp $]
# purpose: Modify section of database
#

# Get Variables
source Variables.sh

# Request Keyword
echo -n "Please enter a keyword: "
read KeyWord

# Display Lines
OutputFile=/tmp/$$.fil
OutputSort=/tmp/$$.sor
for Keys in $KeyWord;
do
	grep -i -n "$Keys" $Database >> $OutputFile
done
sort $OutputFile | uniq > $OutputSort

awk -F: '{ printf("%s\t%60.60s %5.5s\n", "Choice", $2, $1) }' $Index
echo "--------------------------------------------------------------------------"
awk -F: '{ printf("%d:\t%60.60s %5.5d\n", $1, $3, $2) }' $OutputSort

# User Picks Line
echo ""
echo -n "Which item: "
read UserChoice
#	Create a reference index from data in the file. Be very specific, the index
#		will be at the front of the file.  Only use the first item in the searches.
#		Use Column 2
IndexOne=`grep "^$UserChoice:" $OutputSort | awk -F: '{ print $2 }' | awk '{ print $1 }'`
echo $IndexOne > /dev/tty4
#		Use Column 3
IndexTwo=`grep "^$UserChoice:" $OutputSort | awk -F: '{ print $3 }' | awk '{ print $1 }'`
echo $IndexTwo > /dev/tty4
#		Use Column 4
IndexFour=`grep "^$UserChoice:" $OutputSort | awk -F: '{ print $4 }' | awk '{ print $1 }'`
echo $IndexFour > /dev/tty4
#		Use Column 5
IndexFive=`grep "^$UserChoice:" $OutputSort | awk -F: '{ print $5 }' | awk '{ print $1 }'`
echo $IndexFive > /dev/tty4

# User Picks Option to Modify
OriginalLine=/tmp/$$.ol
NewLine=/tmp/$$.nl
IndexLine=/tmp/$$.ndx
MergedLine=/tmp/$$.mrg
#	Create Index file
cat $Index | tr ':' '\n' | awk '{ print $1 }' > $IndexLine
#	Create Original Line, Remember to rip out that last line, the index will get 
#		the correct source line.
grep -i $IndexOne $Database | grep $IndexTwo | grep $IndexFour | grep $IndexFive | tr ':' '\n' > $OriginalLine
#	Merge the index and the original line file, Make sure I remove that last colon
paste -d: $IndexLine $OriginalLine | grep -v "^:" > $MergedLine

#	Create New Line
for Line in `cat $IndexLine`
do
#	The option will be from the Index file
	Option=$Line
#	The default info will be from the Original file
	Key=`echo "$Line" | awk -F'_' '{ print $1 }'`
	Default="`grep "$Key" $MergedLine | awk -F: '{ print $2 }'`"
	echo " "
	echo "$Option = $Default"
	echo -n "$Option: "
	read Input
#	If the user inputs a ctrl-d then use default
	if [ "$Input" = "" ]; then
	echo "Use Default..."
		echo "$Default" >> $NewLine
	else # eol_use_default #
		echo "$Input" >> $NewLine
	fi # NOT_eol_use_input #
done # for_merged_lines #

# Write Changes
#	Take out the line with the option
Working=/tmp/$$.wrk
SedScript=/tmp/$$.sed
echo "$UserChoice d" > $SedScript
# need to do that fancy merge thing, top and bottom, look in unix book
sed -f $SedScript $Database > $Working
echo "`cat $NewLine | tr '\n' ':'`" >> $Working
mv $Database $Database.ORIG
mv $Working $Database


# Clean up
rm -f $OutputFile \
	$NewLine \
	$OriginalLine \
	$NewLine \
	$IndexLine \
	$MergedLine \
	$SedScript \
	$Working
