/* menu.c - view menu files offline
 *
 * $Id: menu.c,v 1.2 2000/08/08 15:50:22 ivarch Exp $
 */

#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include "terminal.h"
#include "ldb.h"


void sh_cont (int);					/* SIGCONT handler */
int read_menu (char *, char *, char *, char *, int);	/* menu viewer */


typedef void (*sighandler_t)(int);


/* View "file" in the menu viewer.
 *
 * If "ldbfile" is not null, it is used to read and store the last access
 * details in and will be created if it does not already exist.
 */
int mview_menu (char * file, char * ldbfile) {
  sighandler_t oh;
  struct LDB d;
  int e;

  t_init (getenv ("TERM"));
  t_echo_off ();
  t_canon_off ();

  oh = signal (SIGCONT, sh_cont);

  ldb_read (ldbfile, file, &d);			/* read LDB entry for menu */

  e = read_menu (file, ldbfile, 0, 0, 0);	/* view the menu */

  if (e != 2) {
    d.last_accessed = time (0);
    ldb_write (ldbfile, &d);			/* store LDB entry */
  }

  t_echo_on ();
  t_canon_on ();

  signal (SIGCONT, oh);

  return (e > 1);
}

/* EOF */
