/* find.c - find an entry in an LDB file
 *
 * $Id: find.c,v 1.1.1.1 1999/12/02 20:03:10 ivarch Exp $
 */

#include <string.h>
#include "ldb.h"


/* Look in "ldbfile" for an entry for "file", returning its index in the
 * cache array if found or -1 if not.
 *
 * Note that no file locking is performed on "file".
 */
long ldb_find (char * ldbfile, char * file) {
  long i;

  if ((!ldbfile) || (!file)) return (-1);

  ldb_load (ldbfile);

  for (i = 0; i < ldb_cached_entries; i ++) {
    if (!strcmp (file, ldb_cache_names[i])) return (i);
  }

  return (-1);
}

/* EOF */
