/* readbuf.c - interpret strings and buffers
 *
 * $Id: readbuf.c,v 1.1.1.1 1999/12/02 20:01:17 ivarch Exp $
 */

#include <string.h>
#include "Internal.h"


/* Interpret null-terminated string "str" for terminal "vt". Returns zero
 * on completion, negative on error, or the number of bytes left to process.
 */
int vt100_interpret (vt_info vt, char * str) {
  if (!str) return (-1);
  return (vt100_interpret_buf (vt, str, strlen (str)));
}


/* Interpret "len" bytes starting at "buf" for terminal "vt". Returns zero
 * on completion, negative on error, or the number of bytes left to process.
 */
int vt100_interpret_buf (vt_info vt, char * buf, int len) {
  int e;

  if (!vt) return (-1);
  if (!buf) return (-1);

  for (; len > 0; len --) {
    e = vt100_interpret_char (vt, *buf);	/* interpret character */
    if (e < 0) return (-1);				/* error - abort */
    else if (e > 0) return (len - 1);			/* stop */
    buf ++;						/* continue */
  }

  return (0);
}

/* EOF */
