/* do.c - perform terminal actions
 *
 * $Id: do.c,v 1.1.1.1 1999/12/02 20:00:57 ivarch Exp $
 */

#include "Internal.h"


/* Perform "action" on "vt", assuming the callback function has already been
 * called.
 *
 * Returns negative on error.
 */
int vt100_do_action (vt_info vt, long action) {
  if (!vt) return (-1);
  if (!action) return (0);

  switch (action) {
    case VT_ACTION_BELL:        break;
    case VT_ACTION_LF:          return (vt100__lf (vt));
    case VT_ACTION_CR:          vt->x = 1; break;
    case VT_ACTION_RI:          return (vt100__ri (vt));
    case VT_ACTION_ID:          return (vt100__id (vt));
    case VT_ACTION_SAVE_CUR:    return (vt100__save_cur (vt));
    case VT_ACTION_RESTORE_CUR: return (vt100__restore_cur (vt));
    case VT_ACTION_RESET:       return (vt100_reset (vt));
    case VT_ACTION_STATUS:      return (vt100__status (vt));
    case VT_ACTION_CURSOR:      return (vt100__cursor (vt));
    case VT_ACTION_GOTO:        return (vt100__goto (vt));
    case VT_ACTION_DECALIGN:	return (vt100__decalign (vt));
    case VT_ACTION_CLEAR:       return (vt100__clear (vt));
    case VT_ACTION_SCROLL_UP:   return (vt100__scroll_up (vt));
    case VT_ACTION_SCROLL_DOWN: return (vt100__scroll_down (vt));
    case VT_ACTION_INS_LINE:    return (vt100__ins_line (vt));
    case VT_ACTION_DEL_LINE:    return (vt100__del_line (vt));
    case VT_ACTION_INS_CHAR:    return (vt100__ins_char (vt));
    case VT_ACTION_DEL_CHAR:    return (vt100__del_char (vt));
    case VT_ACTION_XTITLE:      break;
    case VT_ACTION_RENDITION:   return (vt100__rendition (vt));
    case VT_ACTION_SET_MODE:    return (vt100__set_mode (vt));
    case VT_ACTION_RESET_MODE:  return (vt100__reset_mode (vt));
  }

  return (0);
}

/* EOF */
