/* main.c - main program for converter
 *
 * $Id: main.c,v 1.3 2001/11/14 00:04:37 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include "getopt.h"
#include "actions.h"

char * current_user;


/* Process command-line arguments, set option flags, and call process_stream()
 * for each file named. If no files are named, or a filename of "-" is given,
 * process_stream() is called with stdin as the file stream.
 */
int main (int argc, char * argv[]) {
  struct option long_options[] = {
    {"file-input",    0, 0, 'f'},	/* input format options */
    {"menu-input",    0, 0, 'm'},
    {"ansi-input",    0, 0, 'a'},
    {"html-output",   0, 0, 'h'},	/* output format options */
    {"text-output",   0, 0, 't'},
    {"no-colour",     0, 0, 't'},
    {"colour-output", 0, 0, 'c'},
    {"menu-info",     0, 0, 'i'},	/* special input/output option */
    {"anonymous",     0, 0, 'y'},	/* output modifiers */
    {"guest",         0, 0, 'g'},
    {"ldb",           1, 0, 'd'},
    {"no-ldb",        0, 0, 'n'},
    {"unbuffered",    0, 0, 'u'},
    {"width",         1, 0, 'w'},
    {"height",        1, 0, 'H'},
    {"help",          0, 0, '!'},	/* informational options */
    {"version",       0, 0, 'V'},
    {0, 0, 0, 0}
  };
  char * short_options = "fmahtciygd:nuw:H:V";
  FILE * fptr = 0;
  int option_index = 0;
  int input = MT_INPUT_FILE;
  int output = MT_OUTPUT_ANSI;
  char guest = 0;
  char anon = 0;
  char unbuf = 0;
  int width = 80;
  int height = 25;
  struct passwd * z;
  char read_something = 0;
  char * ldbfile = 0;
  char is_stdin;
  char * pn;
  int c, r;

  current_user = getenv ("MCONV_USER");
  if (!current_user) current_user = getenv ("MVIEW_USER");
  if (!current_user) {
    z = getpwuid (getuid ());
    current_user = (z) ? strdup (z->pw_name) : "unknown";
  }

  pn = getenv ("COLUMNS");		/* set default terminal width */
  if (pn) width = atoi (pn);

  pn = getenv ("LINES");		/* set default terminal height */
  if (pn) height = atoi (pn);

  ldbfile = getenv ("MCONV_LDB");
  if (!ldbfile) ldbfile = getenv ("MVIEW_LDB");

  pn = strrchr (argv[0], '/');
  if (pn) pn ++; else pn = argv[0];

  do {			/* read options */
    c = getopt_long (argc, argv, short_options, long_options, &option_index);
    if (c < 0) continue;
    switch (c) {
      case 'f': input = MT_INPUT_FILE; break;
      case 'm': input = MT_INPUT_MENU; break;
      case 'a': input = MT_INPUT_ANSI; break;
      case 'h': output = MT_OUTPUT_HTML; break;
      case 't': output = MT_OUTPUT_TEXT; break;
      case 'c': output = MT_OUTPUT_ANSI; break;
      case 'i': input = MT_INPUT_MENU; output = MT_OUTPUT_INFO; break;
      case 'y': anon = 1; break;
      case 'g': guest = 1; current_user = "guest"; break;
      case 'd': ldbfile = optarg; break;
      case 'n': ldbfile = 0; break;
      case 'u': unbuf = 1; break;
      case 'w': width = atoi (optarg); break;
      case 'H': height = atoi (optarg); break;
      case 'V': display_version (); return (0); break;
      case '!': display_help (width, height); return (0); break;
      default :
        fprintf (stderr, "Try `%s --help' for more information.\n\r", pn);
        return (1);
        break;
    }
  } while (c != -1);

  c = 0;		/* exit status */

  if ((input != MT_INPUT_ANSI) && (output == MT_OUTPUT_HTML)) {
    printf ("<PRE><FONT COLOR=\"#CCCCCC;\">");
  }

  while (optind < argc) {

    if (!strcmp (argv[optind], "-")) {		/* read standard input */

      clearerr (stdin);					/* clear EOF */
      is_stdin = 1;

    } else {

      is_stdin = 0;
      fptr = fopen (argv[optind], "r");		/* read a file */
      if (!fptr) {
        fprintf (stderr, "%s: %s: Failed to open file\n\r", argv[0],
                 argv[optind]);
        c = 1;
      }
    }

    if (is_stdin) {
      r = process_stream (stdin, "-", ldbfile, input, output, guest,
                          anon, width, height);
      c |= r;
      if (r) {
        fprintf (stderr, "%s: standard input: File error\n\r", argv[0]);
      }
    } else if (fptr) {
      r = process_stream (fptr, argv[optind], ldbfile, input, output,
                          guest, anon, width, height);
      fclose (fptr);
      c |= r;
      if (r) {
        fprintf (stderr, "%s: %s: File error\n\r", argv[0], argv[optind]);
      }
    }

    read_something = 1;
    optind ++;
  }

  if (!read_something) {		/* no files specified - read stdin */
    if (unbuf) {
      setvbuf (stdin, 0, _IONBF, 0);
      setvbuf (stdout, 0, _IONBF, 0);
      input = MT_INPUT_UNBUF;
    }
    c = process_stream (stdin, "-", ldbfile, input, output, guest,
                        anon, width, height);
    if (c) {
      fprintf (stderr, "%s: standard input: File error\n\r", argv[0]);
    }
  }

  if ((input != MT_INPUT_ANSI) && (output == MT_OUTPUT_HTML)) {
    printf ("</FONT></PRE>\n");
  }

  return (c);
}

/* EOF */
