/* ban.c - check whether an action is banned
 *
 * $Id: ban.c,v 1.1.1.1 1999/12/02 20:00:11 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>


/* Return 1 if any of the characters in "str" are in the user's ban flags (the
 * environment variable BBS_BANS).
 */
int hook_check_ban (char * str) {
  char * a;
  int i;

  if (!str) return (0);

  a = getenv ("BBS_BANS");
  if (!a) return (0);

  for (i = 0; str[i] != 0; i ++) {
    if (strchr (a, str[i])) return (1);
  }

  return (0);
}

/* EOF */
