/* bored.c - display "bored" character for slow operations
 *
 * $Id: bored.c,v 1.1.1.1 1999/12/02 20:02:36 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include "terminal.h"


/* Displays "bored" character, a rotating | / - \ ... etc, or removes it if
 * "display" is 0. Only one frame is allowed per second.
 */
void t_bored (int display) {
  static char * c = "|/-\\";
  static int frame = 0;
  static time_t last_bored = 0;

  if (!display) {
    t_abswrite (" ");
    t_abswrite ("\010");
    last_bored = time (0) - 1;
    return;
  }

  if (last_bored >= time (0)) return;

  last_bored = time (0);

  write (STDOUT_FILENO, c + frame, 1);
  t_abswrite ("\010");

  frame ++;
  if (frame >= strlen (c)) frame = 0;
}

/* EOF */
