/* setsubs.c - set subscription information
 *
 * $Id: setsubs.c,v 1.2 2001/11/14 15:23:50 ivarch Exp $
 */

#include <ctype.h>
#include <string.h>
#include <sys/stat.h>
#include <unistd.h>
#include "terminal.h"
#include "viewmenu.h"

extern int menuview_abort;


/* Set the unsubscription flag for menu entry "e" to "s".
 */
void menuview_setsub_entry (menudata_t data, menuentry_t * e, int s) {
  struct stat sb;
  struct LDB d;

  if (e->key == 0) return;

  if (stat (e->filename, &sb)) return;

  ldb_read (data->ldbfile, e->filename, &d);
  if (d.last_accessed == 0) d.last_accessed = 1;
  d.sub_status = s;
  ldb_write (data->ldbfile, &d);
}


/* Set the subscription information for one or all of the options in the
 * current menu.
 */
void menuview_setsubs (menudata_t data) {
  int i = 0;
  int j, c;

  menuview_wipe_footer (data);
  strcpy (data->buf,
          "Option letter, [\035B=\035b] for all, [\035BQ\035b] to quit");
  t_goto (0, t_rows - 1);
  t_centre (data->buf);

  do {
    if (menuview_abort) return;
    c = toupper (t_getchar (1));
    if (c == 'Q') return;
    if (c == '=') break;
    for (i = 0; (toupper (data->menu->menu[i].key) != c)
                 && (i < data->menu->num_entries); i ++) ;
  } while (i >= data->menu->num_entries);

  menuview_wipe_footer (data);
  strcpy (data->buf,
          "[\035B2\035b]:Skip, [\035B0\035b]:Don't skip, [\035BQ\035b]:Quit");
  t_goto (0, t_rows - 1);
  t_centre (data->buf);

  do {
    if (menuview_abort) return;
    j = toupper (t_getchar (1));
    if (j == 'Q') return;
  } while ((j != '0') && (j != '2'));

  j -= '0';

  if (c == '=') {
    for (i = 0; i < data->menu->num_entries; i ++) {
      if (data->menu->menu[i].key != 0) {
        menuview_setsub_entry (data, &(data->menu->menu[i]), j);
      }
    }
    rf_redraw = 1;
  }

  if (i >= data->menu->num_entries) return;

  menuview_setsub_entry (data, &(data->menu->menu[i]), j);
  rf_redraw = 1;
}

/* EOF */
