/* execute.c - action for menu item type 'X'
 *
 * $Id: execute.c,v 1.1.1.1 1999/12/02 20:02:29 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "hook.h"
#include "terminal.h"
#include "viewmenu.h"


extern int menuview_rescan_now;


/* Execute menu entry "e".
 */
void menuview_execute (menudata_t data, menuentry_t * e) {
  char * p;
  pid_t c;

  if (!e->filename) return;

  if (bbs_hook (HOOK_VET_COMMAND, e->filename, data)) return;

  bbs_hook (HOOK_SET_ACTION, "Run ",
            (e->status & MENU_STATUS_HIDETITLE) ? "" : e->title);
  bbs_hook (HOOK_SET_KEYPATH, data->buf, 0);

  if (!(e->status & MENU_STATUS_BARLOG)) bbs_hook (HOOK_LOG_RUN, e, data);

  strcpy (data->buf, data->file);
  p = strrchr (data->buf, '/');		/* work out CWD */
  if (p) *p = 0;
  if (e->param == '&') {
    c = fork ();
    if (c == 0) {
      menuview_system (e->filename, data->buf);
      exit (0);
    }
  } else {
    t_echo_on ();
    t_canon_on ();    
    menuview_system (e->filename, data->buf);
    t_init (getenv ("TERM"));
    t_echo_off ();
    t_canon_off ();
  }

  if (e->param == '!') menuview_rescan_now = 1;
}

/* EOF */
