/* move.c - movement actions
 *
 * $Id: move.c,v 1.1.1.1 1999/12/02 20:01:44 ivarch Exp $
 */

#include <stdlib.h>
#include <string.h>
#include "terminal.h"
#include "viewfile.h"


/* Go to top of file and redraw.
 */
void rf_goto_top (rf_data_t data) {
  data->ldb_entry->current_line = -2;
  rf_redraw_screen (data);
}


/* Go to bottom of file and redraw.
 */
void rf_goto_end (rf_data_t data) {
  data->ldb_entry->current_line = data->num_lines;
  rf_redraw_screen (data);
}


/* Scroll back "n" lines.
 */
void rf_scroll_back (rf_data_t data, int n) {
  long line;

  rf_wipe_footer (data);

  line = data->ldb_entry->current_line - t_rows;

  while ((line >= -2) && (n > 0)) {
    t_scrollup ();
    rf_lineout (data, line);
    data->ldb_entry->current_line = line + (t_rows - 1);
    line --;
    n --;
  }

  rf_wipe_footer (data);
  rf_footer (data);
}


/* Scroll forward "n" lines.
 */
void rf_scroll_forward (rf_data_t data, int n) {
  long line;

  rf_wipe_footer (data);

  line = data->ldb_entry->current_line + 1;

  while ((line <= data->num_lines) && (n > 0)) {
    rf_lineout (data, line - 1);
    data->ldb_entry->current_line = line;
    line ++;
    n --;
  }

  rf_footer (data);
}


/* [G] - prompt for a line to go to, and go to it.
 */
void rf_goto (rf_data_t data) {
  char buf[16];
  long n;

  rf_wipe_footer (data);
  buf[0] = 0;

  do {
    n = t_input ("Goto line (or enter % for percentage) : ", buf,
                 sizeof (buf) - 1);
  } while (n == 1);

  rf_wipe_footer (data);
  rf_footer (data);

  if (buf[0] == 0) return;

  n = atol (buf);
  if (strchr (buf, '%')) n = n * data->num_lines / 100;

  if (n < 0) n = 0;
  if (n > data->num_lines) n = data->num_lines;

  data->ldb_entry->current_line = n;
  rf_redraw_screen (data);
}

/* EOF */
