/* vet.c - vet a command in a menu
 *
 * $Id: vet.c,v 1.3 2000/08/11 15:06:28 ivarch Exp $
 */

#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <pwd.h>
#include "viewmenu.h"
#include "bbs.h"


/* Return nonzero if the current menu is not allowed to get the current user
 * to run "cmd".
 *
 * A command is allowed if either the menu is owned by a sysop and is readonly
 * to group, or if the command is listed in the file configured by "paths".
 *
 * Alternatively, if the menu is owned by the current user and is readonly to
 * group, then all commands are allowed.
 */
int hook_vet_command (char * cmd, menudata_t data) {
  char buf[1024];
  struct passwd * p;
  struct stat sb;
  FILE * fptr;
  int ro = 0;
  char * a;

  if (stat (data->file, &sb)) return (1);	/* can't stat menu */

  if ((sb.st_mode & (S_IWGRP | S_IWOTH)) == 0) ro = 1;	/* RO to grp & all */

  if ((sb.st_uid == getuid ()) && ro) return (0);	/* user = menu owner */

  p = getpwuid (sb.st_uid);
  if (!p) return (1);			/* can't find menu owner's username */

  if (bbs_is_sysop (p->pw_name) && ro) return (0);	/* owner is sysop */

  fptr = fopen (cf_str ("paths"), "r");
  if (!fptr) return (1);			/* can't open paths list */

  while (!feof (fptr)) {
    buf[0] = 0;
    fgets (buf, 1023, fptr);
    buf[1023] = 0;
    a = strchr (buf, '\n');
    if (a) *a = 0;
    if (buf[0] == 0) continue;			/* ignore blank lines */
    if (!strncmp (buf, cmd, strlen (buf))) {	/* command is in paths list */
      fclose (fptr);
      return (0);
    }
  }

  fclose (fptr);
  return (1);
}

/* EOF */
