/* hook.c - BBS hook entry point
 *
 * $Id: hook.c,v 1.1.1.1 1999/12/02 19:59:39 ivarch Exp $
 */

#include <sys/types.h>
#include "viewfile.h"
#include "viewmenu.h"
#include "hook.h"
#include "bbs.h"
#include "u2u.h"

extern char * menu_file;

void hook_key_pressed (pid_t *, int *);
void hook_key_file (rf_data_t, int *);
void hook_key_menu (menudata_t, int *);
int  hook_menu_type (menuentry_t *, char *);
void hook_menu_action (menudata_t, menuentry_t *);
void hook_menu_bin (menudata_t, menuentry_t *);
void hook_set_action (char *, char *);
void hook_set_keypath (char *);
void hook_drop_privs (char *, char *);
int  hook_xrated_item (menudata_t, menuentry_t *);
int  hook_vet_command (char *, menudata_t);
int  hook_lookup_email (char **);
int  hook_is_external (void);
int  hook_is_guest (void);
void hook_location (char **);
int  hook_sitecheck (char *);
int  hook_usercheck (char *);
void hook_log_add (rf_data_t);
void hook_log_delete (rf_data_t, long *);
void hook_log_edit (rf_data_t);
void hook_log_run (menuentry_t *, menudata_t);
void hook_log_mail (rf_data_t);
void hook_log_action (menudata_t, menuentry_t *);
void hook_log_client (void);
int  hook_acl_check (menuentry_t *, char *, char **);
void hook_get_keypath (char **);
void hook_get_action (char **);
int  hook_check_ban (char *);


/* Entry point for all BBS hooks.
 */
int bbs_hook (bbs_hook_t which, void * data, void * p) {
  switch (which) {
    case HOOK_IN_BBS       : return (1);
    case HOOK_KEY_PRESSED  : hook_key_pressed (data, p); break;
    case HOOK_KEY_FILE     : hook_key_file (data, p); break;
    case HOOK_KEY_MENU     : hook_key_menu (data, p); break;
    case HOOK_MENU_TYPE    : return (hook_menu_type (data, p));
    case HOOK_MENU_ACTION  : hook_menu_action (data, p); break;
    case HOOK_MENU_BIN     : hook_menu_bin (data, p); break;
    case HOOK_SET_ACTION   : hook_set_action (data, p); break;
    case HOOK_SET_KEYPATH  : hook_set_keypath (data); break;
    case HOOK_DROP_PRIVS   : hook_drop_privs (data, p); break;
    case HOOK_XRATED_ITEM  : return (hook_xrated_item (data, p));
    case HOOK_VET_COMMAND  : return (hook_vet_command (data, p));
    case HOOK_LOOKUP_EMAIL : return (hook_lookup_email (data));
    case HOOK_IS_EXTERNAL  : return (hook_is_external ());
    case HOOK_IS_GUEST     : return (hook_is_guest ());
    case HOOK_LOCATION     : hook_location (data); break;
    case HOOK_SITECHECK    : return (hook_sitecheck (data));
    case HOOK_USERCHECK    : return (hook_usercheck (data));
    case HOOK_LOG_ADD      : hook_log_add (data); break;
    case HOOK_LOG_DELETE   : hook_log_delete (data, p); break;
    case HOOK_LOG_EDIT     : hook_log_edit (data); break;
    case HOOK_LOG_RUN      : hook_log_run (data, p); break;
    case HOOK_LOG_MAIL     : hook_log_mail (data); break;
    case HOOK_LOG_ACTION   : hook_log_action (data, p); break;
    case HOOK_LOG_CLIENT   : hook_log_client (); break;
    case HOOK_ACL_CHECK    : return (hook_acl_check (data, menu_file, p));
    case HOOK_GET_KEYPATH  : hook_get_keypath (data); break;
    case HOOK_GET_ACTION   : hook_get_action (data); break;
    case HOOK_CHECK_MSGS   : u2u_check (data ? 1 : 0); break;
    case HOOK_CHECK_BAN    : return (hook_check_ban (data)); break;
    default: break;
  }
  return (0);
}

/* EOF */
