/* edit.c - edit account details
 *
 * $Id: edit.c,v 1.1.1.1 1999/12/02 20:00:05 ivarch Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "examine.h"
#include "hook.h"
#include "bbs.h"

extern int ed_main (char *, long, char *, char *);
extern int rf_redraw;


/* Allow the user to edit "user"'s UDB.
 */
void examine_edit (char * user) {
  char action[1024];
  char keypath[64];
  char tbuf[1024];
  char buf[1024];
  char * a;
  int ul_c, ul_o;

  if (examine_priv_check (user)) return;

  strcpy (buf, cf_str ("udb"));
  a = strrchr (buf, '/');
  if (!a) return;
  sprintf (a, "/%s", user);

  sprintf (tbuf, "Edit account details for `%s'", user);

  a = 0;
  action[0] = 0;
  bbs_hook (HOOK_GET_ACTION, &a, 0);
  if (a) strncpy (action, a, sizeof (action) - 1);
  a = 0;
  keypath[0] = 0;
  bbs_hook (HOOK_GET_KEYPATH, &a, 0);
  if (a) strncpy (keypath, a, sizeof (keypath) - 1);

  bbs_hook (HOOK_SET_ACTION, 0, tbuf);
  bbs_hook (HOOK_SET_KEYPATH, "", 0);

  ed_main (buf, 0, tbuf, 0);

  bbs_hook (HOOK_SET_ACTION, 0, action);
  bbs_hook (HOOK_SET_KEYPATH, keypath, 0);

  if (strcmp (user, current_user) != 0) {	/* check new userlevel */
    examine_udb_load (user);
    a = getenv ("BBS_LEVEL");
    ul_c = atoi ((a) ? a : "0");

    a = examine_udb_env ("BBS_LEVEL");
    ul_o = atoi (a);

    if (ul_o <= ul_c) {				/* illegally low new level */
      sprintf (buf, "%d", ul_c + 1);
      examine_udb_env_set ("BBS_LEVEL", buf);
      examine_udb_save (user);
    }
  }

  rf_redraw = 1;
}

/* EOF */
