;*# name=Direct-video routines for Maximus
;/

        include dv_asmc.inc

PUBLIC VidGetch

VidGetch proc uses si di es, Row:word, Col:word

IFDEF __FARDATA__
        push    ds
        mov     cx, seg RowTable
        mov     ds, cx
ENDIF
        mov     ax,Vid_Bios             ; Check whether or not we need to
        or      ax,ax                   ; use the BIOS for output
        jnz     DoBios

        mov     ax,Vid_Segment          ; Load video segment into ES
        mov     es,ax

        LoadRow 0,RowTable,Row,Col      ; Figure out the right row/column

        push    ds                      ; Swap the ES:DI (generated by the
        push    es                      ; LoadRow macro) to DS:SI.
        mov     si,di

        SnowCheck Vid_HaveSnow 5        ; Check for display snow
        pop     ds                      ; set ds=es

        lodsw                           ; And dump in memory.
        pop     ds                      ; Restore data segment
        jmp     short getout

DoBios:
        BiosGoto Row, Col
;       mov     ah,02                   ; Set cursor position
;       xor     bh,bh                   ; Page zero
;       mov     dh,byte ptr [Row]       ; Load the row...
;       mov     dl,byte ptr [Col]       ; ...and the column
;       int     10h

        mov     ah,08                   ; Get character
        xor     bh,bh                   ; Page zero
        int     10h
getout:

IFDEF __FARDATA__
        pop     ds
ENDIF
        ret                             ; Return is in AX
VidGetch endp

end

