/*
 * Maximus Version 3.02
 * Copyright 1989, 2002 by Lanius Corporation.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include <stdlib.h>
#include "prog.h"
#include "crc.h"

dword _fast crc32fn(word ch, dword crc)
{
  dword dwch=(dword)ch;
  word i;

  for (i=8; i--; dwch >>= 1)
    crc=(crc >> 1) ^ (((dwch ^ crc) & 1) ? CRC32POLY : 0);

  return crc;
}

dword * _fast mkcrc32tab(void)
{
  dword *tab;
  word i;

  if ((tab=malloc(sizeof(dword)*256))==NULL)
    return NULL;

  for (i=0; i < 256; i++)
    tab[i]=crc32fn(i, 0L);

  return tab;
}

