/*****************************************************************************
 * *
 * *      MODULE:     my_types.h
 * *                  ----------
 * * $Id: my_types.h,v 1.5 1998/05/25 20:06:12 jvuokko Exp $
 * ***************************************************************************
 * *
 * *
 * *  COPYRIGHT (C) 1996-1998 JUKKA VUOKKO <jvuokko@iki.fi>.
 * *  ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Common datatypes and macros.
 * *
 *****************************************************************************/
#ifndef _my_types_h_
#define _my_types_h_

#define _XOPEN_SOURCE

#include <limits.h>

typedef unsigned char uchar_t;
typedef unsigned long ulong_t;
typedef unsigned short ushort_t;
typedef unsigned int  uint_t;
typedef uchar_t byte_t;
typedef unsigned int flag_t;
typedef unsigned short word_t;

typedef unsigned short word;
typedef unsigned char  byte;
typedef unsigned int   dword;

#if UINT_MAX != 4294967295U
#   error "Unsigned int is not 32 bit type. Sorry!"
#endif

#if UCHAR_MAX != 255
#   error "Unsigned char is not 8 bit type. Sorry!"
#endif

#if USHRT_MAX != 65535
#   error "Unsigned short is not 16 bit type. Sorry!"
#endif

inline dword bytes2dword( byte *s )
{
        dword v;
#ifdef LITTLE_ENDIAN_SYS
        v = *((dword*) s);
#else
        v = (dword) s[0] +
                ( ( (dword) s[1] ) << 8 ) +
                ( ( (dword) s[2] ) << 16 ) +
                ( ( (dword) s[3] ) << 24 );
#endif
        return v;
}

inline byte*
dword2bytes (byte *s, dword value)
{
#ifdef LITTLE_ENDIAN_SYS
        dword *ss = (dword*) s;
        *ss = value;
#else
        s[0] = (byte) (value & 0xff);
        s[1] = (byte) ((value >> 8) & 0xff);
        s[2] = (byte) ((value >> 16) & 0xff);
        s[3] = (byte) ((value >> 24) & 0xff);
#endif
        return s;
}

#ifdef USE_DEBUG
#   include <iostream.h>
/**
 *  Macro for printing debug-information. 
 *  Usage is simply: DEBUG( "foobar" << value ). The output is printed to
 *  stderr device and it is formatted like: '[foobar.cc:423]: message'.
 *  The name of the module and the line in the module is between brackets at
 *  the start of the line. The actual debug message follows it.
 *  If macro USE\_DEBUG is not defined, then macro DEBUG is empty.
 */
#   define DEBUG(x) (cerr << "[" << __FILE__ <<":"<< __LINE__ <<"]: "<< x << endl)
#else
#   define DEBUG(x)
#endif

#include <assert.h>


/** Macro for getting lower byte from the word */
#define LOW(a) ((a) & 0xff)

/** Macro for getting higher byte from the word */
#define HIGH(a) (((a) >> 8) & 0xff)

/** Macro for getting maximum value of two arguments */
#define MAX(a,b) (((a) > (b)) ? (a) : (b))

/** Macro for getting minimum value of two arguments */
#define MIN(a,b) (((a) < (b)) ? (a) : (b))


#ifdef NEED_BOOL   // for old c++ compilers that does not have bool type
typedef int bool;
#define false 0
#define true (!false)
#endif

#endif
