// $Id: wrapmsg.cc,v 1.1 1997/11/02 17:35:46 jvuokko Exp $

/*****************************************************************************
 * *
 * *      MODULE:     wrapmsg.cc
 * *                  ----------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Implementation of class Wrap_msg. Class is used for handling
 * *      article that contains lines that are too long to fit display.
 * *
 *****************************************************************************/

#include "wrapmsg.hh"

//**************************************************************************/
// CLASS: Wrap_msg
// MEMBER FUNCTION: operator =
//**************************************************************************/ 
//
// Initializes contents of object with contents of given Message object 'msg'.
// 
// 
// PARAMETERS: Message& msg   Reference to original Message object
//
// RETURN: Reference to initialized Wrap_msg object.
//**************************************************************************/
const Wrap_msg&
Wrap_msg::operator = (Message& msg)
{
        Message::operator=(msg);
        is_wrapped = false;
        return *this;
}
//**************************************************************************/
// CLASS: Wrap_msg
// MEMBER FUNCTION: wrap
//**************************************************************************/ 
//
// FIXME: jotain sepustusta...
// 
// 
// PARAMETERS: int width    Maximum width of the line that can be fitted to
//                          'bounding box'.
//
// RETURN: -
//**************************************************************************/
void
Wrap_msg::wrap( int width )
{
        if (is_wrapped == true ) {
                return;
        }
        is_wrapped = true;
        this->first_line();

        original_lines.destroy();
        if (true == msg_lines.first()) {
                String *tmp_str;
                do {
                        assert( msg_lines.get() );
                        tmp_str = new String( *msg_lines.get() );
                        original_lines.add( tmp_str );

                } while ( msg_lines.next() == true );
                original_lines.first();
                msg_lines.destroy();

                String *tmp;
                int len;
                do {
                        assert( original_lines.get() );
                        tmp_str = new String( *original_lines.get() );

                        if ( (len = tmp_str->length()) <= width ) {
                                msg_lines.add( tmp_str );
                        } else do {
                                tmp = new String;
                                tmp->copy( *tmp_str, 0, width-1);
                                len -= (width-1);
                                if (len > 0 ) {
                                        // append two spaces, so that line
                                        // will be little too long...
                                        tmp->append( "  " );
                                }
                                msg_lines.add( tmp );
                                tmp_str->copy( *tmp_str, width-1 );
                        } while ( len > 0 );
                } while ( original_lines.next() == true );
        }
        msg_lines.first();
}
//**************************************************************************/
// CLASS: Wrap_msg
// MEMBER FUNCTION: unwrap
//**************************************************************************/ 
//
// Restores contents wrapped of object to contents of original, unwrapped
// Message object.
// 
// PARAMETERS: -
// 
// RETURN: -
//**************************************************************************/
void
Wrap_msg::unwrap( void )
{
        if (is_wrapped == false ) {
                return;
        }
        is_wrapped = false;
        msg_lines.destroy();
        if (true == original_lines.first()) {
                String *tmp_str;
                do {
                        assert( original_lines.get() );
                        tmp_str = new String( *original_lines.get() );
                        msg_lines.add( tmp_str );
                } while ( original_lines.next() == true );
                msg_lines.first();
        }
}

