/* $Id: tree.cc,v 1.5 1998/05/25 20:06:08 jvuokko Exp $ */

/*****************************************************************************
 * *
 * *      MODULE:     tree.cc
 * *                  -------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      Methods for handling different tree structures.
 * *
 *****************************************************************************/

#include "datatypes.hh"
#include "../utilib/String.hh"
#include "tree.hh"
#include "../utilib/List.hh"


#undef DEBUG
#define DEBUG(ex)

//**************************************************************************/
// CLASS: key_tree
// MEMBER FUNCTION: init
//**************************************************************************/ 
//
// This function initializes trie (a sort of tree) with contents of an
// static array.
//
//
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: number of nodes in a trie
//**************************************************************************/
int
key_tree::init( const char* array[] )
{
        int i = 0;
        int num = 0;
        node* tmp;

        DEBUG("Initializing tree with array");
        
        // loop until item "@END" is reached
        while (strcmp( array[i], "@END") != 0) {
                DEBUG("-->Node: "<<array[i]);
                tmp = new node;
                tmp->key = array[i];
                ++i;
                ++num;
                while (strcmp( array[i], "@NEXT" ) != 0) {
                        DEBUG("  Value: " << array[i]);
                        String *str = new String;
                        *str =  array[i] ;
                        tmp->values.add( str );
                        ++i;
                }
                tree.add( tmp );
                ++i;
        }
        DEBUG("Tree initialized. Size is " << num);
        return num;
}


//**************************************************************************/
// CLASS: key_tree
// MEMBER FUNCTION: get_value
//**************************************************************************/ 
//
// Searchs for keyword that matches with given c-string key, and returns
// value of that keyword.
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS: keyword to get value from.
//
// RETURN: value of a given key as a string object
//**************************************************************************/
String&
key_tree::get_value( const char* key )
{
        String kw = key;
        goto_keyword( kw );
        assert( tree.get() != 0);
        return tree.get()->rc_value;
        
}
//**************************************************************************/
// CLASS: key_tree
// MEMBER FUNCTION: goto_keyword
//**************************************************************************/ 
//
// Moves current position in a tree ("trie") to a given keyword. If keyword
// not found, then false is returned.
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS: keyword to search
//
// RETURN: true if found, false if not
//**************************************************************************/
bool
key_tree::goto_keyword( String& key)
{
        tree.first();
        assert(tree.first() == true);
        do {
                if (key == tree.get()->key) {
                        return true;
                }
        } while (tree.next() == true);
        return false;
}
//**************************************************************************/
// CLASS: key_tree
// MEMBER FUNCTION: set_value
//**************************************************************************/ 
//
// This function assings given value to current keyword.
// Function also checks that given value matches with a rule of a keyword.
// If given value does not match with a any rule, then false is returned.
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS: value for keyword.
//
// RETURN: true if value was accepted, false if value was illegal.
//**************************************************************************/
bool
key_tree::set_value( String& value)
{
        node *tmp = tree.get();
        tmp->values.first();
        assert( tmp->values.first() == true);

        // first check if value must be number
        if ( *tmp->values.get() == "$" ) {
                if (value.is_number() == true) {
                        tmp->rc_value = value;
                        return true;
                } else {
                        return false;
                }
        }

        // then check if resource must have value, but type of
        // value is not ordered.
        if ( *tmp->values.get() == "*") {
                if (value.is_empty() == false) {
                        tmp->rc_value = value;
                        return true;
                } else {
                        return false;
                }
        }

        // check if anything is accepted, even empty value.
        if ( tmp->values.get()->is_empty() == true) {
                if (value.is_empty()) {
                        tmp->rc_value = " ";
                } else {
                        tmp->rc_value = value;
                }
                return true;
        }

        // keyword has no special rules, value of it must match
        // with some of defined values.
        do {
                if ( value == *tmp->values.get() ) {
                        tmp->rc_value = value;
                        return true;
                }
        } while (tmp->values.next() == true);
        
        return false;
}

void
menu_trie::add_menu( const String& str, const int cmd )
{
        trienode *tmp = new trienode;
        tmp->menu = str;
        tmp->command = cmd;
        tmp->maxlen = str.length();
        trie.add( tmp );
}

void
menu_trie::add_item( const String &str, const int cmd )
{
        trienode *tmp;
        node *nd = new node;
        
        tmp = trie.get();
        assert( tmp != 0 );

        nd->item = " " + str;
        nd->item += " ";
        nd->command = cmd;

        if (tmp->maxlen < (str.length()+2)) {
                tmp->maxlen = str.length()+2;
        }
        tmp->items.add( nd );
}

int
menu_trie::get_maxlen()
{
        trienode *tmp;
        tmp = trie.get();
        assert( tmp );

        return tmp->maxlen;
}

bool
menu_trie::first_menu()
{
        return trie.first();
}

bool
menu_trie::next_menu()
{
        return trie.next();
}

bool
menu_trie::prev_menu()
{
        return trie.prev();
}

bool
menu_trie::first_item()
{
        trienode *tmp = trie.get();
        assert (tmp != 0);
        return tmp->items.first();
}

bool
menu_trie::next_item()
{
        trienode *tmp = trie.get();
        assert (tmp != 0);
        return tmp->items.next();
}

bool
menu_trie::prev_item()
{
        trienode *tmp = trie.get();
        assert (tmp != 0);
        return tmp->items.prev();
}

const String&
menu_trie::get_menu()
{
        assert (trie.get() != 0);
        return trie.get()->menu;
}

const String&
menu_trie::get_item()
{
        assert( trie.get() != 0 );
        assert( trie.get()->items.get() != 0 );
        return trie.get()->items.get()->item;
}

int
menu_trie::get_command()
{
        assert( trie.get() != 0 );
        trienode *tmp;

        tmp = trie.get();
        
        if (tmp->items.check() == false) {
                return tmp->command;
        }

        return tmp->items.get()->command;
}

void
menu_trie::destroy()
{
        if (true == trie.first()) {
                trie.destroy();
        }
}
