// 	$Id: time.cc,v 1.3 1997/08/28 18:24:59 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : time.cc
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Methods for getting current time and for handling date in jmr's internal
 * * format and in displayed format.
 * *
 * *
 * *
 * *
 ***************************************************************************/


#include "time.hh"
#include "jmr.hh"


extern settings_t Settings;

//**************************************************************************/
//  CLASS: Time_handler
//  MEMBER FUNCTION: update
// 
// 
//  DESCRIPTION: Updates time
// 
// 
//**************************************************************************/
void
Time_handler::update()
{
        current_time = time (NULL);
        local_time = localtime (&current_time);
}

//**************************************************************************/
//  CLASS: Time_handler
//  MEMBER FUNCTION: get_time
// 
// 
//  DESCRIPTION: Returns pointer static string that contains current time in
//               hh:mm format.
//
//  NOTE: Copy contents of returned string immediately to somewhere better
//        place!
// 
//**************************************************************************/

char*
Time_handler::get_time()
{
        update();
        static char buffer[6];
        strftime (buffer, 6, "%H:%M", local_time);
        return buffer;
        
}

//**************************************************************************/
//  CLASS: Time_handler
//  MEMBER FUNCTION: get_date
// 
// 
//  DESCRIPTION: Returns pointer to static string that contains current 
//               date in mm-dd-yyyy form.
//
//  NOTE: Copy contents of returned string immediately to somewhere better
//        place!
// 
//**************************************************************************/
char*
Time_handler::get_date()
{

        static char buffer[12];
        update();
        strftime (buffer, 11, "%m-%d-%Y", local_time);
        return buffer;
}




void
Date::set_date()
{
        _date = "";
        char *ptr = Settings.date_fmt.c_str();
        
        while (*ptr) {
                if (*ptr != '%' ) {
                        _date += *ptr;
                } else if (*++ptr) {
                        int tmp;
                        switch( *ptr ) {
                        case 'D':
                                tmp = get_day( _jmrdate.c_str() );
                                if (tmp < 10 ) {
                                        _date += '0';
                                }
                                _date += tmp;
                                break;
                        case 'M':
                                tmp =  get_month( _jmrdate.c_str() );
                                if (tmp < 10) {
                                        _date += '0';
                                }
                                _date += tmp;
                                break;
                        case 'Y':
                                _date += get_year( _jmrdate.c_str() );
                                break;
                        default:
                                _date += *ptr;
                        }
                }
                ++ptr;
        }
}


const Date&
Date::operator=(const Date& src)
{
        if (this == &src) {
                return *this;
        }
        _date = src._date;
        _jmrdate = src._jmrdate;
        return *this;
}
