#ifndef __threadit_otsikko
#define __threadit_otsikko
 
#include "../utilib/my_types.h"
#include "constants.h"
#include "../utilib/List.hh"
#include "mail.hh"
#include "ring.hh"

extern Mail* mail;

class Msgthread {
public:
        Msgthread( int i) : unread(0), total(0), index(i) {}
        ~Msgthread() { articles.leave(); }
        int count_unread() const { return unread; }
        int count_articles() const { return total; }
        void refresh();
        int get_index() const { return index; }
        Message* get() { return articles.get(); }
        bool add_msg( Message* msg );
        bool first() { return articles.first(); }
        bool next() { return articles.next(); }
        bool prev() { return articles.prev(); }
        bool last() { return articles.last(); }
        void save_position() { articles.save_position(); }
        void restore_position() { articles.restore_position(); }
        void dec_unread() { --unread; }
private:
        int unread;
        int total;
        int index;
        List<Message> articles;
};


class Grpthread {
public:
        Grpthread() : initialized( false ), all_flag( false ) {}
        ~Grpthread() {};
        void update( bool show_all = false );
        void refresh();
        bool next_unread();
        bool next() { return threads.next();}
        bool prev() { return threads.prev();}
        bool last() { return threads.last();}
        bool go_index( int i );
        bool go_message( Message *msg );
        bool check() const { return threads.check(); }
        void sort( int order ) { mail->sort(order); update( all_flag ); }
        bool tag_all();
        int get_index() const { return threads.get()->get_index(); }
        int count_threads_articles() {return threads.get()->count_articles();}
        int count_threads_unread() { return threads.get()->count_unread(); }
        int count_threads() { return threads.count_items(); }
        Msgthread* get_thread() { return threads.get(); }
        Message* get_article() { return threads.get()->get(); }
        const String& get_subject() {return get_article()->get_subject(); }
        const String& get_author()  {return get_article()->get_writer(); }
        const String& get_receiver() {return get_article()->get_receiver(); }
private:
        void create_threads();
        void create_article_list();
        bool initialized;
        bool all_flag;
        List<Msgthread> threads;
};


#endif
