
// Module id :
// $Id: threads.cc,v 1.1 1997/07/17 15:37:25 jvuokko Exp $

/*****************************************************************************
 * *
 * *      MODULE:     threads.cc
 * *                  ----------
 * ***************************************************************************
 * *
 * *
 * *      COPYRIGHT (C) 1997 JUKKA VUOKKO. ALL RIGHTS RESERVED
 * ***************************************************************************
 * *
 * *      This module contains functions for handling single thread and
 * *      all threads withing a group.
 * *
 *****************************************************************************/

#include "jmr.hh"
#include "threads.hh"

//**************************************************************************/
// CLASS: Msgthread
// MEMBER FUNCTION: add_msg 
//**************************************************************************/ 
//
// Adds new article to thread (next to current article ).
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: true if success
//**************************************************************************/
bool
Msgthread::add_msg( Message *msg )
{
        ++total;
        if ( !(msg->get_status() & READ_ST) ) {
                ++unread;
        }
        return articles.add( msg );
}

//**************************************************************************/
// CLASS: Msgthread
// MEMBER FUNCTION: refresh 
//**************************************************************************/ 
//
// This updates count of unread and total articles of thread.
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: -
//**************************************************************************/
void
Msgthread::refresh()
{
        Message *msg;
        total = unread = 0;
        articles.save_position();
        if (articles.first() == false) {
                return;
        }
        do {
                msg = articles.get();
                if ( !(msg->get_status() & READ_ST) ) {
                        ++unread;
                }
                ++total;
        } while ( articles.next() == true );

        articles.restore_position();
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: update
//**************************************************************************/ 
//
// Updates contents of threads.
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Grpthread::update( bool show_all)
{
        if ( threads.check() == true ) {
                threads.destroy();
        }
        all_flag = show_all;
        if (mail->is_group_used() == true ) {
                if (mail->get_sort_order() == THREAD_SORTED ) {
                        create_threads();
                } else {
                        create_article_list();
                }
                threads.first();
        }
        initialized = true;
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Grpthread::create_threads()
{
        Message *tmp;
        String first_subject, current_subject;
        Msgthread *thread;
        int index = 0;

        mail->save_message_pos();
        mail->first_article();
        do {
                int n = 1;
                tmp = mail->get_article();
                tmp->set_number_in_thread (n);
                // add first message of a current thread
                first_subject = tmp->get_stripped_subject();

                thread = new Msgthread( index );

                thread->add_msg( tmp );
                
                // then get rest articles of a current thread
                while (mail->next_article() == true) {
                        ++n;
                        tmp = mail->get_article();
                        tmp->set_number_in_thread (n);
                        current_subject = tmp->get_stripped_subject();
                        strip_re_prefix(current_subject);

                        if (first_subject == current_subject) {
                                thread->add_msg (tmp);
                        } else {
                                mail->prev_article();
                                break;
                        }
                }
                // if thread does not contains any unread articles
                // and only unread articles is wanted, then abandon it.
                if (thread->count_unread() == 0 && all_flag == false) {
                        delete thread;
                        continue;
                }
                thread->first();
                threads.add (thread);
                ++index;
        } while (mail->next_article() == true);
        mail->restore_message_pos();
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Grpthread::create_article_list()
{
        Message *tmp;
        Msgthread *thread;
        int i = 0;
        mail->save_message_pos();
        mail->first_article();
        do {
                tmp = mail->get_article();
                if (all_flag == false && tmp->get_status() & READ_ST) {
                        continue;
                }
                thread = new Msgthread( i );
                tmp->set_number_in_thread( 1 );
                thread->add_msg( tmp );
                threads.add (thread);
                ++i;
        } while (mail->next_article() == true);
        mail->restore_message_pos();
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
void
Grpthread::refresh()
{
        assert( initialized );
        // update every thread
        threads.save_position();
        if (threads.first() == false) {
                return;
        }
        do {
                threads.get()->refresh();
        } while (threads.next() == true);
        threads.restore_position();
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
bool
Grpthread::next_unread()
{
        bool rc = false;
        int i;
        Msgthread *tmp;

        // first check if thread have unread articles. If not, then
        // search for unread thread.
        if (threads.check() == false ) {
                return false;
        }
        tmp = threads.get();
        i = tmp->get_index();

        if (tmp->count_unread() > 0) {
                rc = true;
        } else {
                threads.save_position();
                // seek forward for unread articles
                while (threads.next() == true) {
                        tmp = threads.get();
                        if (tmp->count_unread() > 0) {
                                rc = true;
                                break;
                        }
                }
                // if unread message not found, try seek from the first thread.
                if (rc == false) {
                        threads.first();
                        do {
                                tmp = threads.get();
                                if (tmp->count_unread() > 0) {
                                        rc = true;
                                        break;
                                }
                        } while (threads.next()==true && tmp->get_index() < i);
                        if (rc == false) {
                                threads.restore_position();
                        }
                }
        }
        // if thread that have unread articles found, then set position
        // to first unread message
        if (rc == true) {
                tmp = threads.get();
                if ( (rc = tmp->first()) == true ) {
                        Message *msg;
                        do {
                                msg = tmp->get();
                                if (!(msg->get_status() & READ_ST)) { 
                                        break;
                                }
                        } while ((rc = tmp->next()) == true);
                }
        }
        return rc;
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
bool
Grpthread::go_index( int i )
{
        Msgthread *tmp;
        assert( initialized );
        if (threads.check() == false) {
                return false;
        }
        tmp = threads.get();
        
        while (tmp->get_index() < i) {
                if (threads.next() == false) {
                        break;
                }
                tmp = threads.get();
                
        } 
        while (tmp->get_index() > i) {
                if (threads.prev() == false) {
                        break;
                }
                tmp = threads.get();
        }
        return true;
}

//**************************************************************************/
// CLASS: Grpthread
// MEMBER FUNCTION: 
//**************************************************************************/ 
//
// 
// 
// EXTERNAL VARIABLE REFERENCES
//   IN :  
//   OUT: 
// 
// PARAMETERS:
//
// RETURN: 
//**************************************************************************/
// palauttaa true jos kaikki tagattu, false jos merkinnt poistettu.
bool
Grpthread::tag_all()
{
        static int count;
        Message *msg;
        threads.save_position();
        ++count;
        assert( initialized );
        if (false == threads.first()) {
                return false;
        }

        // tag current article of each thread
        if (count % 2) {
                do {
                        msg = get_article();
                        assert( msg != 0 );
                        if (! (msg->get_status() & TAGGED_ST) ) {
                                mail->tag_article( msg );
                        }
                } while (threads.next() == true);
        } else {
                // untag current article of each thread
                do {
                        msg = get_article();
                        assert( msg );
                        if (msg->get_status() & TAGGED_ST ) {
                                mail->tag_article( msg );
                        }
                } while (threads.next() == true );
        }
        threads.restore_position();
        if (count % 2 ) {
                return true;
        }
        return false;
}



bool
Grpthread::go_message( Message* msg )
{
        threads.save_position();
        if( threads.first() == false) {
                return false;
        }
        do {
                Msgthread *tmp;
                tmp = threads.get();
                tmp->save_position();
                if (tmp->first() == false ) {
                        continue;
                }
                do {
                        if (tmp->get() == msg ) {
                                return true;
                        }
                } while ( tmp->next() == true );
                tmp->restore_position();
        } while ( threads.next() == true );
        threads.restore_position();
        return false;
}

