
// 	$Id: replies.hh,v 1.9 1998/07/18 19:52:03 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : replies.hh
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * *
 * * Class for writing articles
 * *
 * *
 * *
 * *
 ***************************************************************************/

#ifndef __REPLIES_HH__
#define __REPLIES_HH__

#include "messagedata.hh"

class Replyhandler {
public:
        Replyhandler();
        ~Replyhandler(){};
        void followup (Message *message);
        void reply (Message *message);
        void edit (Message *message);
        void write();
        void edit_header( Message* msg );
private:
        String tagline;
#ifdef TAGB
		String savedtag;
#endif
        int ypos;
//        int counter; // kasvaa aina yhdell, kun jotakin reply
        // ksitelln. Tmn perusteella otetaan aina indeksi replylle.

        int msg_type; // EDIT_MSG, REPLY_MSG or NEW_MSG
        
        Message *src_article; // osoitin lainattavan viestin dataan
        // seuraava muistetava aina varata uutta viesti varten!!
        Message *new_article;   // osoitin uuden viestin dataan

        int reply_group; // ryhm johon henkilkohtainen vastaus menee

        void handle_reply ();
        bool fwrite_article ();
        void fwrite_replystring (fstream& file);
        bool fread_article ();
        void update_header(); 
        //void update_reply_group ();
        int get_info();   // kysyy viestin tietoja
        bool get_confirm();
        void get_subject();
        void get_status();
        void get_receiver();
        void get_new_group();
        void edit_tagline();
        void select_reply_group();
//        void init_counter();

};

#endif
