// 	$Id: replies.cc,v 1.29 1998/07/22 19:26:27 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : replies.cc
 * *
 * *  Copyright (c) 1997,1998 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Functions for writing and editing messages.
 * *
 * *
 * *
 * *
 * *
 ***************************************************************************/

#include <fstream.h>
#include <stdio.h>  // sprinf()
#include <stdlib.h> // system()
#include <ctype.h>  // isdigit()

#ifdef __unix__
#   include <unistd.h>
#endif
#include "jmr.hh"
#include "mail.hh"
#include "replies.hh"
#include "terminal_io.hh"
#include "time.hh"
#include "groupselect.hh"
#include "userselect.hh"

//***************** global variables ***************************************/
extern Terminal_screen Screen;
extern settings_t Settings;
extern Mail* mail;


//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: Replyhandler
// 
// 
//  DESCRIPTION: Constructor...
// 
// 
//**************************************************************************/
Replyhandler::Replyhandler()
{
        ypos = Screen.get_ymax();
        reply_group = -1;
#ifdef TAGB
	savedtag = tagline;			// initally these are the same
#endif
}
/*
void
Replyhandler::init_counter()
{
        mail->save_group_pos();
        mail->go_group_number (NEW_REPLIES_NUMBER);
        counter = mail->count_articles();
        DEBUG( "Replyhandler: counter initialized to: " << counter );
        mail->restore_group_pos();

}*/

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: followup
// 
// 
//  DESCRIPTION: For write followup to message
// 
// 
// 
//**************************************************************************/
void
Replyhandler::followup (Message *message)
{
        src_article = message;
        msg_type = FOLLOWUP_MSG;
//        init_counter();
#ifdef TAGB
	savedtag = tagline;
#endif
        handle_reply();
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: reply
// 
//  DESCRIPTION: for reply message. 
//               This function asks if current group is suitable for
//               private replies, and allows user to choose better group.
// 
// 
// 
//**************************************************************************/
void
Replyhandler::reply (Message *message)
{
        int c;
        src_article = message;
        msg_type = REPLY_MSG;

//        if (reply_group == -1) {  FIXME - se replyryhm-automaatio...
        reply_group = src_article->get_group_number();
//        }
loop:
        Screen.clear();
        mail->save_group_pos();
        mail->go_group_number (src_article->get_group_number());
        Screen.print( "\nYou're replying for message from group : %s (%d)\n\n",
                      mail->get_group_name().c_str(),
                      src_article->get_group_number() );
        mail->go_group_number (reply_group);
        Screen.textcolor (Settings.header_subject_color | BOLD);
        Screen.print( "Current group setting for reply is : %s (%d)",
                      mail->get_group_name().c_str(), reply_group );
        Screen.reset_attr();
        mail->restore_group_pos();

        Screen.bold();
        Screen.addstr( "\n\nIs current group right for private reply?" );
        Screen.bottom();
        show_option_str( "[@q@]uit [@n@]o, choose other group [@y@]es, "
                         "group is right. @n@" );
        do {
                c = Screen.get_ch();
        } while (c != QUIT_CMD && c != 'n' && c != 'y' && c != SELECT_CMD);
        if (c == QUIT_CMD) {
                return;
        }
        if ( c != 'y') {
                select_reply_group();
                goto loop;
        }
        
//        init_counter();
#ifdef TAGB
	savedtag = tagline;
#endif
        handle_reply();
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: write.
// 
// 
//  DESCRIPTION: Function for writing new article.
// 
// 
// 
//**************************************************************************/
void
Replyhandler::write()
{
        Message dummy;
        Groupselection grpsel;
        
        char *tmp = new char [Settings.max_subject_len+1];
        *tmp = '\0';
        dummy.set_group_number (mail->get_group_number());
        dummy.set_writer (mail->get_username());
        dummy.init_status (UNREAD_ST);
        Screen.clear();
        Screen.gotoxy( 0, 2 );
        Screen.addstr( "Enter subject for message : " );
        Screen.textcolor(BOLD);
        Screen.getline (tmp, Settings.max_subject_len, 0);
        dummy.set_subject (tmp);
        Screen.reset_attr();
        Screen.gotoxy( 0, 4 );
        Screen.addstr( "Enter receiver for message : " );
        Screen.textcolor(BOLD);
        strcpy (tmp, Settings.default_receiver.c_str());
        Screen.getline (tmp, Settings.max_bbs_subject_len, 0);
	while (strcmp(tmp, "") == 0) {
                Userselection us; // KRID
                String st = us.select();
                strncpy(tmp, st.c_str(), Settings.max_bbs_subject_len);
                Screen.gotoxy( 0, 4 );
                Screen.addstr( "Enter receiver for message : " );
                Screen.textcolor(BOLD);
                Screen.getline (tmp, Settings.max_bbs_subject_len, 0);
                Screen.gotoxy( 0, ypos );
                Screen.reset_attr();
                Screen.empty_line();
	} 
        dummy.set_receiver (tmp);
        delete[] tmp;

        Screen.gotoxy( 0, 6 );
        Screen.reset_attr();
        Screen.empty_line();
        Screen.addstr( "Group : ");
        Screen.bold();
        Screen.print( "%s [ %d ]", mail->get_group_name().c_str(),
                      mail->get_group_number());
        Screen.refresh( REDRAW_ALL );
        int c = Screen.get_ch();
        if ( c == QUIT_CMD ) {
                return;
        } else if ( c != SELECT_CMD ) {
                grpnode num = grpsel.select();
                dummy.set_group_number (num.number);
                dummy.set_number (num.number);
        }
        
        src_article = &dummy;
        msg_type = NEW_MSG;
//        init_counter();
#ifdef TAGB
	savedtag = tagline;
#endif
        handle_reply();

}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: edit
// 
// 
//  DESCRIPTION: Fuction for edit message (reply)
// 
// 
// 
//**************************************************************************/
void
Replyhandler::edit (Message *message)
{
        src_article = message;
#ifndef TAGB
        src_article->strip_tagline();
#else
	src_article->strip_tagline(savedtag);
	if (savedtag.is_empty())
	  savedtag = tagline;
#endif
        msg_type = EDIT_MSG;
//        init_counter();
        handle_reply();

}

void
Replyhandler::edit_header( Message *msg )
{
        src_article = msg;
        new_article = new Message;
        *new_article = *msg;
#ifndef TAGB
        new_article->strip_tagline();
#else
	new_article->strip_tagline(savedtag);
	if (savedtag.is_empty())
	  savedtag = tagline;
#endif
        if (SUCCESS_FL == get_info() ) {
                *msg = *new_article;
#ifndef TAGB
                msg->add_tagline( tagline );
#else
		msg->add_tagline( savedtag );
#endif
        }
        delete new_article;
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: handle_reply
// 
// 
//  DESCRIPTION: This function writes quoted message to file, executes editor
//               and stores new article.
//               Tagline is also appended here.
// 
//  EXTERNAL REFERENCES:
//  IN :  Settings.editor
//  OUT: 
// 
//**************************************************************************/
void
Replyhandler::handle_reply()
{
       String cmd;
       int i;
       cmd = Settings.editor + " " + REPLY_TEMP_FILENAME;

       if (false == fwrite_article()) {
               return;
       }
       
       new_article = new Message;
       update_header();
       
edit_again:
       // change to jmr's root-directory. If jmr or whole system crashes when
       // you're editing reply, your editor might left emergency file here...
       change_dir (Settings.jmrdir.get());

       DEBUG( "handle_reply: Executing editor" );
       if (jmrsystem (cmd.get())) {
               String tmp = "Cannot execute editor using command: \'"
                       + cmd + "\'\n";
               system_error( tmp.get() );
               change_dir( Settings.workdir.get() );
               delete new_article;
               return;
       }
       // return to working directory
       change_dir (Settings.workdir.get());

       new_article->remove_lines();
       DEBUG( "Reading contents of new reply from disk" );
       if (fread_article() == false) {
               delete new_article;
               return;
       }
       
       if ((i = get_info()) == FAILED_FL) {
               delete new_article;
               return;
       }

       if (i == EDIT_FL) {
               goto edit_again;
       }
       DEBUG( "handle_reply: Setting replied flag" );
       src_article->set_status_bits( REPLIED_ST );

       DEBUG ("Add tagline");
#ifndef TAGB
       new_article->add_tagline (tagline);
#else
       new_article->add_tagline (savedtag);
#endif
       if (msg_type == EDIT_MSG) {
               *src_article = *new_article;
               delete new_article;
       } else {
               DEBUG ("Add reply to list");
               mail->add_reply (new_article);
       }
       DEBUG("OK");
//       ++counter;

       mail->write_recovery_file();
}


//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: select_reply_group
// 
// 
//  DESCRIPTION: Select new group for reply.
// 
// 
//**************************************************************************/
void
Replyhandler::select_reply_group()
{
        Groupselection grp;
        int saved = mail->get_group_number();
        reply_group = grp.select().number;
        mail->go_group_number( saved );
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: update_header
// 
// 
//  DESCRIPTION: Updates header of new reply and asks information for user.
//               
//  /* FIXME */ Does not return anything...
//  RETURNS: FAILED_FL is user aborts message. EDIT_FL if user wants to edit
//           reply. SUCCESS_FL if ok.
//**************************************************************************/
void
Replyhandler::update_header()
{
        Time_handler Time;
        
        new_article->init_status (src_article->get_status());
        new_article->reset_status_bits (READ_ST | TAGGED_ST);

        // insert prefix 'Re: ' if reply, and set private flag
        if (msg_type == REPLY_MSG) {
                String tmp;
                new_article->set_status_bits (PRIVATE_ST);
                new_article->set_number (reply_group);
                new_article->set_group_number (reply_group);
                tmp = src_article->get_subject();
                strip_re_prefix (tmp);
                new_article->set_subject ("Re: " + tmp);
        } else {
                new_article->set_group_number(src_article->get_group_number());
                new_article->set_number (src_article->get_group_number());
                new_article->set_subject (src_article->get_subject());
        }
        new_article->set_date (Time.get_date());
        new_article->set_time (Time.get_time());
        new_article->set_writer (mail->get_username());
        if (msg_type == FOLLOWUP_MSG || msg_type == REPLY_MSG) {
#ifndef F_TO_ALL
                new_article->set_receiver (src_article->get_writer());
#else
	  if (msg_type == FOLLOWUP_MSG) {
	    if (Settings.followupto == FUT_WRITER ) // ;)
	      new_article->set_receiver(src_article->get_writer());
	    else if (Settings.followupto == FUT_ALL)
	      new_article->set_receiver ( FUT_ALL );
	    else
	      new_article->set_receiver ( Settings.followupto );
	  } else {
	    new_article->set_receiver (src_article->get_writer());
	  }
#endif
        } else {
                new_article->set_receiver (src_article->get_receiver());
        }

        if (msg_type == REPLY_MSG || msg_type == FOLLOWUP_MSG) {
                new_article->set_reference_num (src_article->get_number());
        } else if (msg_type == EDIT_MSG) {
                DEBUG( "Setting reference number to " << src_article->get_reference_num() );
                new_article->set_reference_num (src_article->
                                                get_reference_num());
                new_article->set_number_in_thread( src_article->
                                                   get_number_in_thread() );
        } else {
                new_article->set_reference_num (0);
        }
        if (mail->get_group_number() >= BASEGROUP_NUMBER &&
            mail->get_group_number() != NEW_REPLIES_NUMBER ) {
                new_article->set_reference_num (0);
        }
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_info
// 
// 
//  DESCRIPTION: Allow user change subject, group, tagline etc.
// 
// 
// 
//  RETURNS: SUCCESS_FL is ok, FAILED_FL if user aborts reply. EDIT_FL if
//           user wants edit reply again.
// 
//**************************************************************************/
int
Replyhandler::get_info()
{
        bool quit = false;
        int c;
        tagline = get_tagline();
        while (quit == false) {
                Screen.clear();
                show_option_str("@a)@ Subject : ");
                Screen.textcolor (Settings.header_subject_color);
                Screen.addstr( new_article->get_subject() );
                Screen.gotoxy( 0, 2);
                
                show_option_str("@b)@ Receiver : ");
                Screen.textcolor (Settings.header_subject_color);
                Screen.addstr( new_article->get_receiver() );
                Screen.gotoxy( 0, 4 );

                show_option_str("@c)@ Message status : ");
                
                Screen.textcolor (Settings.header_subject_color);
                if (new_article->get_status() & PRIVATE_ST) {
                        Screen.blink();
                        Screen.addstr( "Private" );
                } else {
                        Screen.addstr( "Public" );
                }
                Screen.gotoxy( 0, 6 );

                show_option_str("@d)@ Group : ");
                Screen.textcolor (Settings.header_subject_color);
                // Get pointer to current group's data
                mail->save_group_pos();
                mail->go_group_number (new_article->get_group_number());
                Screen.print("%s [%s]", mail->get_group_name().c_str(),
                             mail->get_group_numstr().c_str() );
                mail->restore_group_pos();
                Screen.gotoxy( 0, 8 );
                
                // display tagline
                show_option_str("@t)@ Tagline : \n");
                Screen.textcolor (Settings.header_subject_color);
#ifndef TAGB
                Screen.addstr( tagline );
#else
		if ( savedtag.is_empty() )
		  savedtag = tagline;

		Screen.addstr( savedtag );
#endif
                Screen.gotoxy( 0, ypos );
                Screen.reset_attr();
                show_option_str("[@abcdt@] to change item, [@fq@] forget"
                                " message [@e@]dit or [@p@]ost message. @p@");
                c = Screen.get_ch();
                switch (c) {
                case 'a':
                        get_subject();
                        break;
                case 'b':
                        get_receiver();
                        break;
                case 'c':
                        get_status();
                        break;
                case 'd':
                        get_new_group();
                        break;
                case 'e':
                        return EDIT_FL;
                case 't':
                        edit_tagline();
                        break;
                case 'f':
                case 'q':
                        if (get_confirm() == true) {
                                return FAILED_FL;
                        }
                        break;
                case 'p':
                case LINE_FEED:
                        quit = true;
                        break;
                }

        }
        return SUCCESS_FL;
}

//**************************************************************************/
// CLASS: Replyhandler
// MEMBER FUNCTION: edit_tagline
//**************************************************************************/ 
//
// Gets new tagline
// 
//**************************************************************************/
void
Replyhandler::edit_tagline()
{
#define MAX_TAGLINE_LEN 76
        for (;;) {
                Screen.clear();
#ifndef TAGB
                Screen.print( "\nTagline : \n%s", tagline.c_str() );
#else
		Screen.print( "\nTagline : \n%s", savedtag.c_str() );
#endif
                Screen.gotoxy(0, ypos );
                show_option_str( "[@e@]dit tagline [@r@]andom tagline"
                                 " [@n@]o tagline @ENTER@=done" );
                int c;
                while ( (c = Screen.get_ch()) != 0 ) {
                        if (c == SELECT_CMD) {
                                return;
                        }
                        if (c == 'e') {
                                char tmp [80];
                                Screen.gotoxy (0,ypos);
                                Screen.reset_attr();
                                Screen.empty_line();
                                
                                for (int i=0; i < MAX_TAGLINE_LEN;i++) {
                                        Screen.addch( '-' );
                                }
                                Screen.gotoxy( 0, ypos-2 );
                                Screen.empty_line();
                                Screen.addstr( "Type new tagline:" );
                                Screen.gotoxy( 0, ypos-1 );
                                Screen.textcolor (BOLD);
#ifndef TAGB
                                strncpy( tmp, tagline.get(), 76 );
#else
				strncpy( tmp, savedtag.get(), 76 );
#endif
                                DEBUG( "Editing tagline '" << tmp << "'" );
                                Screen.getline (tmp, 76, 0 );
#ifndef TAGB
                                tagline.put( tmp );
#else
				savedtag.put( tmp );
#endif
                                break;
                        }
                        if (c == 'r') {
                                tagline = get_tagline();
#ifdef TAGB
                                savedtag = get_tagline();
#endif
                                break;
                        }
                        if ( c == 'n' ) {
                                tagline = "";
#ifdef TAGB
                                savedtag = "";
#endif
                                break;
                        }
                }
        }
}


//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_confirm
// 
// 
//  DESCRIPTION: Makes sure that user really want to abort message.
// 
// 
//  RETURNS: true if message must abort.
// 
//**************************************************************************/
bool
Replyhandler::get_confirm()
{
        int c;
        Screen.gotoxy( 0, ypos );
        Screen.empty_line();
        
        show_option_str( "Do You really want to forget message [@yn@] @n@");

        c = get_yesno ('n');
        if (c == 'y')
                return true;
        return false;
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_subject
// 
// 
//  DESCRIPTION: Asks for new subject.
// 
// 
//  EXTERNAL REFERENCES:
//  IN :  Settings
//  OUT: 
// 
//  RETURNS: 
// 
//**************************************************************************/
void
Replyhandler::get_subject()
{
        char *tmp = new char [Settings.max_subject_len+1];

        Screen.gotoxy (0,ypos);
        Screen.reset_attr();
        Screen.empty_line();

        Screen.goto_x( 20 );
        for (int i=0; i < Settings.max_subject_len;i++) {
                Screen.addch( '-' );
        }
        Screen.gotoxy(0, ypos-1);
        Screen.empty_line();
        Screen.addstr( "Enter new subject : " );        
        Screen.textcolor (BOLD);
        strcpy (tmp, new_article->get_subject().get());
        Screen.getline (tmp, Settings.max_subject_len);
        new_article->set_subject(tmp);
        delete[] tmp;
}
//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_status
// 
// 
//  DESCRIPTION: Ask for new status, private or public
// 
// 
//**************************************************************************/
void
Replyhandler::get_status()
{
        Screen.gotoxy (0,ypos);
        Screen.reset_attr();
        Screen.empty_line();
        show_option_str( "[@p@] for private, any other for public");
        if (Screen.get_ch() == 'p') {
                new_article->set_status_bits (PRIVATE_ST);
        } else {
                new_article->reset_status_bits (PRIVATE_ST);
        }
}
//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_receiver
// 
// 
//  DESCRIPTION: Ask for new receiver.
// 
// 
//  EXTERNAL REFERENCES:
//  IN :  Settings
//  OUT: 
// 
//  RETURNS: 
// 
//**************************************************************************/
void
Replyhandler::get_receiver()
{
        char *tmp = new char [Settings.max_subject_len+1];

        Screen.gotoxy (0,ypos);
        Screen.reset_attr();
        Screen.empty_line();
        Screen.goto_x( 21 );
        for (int i=0; i < Settings.max_bbs_subject_len;i++) {
                Screen.addch( '-' );
        }
        Screen.gotoxy(0, ypos-1);

        Screen.empty_line();
        Screen.addstr( "Enter new receiver : " );

        Screen.textcolor (BOLD);
        strcpy (tmp, new_article->get_receiver().get());
        Screen.getline (tmp, Settings.max_bbs_subject_len);
        new_article->set_receiver (tmp);
        new_article->set_reference_num (0);
        delete[] tmp;
}
//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: get_new_group
// 
// 
//  DESCRIPTION: Asks new group for article.
// 
// 
//**************************************************************************/
void
Replyhandler::get_new_group()
{
        Groupselection grp;
        mail->save_group_pos();
        mail->go_group_number( new_article->get_group_number() );
        int num = grp.select().number;
        mail->restore_group_pos();
        new_article->set_group_number (num);
        new_article->set_number (num);
}        

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: fread_article
// 
// 
//  DESCRIPTION: Reads reply from file.
// 
// 
//  EXTERNAL REFERENCES:
//  IN :  Settings.jmrdir
//  OUT: 
// 
//  RETURNS: false if cannot read file.
// 
//**************************************************************************/
bool
Replyhandler::fread_article ()
{
        fstream file;
        String str;
        String reply_file = Settings.jmrdir + REPLY_TEMP_FILENAME;
        char line[MAX_REPLY_LINE_LEN+1];

        file.open (reply_file.get(), ios::in);
        if (file.fail()) {
                str = "Cannot read reply file (";
                str += reply_file + ")";
                system_error (str.c_str());
                return false;
        }
        do {
                file.getline( line, MAX_REPLY_LINE_LEN );
                str = line;
                new_article->add_line( str );


        } while (!file.eof() );

        file.close();
        return true;
}
//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: fwrite_article
// 
// 
//  DESCRIPTION: Writes message to file that editor can read it.
//               Function also inserts quote-characters to message.
// 
//  EXTERNAL REFERENCES:
//  IN :  Settings.jmrdir
//  OUT: 
// 
//  RETURNS: false if cannot create file
//**************************************************************************/
bool
Replyhandler::fwrite_article ()
{
        fstream file;
        String tmp;
        String reply_file = Settings.jmrdir + REPLY_TEMP_FILENAME;
        file.open (reply_file.get(), ios::out);
        if (file.fail()) {
                system_error( "Cannot create replyfile");
                return false;
        }
        fwrite_replystring (file);
        src_article->save_position();
        if (src_article->first_line() == true) {
                do {
                        if (msg_type ==REPLY_MSG || msg_type==FOLLOWUP_MSG) {
                                file << Settings.quoteprefix;
                        }
                        file << src_article->getline() << "\n";
                } while (src_article->next_line() == true);
        }
        file.close();
        src_article->restore_position();
        return true;
}

//**************************************************************************/
//  CLASS: Replyhandler
//  MEMBER FUNCTION: fwrite_replystring
// 
//  DESCRIPTION: Writes expanded follow-up string or reply string to
//               given fstream.
//
// 
//  EXTERNAL REFERENCES
//  IN :  Settings.followup, Settings.reply
//  OUT: 
// 
//  RETURNS: 
//**************************************************************************/
void
Replyhandler::fwrite_replystring (fstream& file)
{
        char *ptr = NULL;
        // get pointer to format string
        if (msg_type == FOLLOWUP_MSG) {
                ptr = Settings.followup.get();
        } else if (msg_type == REPLY_MSG) {
                ptr = Settings.reply.get();
        } else {
                return;
        }
        // expand format specifiers
        while (*ptr) {
                if (*ptr != '%') {
                        file << *ptr;
                } else if (*++ptr) {
                        switch (*ptr) {
                        case 'd': // date
                                file << src_article->get_date();
                                break;
                        case 't': // time
                                file << src_article->get_time();
                                break;
                        case 'n': // name
                                file << src_article->get_writer();
                                break;
                        case 's': // subject
                                file << src_article->get_subject();
                                break;
                        case 'm': // msgid
                                file << src_article->get_number();
                                break;
                        case 'M': // number of month
                                file<<get_month(src_article->get_date().get());
                                break;
                        case 'D': // number of day
                                file << get_day(src_article->get_date().get());
                                break;
                        case 'Y': // year
                                file <<get_year(src_article->get_date().get());
                                break;
//                         case 'g': // group
//                                 break;
                        case '%': // percent
                                file << '%';
                                break;
                        }
                }
                ptr++;
        }
        file << "\n";
}










