/* $Id: qwk.hh,v 1.10 1998/07/18 19:51:00 jvuokko Exp $ */
/****************************************************************************
 * *
 * *  MODULE : qwk.hh
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Class for reading contents of QWK file.
 * *
 * *
 * *
 * *
 * *
 ***************************************************************************/


#ifndef __QWK_HH__
#define __QWK_HH__
#include "terminal_io.hh"
#include "../utilib/String.hh"
#include "../utilib/List.hh"
#include "mail.hh"
#include "jmr.hh"
#include <fstream.h>

#define MSG_HEADER_SIZE 128
#define MSG_BLOCK_SIZE 128

//**************************************************************************/
//
// CLASS: Qwk
//
// DERIVED FROM: Mail
//
// Reads contents of QWK mail packet and writes QWK replypacket
//
//**************************************************************************/
class Qwk : public Mail {
public:        
        Qwk (const char*, bool open_new = true);
        ~Qwk();
private:
        void read_control(const char *);
        void read_articles();
        int convert_header (Message*, byte_t*);
        void read_msg_data (Message*, int, ifstream&);
        void read_old_replies (const int flag = DEFAULT_FL);
        void get_pcb_data (Message *);
        int count_record_blocks (Message *msg);
        void write_header (Message *msg, const int blocks, fstream&);
        void write_message (Message *msg, fstream&);
        void write_bbsid (fstream&);
        void insert_pcb_lines(Message* msg);
};





#endif








