// 	$Id: messagelog.cc,v 1.14 1998/04/30 16:30:08 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : messagelog.cc
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Functions for writing and reading messages from log.
 * *
 * *
 * *
 * *
 * *
 ***************************************************************************/

#include <fstream.h>
#include <string.h>   // memset
#include "jmr.hh"
#include "../utilib/List.hh"
#include "../utilib/String.hh"
#include "messagedata.hh"


extern settings_t Settings;

/***************************************************************************
 * FUNCTION: write_msg_to_log
 ***************************************************************************
 *
 * Writes contents of given article specified file stream.
 * 
 *
 ***************************************************************************/
void
write_msg_to_log (
                  fstream& file,      // reference to outputfile (binary)
                  Message& msg)   // message structure
{
        String tmp;
        char *buffer;
        int c;
        int size = 320;
        
        if (msg.first_line() == true) {
                do {
                        size += msg.getline().length() + 1;
                        //size += tmp.length() + 1;
                } while (msg.next_line() == true);
        }
        buffer = new char [size + 1];

        memset (buffer, 0, size);
        
        // Fill buffer with data of article.
        put_le_int32 ((byte_t*) buffer + SIZE_OFFSET, size);

        tmp = msg.get_subject();
        tmp.get_at (buffer + SUBJECT_OFFSET);

        tmp = msg.get_writer();
        tmp.s_capitalize();
        tmp.get_at (buffer + WRITER_OFFSET);

        tmp = msg.get_receiver();
        tmp.s_capitalize();
        tmp.get_at (buffer + RECEIVER_OFFSET);

        tmp = msg.get_jmrdate();
        tmp.get_at (buffer + DATE_OFFSET);
        tmp = msg.get_time();
        tmp.get_at (buffer + TIME_OFFSET);
                
        *(buffer + STATUS_OFFSET) = (char) msg.get_status();
        put_le_int32 ((byte_t*)buffer + NUMBER_OFFSET, msg.get_number());
        put_le_int32 ((byte_t*)buffer + REFERENCE_OFFSET,
                      msg.get_reference_num());
        put_le_int32 ((byte_t*)buffer + GROUP_OFFSET,msg.get_group_number());

        c = ARTICLE_OFFSET;
        if (msg.first_line() == true) {
                do {
                        tmp = msg.getline();
                        tmp.get_at (buffer + c);
                        c += (tmp.length() + 1);
                } while (msg.next_line() == true);
        }

        // write contents of buffer to file
        file.write (buffer, size);

        delete[] buffer;
}

/***************************************************************************
 * FUNCTION: read_msg_from_log
 ***************************************************************************
 *
 * Allocates space for message, and reads next message from
 * given filestream (binary).
 * 
 *
 * RETURN: contents of message at Message_t structure. NULL if failed.
 ***************************************************************************/
Message*
read_msg_from_log (fstream& file, int flag)
{
        int c;
        String tmp;
        char *buffer;
        unsigned int size;
        byte_t little_endian_value[4];
        Message *msg;

        if (flag & HEADER_ONLY_FL) {
                msg = new Message (&file);
        } else {
                msg = new Message;
        }
        
        // luetaan tietueen koko
        file.read ((char*) little_endian_value, 4);
	if (file.fail()) {
                delete msg;
		return NULL;
	}
        size = get_le_int32 (little_endian_value);

	// varataan tila puskurille
        buffer = new char [size+1];

        size -= SUBJECT_OFFSET;
        
        file.read (buffer+SUBJECT_OFFSET, size);
        // jos luku eponnistui, niin hyptn lopetuksiin
        if (file.fail()) {
                delete msg;
                return NULL;
        }


        tmp.put (buffer + SUBJECT_OFFSET);
        msg->set_subject (tmp);
        
        tmp.put (buffer + WRITER_OFFSET);
        msg->set_writer (tmp);
        
        tmp.put (buffer + RECEIVER_OFFSET);
        msg->set_receiver (tmp);

        tmp.put (buffer + DATE_OFFSET);
        msg->set_date (tmp);

        tmp.put (buffer + TIME_OFFSET);
        msg->set_time (tmp);

        msg->init_status ( *(buffer + STATUS_OFFSET) );

        msg->set_number ((int) get_le_int32 ((byte_t*) (buffer +
                                                        NUMBER_OFFSET)));

        msg->set_reference_num ((int) get_le_int32 ((byte_t*)(buffer +
                                                           REFERENCE_OFFSET)));

        msg->set_group_number ((int) get_le_int32 ((byte_t*) (buffer
                                                           + GROUP_OFFSET)));
        
        // read article lines
        if (!(flag & HEADER_ONLY_FL)) {
                c = ARTICLE_OFFSET;
                while ((unsigned int) c < size) {
                        c += tmp.put (buffer + c) +1;
                        msg->add_line (tmp);
                }
        }
        
        //msg->set_index (Counter);

        //++Counter;
        delete[] buffer;
        return msg;
}
        
//
// tll luetaan vanhan formaatin mukainen loki
// Vanhan lokin tunnistaa siit, etteivt nelj ensimmist tavua
// ole 00 05 08 05
//
Message*
read_msg_from_obsolete_log (fstream& file, int flag)
{
        String tmp;
        char line[MAX_REPLY_LINE_LEN+1];
        Message *msg = new Message();

        // this is for disabling warning about unused variable 'flag'...
        if (flag == 0) {
                flag = 0;
        }
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        if (file.eof() || (unsigned char) line[0] == (unsigned char) 227) {
                return NULL;
        }
        
        tmp = line;
        msg->set_subject (tmp);
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        tmp = line;
        msg->set_writer (tmp);
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        tmp = line;
        msg->set_receiver (tmp);
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        tmp = line;
        msg->set_date (tmp);
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        tmp = line;
        msg->set_time (tmp);
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        msg->init_status ( (byte_t) line[0] );
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        msg->set_number ( atoi (line) );
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        msg->set_reference_num ( atoi (line) );
        
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        msg->set_group_number ( atoi (line) );

        // read message lines
        file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        while (file.eof() == 0 &&
               (unsigned char) line[0] != (unsigned char) 227) {
                tmp = line;
                msg->add_line (tmp);
                file.getline (line, MAX_REPLY_LINE_LEN, 0x0a);
        }
        
        return msg;
}






