// 	$Id: menu.hh,v 1.12 1998/04/30 16:30:08 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : menu.hh
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Classes for handling group selection, thread selection and
 * * article display levels.
 * *
 * *
 * *
 * *
 ***************************************************************************/

#ifndef __MENU_HH
#define __MENU_HH


#include "terminal_io.hh"
#include "mail.hh"
#include "../utilib/List.hh"
#include "menubar.hh"
#include "jmr.hh"
#include "threads.hh"
#include "ring.hh"
#include "wrapmsg.hh"



//**************************************************************************/
//
// CLASS: Groupmenu
//
// DERIVED FROM:
//
// DESCRIPTION: group selection level functions.
//
//**************************************************************************/
class Groupmenu {
public:
        Groupmenu();
        ~Groupmenu(){};
private:
        void count_pages ();
        void update_all ();
        void update_list();
        bool catchup();
        int search();
        int  get_search_groups();
        bool tag_all();
        void goto_current_group ();
        bool previous_group ();
        bool next_group ();
        void draw_group_data (int flag=DEFAULT_FL);
        bool up();
        bool down();
        bool page_up();
        bool page_down();
        void last_group();
        bool next_unread();
        bool confirm_quit();
        
        Menubar menubar;
        Sline sline;
        Infoline iline;
        List<int> groupnumbers;
        String headerline;
        int ymin;
        int ymax;                // maksimi rivimr 
        int ypos;                // koordinaatti
        int pages;               // Sivujen mr
        int current_page;         // Nykyinen sivu
        int groups_per_page;  // kokousten mr sivulla
        int first_of_page;     // Sivun ensimmisen conf. indeksi
        int current_group;   // Nykyisen kokouksen indeksi. Huom! suhteessa
                             // kokousten mrn (kaikka/uudet)
        int groups;
        int all_groups;
        bool show_all_groups;
};


//**************************************************************************/
//
// CLASS: Msgmenu
//
// DERIVED FROM:
//
// DESCRIPTION: functions for thread selection level
//
//**************************************************************************/
class Msgmenu {
public:
        Msgmenu ();
        ~Msgmenu() {}
        void enter ();
private:
        bool go_thread_index (int n);
        void display ();
        void draw_list();
        void draw_article_info (int flag = 0);
        void draw_thread (int flag);
        void draw_detailed (int flag);
        void draw_header();
        bool page_up();
        bool page_down();
        bool down();
        bool up();
        // siirtyy seuraavaan messuun
        bool go_next_article();
        // pivitt nyttmuuttujien sisllt ym.
        void update();
        void update_msg_counts();
        void set_selector_to_current_thread();
        bool sort();
        void go_last_thread();
        bool catchup();

        bool is_status_msg;
        bool show_all_articles;
        bool thread_mode; // true if threaded mode is on
        int ymin;
        int ymax;
        int ypos;
        int pages;
        int current_page;
        int first_of_page;
        int lines_per_page;
        int current;
        int thread_cnt;

        Grpthread threads;
        Sline sline;
        Infoline iline;
        Menubar menubar;
        String dashline;
        
};


//**************************************************************************/
//
// CLASS: Msgdisplay
//
// DERIVED FROM:
//
// DESCRIPTION: functions for article viewing level.
//
//**************************************************************************/
class Msgdisplay {
public:
        Msgdisplay ( Grpthread &groups_threads);
        ~Msgdisplay (){};
        int enter (bool *showflag, int flag);
private:
        void display (int flag=0);
        void draw_header();
        void draw_header_status();
        void update();
        void down();
        void up();
        bool begin_of_thread();
        bool end_of_thread();
        bool next();
        bool prev();
        bool page_down(int flag=DEFAULT_FL);
        void page_up();
        void go_bottom();
        void no_next_unread_err();

        enum { ROT13MODE = 1, WRAPMODE = 2 };
        flag_t modefl;
        bool *show_all_articles;
        bool is_bottom;
        Message *orig_article;
        Wrap_msg article;
        int ymin;
        int ymax;
        int xmax;
        int ypos;
        int lines_per_page;
        int lines_in_article;
        int pages;
        int first_of_page;
        String dashline;
        Infoline iline;
        Sline sline;
        Menubar menubar;
        Grpthread &threads;

        NRing<Message*> hist_ring;

        
};

#endif

