// 	$Id: menu.cc,v 1.16 1997/08/28 18:21:34 jvuokko Exp $	

/****************************************************************************
 * *
 * *  MODULE : menu.cc
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * * Functions for handling group selection menu.
 * *
 * *
 * *
 * *
 * *
 ***************************************************************************/
#include <time.h> // testi varten
#include <iostream.h>
#include "jmr.hh"
#include "menu.hh"
#include "mail.hh"
#include "replies.hh"
#include "menubar.hh"

extern Terminal_screen Screen;
extern Window* Wscript;
extern settings_t Settings;
extern Mail* mail;

static const menuinfo group_menu_array[] = {
        {"[jmr]", 0 },
        {"Exit from menu", 0},
        {"Back to mail packet selection", QUIT_CMD},
        {"Quit jmr", FORCED_QUIT_CMD},
        {"@NEXT", 0 },
        {"[Tagging]", 0 },
        {"Tag/untag group", TAG_CMD },
        {"Tag/untag all", TAG_ALL_CMD },
        {"@NEXT", 0 },
        {"Write", WRITE_CMD },
        {"@NEXT", 0 },
        {"Yank in/out", YANK_IN_OUT_CMD },
        {"@NEXT", 0 },
        {"Search", SEARCH_CMD },
        {"@NEXT", 0 },
        {"@END", 0 }
};


//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: Groupmenu
//
// description: Constructor. This is main function of class.
//              NOTE: Mail *mail must be initialized before use this!!
//
//  in: Screen, Quit_flag
// out: Quit_flag
//
//**************************************************************************/
Groupmenu::Groupmenu()
{
        int c;
        int tmp = 0;
        Msgmenu msgmenu;      // thread selection level        
        bool quit = false;
        show_all_groups = false;
        pages = 0;
        ymax = Screen.get_ymax() - 2;
        ymin = 6;
        ypos = ymin;
        groups_per_page = ymax - ymin +1;
        current_page = 0;
        first_of_page = 0;
        current_group = 0;
        headerline = "------------ Group  Name of the Group ----------- Unread   Total ";
        for (c = Screen.get_xmax() - headerline.length(); c >= 0; c--) {
                headerline += "-";
        }
        
        menubar.init( group_menu_array );
        menubar.set_text( MENUBAR_TEXT );
        sline.init( Screen.get_xmax() + 1);
        update_all ();
        iline.set_default ( GROUP_MENU_KEYS_MSG );
        iline.show_default();

        do {
                c = Screen.get_ch();
                iline.reset();
                if (c == ESCAPE) {
                        iline.set( MENU_MSG );
                        iline.show();
                        c = menubar.select();
                        update_all();
                        iline.reset();
                }
                switch (c) {
                case MESSAGEWIN_CMD:
                        Wscript->enable();
                        iline.set ( MESSAGES_MSG );
                        iline.show();
                        Screen.get_ch();
                        iline.reset();
                        Wscript->disable();
                        break;
                case PREV_CMD:
                case CODE_UP:
                        if (false == up()) {
                                iline.set( AT_TOP_MSG );
                        }
                        break;
                case NEXT_CMD:
                case CODE_DOWN:
                        if (false == down()) {
                                iline.set( AT_BOTTOM_MSG );
                        }
                        break;
                case CODE_NPAGE:
                case PAGE_DOWN_CMD:
                        if (false == page_down()) {
                                iline.set( AT_LAST_PAGE_MSG );
                        }
                        break;
                case CODE_PPAGE:
                case PAGE_UP_CMD:
                        if (false == page_up()) {
                                iline.set( AT_FIRST_PAGE_MSG );
                        }
                        break;
                case CODE_HOME:
                        //pages = 0;
                        current_group=0;
                        update_list();
                        break;
                case CODE_END:
                        last_group();
                        update_list();
                        break;
                case YANK_IN_OUT_CMD:
                        show_all_groups = show_all_groups == true ?
                                false : true;
                        if (show_all_groups == true ) {
                                sline.set_infotext( "List Of All Groups" );
                        } else {
                                sline.set_infotext( "List Of Unread Groups" );
                        }
                        pages = 0;
                        update_all ();
                        break;
                case NEXT_UNREAD_CMD:
                        if (true == next_unread()) {
                                msgmenu.enter();
                                update_all();
                        } else {
                                iline.set( NO_UNREAD_MSG);
                        }
                        break;
                case CODE_RIGHT:
                case SELECT_CMD:
                        msgmenu.enter();
                        update_all();
                        break;
                case WRITE_CMD:
                        if (*groupnumbers.get() < BASEGROUP_NUMBER) {
                                mail->write();
                                pages = 0;
                                update_all();
                        }
                        break;
                case CATCHUP_CMD:
                        if (true == catchup()) {
                                update_all();
                                iline.set("Articles marked as read");
                        } else {
                                iline.show(REFRESH_ALL_FL);
                        }
                        break;
                case FORCED_CATCHUP_CMD:
                        mail->catchup();
                        update_all();
                        break;
                case SEARCH_CMD:
			tmp = search();
                        if (tmp > 0) {
                                pages = 0;
                        }
                        update_all();
                        if (tmp == 0) {
                                iline.set("No matching articles found!");
                        } else if (tmp) {
                                String _tmp = "Expression found from ";
                                _tmp += tmp;
                                _tmp += " articles";
                                iline.set(_tmp.get());
                        }
                        break;
                case TAG_CMD:
                        mail->tag_group();
                        Screen.gotoxy( 0, ypos );
                        draw_group_data( EMPHASIZED_FL );
                        break;
                case TAG_ALL_CMD:
                        if (true == tag_all()) {
                                update_all();
                                iline.set("All groups tagged");
                        } else {
                                update_all();
                                iline.set("All tags removed");
                        }
                        break;
                case HELP_CMD:
                        show_help();
                        update_all();
                        break;
                case QUIT_CMD:
                        quit = confirm_quit();
                        break;
                case FORCED_QUIT_CMD:
#ifndef NO_EXCEPTIONS
                        throw quit_exception();
#else
                        Quit_flag = true;
                        break;
#endif
                case 0:
                        break;
                default:
                        iline.set( INVALID_COMMAND_MSG );
                        break;
                }
                iline.show();
        } while (quit == false
#ifdef NO_EXCEPTIONS
                 && Quit_flag == false
#endif
                 );
        Screen.bottom();
        Screen.clr_eol();
}

bool
Groupmenu::confirm_quit()
{
        if (Settings.confirm_return == false) {
                return true;
        }
        bool rc = true;
        Screen.bottom();
        show_option_str( "Really return to the packet selection level"
                         " (y/n) @y@" );
        Screen.clr_eol();
        if (get_yesno( 'y' ) == 'n' ) {
                iline.show( REFRESH_ALL_FL );
                rc = false;
        } 
        return rc;
}

// true jos kaikki merkitty, false jos merkit poistettu
bool
Groupmenu::tag_all()
{
        static int count;
        mail->save_group_pos();
        ++count;
        mail->first_group();
        if (count % 2) {
                do {
                        if (mail->is_group_tagged() == false) {
                                mail->tag_group();
                        }
                } while (mail->next_group() == true);
        } else {
                do {
                        if (mail->is_group_tagged() == true) {
                                mail->tag_group();
                        }
                } while (mail->next_group() == true);
        }
        mail->restore_group_pos();

        if (count % 2) {
                return true;
        }
        return false;
}


int
Groupmenu::get_search_groups()
{
        Screen.bottom();
        show_option_str("Search from [@a@]ll groups [@c@]urrent group [@t@]agged groups or [@q@]uit? @c@");
        Screen.clr_eol();
        int c;
        while ((c = Screen.get_ch()) != 0) {
                switch (c) {
                case 'a':
                        Screen.print( "\ba" );
                        Screen.refresh();
                        return ALL_FL;
                case 'c':
                case SELECT_CMD:
                        return CURRENT_FL;
                case 't':
                        Screen.print( "\bt" );
                        Screen.refresh();
                        return TAGGED_FL;
                case 'q':
                        return QUIT_FL;
                }
        }
        return DEFAULT_FL;
}

// palauttaa lydettyjen mrn, tai -1 jos quit.
int
Groupmenu::search()
{
        int c;
        int mode;
        
        mode = get_search_groups();
        if (mode == QUIT_FL) {
                return -1;
        }
        
        Screen.bottom();
        show_option_str( "And from [@s@]ubject [@a@]uthor [@r@]eceiver [@h@]eader [@A@]rticle or [@q@]uit? @h@" );
        Screen.clr_eol();
        while ((c = Screen.get_ch()) != 0) {
                switch (c) {
                case 's':
                        mode |= SUBJECT_FL;
                        goto out_of_loop;
                case 'a':
                        mode |= AUTHOR_FL;
                        goto out_of_loop;
                case 'r':
                        mode |= RECEIVER_FL;
                        goto out_of_loop;
                case SELECT_CMD:
                case 'h':
                        c = 'h';
                        mode |= SUBJECT_FL | AUTHOR_FL | RECEIVER_FL;
                        goto out_of_loop;
                case 'A':
                        mode |= SUBJECT_FL | AUTHOR_FL|RECEIVER_FL|ARTICLE_FL;
                        goto out_of_loop;
                case 'q':
                        return false;
                }
        }
  out_of_loop:
        char *buf = new char [82];
        memset (buf, 0, 82);
        Screen.bottom();
        Screen.print( "Type expression : " );
        Screen.clr_eol();
        Screen.getline (buf, 60, 0);
        if (*buf == 0x00) {
                delete[] buf;
                return false;
        }
        Screen.bottom();
        Screen.clr_eol();
        int n = mail->search (buf, mode);
        delete[] buf;
        return n;
}

bool
Groupmenu::catchup()
{
        Screen.bottom();
        show_option_str( "Really want mark all articles as read (y/n) @y@" );
        Screen.clr_eol();
        if (get_yesno ('y') == 'y') {
                mail->catchup();
                return true;
        }
        return false;
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: count_pages
//
// description: Counts all values that are necessary for corresponding paging.
//              Sets up list contains numbers of all groups to be show.
//
// in:  mail
// out: 
//
//**************************************************************************/
void
Groupmenu::count_pages ()
{
        all_groups = mail->get_num_groups();
        int *i;
        mail->first_group();

        groups = 0;
        groupnumbers.destroy();
        do {
                int n = mail->get_group_number();
                if (show_all_groups == false && mail->count_unread() == 0
                    && n != REPLYLOG_NUMBER && n != NEW_REPLIES_NUMBER) {
                        if (! ((n == SEARCH_RESULTS_NUMBER ||
                                n == TAGGED_ARTICLES_NUMBER) &&
                               mail->count_articles() > 0) ) {
                                continue;
                        }
                }
                i = new int;
                *i = n;
                groupnumbers.add (i);
                ++groups;
        } while (mail->next_group() == true);

        
        pages = groups / groups_per_page;
        pages++;
        while (current_group >= groups) {
                --current_group;
        }
        current_page = current_group / groups_per_page;
        first_of_page = current_page * groups_per_page;
        ypos = ymin + (current_group - first_of_page);
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: update_all
//
// description: Draws everything.
//              
//
// in:  mail, Screen, Quit_flag
// out: 
//
//**************************************************************************/
void
Groupmenu::update_all ()
{
        
        Screen.erase();
#ifdef NO_EXCEPTIONS
        if (Quit_flag == true) {
                return;
        }
#endif
        menubar.show();
        iline.show_default();
        if (pages == 0) {
                count_pages();
        }

        sline.set_infotext( mail->get_bbs_name().get() );
        if (show_all_groups == true) {
                sline.set_extra_info( "All Groups" );
        } else {
                sline.set_extra_info( "Unread Groups" );
        }

        Screen.gotoxy( 0, 1 );
        Screen.print( "Phone : %s  (%s)", mail->get_bbs_phone().c_str(),
                      mail->get_bbs_sysop().c_str());
        Screen.gotoxy(0,2);
        Screen.print( "Packet time : %s", mail->get_packet_time().c_str() );
        Screen.gotoxy(0,3);
        Screen.print( "Total number of the articles in the database: %d",
                      mail->count_all_articles());
        Screen.gotoxy(0,4);
        Screen.print( "New articles from packet: %d",
                      mail->count_new_articles() );
        
        Screen.gotoxy(0,5);
        set_dashline_color();
        Screen.print( headerline.c_str() );
        Screen.reset_attr();
        update_list();

}

void
Groupmenu::update_list()
{
        int i;
        int pros;
        int y = ymin;

        // find first group of current page
        groupnumbers.first();
        i = 0;
        while (i < first_of_page) {
                ++i;
                groupnumbers.next();
        }
        i = current_group;
        current_group = first_of_page;
        // display groups
        do {
                Screen.gotoxy (0,y);

                if (current_group == i) {
                        ypos = y;
                        draw_group_data(EMPHASIZED_FL);
                } else {
                        draw_group_data();
                }
                ++current_group;
                ++y;
        } while (groupnumbers.next() == true && (y <= ymax));
        
        Screen.reset_attr();

        while ( y <= ymax ) {
                Screen.gotoxy(0,y++);
                Screen.empty_line();
        }
        
        if (groups <= groups_per_page ) {
                pros = ALL_PERCENT;
        } else if ( first_of_page == 0 ) {
                pros = TOP_PERCENT;
        } else {
                pros = 100 * current_group / groups;
        }
        sline.set_percent( pros );
        sline.show();

        // Set position in list at current Group
        current_group = i;
        goto_current_group();
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: draw_group_data
//
// description: Displays data of Group
//
//
// in:  mail, Screen, Settings
// out: 
//
//**************************************************************************/
void
Groupmenu::draw_group_data (int flag)
{
        String tmp;

        if (flag & EMPHASIZED_FL) {
                Screen.inverse();
        }

        Screen.empty_line();

        Screen.goto_x (6);
        Screen.print( "%.3d", current_group );

        mail->go_group_number ( *(groupnumbers.get()) );

        Screen.goto_x (14);
        Screen.addstr( mail->get_group_numstr() );

        if (mail->is_group_tagged() == true) {
                Screen.goto_x (18);
                Screen.print( "T" );
        }
        
        Screen.goto_x (20);
        if (!(flag & EMPHASIZED_FL)) {
                if (*(groupnumbers.get()) >= BASEGROUP_NUMBER) {
                        Screen.textcolor (Settings.basegroup_color);
                } else {
                        Screen.textcolor (Settings.subject_color);
                }
        }
        Screen.addstr( mail->get_group_name() );

        if (!(flag & EMPHASIZED_FL)) {
                Screen.textcolor (Settings.author_color);
        }
        Screen.goto_x(50);
        if (mail->count_unread() > 0) {
                Screen.print( "%d", mail->count_unread() );
        } else {
                Screen.addstr( "-" );
        }
        if (!(flag & EMPHASIZED_FL)) {
                Screen.reset_attr();
        }
        Screen.goto_x (59);
        if (mail->count_articles() > 0) {
                Screen.print( "%d", mail->count_articles() );
        } else {
                Screen.addstr( "-" );
        }

        Screen.reset_attr();
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: goto_current_group
//
// description: Moves listpointers to current Group
//
//
// in:  mail
// out: 
//
//**************************************************************************/
void
Groupmenu::goto_current_group()
{
        int i = 0;
        groupnumbers.first();
        while (i < current_group) {
                groupnumbers.next();
                ++i;
        }
        mail->go_group_number (*(groupnumbers.get()));
}
                
//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: previous_group
//
// description: Moves listpointer to previous group
//
// in: mail
// out:
//
// returns: true if previous exist
//
//**************************************************************************/
bool
Groupmenu::previous_group()
{
        bool rc = groupnumbers.prev();
        if (rc == true) {
                --current_group;
                mail->go_group_number ( *(groupnumbers.get()) );
        }
        return rc;
}


//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: next_group
//
// description: moves listpointer to next group
//
// in: mail
// out:
//
// returns: true if next group exist
//
//**************************************************************************/
bool
Groupmenu::next_group()
{
        bool rc = groupnumbers.next();
        if (rc == true) {
                ++current_group;
                mail->go_group_number (*(groupnumbers.get()));
        }
        return rc;
}

//**************************************************************************/
//  CLASS: Groupmenu
//  MEMBER FUNCTION: last_group 
// 
// 
//  DESCRIPTION: Moves pointer to last group
//
//  EXTERNAL VARIABLE REFERENCES
//  IN : mail
//  OUT:
// 
//**************************************************************************/
void
Groupmenu::last_group()
{
        groupnumbers.last();
        mail->go_group_number (*(groupnumbers.get()));
        current_group = groups-1;

        current_page = current_group / groups_per_page;
        first_of_page = current_page * groups_per_page;
        ypos = ymin + (current_group - first_of_page);
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: up
//
// description: Moves cursor up, and updates listpointer
//
// in: Screen
// out:
//
//**************************************************************************/
bool
Groupmenu::up()
{
        if (current_group > 0) {
                if (ypos == ymin) {
                        ypos = ymax;

                        first_of_page = current_group-groups_per_page;
                        --current_group;
                        --current_page;
                        update_list();
                } else {
                        Screen.gotoxy (0, ypos);
                        draw_group_data();
                        Screen.gotoxy (0,--ypos);
                        previous_group();
                        draw_group_data(EMPHASIZED_FL);
                        Screen.reset_attr();
                }
                return true;
        }
        return false;
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: down
//
// description: moves cursor one line down, and moves to next group
//
// in: Screen
// out:
//
//**************************************************************************/
bool
Groupmenu::down()
{
        if (current_group < (groups-1)) {
                if (ypos == ymax) {
                        first_of_page = ++current_group;
                        ++current_page;
                        ypos = ymin;
                        update_list();
                } else {
                        Screen.gotoxy (0,ypos);
                        draw_group_data();
                        
                        Screen.gotoxy (0,++ypos);
                        next_group();
                        draw_group_data (EMPHASIZED_FL);
                        Screen.reset_attr();
                }
                return true;
        }
        return false;
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: page_up
//
// description: Moves cursor one page up
//
//
//**************************************************************************/
bool
Groupmenu::page_up()
{
        int i = groups_per_page;
        if (current_group == 0) {
                return false;
        }
        if (ypos == ymin) {
                while (i && first_of_page > 0) {
                        --first_of_page;
                        --current_group;
                        --i;
                }
        } else {
                while (ypos > ymin) {
                        --ypos;
                        --current_group;
                }
        }
        goto_current_group();

        update_list();

        return true;
}

//**************************************************************************/
//
// CLASS:  Groupmenu
// MEMBER FUNCTION: page_down
//
// description: moves cursor one page down
//
//**************************************************************************/
bool
Groupmenu::page_down()
{

        if (current_group >= groups-1) {
                return false;
        }
        if (ypos == ymax) {
                ++current_page;
                first_of_page = ++current_group;
                for (int i=1; i < groups_per_page && current_group < groups-1;
                     ++i, ++current_group);
                ypos = ymin + (current_group - first_of_page);
        } else {
                while (current_group < groups-1 && ypos < ymax) {
                        ++current_group;
                        ++ypos;
                }
        }
        goto_current_group();

        update_list();

        return true;
}


//**************************************************************************/
//  CLASS: Groupmenu
//  MEMBER FUNCTION: next_unread
// 
//  DESCRIPTION: Selects next group with unread articles. If not found,
//               then seeks for previous group.
//
//  EXTERNAL VARIABLE REFERENCES:
//   IN : mail
//   OUT: 
//
//  RETURNS: true if group found.
//**************************************************************************/

// toimivuus voi olla huono. Saattaa sekoittaa nykyisen sijainnin....
// Kirjoiteltu silmt ristiss klo 00:40...
bool
Groupmenu::next_unread()
{
        bool rc = false;
        int i;
        
        i = current_group;
        mail->go_group_number ( *(groupnumbers.get()) );
        if (mail->count_unread() > 0) {
                rc = true;
        } else {
                groupnumbers.save_position();
                // seek forward for unread articles
                while (groupnumbers.next() == true) {
                        mail->go_group_number ( *(groupnumbers.get()) );
                        ++current_group;
                        if (mail->count_unread() > 0) {
                                rc = true;
                                break;
                        }
                }
                // if unread message not found, try seek from first thread.
                if (rc == false) {
                        groupnumbers.first();
                        current_group = 0;
                        do {
                                mail->go_group_number (*(groupnumbers.get()));
                                if (mail->count_unread() > 0) {
                                        rc = true;
                                        break;
                                }
                                ++current_group;
                        } while (groupnumbers.next() == true
                                 && current_group < i);
                        if (rc == false) {
                                groupnumbers.restore_position();
                                current_group = i;
                        }
                }
        }
        return rc;
}



















