# $Id: makefile.wat,v 1.14 1998/05/25 20:06:05 jvuokko Exp $
#
#  Makefile for compiling jmr with Watcom C/C++
#
#  Os/2 :  wmake -f makefile.wat
#  NT   :  wmake -f makefile.wat nt=1
#  dos  :  wmake -f makefile.wat dos=1
#
#


system=os2v2
os=os2
stack=
sysinc = $(%watcom)\h\os2

!ifdef DOS
system = dos4g
os = dos
stack = op stack=32768
!endif

!ifdef WIN32
system = nt
os = nt
!endif

prog = jmr.exe
CFLAGS =  -w4 -zp4 -zq -5r -fp5 -oneatx -bt=$(os) -wx -xs
LDFLAGS =  name $(prog) SYS $(system) $(stack)

# LSFLAGS = -s	
DEFS = -DNEED_BOOL -DNO_STATIC_CONST

!ifdef debug
DEFS = $+$(DEFS)$- -DUSE_DEBUG
!endif

!ifdef dist
DEFS = $+$(DEFS)$- -DNDEBUG
!endif

CC = *wpp386 $(DEFS) $(CFLAGS) -i$(%watcom)\h;$(sysinc)
O = obj
libs = 
utilib= ..\utilib

utilib_objs = misc.$(O) String.$(O)

objs = menu.$(O) qwk.$(O) jmr.$(O) terminal_io.$(O) &
       message_menu.$(O) mail.$(O) replies.$(O) time.$(O) filelist.$(O) &
       message_display.$(O) messagelog.$(O) messagedata.$(O) &
       tree.$(O) menubar.$(O) groupselect.$(O) window.$(O) threads.$(O) &
       wrapmsg.$(O) userselect.$(O) linereader.$(O) jmrmisc.$(O) &
	$(utilib_objs) 

.EXTENSIONS:
.EXTENSIONS: .exe .obj .cc .h .hh

all : $(prog)

dist: $(prog) # distclean

clean : distclean
	del /n $(prog) 

distclean:
	del /n *.$(O)
	del /n *.map
	del /n *.err
	del /n *.o
	del /n $(utilib)\*.$(O)
	del /n $(utilib)\*.o
	del /n $(utilib)\*.map
	del /n $(utilib)\*.err

$(prog) : $(objs)
	*wlink $(LDFLAGS) file {$(objs)}

.cc: .;$(utilib)

.cc.$(O): .AUTODEPEND
	$(CC) $[@

