// 	$Id: jmr.hh,v 1.36 1998/05/25 20:06:04 jvuokko Exp $	
/*
    This file is part of jmr offline mail reader.
    Copyright (C) 1997 Jukka Vuokko <jvuokko@iki.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/****************************************************************************
 * *
 * *  MODULE : jmr.hh
 * *
 * *  Copyright (c) 1997 Jukka Vuokko
 * *  See file COPYING for more information about copyrights.
 * *
 ****************************************************************************
 * *
 * *  Datatypes and prototypes for miscallenous functions.
 * *
 * *
 * *
 * *
 * *
 ***************************************************************************/

#ifndef __JMR_HH__
#define __JMR_HH__

#include <fstream.h>
#include <errno.h>
#include "../utilib/my_types.h"
#include "constants.h"
#include "datatypes.hh"
#include "terminal_io.hh"
#include "../utilib/String.hh"
#include "../utilib/List.hh"
#include "messagedata.hh"
#include "mail.hh"
#include "../utilib/misc.hh"


class Infoline {
public:
        Infoline() { active = false; is_error=false; }
        ~Infoline() {}
        void set( const char* msg, int fl = DEFAULT_FL);
        void set( const String& msg, int fl = DEFAULT_FL);
        void set_default( const char* msg ) { default_msg =  msg; }
        void show( int flag = DEFAULT_FL);
        void show_default();
        void reset();
private:
        bool active;
        bool is_error;
        String default_msg;
        String _msg;
};


class Sline : public Statusline {
public:
        Sline() : Statusline(0) {};
        ~Sline() {}
        void show();
};


//--------------------------------------------------------------------------
// jmr related helper functions (in jmrmisc.cc module)
//

void show_option_str( const char *msg, int bold_color = DEFAULT_FCOLOR,
                      int color = DEFAULT_FCOLOR );

void set_dashline_color();

void show_help();

void clear_workdir();

String read_tagline (String const &file);

String get_tagline();

void handle_error (const char *msg, int flag = DEFAULT_FL);

void system_error (const char *msg, int flag = DEFAULT_FL);

void fatal_error( const char *msg );

int jmrsystem( const char* );

char* convert_to_qwk_date (char *s);
char* convert_to_jmr_date (char *s);
int get_month (char *s);
int get_day (char *s);
int get_year (char *s);

void write_msg_to_log (fstream& file, Message& msg);

Message* read_msg_from_log (fstream& file, int flag = DEFAULT_FL);
Message* read_msg_from_obsolete_log (fstream& file, int flag = DEFAULT_FL);

bool strip_re_prefix (String& str);


int get_yesno (int default_value);


int get_integer (byte_t*, int);
int get_ushort (byte_t*);

String get_system_info( int flag = DEFAULT_FL);

void die (int sig);

#ifdef __unix__
void suspend (int );
#endif /* __unix__ */

#ifdef NO_EXCEPTIONS
extern bool Quit_flag;  // this is kludge for gcc...
#endif

#endif



