/* $Id: constants.h,v 1.36 1998/07/22 19:25:55 jvuokko Exp $ */
/*****************************************************************************
 * *
 * *      MODULE:     constants.h
 * *                  -----------
 * *
 * *
 * * Revision  : $Revision: 1.36 $
 * * Date(UTC) : $Date: 1998/07/22 19:25:55 $
 * * Source    : $Source: /usr/local/cvsroot/jmr/src/constants.h,v $
 * * Author    : $Author: jvuokko $
 * *
 * ***************************************************************************
 * *    This file is part of jmr offline mail reader.
 * *
 * *    Copyright (C) 1998 Jukka Vuokko <jvuokko@iki.fi>
 * *
 * *    This program is free software; you can redistribute it and/or modify
 * *    it under the terms of the GNU General Public License as published by
 * *    the Free Software Foundation; either version 2 of the License, or
 * *    (at your option) any later version.
 * *
 * *    This program is distributed in the hope that it will be useful,
 * *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 * *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * *    GNU General Public License for more details.
 * *
 * *    You should have received a copy of the GNU General Public License
 * *    along with this program; if not, write to the Free Software
 * *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***************************************************************************
 * *
 * *      This module defines main constants of the program.
 * *
 *****************************************************************************/



#ifndef _CONSTANTS_H_
#define _CONSTANTS_H_

#include "../utilib/system.h"    /* check system configuration */

#define VERSION "0.7.20.1"

#define DIR_ENVIRONMENT      "JMRDIR"
#define DEFAULT_DIRECTORY    ".jmr"
#define RESOURCE_FILE_NAME   "jmrrc"
#define REPLY_TEMP_FILENAME  "reply.msg"
#define DEADJMR_FILENAME     "deadjmr.msg"
#define DEADJMR_ID_FILENAME  "deadjmr.id"
#define TAGLINE_INDICATOR    "-- "
#define NO_MEMORY_ERROR      "Memory not enough."

#define LOG_IDCODE 84411648U

#define LOG_CHARSET ISO_LATIN_CHARSET


#ifdef __unix__
#   define SYSTEM "[Unix]"
#   ifdef __linux__
#      undef SYSTEM
#      ifdef __i386__
#         define LONG_SYSTEM "[i386/Linux]"
#      endif
#      define SYSTEM "[Linux]"
#   endif
#   ifdef sun
#      undef SYSTEM
#      define SYSTEM "[SunOS]"
#   endif
#   ifdef __FreeBSD__
#      undef SYSTEM
#      define SYSTEM "[FreeBSD]"
#   endif
#   ifdef __NetBSD__
#      undef SYSTEM
#      define SYSTEM "[NetBSD]"
#   endif
#   ifdef __sgi
#      undef SYSTEM
#      define SYSTEM "[ SGI ]"
#   endif
#elif defined (OS2)
#   ifndef __EMX__
#      define SYSTEM "[OS/2]"
#   else
#      define SYSTEM "[OS/2-emx]"
#   endif
#elif defined (DOS)
#   if defined (__GO32__)
#       define SYSTEM "[DOS/Go32]"
#   elif defined (__WATCOMC__) && defined (__386__)
#       define SYSTEM "[DOS/4GW]"
#   else 
#       define SYSTEM "[DOS]"
#   endif
#elif defined (__WIN32__) || defined (__NT__)
#   define SYSTEM "[Win32]"
#else
#   define SYSTEM "[QWK]"
#endif

#ifndef LONG_SYSTEM
#   define LONG_SYSTEM SYSTEM
#endif

#ifndef __unix__
#   define DO_NOT_USE_UNAME
#endif




//-------------------------------------------------------------------------
// Shell command for create new directory
// this works in most systems. (Unix, Dos, Os2, Win32)
#if defined (__unix__) || defined (OS2) || defined (DOS) || defined (WIN32)
#   define CREATE_DIRECTORY_COMMAND "mkdir "
#endif

//-------------------------------------------------------------------------
// name of working directory
#define WORK_DIRECTORY "work"

//-------------------------------------------------------------------------
// name of data directory
#define DATA_DIRECTORY "data"

//-------------------------------------------------------------------------
// default path to working directory, if environment variable TMP is not set
// #define DEFAULT_WORK_PATH "/tmp"

//-------------------------------------------------------------------------
// default name of directory for saved messages is $HOME/Messages
#define EXTRACT_DIRECTORY "Messages"

//-------------------------------------------------------------------------
// Wildcard that matches with everything
#if defined(__unix__)  || defined(OS2)
#   define WILDCARD_FOR_ALL "*"
#elif defined (DOS) || defined (WIN32)
#   define WILDCARD_FOR_ALL "*.*"
#endif

//-------------------------------------------------------------------------
// shell command for delete without questions
//#ifdef __unix__
//#   define REMOVE_COMMAND "rm -f "
//#elif defined (OS2) || defined (DOS) || defined (WIN32)
//#   define REMOVE_COMMAND "DEL /N "
//#endif


//-------------------------------------------------------------------------
// maximum lenght of path to current directory
#define MAXPATH 1024

//-------------------------------------------------------------------------
// characters, that might indicate quoting
#define QUOTECHARS ":>%&!/#"

//-------------------------------------------------------------------------
// flags
//
#define DEFAULT_FL        0x00000000
#define ONLY_USED_FL      0x00000001
#define EMPHASIZED_FL     0x00000002
#define REFRESH_ALL_FL    0x00000004
#define NEXT_UNREAD_FL    0x00000008
#define FAILED_FL         0x00000010
#define SUCCESS_FL        0x00000020
#define WRITE_NEW_FL      0x00000040
#define THREAD_FL         0x00000080
#define ARTICLE_FL        0x00000100
#define SHOW_ALL_FL       0x00000200
#define TAGGED_FL         0x00000400
#define HALT_FL           0x00000800
#define SUBJECT_FL        0x00001000
#define RECEIVER_FL       0x00002000
#define WRITER_FL         0x00004000
#define EDIT_FL           0x00008000
#define NEXT_FL           0x00010000
#define INTERACTIVE_FL    0x00020000
#define DEATH_FL          0x00040000
#define HEADER_ONLY_FL    0x00080000
#define AUTHOR_FL         0x00100000
#define HEADER_FL         0x00200000
#define QUIT_FL           0x00400000
#define ALL_FL            0x00800000
#define CURRENT_FL        0x01000000
#define REPORT_FL         0x02000000
#define ERROR_FL          0x04000000

//-------------------------------------------------------------------------
// group indexes.
//
//#define PERSONAL_INDEX          0
//#define REPLYLOG_INDEX          1
//#define NEW_REPLIES_INDEX       2
//#define TAGGED_ARTICLES_INDEX   3
// Index of first group that comes from QWK packet
#define FIRST_GROUP_FROM_PACKET 5

//-------------------------------------------------------------------------
// Number for base groups.
//#define BASEGROUP_NUMBER -1
// First basegroup must be 'personal mail' !!!
#define BASEGROUP_NUMBER        9000
#define PERSONAL_NUMBER         BASEGROUP_NUMBER 
#define REPLYLOG_NUMBER         BASEGROUP_NUMBER + 1
#define NEW_REPLIES_NUMBER      BASEGROUP_NUMBER + 2
#define TAGGED_ARTICLES_NUMBER  BASEGROUP_NUMBER + 3
#define SEARCH_RESULTS_NUMBER   BASEGROUP_NUMBER + 4

#define PERSONAL_TEXT        "Personal Mail"
#define REPLYLOG_TEXT        "Replylog"
#define NEW_REPLIES_TEXT     "New Replies"
#define TAGGED_ARTICLES_TEXT "Tagged Articles"
#define SEARCH_RESULTS_TEXT  "Search Results"

//-------------------------------------------------------------------------
// maximum length of line, when reading jmrrc or control.dat file
#define MAX_LINE_LEN 256


//-------------------------------------------------------------------------
// maximum length of group name
// #define MAX_GROUP_NAME_LEN 13

//-------------------------------------------------------------------------
// max. length of subject, writer and receiver (bbs)
#define MAX_SUBJECT_LEN  25

//-------------------------------------------------------------------------
// max. length of subject, writer and receiver. This value is used in jmr
#define JMR_MAX_SUBJECT_LEN  52

//-------------------------------------------------------------------------
// max. length of line, when reading reply
#define MAX_REPLY_LINE_LEN 4096

//-------------------------------------------------------------------------
// 
#define MAX_STATUS_MSG_LEN 50

//-------------------------------------------------------------------------
// max. number of articles stored in history
#define READ_HISTORY_SIZE 50

//-------------------------------------------------------------------------
// message status (8 bit flags).
#define UNREAD_ST  0x00
#define READ_ST    0x10
#define PRIVATE_ST 0x20
#define REPLIED_ST 0x40
#define TAGGED_ST  0x80

//-------------------------------------------------------------------------
// reply status
//
#define EDIT_MSG     1
#define REPLY_MSG    2
#define NEW_MSG      3
#define FOLLOWUP_MSG 4

//--------------------------------------------------------------------------
// Literals for message sort order
#define THREAD_SORTED     1
#define DATE_SORTED       2
#define WRITER_SORTED     3
#define RECEIVER_SORTED   4
#define SUBJECT_SORTED    5

//-------------------------------------------------------------------------
// key literals
//
#define QUIT_CMD             'q'
#define FORCED_QUIT_CMD      'Q'
#define SELECT_CMD           LINE_FEED
#define NEXT_UNREAD_CMD      0x09
#define PREV_CMD             'p'
#define NEXT_CMD             'n'
#define PREV_IN_HIST_CMD     'P'
#define NEXT_IN_HIST_CMD     'N'
#define WRITE_CMD            'w'
#define REPLY_CMD            'r'
#define FOLLOWUP_CMD         'f'
#define TAG_CMD              't'
#define TAG_ALL_CMD          'T'
#define KILL_CMD             'k'
#define YANK_IN_OUT_CMD      'y'
#define YANK_TAG_IN_OUT_CMD  'Y'
#define REFRESH_CMD          'r'
//#define BOTTOM_CMD           '>'
//#define TOP_CMD              '<'
#define PAGE_DOWN_CMD        ' '
#define PAGE_UP_CMD          'b'
#define EDIT_REPLY_CMD       'e'
#define SAVE_TO_FILE_CMD     's'
#define SORT_CMD             's'
#define CATCHUP_CMD          'c'
#define FORCED_CATCHUP_CMD   'C'
#define LOAD_CMD             'l'
#define SEARCH_CMD           '/'
#define HELP_CMD             '?'
#define MESSAGEWIN_CMD       'm'

/*
 * Constants for a resources
 */
#define RC_MAILPATH     "qwkpath"
#define RC_REPLYPATH    "replypath"
#define RC_QUOTEPREFIX  "quoteprefix"
#define RC_EDITOR       "editor"
#define RC_UNPACK       "unzipcmd"
#define RC_PACK         "zipcmd"
#define RC_SYSCHARSET   "systemcharset"
#define RC_BBSCHARSET   "bbscharset"
#define RC_WILDCARD     "searchpattern"
#define RC_WRAPMODE     "wrapmode"
#define RC_WRAPIND      "wrapped_indicator"
#define RC_PTAG         "ptagline"
#define RC_TAG          "tagline"
#define RC_FULL_SYSNAME "tag_full_sysname"
#define RC_CONFIRM_RETURN "confirm_return"
#define RC_EXTRACTDIR   "extractdir"
#define RC_REPLYLOGSIZE "replylogsize"
#define RC_DATABASESIZE "databasesize"
#define RC_QUOTECOLOR   "quote_color"
#define RC_BODYCOLOR    "article_color"
#define RC_FOLLOWUPSTR  "followupstring"
#define RC_REPLYSTR     "replystring"
#define RC_DATESTR      "dateformat"
#define RC_MENU_COLOR   "menubar_color"
#define RC_MENU_BCOLOR  "menubar_back"
#define RC_SLINE_COLOR  "statusline_color"
#define RC_SLINE_BCOLOR "statusline_back"
#define RC_DASHLINE_COLOR "dashline_color"
#define RC_DASHLINE_BCOLOR "dashline_back"
#define RC_SUBJECT_COLOR "subject_color"
#define RC_AUTHOR_COLOR "author_color"
#define RC_ILINE_COLOR   "infoline_color"
#define RC_ILINE_ERROR_COLOR "infoline_error_color"
#define RC_HEADER_SUBJECT_COLOR "header_subject_color"
#define RC_HEADER_AUTHOR_COLOR "header_author_color"
#define RC_PERSONAL_COLOR "personal_color"
#define RC_BASEGROUP_COLOR "basegroup_color"
#define RC_DEFAULT_RECEIVER "default_receiver"
#define RC_DEFAULT_FOLDER   "default_folder"
#define RC_TAGLINE_PROGRAM  "tagline_program"
#define RC_SIGNATUREFILE    "signaturefile"

// Yka
#define RC_RMOLDPACKET	"rmoldpacket"

#ifdef TAGB
#define TAGLEADER       "... "
#define TAGLEADERLEN    strlen(TAGLEADER)
#endif

#ifdef F_TO_ALL

#define RC_FOLLOWUPTO   "followupto"
#define FUT_ALL         "all"
#define FUT_WRITER      "writer"

#endif

#define COLOR_VALUES "0","1","2","3","4","5","6","7","8","9","10","11", \
                     "12","13","14"

#define MENUBAR_TEXT " jmr " VERSION " (Alpha) *** Press 'Q' to quit, '?' for help ***"

// messages
#define INVALID_COMMAND_MSG     "Invalid Command. Press '?' for help"
#define NO_UNREAD_MSG           "No more unread articles"
#define AT_FIRST_PAGE_MSG       "First Page"
#define AT_LAST_PAGE_MSG        "Last Page"
#define AT_TOP_MSG              "Top Of List"
#define AT_BOTTOM_MSG           "Bottom Of List"
#define TAGGING_NOT_ALLOWED_MSG "Tagging is not allowed in thread mode"
#define MENU_MSG                "Menu activated. Press ESC-ESC to return"
#define AT_END_OF_ARTICLE_MSG   "End of article. Press SPC for next unread"
#define MESSAGES_MSG            "Message buffer activated. Press any key to return"

#define GROUP_MENU_KEYS_MSG \
"@ENTER@=select @TAB@=next unread [@w@]rite [@y@]ank in/out @/@=search [@q@]uit"

#define THREAD_MENU_KEYS_MSG \
"@ENTER@=select @TAB@=next unread [@w@]rite [@f@]ollowup [@y@]ank in/out [@s@]ort [@q@]uit"

#define THREAD_MENU_NEW_REPLIES_KEYS_MSG \
"@ENTER@=select @TAB@=next unread [@e@]dit [@k@]ill [@y@]ank in/out [@s@]ort [@q@]uit"

#define THREAD_MENU_BASEGROUP_KEYS_MSG \
"@ENTER@=select @TAB@=next unread [@k@]ill [@f@]ollowup [@y@]ank in/out [@s@]ort [@q@]uit"

#define MSG_DISPLAY_NEW_REPLIES_KEYS_MSG \
"@TAB@=next unread [@n@]ext [@p@]rev [@e@]dit [@k@]ill [@q@]uit"

#define MSG_DISPLAY_BASEGROUP_KEYS_MSG \
"@TAB@=next unread [@n@]ext [@p@]rev [@f@]ollowup [@r@]eply private [@k@]ill [@q@]uit"

#define MSG_DISPLAY_KEYS_MSG \
"@TAB@=next unread [@n@]ext [@p@]rev [@f@]ollowup [@r@]eply private [@q@]uit"

#define DATABASE_LIST_KEYS_MSG \
"@ENTER@=select database [@l@]ist mail packets [@r@]efresh [@q@]uit program"

#define PACKET_LIST_KEYS_MSG \
"@ENTER@=select packet [@l@]ist databases [@r@]efresh [@q@]uit program"

#endif
