/* ix/MBox configuration file. Read and adjust it VERY well! 

   REMEMBER: All entries with a leading "_" (underscore) should 
   be modified inside the BBS with the "config" command! 

   If you've updated them here you'd have to delete the [./etc/mbox.cfg]
   file to allow the BBS to create a new one! */


 
#include "defs.h"
#include "patchlevel.h"

#include "mbox.msg"

   

/* The ORGANIZATION entry will be shown as part of the BBS name and is
   part of your mail & news headers as well. */

#define _ORGANIZATION 	"THE UNDERGROUND NETWORK"


/* The name of your BBS is given by the SYSTEM definition. */

#define _SYSTEM       	"The Time Travelling Agency"  





/* Now for some UUCP/Internet specials. First, define in UUCPSITE how your
   system is called within the networks. */
   
#define _UUCPSITE     	"unnet"



/* There are two different domain names for internal BBS use: UUCPID1 and
   UUCPID2. If you like to make a difference between national and
   international users/account, enter differents domain names here. If
   not, give the same name for both definitions. */

#define _UUCPID2      	"unnet.wupper.DE"        
#define _UUCPID1     	"unnet.wupper.DE"



/* The same for NEWS. To recognize national/local newsgroups, three
   toplevel domains may be defined. Don't leave one of them empty! */   

#define _NAT_DOMAIN1  	".de"
#define _NAT_DOMAIN2  	".sub.org"
#define _NAT_DOMAIN3  	"wupper.de" 



/* Just to keep old traditions, enter your bang path at UUCPBANG. */ 

#define _UUCPBANG     	"~!unido!ruhrgebiet.individual.net!mechti!unnet!"



/* If you want your BBS to be the reference system for your area, please
   supply your dial-in number(s) here. */

#define _PHONE		"+49 202 4660234 (ZyXEL) / +49 202 462114 (ZyXEL)"
#define _LOCATION	"Germany (Europe)"


/* If your UUCP software creates any kind of readable statistics output
   that you like to show to your users, name the path to that output at
   UUCPCOSTS. */

#define UUCPCOSTS    	"/usr/spool/uucp/.costs"



/* If the mailer gets into trouble, it mind find the SMARTHOST entry
   very helpful. */

#define _SMARTHOST	"mechti"






/* The BBS uses two different TMP directories. The first one should be on
   the same drive/partition as the other BBS directories - this will speed
   up copying on systems without symbolic links. The GLOBAL_TMP directory
   should be the unix '/tmp'. */

#define TMP	     	"./tmp"	
#define GLOBAL_TMP	"/tmp"





/* The location of you news spool directory has to be named in NEWS. */

#define NEWS         	"/usr/spool/news"



/* The news system will hold a list of newsgroups and descriptions in
   a file. Define that file and path in NEWSGROUPS. */

#define NEWSGROUPS	"/usr/local/lib/news/newsgroups"



/* The news active file is called NGROUPS inside the BBS. The boards of
   the BBS will be built upon this file. */

#define NGROUPS      	"/usr/local/lib/news/active"


/* The MODERATORS file is used as a mailers aliases file. The BBS needs
   it to recognize moderated newsgroups - instead of a news article, the
   BBS will send a mail to the newsgroups moderator. That's BNEWS only! */

#define MODERATORS	""


/* Some older news systems don't care if you delete news articles by
   yourself. The MB-DAEMON (news index builder of the BBS) will use 
   EXPIRE to do so, if a newsgroups contains too much articles. 


   The max. number of articles is defined in MAX_PER_NG. If you or
   your news system (CNEWS for example) don't want to use EXPIRE, just
   set a very high value here.

   NOTE: The value of MAX_PER_NG is used for string arrays, so keep the
   value well under the 32000 mark!!        

   But no worries at all! The EXPIRE feature is now disabled by default.
   If you want to use it, search for "EXPIRE" in "mb-daemon.c" to enable
   it again.


   How many articles are deleted, is declared in EXPIRED_DAYS. EXPIRE
   will delete all articles older than EXPIRED_DAYS. If the number of
   articles have reached LIM_RE_INFO, you'll find an entry in a file
   called [./log.mbd-error]. That may be worth looking at from time to 
   time! */

#define EXPIRE       	"/usr/local/lib/news/expire"
#define MAX_PER_NG   	3000
#define EXPIRED_DAYS 	32
#define LIM_RE_INFO	300
#define MBD_ERROR	"./etc/log.mbd-error"


/* Which newsgroups a new user is allowed to read is said in the
   definition NEWS_MINIMUM. If you want them to get all, enter "all".
   If you like to use all groups in [./etc/active.selected], enter
   "selected". */

#define _NEWS_MINIMUM 	"selected"
#define _NEWS_LEVEL1	"all"
#define SELECTED	"./etc/active.selected"



/* If your mailer dumps all non-deliverable mails to a certain mailbox,
   the BBS (XMD, to tell the truth) will search for mails to BBS users
   there. If you use SMAIL and it's aliasing mechanism, you don't have
   to define the ERRMBOX - but you wouldn't do wrong, anyway. */

#define ERRMBOX      	"/usr/spool/mail/postmaster"



/* The place where your systems mailer hides his maildrops should be
   defined in MAILDROP. */

#define MAILDROP	"/usr/spool/mail"



/* If shell users getting their first BBS account, the BBS looks at
   SIGNATURE to use that signature for internal use, too. */

#define SIGNATURE    	".wmailsign"



/* The BBS uses an internal mailer to handle the special adresses of
   users without shell accounts. This mailer XMD will log his activities
   in XMDLOG. You may change this definition! */

#define XMDLOG	     	"/usr/adm/xmd.log"



/* XMD is able to redirect mails to BBS users. Therefore aliases may be
   defined in XMD_ALIAS. Change the file, not the definition! */

#define XMD_ALIAS	"./etc/xmd.alias"
#define MAX_XMD_ALIAS   20



/* This is how XMD recognizes the beginning of an undeliverable mail.
   Look at ERRMBOX (the file, not the definition) after writing a mail
   to "yourdomain!mbox.user" (just variables, use right names instead!). */

#define RETURNED_MAIL   "From postmaster"



/* To calculate the delivering time, XMD looks at TIMEZONES to find out
   where the sender of a mail lives. Your own distance from GMT has to
   be defined in GMT_DIFF. Look at TIMEZONES for the correct value ;-) */

#define TIMEZONES	"./etc/timezones"
#define GMT_DIFF	"+0100" 



/* Logins and actions of all users are recorded. You have to choose where
   those informations are stored or printed.

   If CONSOLE is defined as "REDIRECT", than the BBS will read the name
   of a file or device in CDIRECTFL and dump the data on that.

   If CONSOLE includes a filename or device, the BBS will user that for
   all log output. */

#define CONSOLE	     	"REDIRECT"
#define CDIRECTFL    	"/etc/mbox.out"



/* All catched errors are recorded in/on CPRN. All not catched errors will
   leave you with a dumped 'core' ;-) */

#define CPRN	     	"/tmp/errlog"



/* The POSTMASTER is the only person (except "root") who will have complete
   access to the BBS. Enter the name of his/hers shell account! */

#define POSTMASTER   	"volkers"



/* To make sure that no unauthorized person fiddles around with 'classified'
   user data and files, name the one and only terminal the postmaster is 
   allowed to use in PMS_TTY. Leave this definition blank if you don't
   want any checks (#define PMS_TTY		""). */

#define _PMS_TTY      	"/dev/tty4"



/* How fast is your fastest port? Tell this in MAX_BPS - don't brag ;-) */

#define MAX_BPS      	19200



/* The name of your visitors is given by GUEST. */
/*

THIS NOW HAS TO BE DEFINED IN "./src/language"/YOUR_LANGUAGE.msg" !!!

#define GUEST        	"GAST"
*/





/* Don't change but keep in mind pretty well! The first group of files
   will be update by the BBS. You only should read the files for debug
   reasons. 

   BEFEHLE, HILFE and KURZHILFE will be set up by "make english" (or any
   other language). The prototypes of these files are stored in the
   directory "./src/languages". 

   SEQ, CALLS, ALLTIME and WHO are changed everytime a users calls in. */   


#define SEQ          	"./etc/mbox.seq"
#define CALLS        	"./etc/log.calls"
#define ALLTIME		"./etc/log.alltime"
#define MBSTAT		"./etc/log.stat"
#define WHO          	"./etc/mbox.who"



/* How many days you like to store in CALLS? The more, the longer will a
   user have to wait while he is logging in. */

#define PRO_ENTRIES  	1000



/* Number of days shown at CALLS PER DAY statistics. Depends on the number
   of screen lines. 20 has proofen useful. */

#define MAX_TAGE	20



/* The INTRO file should include some announcements or messages to 
   users with BBS accounts. */

#define INTRO        	"./etc/intro"



/* In GUESTS_INTRO you may tell your guests some secrets about your BBS
   and how they may become regular users. */

#define GUESTS_INTRO	"./etc/guests.intro"


/* If a user has been thrown out due to a reached timeout or if he/she
   has yet done the max. allowed number of calls, the following file is
   shown. */

#define THROWN_OUT	"./etc/thrown.out"


/* Before showing the BBS name and the "Username:" line, the BBS will
   display the LOGO. Store your ANSI intro or BBS jingle/logo there. */

#define LOGO         	"./etc/logo"



/* To introduce and describe your system goodies, use the SYSINFO. */

#define SYSINFO		"./etc/sysinfo"



/* BE VERY CAREFUL HERE! The EDITORS file should contain a list of
   editors which your users can use to enter mails and news articles.

   The first two entries should/MUST be "Led" and "Wendy" to prevent
   serious security gaps! */

#define EDITORS      	"./etc/list.editors"



/* The following definitions won't need any changes, either. But you
   should have a look at those files. */

#define UDCS		"./etc/list.udc"
#define PACKERS		"./etc/list.packers"
#define TERMIS          "./etc/list.terminals"
#define STTOUT		"./etc/list.timeouts"
#define MOSTLY_HARMFUL	"./etc/list.critical"


/* Do offer some games. Users will love them - don't ask me why! 
   If you want to have more than 9 games, you have to change the source code! */

#define GAMES	     	"./etc/list.games"
#define MAX_GAMES	9



/* If you have a multiuser/multiport chat program, name it in CHAT. */

#define CHAT         	"/usr/local/bin/chat"




/* To get the following definitions right, you MUST have a look at 
   the "/etc/passwd" file:

   root:O/a0X||||PEr1:0:0:The Postmaster Account:/usr/root:bin/csh
   ^^^^               ^ ^
   guest::12:1:BBS (only) User:/usr/gast:/usr/bin/mbox
   ^^^^^     ^
   gast::13:1:BBS (only) User:/usr/gast:/usr/bin/mbox
   ^^^^     ^
   bbs::14:1:BBS (only) User:/usr/gast:/usr/bin/mbox
   ^^^     ^
   volkers:/SuZF{u9O8X5C:9:6:Volker Schuermann:/usr/volkers:/bin/sh
   ^^^^^^^                 ^

   ROOT_UID 0, ROOT_GID 0
   GUEST_GID 1
   USERS_GID 6 (no need to define this but just for clearness we'll do)

   The BBS won't work properly if you didn't allow to use "root.root"
   permissions (i.e. ROOT_UID 0, ROOT_GID 0).

   NOTE: Some systems (like SCO Unix and SINIX) prefer ROOT_GID 1 (others). 
   That might work, but I wouldn't bet on it!

   Also, you'll get very serious problems if your GUEST_GID isn't
   different from the USERS_GID of "normal" shell users! 

   
   Still as clear as mud? Well, your last chance: Read the FAQ!

   You definitly NEED TO GET THIS RIGHT! Otherwise the BBS may never
   ask guests (i.e. users w/o shell accounts) to log in - as I said,
   it's indeed essential to make correct - means correct according to
   your "/etc/passwd" and "/etc/group" files - definitions here! */


#define ROOT_UID      	0
#define ROOT_GID      	0	 
#define GUEST_GID     	1
#define USERS_GID       6 	



/* If you don't use MINIX, ignore it. If you do, just define the number
   of your first external terminal in FIRST_EX_TTY. */

#define FIRST_EX_TTY	64



/* How many terminal ports do you have. Define MAX_TERMINALS correctly
   to avoid a wast of memory. */

#define MAX_TERMINALS	20



/* There is a news index builder, which should be started every day or
   night after your news system sorted in all new articles. Name the
   place where the binaries of MB_DAEMON are stored (look at Makefile,
   defintion BIN). */

#define MB_DAEMON    	"/local/mbox/mb-daemon"



/* The MB_DAEMON will build up a table of the number of incoming articles.
   Don't change the definitions. */

#define MB_DLOG      	"./etc/log.mbd"
#define MB_READY	"./etc/mb.daemon"



/* Here are a few shell commands used by the BBS to make my life easier. 

   GREP to search something. Add "-n" flag to obtain filenames, line no. ...!
   UUX to execute commands on other uucp systems.
   TAR to pack a list of files. 

   Flags are depending on your very own UNIX version. So have a look 
   at the man pages. */

#define _GREP         	"/usr/bin/fgrep -n"
#define _UUX		"uux -r"
#define _TAR		"/usr/bin/tar -cf"



/* Some statistics are using unix commands to build up figures out of 
   internal protocols and logfiles.

   The syntax of the following definitons may vary fairly drasticly! */

#ifdef _MINIX
#define _SORTEDCUT      "cut -d' ' -i2 -f3 %s | sort - | uniq -c | sort -r - | sed '/ \\//s//   \\//g' > %s"
#define _SECONDCUT	"cut -c6-35 %s | sed '/  /s//     /g' | sort - | uniq -c | sort -r - > %s"
#define _THIRDCUT 	"cut -c68-72 %s | uniq -c > %s"
#define _FOURTHCUT	"sort ./etc/usage | uniq -c | sort -r > %s"  
#else
#define _SORTEDCUT      "cut -b 13-53 %s | sort - | uniq -c | sort -r - | sed '/    /s// /g' > %s"
#define _SECONDCUT	"cut -c6-35 %s | sort - | uniq -c | sed '/    /s//   /g' | sort -r - > %s"
#define _THIRDCUT 	"cut -c68-72 %s | uniq -c > %s"
#define _FOURTHCUT	"sort ./etc/usage | uniq -c | sort -r > %s"  
#endif


/* The "pd.script" uses this definition to fetch your most beloved
   editor. */

#define FAVORITE_EDITOR	"/usr/bin/vi"


/* Name a printing device here. If you are reading mails/articles, you are
   able to print them by typing "d" or "p". This isn't documented any-
   where to avoid a waste of print paper. Please don't tell MY users! */

#define PRINTER		"/usr/local/bin/ftpprint"


/* If you have got any sort of GIF/JPG/whatever previewer that could be
   used by callers, just enter it here. */

#define PREVIEW		"/usr/bin/gifview"


/* Newsgroups for broadcasting binaries are containing articles encrypted
   with UUDECODE. Tell the BBS where you want to store the binaries in
   UUINCOMING. */

#define UUDECODE	"/usr/bin/uudecode"
#define UUINCOMING	"/tmp/.uud"
#define IPINCOMING	"/usr3/incoming"  


/* Up- and Download has to be done with protocol flow control. Which
   protocols/programs are used will be defined in SZ, SX, SB, RZ, RX, RB. */

#define SZ           	"/usr/bin/sz"
#define SX           	"/usr/bin/sx"
#define SB 	     	"/usr/bin/sb"

#define RZ           	"/usr/bin/rz"
#define RX	     	"/usr/bin/rx"
#define RB	     	"/usr/bin/rb"





/* Now for the Public Domain, Share- or Freeware stuff. The name of
   your PD hierachy/groups is defined as PDNG. PDLOG and PDSCRIPT don't
   need to be changed. Make sure you understood the purpose of PDSCRIPT,
   described in README! 

   NOTE: Don't leave PDNG blank! */

#define PDNG	     	"local.pd"
#define PDLOG	     	"./etc/log.pd"
#define PDSCRIPT     	"./etc/pd.script"


/* If you own a CDROM device, you can offer PD stuff and things to your
   very lucky users. I can't imagine any reason to rename the definitions,
   but whatever you do, you have to keep in mind that CDROMNG must never
   be empty - the defintion mustn't be "", that is! */

#define CDROMNG		"cdrom"
#define CDROM_DUMMY	"local.pd.cdrom"

#define ADULTNG		"adult"



/* The Telecom/PTT/AT&T/BELL or others are charging as follows ...

   TARIF says how many money per unit.

   NZNT how long lasts a unit (prime time, local call)
   NZBT how long lasts a unit (non-prime time, local call)

   RZNT how long lasts a unit (prime time, national call)
   RZBT how long lasts a unit (non-prime time, national call)

   WZNT how long lasts a unit (prime time, long distance call)
   WZBT how long lasts a unit (non-prime time, long distance call) */

#define _TARIF        	23
#define _NZNT         	360
#define _NZBT         	720
#define _RZNT 	     	60
#define _RZBT	    	120
#define _WZNT	     	21
#define _WZBT	     	42





/* The MB-DAEMON also is able to "reflect" certain newsgroups. That means,
   it replies to articles in REFLECT_NG by mailing the author. */

#define _REFLECT_NG  	"wupper.test"



/* The reflector will send a list or text on command. Which text is defined
   in DIRLIST. */
   
#define DIRLIST     	"/public/pd/DIRLIST"



/* The following REFLECT_LOG needn't be changed. Look at that file from
   time to time, to see who used the reflector. */

#define REFLECT_LOG 	"./etc/log.reflector"



/* I really don't know! It's an offset to get time calculating work
   properly. Maybe I have to set it to '1', cause I'm living at a 
   timezone GMT +0100 ... don't ask, I've no idea! */

#define TZS		1



/* The MIME_VERSION is defined in MIME, METAMAIL or any other RTF-
   package. The BBS doesn't need this, but receivers of you mails
   will! */

#define MIME_VERSION	"1.0"




/* This is for systems only, which are getting the newsgroup "de.etc.finanz",
   where a friendly guy (STOCK_AUTOR) posts business reports. 

   Nobody needs to change anything. Be happy if it works ... */ 

#define STOCK_DJ	"Subject: Dow Jones Aktien"
#define WPKN_DJ		"Subject: Dow Jones Aktien WPKN"
#define STOCK_DAX	"Subject: DAX Aktien"
#define WPKN_DAX	"Subject: DAX Aktien WPKN"
#define STOCK_AUTOR	"Michael_Wagner@the-msu.fido.de"
#define STOCK_PATH	"./stock"
#define STOCK_INDEX	"./stock/index"



/* The following is used only if you are supporting the weather report
   (mis-)feature of the ix/MBox ;-) */

#define WEATHER_REPORT	"./etc/weather.report"


/* The entries for VERSION and AUTOR mustn't be changed by anyone but
   me! */

#define VERSION	     	"ix/MBox BBS 2.6"
#define AUTOR        	"by <volkers@unnet.wupper.DE>"


/* Configuration file. Some of the defines in [mbox.h] (this file here)
   are stored in MBOX_CFG to give you the ability to redefine them w/o
   recompiling the BBS. */ 

#define MBOX_CFG	"./etc/mbox.cfg"


/* To change this isn't part of your duty. Simply ignore it! */

#define X_MAIL_DEMON 	"X-Mail-Daemon"


/* The BBS paths to LIB and AGROUPS may be changed, but there isn't
   any need! */

#define LIB	     	"./lib"
#define AGROUPS      	"./etc/active"



/* You don't have to manipulate UDBASE and UDSEQ - neither path nor
   contents! Just keep in mind where both files are and make backups
   fairly often. */

#define UDBASE       	"./etc/users.data"
#define UDSEQ        	"./etc/users.seq"



/* To get the permissions and user id on shell level in order, the BBS
   uses its own shell RSH. Leave this shell where and how it is! */

#define RSH          	"./etc/mbrsh"


/* Some nice (?) IBM-ANSI-Headlines for the PC-DOS callers. No changing
   should be needed. If you like to improve the files you have to use
   an ANSI editor like "TheDraw" (for DOS). */

#define ANSI_COMMANDS		"./etc/ansi.commands"
#define ANSI_HELP		"./etc/ansi.help"
#define ANSI_PORTINFO		"./etc/ansi.portinfo"
#define ANSI_SYSINFO		"./etc/ansi.sysinfo"
#define ANSI_INTRO		"./etc/ansi.intro"
#define ANSI_USERS		"./etc/ansi.users"


#define WWW			"/usr/local/bin/www"
