
/* ix/MBox (g94.c) by Volker Schuermann, 29.03.1995 

   This C source code contains the following functions:

   #G9 g94()		  main loop of g94 support

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "mbox.h"


#define SCHWARZ      0
#define DUNKELGRAU   1
#define GRAU         2
#define HELLGRAU     3
#define WEISS        4
#define DUNKELROT    5
#define ROT          6
#define HELLROT      7
#define GELB         8
#define HELLGRUEN    9
#define GRUEN       10
#define DUNKELGRUEN 11
#define HELLBLAU    12
#define BLAU        13
#define DUNKELBLAU  14
#define PINK        15


#define SCREENFULL	39

#define MAIL	1
#define NWS	2
#define STAT	3 
#define UDAT	4
#define W3W	5

#define SHOWGROUP	1
#define SHOWMAIL	2	
#define SHOWARTI	3


UNSIGNED char TO_DOWNLOAD[STRING];
UNSIGNED char LAST_TEXT[STRING];


void debug( text )
UNSIGNED char text[];
{ 
  FILE *fp;

  fp = fopen( "/tmp/debug", "a" );
  fprintf(fp, "%s - %s  ", mydate( 1 ), mytime( 1 ));
  fprintf(fp, "(%s)  ", ttyna());
  fprintf(fp, "%s\n", text);
  fclose(fp);
}



void g94_nrep( path )
unsigned char path[];
{
  FILE *fp;
  int i;
 
  UNSIGNED char s[STRING];
  UNSIGNED char ex[LONGSTRING];

  printf("%cAE%c%c%c\n", ESC, 32+1, 32+1, 32+SCHWARZ );
  
  sprintf(s, "%s %s", SX, path );
  debug( s );
  system( s );
 
  i = 0;
  do{
	strcpy(s, (UNSIGNED char *) getline(STRING, 0, ' ', ""));
	sprintf(ex, "%s (%d)\n", s, i);
	debug( ex ); 
	i++; 
  }while((i < 5) && (strcomp("GO, GO, GO!!!", s)!= 0));

  if(i == 5){
     sprintf(s, "Timeout in Download // g94_nrep()");
     debug( s );
     return;
  }

  sprintf(s, "%s -vvvvv %s 2>> /tmp/debug", RX, path );
  debug( s );
  system( s ); 
  debug( "Download finished." );
}


void g94_xfer()
{
  FILE *fp;
  int i;
 
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];

  sprintf(t, "%s/%dTep", TMP, getpid());

  printf("%cAE%c%c%c\n", ESC, 32+1, 32+1, 32+SCHWARZ );
  
  sprintf(s, "%s %s", SX, t );
  debug( s );
  system( s );
 
  i = 0;
  do{
	strcpy(s, (UNSIGNED char *) getline(STRING, 0, ' ', ""));
	sprintf(ex, "%s (%d)\n", s, i);
	debug( ex ); 
	i++; 
  }while((i < 5) && (strcomp("GO, GO, GO!!!", s)!= 0));

  if(i == 5){
     sprintf(s, "Timeout in Download // g94_xfer()");
     debug( s );
     return;
  }

  sprintf(s, "%s -vvvvv %s 2>> /tmp/debug", RX, t );
  debug( s );
  system( s ); 
  debug( "Download finished." );
}



void g94_reply( mode )
char mode;
{
  FILE *fp, *ff;
  int i;
 
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];

  sprintf(t, "%s/%s/%dRep", HOME, TMP, getpid());

  fp = fopen( LAST_TEXT, "r" );
  if(fp == NULL){
	debug( LAST_TEXT );
  }
  ff = fopen( t, "w" );
  if(ff == NULL){
  	debug( t );
  }

  while(fgets(ex, LONGSTRING, fp) != NULL) fputs(ex, ff);
   
  fclose(ff);
  fclose(fp);

  if(mode == 'a')
	brief( "~REPLY~" );
  else
	schreiben( "" );


  sprintf(s, "%s/A%d",     TMP, getpid()); unlink( s );
  sprintf(s, "%s/%dRep",   TMP, getpid()); unlink( s );
  sprintf(s, "%s/%dTep",   TMP, getpid()); unlink( s );
  sprintf(s, "%s/%d.expm", TMP, getpid()); unlink( s );
 
  return;
}         


void g94_text( x, y, maxl, text )
int x, y, maxl;
UNSIGNED char text[];
{
  FILE *fp;
 
  UNSIGNED char s[STRING];
  UNSIGNED char ex[LONGSTRING];
  int i, l = 0;

  struct stat fst;


  fp = fopen( text, "r" );
  if(fp == NULL){
	printf("Hae??");
	return;
  }


  while((fgets(ex, LONGSTRING, fp) != NULL) && (ex[0] > 32));

  while((fgets(ex, LONGSTRING, fp) != NULL) && (ex[0] < 32));

  if(strcomp("Content-", ex) == 0) 
      	fgets(ex, LONGSTRING, fp);

  if(strcomp("BINFILE", ex) == 0){
	fgets(TO_DOWNLOAD, STRING, fp);	/* DOWNLOAD PATH/FILENAME */
	strcpy(TO_DOWNLOAD, (UNSIGNED char *) stripped( TO_DOWNLOAD ));
	fclose(fp);
	l = 0; i = 0;
	while(TO_DOWNLOAD[i] != '\0'){
		if(TO_DOWNLOAD[i] == '/') l = i + 1;
		i++;
	}
	strcpy(s, (UNSIGNED char *) strcopy(TO_DOWNLOAD, l, strlen(TO_DOWNLOAD)));
	stat(TO_DOWNLOAD, &fst);
	
	printf("%cAD%c%c%c%s=%ld\n", ESC, 32+x, 32+y, 32+SCHWARZ, s, (long) fst.st_size);		

	return;
  }

  if(strcomp(XMD02_MSG, ex) == 0){
     fgets(ex, LONGSTRING, fp);
  }
  else{
    rewind(fp);
  }

  printf("%cAT%c%c%c\n", ESC, 32+x, 32+y, 32+SCHWARZ );
  
  while((fgets(s, STRING, fp) != 0) && (l < maxl)){
	printf("%s", s);
	l++;
  }
  fclose(fp);

  printf("\n-e-\n");

  strcpy(LAST_TEXT, (UNSIGNED char *) text);
 
  return;
}





void g94_intro()
{
  FILE *fp;
  int c; 

  printf("%cAC\n", ESC);

  printf("%cAW%c%c%c%c%c\n", ESC, 32+25, 32+19, 32+55, 32+27, 32+0 );
  printf("%cAS%c%c%c%s\n",   ESC, 32+26, 32+21, 32+HELLROT, ORGANIZATION );
  printf("%cAS%c%c%c%s\n",   ESC, 32+26, 32+23, 32+SCHWARZ, SYSTEM );
  printf("%cAS%c%c%c%s\n",   ESC, 32+26, 32+25, 32+BLAU, VERSION ); 

  printf("%cAX%c%c%c\n", ESC, 32+47, 32+20, 32+HELLGRAU);
  fp = fopen( "./etc/face.put", "r" );
  while((c = fgetc(fp)) != EOF){
	printf("%c", c);
  }
  fclose(fp);
  printf("X"); 
 
  printf("%cAMInfo,Mail,News,WWW,Stats,Users,Restart,End\n", ESC );

  printf("%cAl\n", ESC); /* WWW Autostart !!! */

  return;
}


void g94_showarticles( path )
UNSIGNED char path[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;


  printf("%cAb%c%c%c%cArticles\n", ESC, 32+45, 32+5, 32+8, 32+SHOWARTI );

  fp = fopen( path, "r" );
  while(fgets(s, STRING, fp) != 0){
	s[32] = '\0';
	if((s[5] != '*') && (s[5] != '=')) printf("  %s\n", s);
  }
  fclose(fp);
  printf(" \n");

  return;
}





void g94_req( no, line )
int no;
UNSIGNED char line[];
{
  FILE *fp;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i;

 
  switch(no){
	case SHOWGROUP : 	strcpy(s, (UNSIGNED char *) shortname( line ));
				strcpy(BRETT, (UNSIGNED char *) line);
				strcpy(NG, (UNSIGNED char *) line);
				i = 0; 
				while(NG[i] != '\0'){
					if(NG[i] == '.') NG[i] = '/';
					i++;
				}
				sprintf(t, "%s/%s/%s", HOME, LIB, s);
				g94_showarticles( t );									
				break;
        case SHOWMAIL  :	i = atoi( line );
				sprintf(s, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, i );
				g94_text( 100, 100, 9999, s );
				break;
	case SHOWARTI  :	i = atoi( line );
				sprintf(s, "%s/%s/%d", NEWS, NG, i);	
				g94_text( 100, 100, 9999, s );
				break;
	default 	:	break;
  }
  return;
}


void g94_showmails()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;

  printf("%cAb%c%c%c%cMails\n", ESC, 32+45, 32+5, 32+8, 32+SHOWMAIL );

  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
 
  fp = fopen( s, "r" );
  fgets(s, STRING, fp);
  fgets(s, STRING, fp);
  while(fgets(s, STRING, fp) != 0){
	s[32] = '\0';
	if((s[5] != '*') && (s[5] != '=')) printf("  %s\n", s);
  }
  fclose(fp);
  printf(" \n");

  return;
}



void g94_showgroups()
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  FILE *fp;


  printf("%cAb%c%c%c%cBoards\n", ESC, 32+45, 32+5, 32+8, 32+SHOWGROUP );

  fp = fopen( AGROUPS, "r" );
  while(fgets(s, STRING, fp) != 0){
  	sscanf(s, "%s %s %s", s, t, t);
	printf("%s\n", s);
  }
  fclose(fp);
  printf(" \n");

  return;
}



int g94_mail( ret )
int ret;
{
  switch( ret ){
        case 1 :	g94_showmails();
			break;
	case 2 :
			break;
	case 3 : 	
			break;
  }
  return;
}



int g94_news( ret )
int ret;
{
  switch( ret ){
	case 1 :	g94_showgroups();
			break;
	case 2 :	g94_showgroups(); 
			break;
  }

  return;
}


int g94_stat( ret )
int ret;
{
  switch( ret ){
	case 1 :	g94_text( 100, 100, SCREENFULL, CALLS );
			break;
	case 2 :	g94_text( 100, 100, SCREENFULL, MB_DLOG );
			break;
	case 3 :        g94_text( 100, 100, SCREENFULL, PDLOG );
			break;
  }
  return;
}


int g94_user( ret )
int ret;
{
   printf("%cAF\n", ESC);
   printf("130 0010\n");
   printf("138 0010\n");
   printf("146 0010\n");
   printf("155 0010\n");
   printf(" \n");
   return;
}


int g94_www( ret )
int ret;
{
  if(ret == 2){
	printf("%cAF\n155 0015\n \n", ESC);
	return;
  }
  printf("%cAl\n", ESC);
}


int g94_www_interact( htline )
UNSIGNED char htline[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  int c;

  printf("\n*");  
  sprintf(s, "%s -source %s > ./tmp/html.%d", WWW, htline, getpid() );
  debug( s );
  system( s );

  sprintf(s, "./tmp/html.%d", getpid() );
  fp = fopen( s, "r" );
  if(fp == NULL){
     printf("\nWWW//EOF\n");
     return;
  }
  do{
    c = fgetc(fp);
    if(c == 10){
       printf("**");
       c = 13;
    }
    printf("%c", c);
  }while(c != EOF);
  fclose(fp);

  system( "./contrib/reset.httpd" );

  printf("\nWWW//EOF\n");
} 


int g94_pop( no, ret )
int no, ret;
{
  switch( no ){
	case MAIL :	g94_mail( ret );
			break;	
	case NWS  : 	g94_news( ret );
			break;
	case STAT :	g94_stat( ret );
			break;
 	case UDAT :	g94_user( ret );
			break;	
	case W3W  :	g94_www( ret );
			break;
  }
  return;
}


int g94_menue( c )
char c;
{
  int ok = 0;


  switch( c ){
	case 1 : 	g94_text( 20, 2, 9999, "/local/mbox/etc/intro");	
			break;
	case 2 :	printf("%cAP%c%c%c%cRead Mail,Send Mail,Delete Mail\n", ESC, 32+17, 32+7, 32+SCHWARZ, 32+MAIL);
			break;
	case 3 :	printf("%cAP%c%c%c%cChange Group,Read Article,Send Article\n", ESC, 32+18, 32+9, 32+SCHWARZ, 32+NWS);
			break;
	case 4 :	printf("%cAP%c%c%c%cBrowse,Create\n", ESC, 32+20, 32+11, 32+SCHWARZ, 32+W3W); 
			break;
	case 5 :	printf("%cAP%c%c%c%cCalls,News,Downloads\n", ESC, 32+20, 32+11, 32+SCHWARZ, 32+STAT);
			break; 
	case 6 :	printf("%cAP%c%c%c%cList,Finger\n", ESC, 32+22, 32+13, 32+SCHWARZ, 32+UDAT); 
			break;
	case 7 : 	g94_intro();
			break;
	case 8 :	printf("%cAQ\n", ESC);
			ok++;
			
  }

  return ok;
}




void g94()
{
  UNSIGNED char line[STRING];
  UNSIGNED char s[STRING];
  int end = 0;
  int c, d; 

  FILE *fp;

  chdir( HOME );

  MENUE_USING = 0;

  if(strcomp("Volker Schuermann", USER.name) != 0){
	fp = fopen( "/tmp/surf", "a" );
	fprintf(fp, "%s  -  ", mydate( 1 ));
	fprintf(fp, "%s  %s (%d)\n", mytime( 2 ), USER.name, USER.id);
	fclose(fp);
  }
  sprintf(s, "[%s  %s (%d)]", mydate( 1 ), USER.name, USER.id);
  debug( s );

  G94ACTIVE = 1;

  do{
	strcpy(line, (UNSIGNED char *) getline(80, 0, ' ', "") );

	debug( line );

 	sprintf(s, "G94: %d (ID), %d (RET)", line[1] - 32, line[2] - 32);
	whodo( s ); 
 
	if(line[0] == 'G'){
		g94_intro();
	}

	if(line[0] == 'M'){
		if(g94_menue( line[1] - 32 ) == 1) end++;
  	}

	if(line[0] == 'P'){
		g94_pop( line[1] - 32, line[2] - 32);
	}

	if(line[0] == 'B'){
		strcpy(s, (UNSIGNED char *) strcopy(line, 2, strlen(line)));
		strcpy(s, (UNSIGNED char *) stripped(s));
		g94_req( line[1] - 32, s );	
  	}

	if(line[0] == 'D'){
		sprintf(s, "%s %s", SZ, TO_DOWNLOAD);
		system( s );
	}

	if((line[0] == 'A') || (line[0] == 'a')){
	   	g94_reply( line[0] );	
	}

	if(line[0] == 'l'){
		strcpy(s, (UNSIGNED char *) strcopy(line, 1, strlen(line)));
		strcpy(s, (UNSIGNED char *) stripped(s));
		g94_www_interact( s );
 	}

	if(end == 0){
		c = getint(); /* ESC */
		d = getint(); /* 'A' */
	}	

  }while(end == 0);

}
