/* ix/MBox/WENDY (echo.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #GE getch()            switch echo on/off, return anyway

   Contact <volkers@unnet.wupper.de> for help! 


   !!! See below to find out who wrote this one!!! */








/*
 *	%Z% %M%	%I% %D% %Q%
 *
 *	Copyright (C) 1990 by Christian Schlichtherle
 *			      (chriss@attron.ruhr.sub.org)
 *
 *	%M% - C module for getch(S).
 *
 *	"getch" is a DOS and curses(S) like function which reads
 *	a unsigned character and returns immediately without waiting for
 *	newline.
 *
 * 	getch() - Gets a unsigned character.
 * 	This function gets one unsigned character and immediately returns
 * 	without waiting for newline. The unsigned character is not echoed.
 * 	This function can be used best when you want to input only one
 * 	unsigned character within canonical input or if you need this function
 * 	only very rarely.
 * 	EOF is returned on errors or if an ignored signal occured.
 *	
 *	Modificated by andreas@xenox.w.open.de 06/20/92 Xenox
 */


#include <sys/types.h>
#include <stdio.h>    
#include <errno.h>
#ifndef _SYS7
#include <sys/ioctl.h>
#include <termio.h>
#else
#include <sgtty.h>
#endif 

#ifndef _SYS7
static struct termio	told, tnew;

#define	get_oldmode()	ioctl(0,TCGETA, &told)
#define	set_oldmode()	ioctl(0,TCSETA, &told)
#define	set_newmode()	(tnew.c_cc[VMIN] = 1,tnew.c_cc[VTIME] = 0,\
			 tnew.c_lflag &= ~(ICANON | ECHO),\
			 ioctl(0, TCSETA, &tnew))

#else
static struct sgttyb	told, tnew;

#define	get_oldmode()	ioctl(0,TIOCGETP, &told)
#define	set_oldmode()	ioctl(0,TIOCSETP, &told)
#define	set_newmode()	(tnew.sg_flags |= RAW,tnew.sg_flags &= ~ECHO,\
			 ioctl(0, TIOCSETP, &tnew))

#endif

static int	set = 0;

void	echo( mode )
int 	mode;
{
	int	rstat;

	if(mode == 0){
		if (!set) {
			get_oldmode();
			tnew = told;
			set = 1;
		}
		set_newmode();
	}	
	if(mode == 1){
	        set_oldmode();
	}
}

