/* ix/MBox (weiterl.c) by Volker Schuermann, 01.04.1995

   This C source code contains the following functions:

   #WL weiterleiten()    forward mails or articles
   #CC carboncopy()      send copies to other users
   #BO boerse()          stock exchange ("de.etc.finanz")
   #OW old_weiterl()     guess what ...

   Contact <volkers@unnet.wupper.de> for help! */






#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "mbox.h"



void old_weiterl();


/* #WL - Forward mails/articles to a couple of "destinations" ... */

void weiterleiten( argument )
UNSIGNED char argument[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char v[STRING];
  UNSIGNED char empf[STRING];
  UNSIGNED char group[STRING];
  UNSIGNED char host[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char arg[STRING];

  UNSIGNED char oempf[STRING];
  UNSIGNED char oabs[STRING];
  UNSIGNED char obetr[STRING];
  UNSIGNED char odate[STRING];
 
  UNSIGNED char ex[LONGSTRING];


  int a, b = -1, i = 0, j = -1, x = -1, von = 1, bis = 99999;
  int email = 0, article = 0, local = 0, ok, header;
  int run = 0;
  int kopie = 0;

  long tdummy;


  FILE *fp, *ff;



  oempf[0] = '\0';
  oabs[0]  = '\0';
  obetr[0] = '\0';
  odate[0] = '\0';

  strcpy(arg, (UNSIGNED char *) argument);

  if(strcomp("-K", arg) == 0) kopie = 1;
  if(strcomp("-O", arg) == 0) kopie = 2;
  if((strcomp("-K", arg) == 0) || (strcomp("-O", arg) == 0)){
	i = 0;
	while((arg[i] != ' ') && (arg[i] != '\0')) i++;
	strcpy(arg, (UNSIGNED char *) strcopy(arg, (i+1), strlen(arg)));
  }

  i = 0;
  while(arg[i] != '\0'){
	if(arg[i] == '-') j = i;
	if((arg[i] > 64) && (b == -1)) b = i;
        i++;
  } 

  if(j >= 0){
 	if(j == 0){
		von = 1;	
	}
	else{	
		strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (j - 1)));
		von = atoi( (UNSIGNED char *) stripped(s) );
	}

	strcpy(s, (UNSIGNED char *) strcopy(arg, (j+1), b));
	bis = atoi( (UNSIGNED char *) stripped(s) );
  }
  else{
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (b - 1)));
	von = atoi( (UNSIGNED char *) stripped(s) );

	bis = von;
  }
   
  if(von < 1) von = 1;
  if(bis < von){
	if(bis != 0){
		i = bis;
		bis = von;
		von = i;
	}
	else{
		bis = 99999;
	}
  } 

  if(b < 0) b = strlen(arg);
  strcpy(t, (UNSIGNED char *) stripped(strcopy(arg, (b-1), strlen(arg))));

  i = 0; a = -1; b = 0; j = 0;

  while(t[i] != '\0'){
	if(t[i] == '(') a = i + 1;
	if(t[i] == ')') b = i - 1;
	if(t[i] == '!') j = i;
	if(t[i] == '@') j = i;
  	i++; 
  }

  if((strlen(t) < 3) || (x != -1)){
	printf("\n");
	intuition( 340 );
	return;
  }

  if(b == 0) b = strlen(t);
  if(a > -1) article = 1;
  if(j != 0){
	if(USER.level < WRITE_EX_LEV){
		printf(" %s (%d)!!!\n", LOP30_MSG, USER.level); 
		return;
	}	
	strcpy(host, (UNSIGNED char *) strcopy( t, 0, (j - 1)));	
  }
  else local = 1;
  if(article == 0){
	email = 1;
	if(von != bis)
		sprintf(empf, "%s?", t);
	else
		sprintf(empf, "%s$", t);
  }
  else{
	strcpy(group, (UNSIGNED char *) strcopy(t, a, b));
  }  

  printf("\n\n[????]");

  for(i = von; i <= bis; i++){

	if(strcomp(BRETT, "PM") != 0){
		sprintf(s, "%s/%d", BRETT, i);
	}
	else{
		sprintf(s, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, i);
	}
	sprintf(tmp, "%s/frw.%d", TMP, getpid());

	fp = fopen(s, "r" );
	if(fp == NULL){
		continue;
	}

	ff = fopen(tmp, "w" );
	if(ff == NULL){
		fclose(fp); /* !!! */
		return;
	}

	time(&tdummy);

	if(article != 0){
		fprintf(ff, "Newsgroups: %s\n", group);
		fprintf(ff, "Message-ID: <%x.%d@%s>\n", tdummy, USER.id, UUCPID); 
	}

	header = 1;

	while(fgets(ex, LONGSTRING, fp) != 0){
		ok = 1;
		if(article != 0){
			if((strcomp("Newsgroups: ", ex) == 0) ||
		   	   (strcomp("Message-ID: ", ex) == 0)){
				ok = 0;
			}
		}
		if(strcomp("From:", ex) == 0){
			strcpy(oabs, (UNSIGNED char *) strcopy(ex, 6, strlen(ex)));
		}
		/*
		if(strcomp("From ", ex) == 0){
			strcpy(oabs, (UNSIGNED char *) strcopy(ex, 5, strlen(ex)));
		}
		*/
		if(strcomp("To:", ex) == 0){
			strcpy(oempf, (UNSIGNED char *) strcopy(ex, 4, strlen(ex)));
		}
		if(strcomp("Newsgroups:", ex) == 0){
			strcpy(oempf, (UNSIGNED char *) strcopy(ex, 12, strlen(ex)));
		}
		if(strcomp("Subject:", ex) == 0){
			strcpy(obetr, (UNSIGNED char *) strcopy(ex, 9, strlen(ex)));
		}
		if(strcomp("Date:", ex) == 0){
			strcpy(odate, (UNSIGNED char *) strcopy(ex, 6, strlen(ex)));
		}

		if(ex[0] < 32){
			if((header == 1) && (kopie == 1)){
				sprintf(s, "%s", USER.name);
				j = 0;
				while(s[j] != '\0'){
					if(s[j] == ' ') s[j] = '.';
					j++;
				}

				if(oempf[0] == '\0') sprintf(oempf, "%s\n", NG);

				fprintf(ff, "## weitergeleitet durch: %s@%s\n", s, UUCPID);
				fprintf(ff, "## Originalempfaenger: %s", oempf);
				fprintf(ff, "## Originalabsender: %s", oabs);
				fprintf(ff, "## Originalbetreff: %s", obetr);
				fprintf(ff, "## Originaldatum/-uhrzeit: %s", odate);
				fprintf(ff, "\n");
			}
			header = 0;	
		}

		if((article == 0) && (header == 1) && (kopie == 0)) fprintf(ff, "> ");

		if((header == 1) && (kopie != 0)) ok = 0;
	
		if(ok == 1) fprintf(ff, "%s", ex);
	}					

	fclose(fp);
	fclose(ff);


	if(email != 0){
		strcpy(s, (UNSIGNED char *) empf);
		s[strlen(s)-1] = '\0';
		printf("%c[%d] -> %s", CR, i, s );

		if(strcomp(BRETT, "PM") != 0){
			sprintf(s, "cp %s %s/usr/%c/%d/.lastletter", tmp, HOME, USER.name[0], USER.id);
		}
		else{
			sprintf(s, "cp %s %s/usr/%c/%d/.lastletter", tmp, HOME, USER.name[0], USER.id);
		}
		system(s);
		sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
		fp = fopen( s, "w" );
		if(fp == NULL){
			nerror("weiterl.c", 76, "weiterleiten", "Can't write to", s);
		}
		fprintf(fp, "%d <%s>", i, NG);
		fclose(fp);

		strcpy(s, (UNSIGNED char *) empf);	
		brief( s );
	}


	if(article != 0){
		a = 0;
		while(group[a] != '\0'){
			t[a] = group[a];
			if(t[a] == '.') t[a] = '/';
			a++;
		}
		t[a] = '\0';

		if(local == 0){
			if(USER.level < WRITE_INTERNAT){
				printf(" %s (%d)!!!\n", LOP30_MSG, USER.level); 
				return;
			}
			time(&tdummy); sprintf(v, "%s/tmp/host.%d.%X", HOME, run, tdummy);
			run++;
			sprintf(s, "cp %s %s", tmp, v);
			system( s );

			strcpy(s, (UNSIGNED char *) NEWS);
			a = 0; b = 0;
			while(s[a] != '\0'){
				if(s[a] == '/') b++;	
				a++;
			}
			strcpy(s, "../../../../../../../../../../..");
			b = (b * 2) + (b - 1);
			s[b] = '\0';
			sprintf(s, "%s%s", s, v);
			sprintf(t, "echo %s >> /usr/spool/news/out.going/%s/togo", s, host);
			system( t );
			printf("%c[%d] -> %s @ %s", CR, i, group, host);

			strcpy(frwd_host, (UNSIGNED char *) host);
		}
		else{
			printf("%c[%d] -> %s", CR, i, group);
			sprintf(t, "/bin/sh ./etc/inews.sh %s %s", group, tmp);
			system(t);
			unlink( tmp );
		}
	}
  }   

  if((article != 0) && (local != 0)){
	sprintf(s, "%s %s", MB_DAEMON, group);
	system( s );
  }
 
  printf("\n");
}





/* #CC - Send copies of mails to various users.

   [cc]   ->  name of users (shown in "Cc:" header line)
   [bcc]  ->  name of users (shown in "Bcc:" header line, not shown to
              users) */

void carboncopy( cc, bcc )
UNSIGNED char cc[], bcc[];
{
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char ef[LONGSTRING];
  UNSIGNED char s[STRING];

  int a = 0, i = 0;
  int ok = 0;

  printf("\n");

  strcpy(ex, (UNSIGNED char *) stripped(cc));
  if(bcc[0] != '\0'){
	strcat(ex, ","); strcat(ex, bcc);
  }

  if(ex[0] == '\0') return;

  while(ok == 0){
	while((ex[i] != ',') && (ex[i] != '\0')) i++;

	if(ex[i] == '\0') ok++;

	strcpy(ef, (UNSIGNED char *) bigcopy(ex, a, (i-1)));
	strcpy(s, (UNSIGNED char *) stripped(ef));

	if((strlen(s) > 1) && (s[0] != '(')){
		old_weiterl( s );
	}
	a = i + 1;
	i++;
  }
  
}




/* #BO - Handle stock exchange database.

   This needs informations from newsgroup "de.etc.finanz".

   NOTE: This stuff is still under construction!  */

#define MAX_BOERSE	40
#define MAX_KURSE	40

void boerse( arg )
UNSIGNED char arg[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  UNSIGNED char d[MAX_BOERSE][STRING];
  UNSIGNED char l[MAX_KURSE][STRING];
  int dptr;

  FILE *fp;

  int c, i, j, a, b;

  long t1, t2;
  long o1, o2;
  long p1;
  long x1, x2;
  long q;

  DIR *dp;
  struct dirent *actdir;



  if(USER.terminal == 4){
	printf(" <- %s\n", BAU04_MSG );
	return;
  }


  sprintf(s, " Stock Exchange                      [Support: %s] ", STOCK_AUTOR);
  headline( s );

  fp = fopen( STOCK_INDEX, "r" );
  if(fp != NULL){

	ansi2( "cm", 56, 3 );
	printf("DAX ........");
	ansi2( "cm", 56, 4 );
	printf("FTSE .......");
	ansi2( "cm", 56, 5 );
	printf("DOW JONES ..");
	ansi2( "cm", 56, 6 );
	printf("CAC ........");
	ansi2( "cm", 56, 7 );
	printf("MIBTEL .....");
	ansi2( "cm", 56, 8 );
	printf("IBEX .......");

	while(fgets(s, STRING, fp) != 0){
		if(strlen(s) > 10) strcpy(t, (UNSIGNED char *) s);
	}

	fclose(fp);

	ansi2( "md", 0, 0 );

	j = 12;

	for(i = 3; i < 9; i++){
		ansi2( "cm", 69, i );
		printf("%s", (UNSIGNED char *) strcopy(t, j, (j + 8)));
		j += 11;
 	}  	

	ansi2( "cm", 56, 10 );
	ansi2( "mr", 0, 0 );
	printf("      %s      ", (UNSIGNED char *) strcopy(t, 0, 9) );
  }

  ansi2( "cm", 1, 2 );
  ansi2( "me", 0, 0 ); 

  printf("\n  1 - DAX Aktien Kurse\n");
  printf("\n  2 - Dow Jones Aktien Kurse\n");
  ansi2( "us", 0, 0 );
  printf("\n  3 - Diagramm\n\n\n");
  ansi2( "me", 0, 0 );  

  ansi2( "md", 0, 0 );
  printf("[Kurse] Welche? > ");

  c = getint();

  ansi2( "me", 0, 0 );

  if((c < '1') || (c > '3')){
	printf("\n");
	return;
  }

  if(c != '3'){

	sprintf(s, " Stock Exchange                      [Support: %s] ", STOCK_AUTOR);
	headline( s );

	dptr = 1;

	dp = opendir( STOCK_PATH );
	if(dp == NULL){
		nerror("weiterl.c", 216, "boerse", "Directory not found", STOCK_PATH);
	}
  
	while(((actdir = readdir(dp)) != NULL) && (dptr < MAX_BOERSE)){
		strcpy(s, (UNSIGNED char *) actdir->d_name);
		i = strlen(s);
		if(i > 3){
			while(i > -1){
				if(s[i] == '.'){
					a = i + 1;
					i = -1;
				}
				i--;
			}
			strcpy(t, (UNSIGNED char *) strcopy(s, a, strlen(s)));
	
			if(c == '1'){
				if(strcomp("dax", t) == 0){
					strcpy(d[dptr], actdir->d_name);
					dptr++;
				}
			}
			if(c == '2'){
				if(strcomp("dj", t) == 0){
					strcpy(d[dptr], actdir->d_name);
					dptr++;
				}	
			}
		}
	}
	closedir(dp);

  
	for(i = 1; i < dptr; i++){
		for(j = 1; j < dptr; j++){
			t1 = dateconv( d[i] );
			t2 = dateconv( d[j] );
			if(t1 > t2){
				strcpy(s, (UNSIGNED char *) d[i]);
				strcpy(d[i], (UNSIGNED char *) d[j]);
				strcpy(d[j], (UNSIGNED char *) s);
			}
		}
	}
	
	
	j = 0; strcpy(l[0], "                               "); 

	if(dptr > 5) dptr = 5;

	for(i = 1; i < dptr; i++){
	
		sprintf(s, "%s/%s", STOCK_PATH, d[i]);

		b = 1;
	
		fp = fopen( s, "r" );
		if(fp == NULL){
			nerror("weiterl.c", 274, "boerse", "Can't read", s);
		}
	
		strcat(l[0], "    ");
		strcat(l[0], (UNSIGNED char *) strcopy(d[i], 0, 7));
	
		while(fgets(s, STRING, fp) != 0){
			if(j == 0){
				strcpy(l[b], stripped( (UNSIGNED char *) strcopy(s, 7, 80)));
				while(strlen(l[b]) < 31) strcat(l[b], " ");	
				l[b][31] = '\0';
			}
			fgets(t, STRING, fp);
			if(s[0] == t[0]){
				sprintf(s, "   %9.9s", stripped( (UNSIGNED char *) strcopy(t, 7, 80)));
			}
			else{
				sprintf(s, "   %9.9s", "WPKN?");
			}
			strcat(l[b], s);
			if(b < MAX_KURSE) b++;
	   	}
		fclose(fp);
	
		j++;
	}  

	sprintf(t, "%s/city.%d", STOCK_PATH, getpid());

	fp = fopen( t, "w" );
	if(fp == NULL){
		nerror("weiterl.c", 303, "boerse", "Can't write to", t);
	}

	fputs("Content-Type: text/richtext\n", fp);

	a = 0;

	for(i = 1; i < b; i++){
		if(l[i][0] >= 'A'){
			if(a == 0){
				fprintf(fp, "%s\n", l[i]);
				a++;
			}
			else{
				fprintf(fp, "<Underline>%s</Underline>\n", l[i]);
				a = 0;
			}
		}
	}
	fclose(fp);

	sprintf(s, " Stock Exchange                      [Support: %s] ", STOCK_AUTOR);
	headblock( s, l[0] );
	show( t, 9999, USER.more + 100 );

	unlink( t );

  }	
  else{ /* Grafik */

	sprintf(s, " Stock Exchange                      [Support: %s] ", STOCK_AUTOR);
	headline( s );

	dptr = 1;

	dp = opendir( STOCK_PATH );
	if(dp == NULL){
		nerror("weiterl.c", 341, "boerse", "Directory not found", STOCK_PATH);
	}
  
	while((actdir = readdir(dp)) != NULL){
		if(dptr >= MAX_BOERSE){
			for(i = 1; i <= dptr; i++)
				strcpy(d[i], (UNSIGNED char *) d[i+1]);
			dptr--;
		}
		strcpy(s, (UNSIGNED char *) actdir->d_name);
		i = strlen(s);
		if(i > 3){
			while(i > -1){
				if(s[i] == '.'){
					a = i + 1;
					i = -1;
				}
				i--;
			}
			strcpy(t, (UNSIGNED char *) strcopy(s, a, strlen(s)));
	
			if((strcomp("wpkn", t) != 0) && (strcomp("index", s) != 0)){
				strcpy(d[dptr], actdir->d_name);
				dptr++;
			}
		}
	}
	closedir(dp);

  
	for(i = 1; i < dptr; i++){
		for(j = 1; j < dptr; j++){
			t1 = dateconv( d[i] );
			t2 = dateconv( d[j] );
			if(t1 < t2){
				strcpy(s, (UNSIGNED char *) d[i]);
				strcpy(d[i], (UNSIGNED char *) d[j]);
				strcpy(d[j], (UNSIGNED char *) s);
			}
		}
	}

	b = 1; t1 = 9999L; t2 = 0L; o1 = 9999L; o2 = 0L;
	
	for(i = 1; i < dptr; i++){				/* Pass 1 */
		sprintf(s, "%s/%s", STOCK_PATH, d[i]);
	
		fp = fopen( s, "r" );
		if(fp == NULL){
			nerror("weiterl.c", 385, "boerse", "Can't read", s);			
		}
	
		fgets(t, STRING, fp); 
		fgets(s, STRING, fp); 

		if(atol(t) != atol(s)){	/* WPKN ??? */
			fclose(fp);
			continue;
		}

		strcpy(l[b], (UNSIGNED char *) strcopy(s, 7, 80));

		q = atol(l[b]);
	
		if(d[i][strlen(d[i]) -1] == 'x'){
			if(q < t1) t1 = q;
			if(q > t2) t2 = q;
		}
		else{
			if(q < o1) o1 = q;
			if(q > o2) o2 = q;
		}

		if(b < MAX_KURSE) b++;
		fclose(fp);
	}

	t1 = (t1 + t2) / 2;
	o1 = (o1 + o2) / 2;	

	x1 = (t2 - t1) / 10 + 1;
	x2 = (o2 - o1) / 10 + 1;

	a = 15;

	for( i = 3; i < (42 - USER.tlines); i++){
		ansi2( "cm", 14, i );
		printf("------------------------------------------------------------------");
	}


	ansi2( "md", 0, 0 );
	ansi2( "cm", 14, 12 );
	printf("------------------------------------------------------------------");
	ansi2( "cm", 14, (42 - USER.tlines) );
	printf("------------------------------------------------------------------");

	ansi2( "me", 0, 0 );

	for( i = 4; i < 7; i++){
		ansi2( "cm", 68, i );
		printf("             ");
	}

	ansi2( "cm", 69, 4 );
	ansi2( "mr", 0, 0 );
	printf("=");
	ansi2( "me", 0, 0 );
	ansi2( "md", 0, 0 );
	printf(" DAX");
	ansi2( "me", 0, 0 );

 	ansi2( "cm", 69, 6 );
	ansi2( "mr", 0, 0 );
	printf("+");
	ansi2( "me", 0, 0 );
	printf(" Dow Jones");

	ansi2( "cm", 58, (41 - USER.tlines) );
	ansi2( "us", 0, 0 );
	strcpy(t, (UNSIGNED char *) strcopy(d[(dptr - 1)], 0, 7));
  	printf(" %s bis %s", (UNSIGNED char *) strcopy(d[1], 0, 7), t); 
	ansi2( "me", 0, 0 );

	j = 1;
	/*
        if(dptr > 22) j = dptr - 22;
	*/
 	if(dptr > 27) j = dptr - 27;

	for(i = j; i < dptr; i++){				/* Pass 2 */
		sprintf(s, "%s/%s", STOCK_PATH, d[i]);
	
		fp = fopen( s, "r" );
		if(fp == NULL){
			nerror("weiterl.c", 476, "boerse", "Can't read", s);
		}
	
		fgets(t, STRING, fp); 
		fgets(s, STRING, fp); 

		if(atol(t) != atol(s)){	/* WPKN ??? */
			fclose(fp);
			continue;
		}

		strcpy(t, (UNSIGNED char *) strcopy(s, 7, 80));
			
		q = atol(t);

		ansi2( "mr", 0, 0 );

		if(d[i][strlen(d[i]) -1] == 'x'){

			p1 = t1 - q;
			p1 /= x1;
			if(p1 == 0) p1 = 1;

			
			if(p1 > 0){
				for(j = 0; j < p1; j++){
					b = 12 + j;
					ansi2( "cm", a, b);
					printf("=");
				}
			}
			else{
				p1 *= -1;

				for(j = 0; j < p1; j++){
					b = 12 - j;
					ansi2( "cm", a, b);
					printf("=");
				}

			}
			
			ansi2( "cm", 1, b);
			ansi2( "me", 0, 0 );
			ansi2( "md", 0, 0 );
			printf("%s", t);
		}
		else{
			p1 = o1 - q;
			p1 /= x2;
			if(p1 == 0) p1 = 1;


			if(p1 > 0){
				for(j = 0; j < p1; j++){
					b = 12 + j;
					ansi2( "cm", a, b);
					printf("+");
				}
			}
			else{
				p1 *= -1;

				for(j = 0; j < p1; j++){
					b = 12 - j;
					ansi2( "cm", a, b);
					printf("+");
				}

			}
			ansi2( "cm", 1, b);
			ansi2( "me", 0, 0 );
			printf("%s", t);
		}

		for(j = 0; j < 2; j++){
			ansi2( "cm", a, (43 - USER.tlines) + j );
			printf("%c", d[i][j]);
		}

		ansi2( "me", 0, 0 );

		a += 2;

		fclose(fp);
	}	
	ansi2( "cm", 1, (USER.tlines + 1) );
  }
}


/* #OW - Forward mails - the old-fashioned way ...

   [arg]    ->  ''             = show which mail may be forwarded
            ->  'user'         = forward the last mail to 'user'
            ->  'article user' = forward 'article' to 'user' */

void old_weiterl( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char subject[STRING];
  int i, a, num;
  UNSIGNED char empf[STRING];

  subject[0] = '\0';

  sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
  fp = fopen( s, "r" );
  if(fp != NULL){
	fgets(subject, STRING, fp);
	fclose(fp);
  }

  if((subject[0] == '\0') && ((arg[0] > 64) || (arg[0] == '?'))){
	ansi2("md", 0, 0);
	printf(" %s\n", WEI01_MSG);
	ansi2("me", 0, 0);
	return;
  }

  if(arg[0] == '\0'){
	printf("\n\n%s\n\n", WEI02_MSG);
	ansi2("md", 0, 0);
	printf("%s %s\n\n", WEI03_MSG, subject);
	ansi2("me", 0, 0);
	return;
  }

  num = 0;

  if(arg[0] < 65){
	i = 0;
	while((arg[i] > 32) && (arg[i] != '\0')) i++;
	strcpy(s, (UNSIGNED char *) strcopy(arg, 0, (i-1)));
	num = atoi(s);
	strcpy(empf, (UNSIGNED char *) strcopy(arg, (i+1), strlen(arg)));
	strcat(empf, "?");
  }
  else{
	sprintf(empf, "%s?", arg);
  }  

  if(num != 0){
	if(strcomp(BRETT, "PM") != 0){
		sprintf(t, "%s/%d", BRETT, num);
		sprintf(s, "cp %s/%d %s/usr/%c/%d/.lastletter", BRETT, num, HOME, USER.name[0], USER.id);
	}
	else{
		sprintf(t, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, num);
		sprintf(s, "cp %s/usr/%c/%d/%d %s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id, num, HOME, USER.name[0], USER.id);
	}
	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi2("md", 0, 0);
		printf(" %s\n", WEI04_MSG);
		ansi2("me", 0, 0);
	return;
	}
	fclose(fp);
	system(s);
	sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);

	sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
	fp = fopen( s, "w" );
	if(fp == NULL){
		nerror("weiterl.c", 76, "weiterleiten", "Can't write to", s);
	}
	fprintf(fp, "%d <%s>", num, NG);
	fclose(fp);
  }
  brief(empf);
}
