/* ix/MBox (uptodate.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #UD uptodate()        call for an update at our ix/MBox headquarters ;-)
   #CG charge()          
   #ID indecent()

   Contact <volkers@unnet.wupper.de> for help! */









#include <stdio.h>

#include "mbox.h"

/*
	WARNING! This part of the ix/MBox automagically generates an
        update-request every month. This request is sent to "unnet!mbox"
        in Germany.

        If there are any bugfixes, infosheets etc., you'll get them
        via mailserver as an reply to the update-request.

        The update-request includes some informations about your BBS:
        name, uucp-address, sysops name, number of accounts&caller etc. ...

        Maybe this data will be used to build reference-lists or will
        be mentioned in infosheets.

 
        If you don't want|like that, please change the following
        defines!!! 
*/

#ifdef _UPDATERQ
#define NO_UPDATE	0	/* 1 means: absolutly no update-requests */
#define NO_DETAILS	0	/* 1 means: don't send any sensitive data */
#else
#define NO_UPDATE	1	/* 1 means: absolutly no update-requests */
#define NO_DETAILS	1	/* 1 means: don't send any sensitive data */
#endif


/* #UD - Call for updates. */

uptodate()
{

#if !NO_UPDATE

  FILE *fp;
  
  char s[STRING];
  char d[STRING];

  int accounts;
  int calls;
  int month;


  if(USER.level < WRITE_EX_LEV) return;
  if(strcomp("unnet", UUCPSITE) == 0) return;

  strcpy(d, (UNSIGNED char *) mydate( 1 ));
  month = atoi(strcopy(d, 3, 4));
  sprintf(s, "%s/etc/uptodate.%d", HOME, month);
  fp = fopen(s, "r");
  if(fp != NULL){
	fclose(fp);
	return;
  }
  fp = fopen(s, "w");
  if(fp == NULL){
	return;
  }
  fprintf(fp, "Update requested: %s at %s", mydate( 1 ), mytime( 0 )); 
  fclose(fp);

  if(month == 1) month = 13;
  month--;

  sprintf(s, "%s/etc/uptodate.%d", HOME, month);
  unlink( s );

  sprintf(s, "%s/etc/users.seq", HOME);
  fp = fopen(s, "r");
  if(fp == NULL){
	return;
  }
  fgets(s, STRING, fp);
  fclose(fp);
  accounts = atoi(s);

  sprintf(s, "%s/etc/mbox.seq", HOME);
  fp = fopen(s, "r");
  if(fp == NULL){
	return;
  }
  fgets(s, STRING, fp);
  fclose(fp);
  calls = atoi(s);

  sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w"); 
  if(fp == NULL){
	return;
  }
  fprintf(fp, "This is %s %s on <%s>!\n\n", VERSION, PATCHLEVEL, UUCPID1);

#if !NO_DETAILS
  fprintf(fp, "My sysop %s of %s\n", POSTMASTER, ORGANIZATION);
  fprintf(fp, "wants update patches, infosheets and so on ...\n\n");
  fprintf(fp, "Our systems' called \"%s\",\n", SYSTEM);
  fprintf(fp, "and we joggle around with %d users (%d calls) at this moment.\n\n", accounts, calls);
#endif /* NO_DETAILS */

  fprintf(fp, "If you can't reach us, call <%s> or <%s> ...\n\n", UUCPID2, SMARTHOST);
  fprintf(fp, "You also might give us a call on %s ...\n\n", PHONE);
  fclose(fp);

  sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  if(fp == NULL){
	return;
  }
  fprintf(fp, "UPDATE-RQ <%s>", UUCPID1);
  fclose(fp);

  brief( "mbox@unnet.wupper.DE?" );

#endif	/* NO_UPDATE */

}



void charge( uid, service, bytes )
int uid;
UNSIGNED char service[];
long bytes;
{
  UNSIGNED char s[STRING];
  FILE *fp;

#ifdef _UNNET
  fp = fopen( "./etc/log.charge", "a" );
  fprintf(fp, "%s %s  ", (UNSIGNED char *) mydate(1), (UNSIGNED char *) mytime(1));
  fprintf(fp, "%-5d ", uid );
  fprintf(fp, "%10ld  %s\n", bytes, service);
  fclose(fp);
#endif

}


#define MAX_INDECENT	100

/* 0 clean, >0 drity */

int indecent( path, words )
UNSIGNED char path[], words[];
{
  FILE *fp;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char a[30][MAX_INDECENT];
  
  int ap = 0, ok = 0, i, line = 0;

  fp = fopen( "./etc/dirty.dictionary", "r" );
  if(fp == NULL){
	return 0;
  }
  while(fgets(s, STRING, fp) != 0){
	if(s[0] >= 'A'){
		s[30] = '\0';
		strcpy(a[ap], (UNSIGNED char *) stripped( upcased(s) ));
		ap++;
	}
  }
  fclose(fp); 

  if(words[0] != '\0'){
	strcpy(s, (UNSIGNED char *) stripped( upcased(words) ));
	for(i = 0; i < ap; i++){
		if(sgrep(s, a[i]) != 0){
			printf("\n\n%s\n", UPD08_MSG);
			return 1;			
		}
	}
	return 0;
  }

  printf("\n\n%s", UPD01_MSG);

  fp = fopen( path, "r" );
  if(fp == NULL){
	printf("?? %s ??", path);
	return 0;
  }
  while(fgets(s, STRING, fp) != 0){
	line++;
	for(i = 0; i < ap; i++){
		strcpy(s, (UNSIGNED char *) stripped( upcased(s) ));
		if(sgrep(s, a[i]) != 0){
			ok++;
			if(ok == 1){
				printf("\n\n%s\n%s\n%s\n\n%s\n%s\n\n", UPD02_MSG, UPD03_MSG, UPD04_MSG,
					UPD05_MSG, UPD06_MSG);
					
			}
			printf("%s %03d \"%s\"\n", UPD07_MSG, line, a[i]);
		}
	}
  }
  fclose(fp);
 
  return ok; 
}
