/* ix/MBox (suchen.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #SU suchen()           search & find patterns in newsgroups
   #ED edit()             edit articles
   #KB kombinieren()      combine a couple of mails
   #SE security_ed()      close a serious security gap with external editors
   #FI finder()		  scanning CDROM index files
   #OP opinion_poll()	  do an opinion poll    
   #CB check_binfile()    another HOLE in security gets closed     
   #HT http()             get into the WorldWideWeb
   #TT talk_talk()        prepare a TALK conversation
  
   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "mbox.h"





/* #SU - Find the pattern [muster] in the current newsgroup. */

void suchen( muster )
UNSIGNED char muster[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char hl[STRING];
  UNSIGNED char ex[LONGSTRING];
  UNSIGNED char fx[LONGSTRING];

  int fpid;
  int found = 0;
  int ok = 0;
  int i, j;
  

  if(muster[0] == '\0'){
	ansi2( "md", 0, 0 );
	printf("\n\n%s ", SUC01_MSG);
	ansi2( "me", 0, 0 );
	strcpy(muster, (UNSIGNED char *) getline(60, 1, 32, ""));
	if(muster[0] == '\0'){
		printf(" <- %s\n", SUC02_MSG);
		return;
	}
  }

  i = 0;
  while(muster[i] != '\0'){
	if(muster[i] == '"') muster[i] = ' ';
	i++;
  }

  sprintf(hl, " %s \"%s\" %s [%s] ", SUC03_MSG, (UNSIGNED char *) stripped(muster), SUC04_MSG, NG);
  headline( hl );

  printf("%s .", SUC05_MSG);

  sprintf(tmp, "%s/such.%d", GLOBAL_TMP, getpid());

  if(strcomp("PM", BRETT) == 0){
	sprintf(t, "%s/usr/%c/%d", HOME, USER.name[0], USER.id);
	chdir( t );
  }
  else{
	chdir( BRETT );
  }

  switch( (fpid = fork()) ){
		case -1 :
				break;
		case  0 :	while(1){
					printf(".");
					sleep(3);
				}	
				break;
  }

  sprintf(s, "%s \"%s\" * > %s 2> %s", GREP, (UNSIGNED char *) stripped(muster), tmp, CPRN);
  system( s );

  kill( fpid, SIGKILL );
  (void) wait( &fpid );

  printf("%c", CR);

  sprintf(t, "%s/sres.%d", GLOBAL_TMP, getpid());  
 
  ff = fopen( t, "w" );
  if(ff == NULL){
  }

  fp = fopen( tmp, "r" );
  if(fp == NULL){
	
  }
  while((fgets(ex, LONGSTRING, fp) != NULL) && (ok == 0)){
	if(atoi(ex) != 0){	
		i = 0;			
		while((ex[i] != '\0') && (ex[i] != ':')) i++;
		j = i + 1;
		strcpy(fx, (UNSIGNED char *) bigcopy(ex, 0, (i - 1)));
		fprintf(ff, "%-8s", fx);
		i++;
		
		while((ex[i] != '\0') && (ex[i] != ':')) i++;
		strcpy(fx, (UNSIGNED char *) bigcopy(ex, j, (i - 1)));
		fprintf(ff, "%6s    ", fx);		
		j = i + 1;

		strcpy(fx, (UNSIGNED char *) bigcopy(ex, j, (strlen(ex))));
	
		fx[61] = '\0';
	
		fprintf(ff, "%s\n", stripped(fx));

		found++;
	}
  }
  fclose(fp);
  fclose(ff);

  chdir( HOME );

  if(found == 0){
	printf("%s \"%s\" %s\n", SUC06_MSG, (UNSIGNED char *) stripped(muster), SUC07_MSG);
  }
  else{
	headblock( hl, SUC06aMSG );
	show(t, 9999, USER.more + 100);
  }

  unlink( tmp );
  unlink( t );
}


/* #ED - Reedit a file [arg] (number, not path!). */

void edit( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char d[STRING];
  UNSIGNED char p1[STRING];
  UNSIGNED char p2[STRING];

  int ok = 0;
  int yet = 0;

  if (arg[0] == '\0') {
	ansi2( "md", 0, 0 );
	printf(" <- %s\n", SUC07aMSG);
	ansi2( "me", 0, 0 ); 
	intuition( 480 );
	return;
  }

  if (strcomp(BRETT, "PM") != 0) {
        sprintf(t, "%s/%s", BRETT, arg); 
  }
  else {
	sprintf(t, "%s/usr/%c/%d/%s", HOME, USER.name[0], USER.id, arg);
  }
  
  if((USER.level < ADMIN_LEV) && (USER.level >= EXE_LEV)){
 	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi2( "md", 0, 0 );
		printf(" <- %s\n", SUC10_MSG);
		ansi2( "me", 0, 0 ); 
		return;
	}
	while((fgets(s, STRING, fp) != 0) && (ok == 0)){
		if(strcomp("From: ", s) == 0){
			strcpy(d, (UNSIGNED char *) strcopy(s, 6, STRING));
			if(strcomp(USER.name, d) == 0) ok++;
		}
	}
	fclose(fp);
	if(ok == 0){
		ansi2( "md", 0, 0 );
		printf(" <- %s\n", SUC09_MSG);
		ansi2( "me", 0, 0 ); 
		return;
	}
  }

  if(USER.level >= EXE_LEV){

	noctrlx();
	security_ed( t );
	ctrlx();
  }
  else{
	sprintf(p1, "%s/%dED1", TMP, getpid());
	sprintf(p2, "%s/%dED2", TMP, getpid());

	fp = fopen( t, "r" );
	if(fp == NULL){
		ansi2( "md", 0, 0 );
		printf(" <- %s\n", SUC08_MSG);
		ansi2( "me", 0, 0 ); 
		return;
	}
 	ff = fopen( p1, "w" );
	while(fgets(s, STRING, fp) != NULL){
		fputs(s, ff);
		if(strcomp("From: ", s) == 0){
			strcpy(d, (UNSIGNED char *) strcopy(s, 6, STRING));
			if(strcomp(USER.name, d) == 0) ok++;
		}
		if((strlen(s) < 3) && (yet == 0)){
			fclose(ff);
			ff = fopen( p2, "w" );
			yet++;
		}
	}
	fclose(fp);
	fclose(ff);

	if(ok == 0){
		ansi2( "md", 0, 0 );
		printf(" <- %s\n", SUC09_MSG);
		ansi2( "me", 0, 0 ); 
		unlink( p1 );
		unlink( p2 );
		return;
	}

	noctrlx();
	security_ed( p2 );
	ctrlx();

	sprintf(s, "cat %s > %s", p1, t);
	system( s );
	sprintf(s, "cat %s >> %s", p2, t);
	system( s );

	unlink( p1 );
	unlink( p2 );
  }
}





/* #KB - Combine a couple of mails [arg]. */

void kombinieren( arg )
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  int i = 0, a = 0;
  int runde = 0;

  if(arg[0] == '\0'){
	intuition( 580 );
	return;
  }

  strcat(arg, " ");

  while(arg[i] != '\0'){
	if(arg[i] == ' '){
		runde++;
		strcpy(t, (UNSIGNED char *) strcopy(arg, a, (i-1)));
		a = i + 1;
		if(atoi(t) != 0){
			if(runde == 1){
				sprintf(s, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, atoi(t));
				fp = fopen( s, "r" );
				if(fp == NULL){
					printf(" <- %s\n", SUC11_MSG);
					return;
				}
				fclose(fp);
				fp = fopen( s, "a" );
			}
			else{
				fprintf(fp, "\n+ + +  S T O P  + + +\n");
			
				sprintf(s, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, atoi(t));
				ff = fopen( s, "r" );
				if(ff != NULL){
					while(fgets(s, STRING, ff) != NULL){
						fputs(s, fp);		
					}
					fclose(ff);

					loeschen( t );
				}
			}
		}
	}
	i++;
  }
  fclose(fp);
}



/* #SE - Edit the file [path] with any editor */

security_ed( path )
UNSIGNED char path[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  UNSIGNED char *home;

  struct stat fst;
 
  mode_t mode;
  uid_t uid;
  short int gid;

  int is_new = 0;

  stat(path, &fst);
  mode = fst.st_mode;
  uid  = fst.st_uid;
  gid  = fst.st_gid;

  strcpy(s, (UNSIGNED char *) ttyname(0));
  if(strlen(PMS_TTY) > 3){
	if((OLDUID == ROOT_UID) && (OLDGID == ROOT_GID) && (strcomp(s, PMS_TTY) != 0)){
		nerror( "suchen.c", 366, "security_ed", "Security gap!", "No permission to proceed!" );
	}
  }
  else{
	if((OLDUID == ROOT_UID) && (OLDGID == ROOT_GID)){
		nerror( "suchen.c", 366, "security_ed", "Security gap!", "No permission to proceed!" );
	}
  }	

  sprintf(t, "%s/%d.ED", GLOBAL_TMP, getpid());
  if(mbrename( path, t ) != 0){

	/*	
	printf("\nCan't rename %s -> %s\n", path, t);
	It might be a NEW file, so it doesn't matter!
	*/	

	is_new ++;
  }
 
  chmod( t, 0777 );

  home = (UNSIGNED char *) getenv( "HOME" );

  chdir( home );

  noctrlx();
  sprintf(s, "%s/%s %s %s %d %d", HOME, RSH, EDDY, t, OLDUID, OLDGID);
  system(s);
  ctrlx();

  chdir( HOME );

  if(mbrename( t, path ) != 0){
	printf("\nCan't rename %s -> %s\n", t, path);
  }

  if(is_new) return;

  chmod( path, mode );

#ifdef _SYS7  
  chown( path, uid, gid );
#else
  chown( path, uid, gid );

  /* SVR3, SVR4 maybe this way ???

  chown( path, uid );
  chgrp( path, gid );

  */
#endif
}



/* #FI - scanning CDROM index files (w/o accessing the device!) */

void finder( muster )
UNSIGNED char muster[];
{
  FILE *fp;
  FILE *ff;

  UNSIGNED char z[LONGSTRING];
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char tmp[STRING];

  int i, j;
  int fpid;
 

  if(muster[0] == '\0'){
	ansi2( "md", 0, 0 );
	printf("\n\n%s ", SUC01_MSG);
	ansi2( "me", 0, 0 );
	strcpy(muster, (UNSIGNED char *) getline(60, 1, 32, ""));
	if(muster[0] == '\0'){
		printf(" <- %s\n", SUC02_MSG);
		return;
	}
  }

  headline( " Finder (CDROM Shareware Archive) " );

  printf("%s .", SUC05_MSG);

  switch( (fpid = fork()) ){
		case -1 :
				break;
		case  0 :	while(1){
					printf(".");
					sleep(1);
				}	
				break;
  }

  sprintf(tmp, "%s/fin.%d", TMP, getpid());
  sprintf(t,   "%s/fis.%d", TMP, getpid());

  sprintf(s, "fgrep \"%s\" %s/cdrom/index/* > %s", muster, HOME, tmp);
  system(s);

  fp = fopen( tmp, "r" );
  ff = fopen( t,   "w" );

  fputs("\n", ff);

  while(fgets(z, LONGSTRING, fp)!= 0){
	i = strlen( "/local/mbox/cdrom/index/" );
	j = 0;

	if((strlen(z) - i) < 30) continue;

	while(z[i] != '\0'){
		fputc(z[i], ff);
		if((z[i] == ':') && (j == 0)){
			fputs("\n- ", ff);
			strcpy(s, (UNSIGNED char *) termansi( "md" ));
			fputs(s, ff);
			j = 1;
		}
		if((z[i] == ' ') && (j == 1)){
			strcpy(s, (UNSIGNED char *) termansi( "me" ));
			fputs(s, ff);
			j = 2;	
		}
		i++;
	}

	strcpy(s, (UNSIGNED char *) termansi( "me" ));
	fputs(s, ff);	
	fputs("\n", ff);
  }

  fclose( ff );
  fclose( fp );  

  kill( fpid, SIGKILL );
  (void) wait( &fpid );

  headline( " Finder (CDROM Shareware Archive) " );
  show(t, 9999, USER.more + 100);

  unlink(t);
  unlink(tmp);
}



#define MAX_OP_ANSWERS	20



/* #OP - do opinion polls */

opinion_poll()
{
  FILE *fp;
  FILE *ff;

  int answers[100][MAX_OP_ANSWERS];
  int i, a = 0;
  int c;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];


  sprintf(s, "%s/op/.ask", HOME);
  fp = fopen( s, "r" );
  if(fp == NULL){
	return;  
  }
  fclose(fp);

  printf("\n\n");

  more();
  headline( " Umfrage / Auswertung ");
  printf("\n");

  sprintf(s, "%s/op/intro", HOME);
  ansi2( "us", 0, 0 );
  show_raw( s, 0 );
  ansi2( "me", 0, 0 );

  ansi2( "mr", 0, 0 );
  printf("\nTeilnehmen an der Umfrage? (j/n), Auswertung sehen! (a) ");
  ansi2( "me", 0, 0 );

  do{
	c = getch();
	if(c > 96) c -= 32;
  }while((c != GBL06_MSG) && (c != GBL07_MSG) && (c != 'A'));

  printf("%c\n\n");

  sprintf(s, "%s/op/results", HOME);

  fp = fopen( s, "r" );
  if(fp == NULL){
	for(i = 0; i < 100; i++){
		answers[i][0] = 0;
		answers[i][1] = 0;
		answers[i][2] = 0;
		answers[i][3] = 0;
		answers[i][4] = 0;
	} 	
  }
  else{
	i = 0;
	while(fgets(s, STRING, fp) != 0){
		answers[i][0] = atoi(s);
		fgets(s, STRING, fp);		 
		answers[i][1] = atoi(s);
		fgets(s, STRING, fp);		 
		answers[i][2] = atoi(s);
		fgets(s, STRING, fp);		 
		answers[i][3] = atoi(s);
		fgets(s, STRING, fp);		 
		answers[i][4] = atoi(s);
		i++;
	}
	fclose(fp);	
  } 


 
  if(c == GBL07_MSG) return;
  if(c == 'A') goto AUSWERTUNG;


  i = 0; 

  sprintf(s, "%s/op/quests", HOME);
  fp = fopen( s, "r" );

  while(fgets(s, STRING, fp) != 0){
 	a = 1;
  	ansi2( "us", 0, 0 );
  	printf("\n\n\n(%d)  ", a);
  	ansi2( "me", 0, 0 );
	printf("%s\n", s);
	
	while((fgets(s, STRING, fp) != 0) && (strlen(s) > 3)){
		a++;
		if(a > MAX_OP_ANSWERS){
			nerror( "suchen.c", 585, "opinion_poll", "Dimensioniering problem!", "" );
		}
		ansi2( "us", 0, 0 );
		printf("(%d)  ", a);
		ansi2( "me", 0, 0 );
		printf("%s\n", s);
  	}
	ansi2( "us", 0, 0 );
	printf("Nun? (1-%d) ", a);
	ansi2( "me", 0, 0 );

	do{
		c = getch();
		c -= '0';
	}while((c < 1) || (c > a));

	printf("%d", c);
	answers[i][(c - 1)]++;
	
	i++;
  }
  fclose(fp);
  
  sprintf(s, "%s/op/results", HOME);

  fp = fopen( s, "w" );
  for(i = 0; i < 100; i++){
	fprintf(fp, "%d\n%d\n%d\n%d\n%d\n", answers[i][0], answers[i][1],
		answers[i][2], answers[i][3], answers[i][4]);
  }
  fclose(fp);	

  printf("\n\n");


  sprintf(s, "%s/op/users", HOME);
  fp = fopen( s, "a" );
  fprintf(fp, "%d\n", USER.id);
  fclose(fp);


  AUSWERTUNG:

  headblock( " Umfrage / Auswertung ", "Zu jedem Statement wird die Anzahl der User ausgegen, die es bestaetigt haben! " );

  sprintf(t, "%s/op.%d", TMP, getpid());
  ff = fopen( t, "w" );
  
  i = 0; a = 0;

  sprintf(s, "%s/op/quests", HOME);
  fp = fopen( s, "r" );

  while(fgets(s, STRING, fp) != 0){
	a = 0;
	strcpy(s, (UNSIGNED char *) stripped(s));
	s[75] = '\0';
	while(strlen(s) < 75) strcat(s, ".");

	fprintf(ff, "%s%4d\n", s, answers[i][a]);
	
	while((fgets(s, STRING, fp) != 0) && (strlen(s) > 3)){
		a++;
		strcpy(s, (UNSIGNED char *) stripped(s));
		s[75] = '\0';
		while(strlen(s) < 75) strcat(s, ".");
		fprintf(ff, "%s%4d\n", s, answers[i][a]);
  	}
	i++;
	fprintf(ff, "\n");
  }
  fclose(fp);

  i = 0;
  sprintf(s, "%s/op/users", HOME);
  fp = fopen( s, "r" );
  while(fgets(s, STRING, fp) != 0) i++;
  fclose(fp);

  strcpy(s, (UNSIGNED char *) termansi( "us" ));
  fprintf(ff, "%sAn der Umfrage haben bisher erst %d User teilgenommen.", s, i);
  strcpy(s, (UNSIGNED char *) termansi( "me" ));
  fprintf(ff, "%s", s);
  fclose(ff);

  sprintf(t, "%s/op.%d", TMP, getpid());
  show(t, 9999, USER.more + 100 ); 
  unlink( t );
}


/* #CB - check whether a file which should be transfered is located on
         a "forbidden" path. */

int check_binfile( cd )
UNSIGNED char cd[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];

 
  int i = 1;

  sprintf(s, "%s/%s", HOME, MOSTLY_HARMFUL);

  fp = fopen( s, "r" );
  if(fp == NULL){
	nerror( "suchen.c", 696, "check_binfile", "Can't read", s );
  }  
  while((fgets(s, STRING, fp) != 0) && (s[0] == '#'));
  while(fgets(s, STRING, fp) != 0){
	strcpy(t, (UNSIGNED char *) stripped(s));
	if(strlen(t) > 1){
		if(sgrep( cd, t ) != 0) i = 0;
	}
  } 

  fclose(fp);
  
  if(i != 0){
	printf("\n%s\n", SUC12_MSG);
	printf("\n%s [%s]\n", SUC12aMSG, cd);
	sprintf(ex, "%s\n%s [%s]", SUC12_MSG, SUC12aMSG, cd);
	control(ex, 99);
	chdir( HOME );
  }
  else{
  	sprintf(s, "%s/etc/list.newpd", HOME);
	fp = fopen(s, "r");
	if(fp != NULL){
		while(fgets(s, STRING, fp) != 0){
			strcpy(t, (UNSIGNED char *) stripped(s));
			if(strlen(t) > 1){
				if(strcomp(cd, t ) == 0) i = 1;
			}
		}
	}
	if(i == 1){
		printf("%s\n", SUC13_MSG);
		chdir( HOME );
	}
  }
 
  return i;  
}



void http( http_line )
UNSIGNED char http_line[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  if(http_line[0] == '\0'){
	printf("\n\nWorldWideWeb -> ");
	strcpy(t, (UNSIGNED char *) "http://localhost/home.html");
	strcpy(s, (UNSIGNED char *) getline( 80, 1001, ' ', t));
  }
  else strcpy(s, (UNSIGNED char *) http_line);

  sprintf(t, "%s %s", WWW, s);
  system( t );

  printf("\n\n");
}


void talk_talk()
{ 
  FILE *fp, *ff;

  UNSIGNED char ar[10][STRING];
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  int i, g, a, end = 0;

  sprintf(s, "%s/tt", TMP);
  sprintf(t, "who > %s", s);
  system( t );

  headblock( " Talkline ", " Der anschliessende CHAT wird mit CTRL-C beendet - BITTE MERKEN!!" );

  printf("\n");

  fp = fopen( s, "r" );
  i = 0;
  while(fgets(ar[i], STRING, fp) != 0){
	ar[i][15] = '\0';
	strcpy(t, "            ");
	if(ar[i][12] >= 'A') strcpy(t, "[erreichbar]");	
	printf("  %d - %s ", i, ar[i]);
	ansi2( "md", 0, 0 );
	printf("%s  ", t);
	ansi2( "me", 0, 0 );
	sprintf(s, "./etc/whatdoes.%s", stripped(strcopy(ar[i], 9, 20)));
	ff = fopen( s, "r" );	
	if(ff != NULL){
		fgets(s, STRING, ff);
		s[35] = '\0';
		printf("%s", stripped(s));
		fclose(ff);
	}
	printf("\n\n");
	i++;  
  }
  fclose(fp); 


  if(USER.terminal != ISO6429)
	ansi2("md", 0, 0);
  else
	ansi2("X9", 0, 0);
  printf("\n%s >", "Wen darf ich rufen?");
  ansi2("me", 0, 0);
  printf(" ");

  do{
	g = getint();
	g -= 48;
	if(g > -1) printf("%d", g);
	if((g > -1) && (g < i)){
		if(ar[g][12] >= 'A'){
			sprintf(s, "exec %s /usr/bin/talk %s %d %d", RSH, ar[g], OLDUID, OLDGID);
			system( s );
			sleep(1);
			end = 1;
		}
		else{
			printf(" <- NICHT ERREICHBAR!" );
			sleep(1);
			for(a = 0; a < 22; a++){
				printf("%c %c", BS, BS);
			}
		}
	}
	else end = 1;	
  }while(end == 0);

  printf("\n");
}
