/* ix/MBox (postfach.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #PF postfach()        create a new account for a BBS user
   #MV moving()          change users home directory

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <ctype.h>
#include <pwd.h>

#include "mbox.h"





/* #PF - Making up a new account.

   [arg]  ->   '*' = called by a user
               ''  = called by sysop
               '#' = BBS installation, data from "mbox.h" */

void postfach(arg)
UNSIGNED char arg[];
{
  int fd;
  FILE *fp;
  UNSIGNED char s[STRING*2];
  UNSIGNED char t[STRING*2];
  struct userdaten LOOSER, OLDIE;
  struct userdaten POSTER;
  int ok, i, j;
  long ll;
  struct passwd *pw_entry;


  OLDIE = USER;

  if (arg[0] == '*') {
	if ((strcomp(GUEST, USER.name) != 0) &&
	    (strcomp(POSTMASTER, USER.sh_name) != 0)) {
		ansi2("md", 0, 0);
		printf(" %s\n", POS01_MSG);
		ansi2("me", 0, 0);
		return;
	}
  }
  
  if (arg[0] == '#') {

	if (arg[1] == '1') { /* ADMINISTRATION */

		strcpy(USER.name, "Administration");
		strcpy(USER.sh_name, POSTMASTER);
		strcpy(USER.nick, "Sysop");

		USER.id = 1;
		USER.level = 9; 	/* needs 10 to be invisible ;-) */
		USER.terminal = 5;

		USER.schluessel[3] = 128;	
		USER.schluessel[4] = 1;
		printf("%s - %s (%s)\n", POS04_MSG, USER.name, USER.sh_name);

		fp = fopen(UDSEQ, "w");
		if (fp == NULL) {
			nerror("postfach.c", 63, "postfach", "Can't write to", UDSEQ);
		}
		fputs("1", fp);
		fclose(fp);
		
		fp = fopen(UDBASE, "w");
		fclose(fp);
	}	 
	if (arg[1] == '2') { /* GUEST */
	
		strcpy(USER.name, GUEST);
		strcpy(USER.sh_name, GBL10_MSG);
		strcpy(USER.nick, POS03_MSG);

		USER.id = 2;
		USER.level = 0;
		USER.terminal = 1;

		USER.schluessel[3] = 128;	
		USER.schluessel[4] = 1;
	
		printf("%s - %s (%s)\n", POS05_MSG, USER.name, USER.sh_name);
	}

	strcpy(USER.passwort, "*****");
	strcpy(USER.wohnort,  "???");
	strcpy(USER.strasse,  "???");
	strcpy(USER.telefon1, "???");
	strcpy(USER.telefon2, "???");
	strcpy(USER.geburtsdatum, "00.00.0000");
	strcpy(USER.account, "00.00.00000000000000000000000000000000000000000000000000000000000000000");

	goto INIT_UDBASE;
  }

  maybe_locked(UDBASE, "r"); 
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("postfach.c", 51, "postfach", "Can't read", UDBASE);
  }
  headline( POS06_MSG );
  ansi2("md", 0, 0);
  fp = fopen( "./etc/acctinf", "r" );
  if(fp != NULL){
 	fclose(fp);
	printf("\n");
	show_raw( "./etc/acctinf", 0 );
	printf("\n\n");
  }
  else{
	printf("\n%s\n%s\n%s\n\n", POS07_MSG, POS08_MSG, POS09_MSG);
  }
  ansi2("me", 0, 0);

  RETRY_1:

  printf("\n%s ", POS10_MSG);
  strcpy(s, POSTER.name);
  strcpy(POSTER.name, (UNSIGNED char *) getline(30, 15, '.', ""));
  if ((strcomp("<BREAK>", POSTER.name) == 0) || (POSTER.name[0] < 64) || (POSTER.name[1] < 64)) {
	strcpy(POSTER.name, s);
	printf("\n\n");
	ansi2("md", 0, 0);
	printf("%s", POS11_MSG);
	ansi2("me", 0, 0);
	printf("\n");

	USER = OLDIE;

	if(USER.level == 0){
		printf("\n");
		return;
	}else{
		return;
	}
  }
  ansi2("md", 0, 0);
  printf("\n%s", POS12_MSG);
  ok = 0;
  strcpy(POSTER.name, (UNSIGNED char *) stripped(POSTER.name));
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (ok == 0)) {
	if (strcomp(POSTER.name, LOOSER.name)    == 0) ok = 1;
	if (strcomp(POSTER.name, LOOSER.nick)    == 0) ok = 1;
	if (strcomp(POSTER.name, LOOSER.sh_name) == 0) ok = 1;
  }

  if (USER.level < ADMIN_LEV){
	  if ((strcomp("SYSOP", POSTER.name) == 0) ||
	      (strcomp("POST",  POSTER.name) == 0) ||
	      (strcomp("GAST",  POSTER.name) == 0) ||
	      (strcomp("ADMIN", POSTER.name) == 0) ||
	      (strcomp("COSYS", POSTER.name) == 0)) ok = 1;
  }

  if (ok == 1) {
	printf(" %s\n", POS13_MSG);
	ansi2("me", 0, 0);
	sprintf(POSTER.name, "%s", s);
	goto RETRY_1;
  }
  ansi2("me", 0, 0);

  do {
	printf("%c%s ", CR, POS14_MSG);
	strcpy(s, (UNSIGNED char *) getline(10, 11, '.', ""));
	if (strcomp("<BREAK>", s) == 0) s[0] = '\0';
	strcpy(POSTER.passwort, (UNSIGNED char *) crypted(s));
	if (strlen(POSTER.passwort) < 5) {
		ansi2("md", 0, 0);
		printf("\n%s\n", POS15_MSG);		
		ansi2("me", 0, 0);
	}
  } while (strlen(POSTER.passwort) < 5);

RETRY_2:

  printf("\n%s ", POS16_MSG);
  strcpy(s, getline(30, 15, '.', ""));
  if (strcomp("<BREAK>", s) == 0) {
	strcpy(s, "John Doe");
  }
  strcpy(POSTER.nick, (UNSIGNED char *) stripped(s));

  ansi2("md", 0, 0);
  printf("\n%s", POS12_MSG);
  ok = 0;
  lseek(fd, 0L, SEEK_SET);
  while ((read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) && (ok == 0)) {
	if (strcomp(POSTER.nick, LOOSER.nick)    == 0) ok = 1;
	if (strcomp(POSTER.nick, LOOSER.name)    == 0) ok = 1;
	if (strcomp(POSTER.nick, LOOSER.sh_name) == 0) ok = 1;
  }

  if (USER.level < ADMIN_LEV){
	  if ((strcomp("SYSOP", POSTER.nick) == 0) ||
	      (strcomp("POST",  POSTER.nick) == 0) ||
	      (strcomp("GAST",  POSTER.nick) == 0) ||
	      (strcomp("ADMIN", POSTER.nick) == 0) ||
	      (strcomp("COSYS", POSTER.nick) == 0)) ok = 1;
  }

  if (ok == 1) {
	printf(" %s\n", POS13_MSG);
	ansi2("me", 0, 0);
	goto RETRY_2;
  }
  ansi2("me", 0, 0);

  if(USER.level >= ADMIN_LEV){
	printf("%c%s ", CR, POS17aMSG);
	strcpy(POSTER.sh_name, (UNSIGNED char *) getline(30, 11, '.', ""));

	if(POSTER.sh_name[0] != '\0'){
        	pw_entry = getpwnam( (UNSIGNED char *) POSTER.sh_name );
		if(pw_entry->pw_uid == 0){
			ansi2( "md", 0, 0 );
			if(strcomp("root", POSTER.sh_name) == 0){
				printf("\n%c%s\n", 7, POS17bMSG); 	
			}
			else{		
				printf("\n%c%s\n", 7, POS17cMSG);
			}
			ansi2( "me", 0, 0 );
		}
	}
  }

  printf("\n%c%s ", CR, POS17_MSG);
  strcpy(POSTER.wohnort, (UNSIGNED char *) getline(30, 11, '.', ""));

  printf("\n%s ", POS18_MSG);
  strcpy(POSTER.strasse, (UNSIGNED char *) getline(30, 11, '.', ""));

  printf("\n%s ", POS19_MSG);
  strcpy(POSTER.telefon1, (UNSIGNED char *) getline(20, 11, '.', ""));

  printf("\n%s ", POS20_MSG);
  strcpy(POSTER.telefon2, (UNSIGNED char *) getline(20, 11, '.', ""));

  printf("\n%s ", POS21_MSG);
  strcpy(POSTER.geburtsdatum, (UNSIGNED char *) getline(10, 114, '?', ""));

  close(fd);

  ansi2("md", 0, 0);
  printf("\n\n%s\n%s\n\n", POS22_MSG, POS23_MSG);
  ansi2("me", 0, 0);

  /* POSTMASTER-Account */

  if (arg[0] != '*') {
	sprintf(s, "%s", arg);
	s[14] = '\0';
	strcpy(USER.sh_name, s);
	USER.level = WRITE_EX_LEV;
  }
  else USER.sh_name[0] = '\0';

  i = 0; j = 0;
  while(POSTER.name[i] != '\0'){
	if(i == j){
		if(POSTER.name[i] > 96) POSTER.name[i] -= 32;
		j = 0;	
	}
	i++;
	if(POSTER.name[i] == ' ') j = i + 1;
  }

  sprintf(USER.name, "%s", POSTER.name);
  sprintf(USER.passwort, "%s", POSTER.passwort);
  sprintf(USER.nick, "%s", POSTER.nick);
  sprintf(USER.wohnort, "%s", POSTER.wohnort);
  sprintf(USER.strasse, "%s", POSTER.strasse);
  sprintf(USER.telefon1, "%s", POSTER.telefon1);
  sprintf(USER.telefon2, "%s", POSTER.telefon2);
  sprintf(USER.geburtsdatum, "%s", POSTER.geburtsdatum);   


  INIT_UDBASE:

  if(USER.terminal < 3)
	USER.editor = 2;
  else
	USER.editor = 1;
  USER.prompt = 2;
  USER.bell = 0;
  USER.more = 3;
  USER.seq = 0;
  USER.intro = 1;
  LASTLOG = (long) dateconv( (UNSIGNED char *) "01.01.1970");
  strcpy(USER.lastlog, (UNSIGNED char *) mydate( 0 ));
  USER.lasttime = 0;
  USER.lastmode = 2;
  USER.leserichtung = 1;
  USER.upratio = 0L;
  USER.downratio = 0L;
  USER.elapsed = 0L;
  USER.tlines = 23;
  sprintf(USER.newsgrps, "%s", NEWS_LEVEL1);
  strcpy(USER.account, "00.00.0000000000000000000000000000000000000000000000000000000000000000000");

  USER.schluessel[3] = 128;	
  USER.schluessel[4] = 1;

  /*
  if((USER.level < PD_U_LEV) && (USER.id > 2)) USER.level = PD_U_LEV;
  */
  if(USER.id > 2) USER.level = PD_U_LEV;

  maybe_locked(UDSEQ, "r"); mblock(UDSEQ);
  fp = fopen(UDSEQ, "r");
  if (fp == NULL) {
	nerror("postfach.c", 188, "postfach", "Can't read", UDSEQ);
  }
  fscanf(fp, "%d", &USER.id);
  fclose(fp);
  mbunlock(UDSEQ);

  if(USER.id < 1) USER.id = 1;

  maybe_locked(UDSEQ, "r"); mblock(UDSEQ);
  fp = fopen(UDSEQ, "w");
  if (fp == NULL) {
	nerror("postfach.c", 196 , "postfach", "Can't write to", UDSEQ);
  }
  fprintf(fp, "%d\n", (USER.id + 1));
  fclose(fp);
  mbunlock(UDSEQ);

  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDWR);
  if (fd == -1) {
	nerror("postfach.c", 204, "postfach", "Can't read", UDBASE);
  }
  ll = lseek(fd, 0L, SEEK_END);
  write(fd, (UNSIGNED char *) &USER, sizeof(USER));
  close(fd);
  mbunlock(UDBASE);
  
  sprintf(s, "%s/usr/%c", HOME, USER.name[0]);
  if(mkdir(s, 0777) != 0){
	/* Who cares ?? */
  }  

  sprintf(s, "%s/usr/%c/%d", HOME, USER.name[0], USER.id);
  if(mkdir(s, 0777) != 0){
	/* Doesn't matter ;-) */
  }  
  
  sprintf(s, "%s/usr/%c/%d/seq", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  if(fp == NULL){
	printf("\n\n%s\n\n", POS24aMSG);	
	sprintf(s, "%s.BAK", UDBASE );
	rename( UDBASE, s );
	unlink( UDBASE );
	sprintf(s, "%s.BAK", UDSEQ );
	rename( UDSEQ, s );
	unlink( UDSEQ );
	exit(0);
  }
  fputs("1\n", fp);
  fclose(fp);

  sprintf(s, "%s/usr/%c/%d/.hello", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fputs("\n", fp);
  fclose(fp);

  sprintf(s, "%s/usr/%c/%d/.signature", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fputs("\n", fp);
  fclose(fp);

  if (arg[0] != '*') {
	sprintf(s, "cp /usr/%s/%s %s/usr/%c/%d/.signature > /dev/null 2>&1", USER.sh_name, SIGNATURE,
		HOME, USER.name[0], USER.id);
	system(s);
  }
  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fprintf(fp, "%s\n", GBL05_MSG);
  fputs("===============================================================================\n", fp);
  fclose(fp);

  if (arg[0] == '#') {
	return; /* UDBASE installiert */
  }

  i = 0;
  strcpy(t, USER.name);
  while(t[i] != '\0'){
	if(t[i] == ' ') t[i] = '.';
	i++;
  }

  sprintf(s, "/bin/sh ./etc/alias.sh \"%s\"", t);
  system( s );


  sprintf(s, "%s \"%s\" (%d)", POS24_MSG, USER.name, USER.id);
  control(s, 3);

  avoid_struggles = USER.id;

  init_user( POS25_MSG, 0 );
  printf("\n");

  sprintf(s, "%s/usr/%c/%d/.lastletter", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fputs("FYI ;-)", fp);
  fclose(fp);

  sprintf(s, "%s/usr/%c/%d/.lastsubject", HOME, USER.name[0], USER.id);
  fp = fopen(s, "w");
  fprintf(fp, ">--- %s (%d) --->>", POS26_MSG, USER.id);
  fclose(fp);

  sprintf(s, "%s?", POSTMASTER );
  brief( s );
  
}


/* #MV - Changing a user home directory */

void moving( oldname, username, userid )
UNSIGNED char oldname[], username[];
int userid;
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char o[STRING];

  ansi2( "md", 0, 0 );
  printf("\n\n%s ...", POS25_MSG);

  sprintf(s, "%s/usr/%c", HOME, username[0]);
  if(mkdir(s, 0777) != 0){
	/* Who cares ?? */
  }  
  printf(".");

  sprintf(s, "%s/usr/%c/%d", HOME, username[0], userid);
  if(mkdir(s, 0777) != 0){
	/* Doesn't matter ;-) */
  }  
  printf(".");

  sprintf(t, "%s/usr/%c/%d", HOME, oldname[0], userid);
  sprintf(o, "cp %s/* %s > /dev/null 2>&1", t, s);
  system( o );
  printf(".");
  sprintf(o, "cp %s/.* %s > /dev/null 2>&1", t, s);
  system( o );
  printf(".%c", CR);

  ansi2( "me", 0, 0 );
}
