/* ix/MBox (portinfo.c) by Volker Schuermann, 04.12.1993
 
   This C source code contains the following functions:

   #PO port()            BBS internal "who" (better "whodo") function
   #SL show_level()      survey of the user levels
   #UL userliste()       various lists of BBS users   
   #FI finger()          get information on a certain user
   #NU new_user_dir()    updating the users directories (be very careful!)
   #RA rebuild_aliases() add a new entry for every user in smails aliases DB
 
   Contact <volkers@unnet.wupper.de> for help! */


 


 
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <utmp.h>
#include <time.h>
#include <signal.h>
#include <string.h>

#include "mbox.h"






void port2(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  int fd;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  struct utmp US;
  int i, j;
  int ok;
  int position = 0;
  int x, y;
  int delay = atoi( arg );
  int fpid;

  struct spy_struct{
	UNSIGNED char name[STRING];
	UNSIGNED char port[STRING];
	UNSIGNED char text[13][STRING];
	int pointer;
	int active;
  } SPY[5]; 


  if(delay == 0) delay = 5;


  for(i = 1; i < 5; i++){
	SPY[i].name[0] = '\0';
	SPY[i].port[0] = '\0';
	for(j = 1; j < 13; j++) SPY[i].text[j][0] = '\0';
	SPY[i].pointer = 1;
	SPY[i].active = 0;
  }

  if(USER.terminal == ISO6429){
	ansi2( "X4", 0, 0 );
	ansi2( "cl", 0, 0 );
	ansi2( "me", 0, 0 );
	headblock( " Big Brother is watching you ... ", " " );
	ansi2( "X1", 0, 0 );
	ansi2( "cm", 40, 3 );
	for(j = 4; j <= (MAX_SCR_LINES + 1); j++){
		printf(" %c", BS);
		ansi2( "do", 0, 0 );
	}
  }
  else{
	ansi2( "cl", 0, 0 );
	printf(" Big Brother is watching you ... ");
	ansi2( "mr", 0, 0 );
	for(j = 2; j <= (MAX_SCR_LINES + 1); j++){
		ansi2( "cm", 40, j );
		printf(" ");
	}
  }
  ansi2( "cm", 1, (MAX_SCR_LINES + 1) );
  printf("                                                                               "); 

  if(USER.level >= ADMIN_LEV) whodo( " " );

  switch( (fpid = fork()) ){
	case -1 : 
		break;
	case  0 :

		while( 1 ){
#ifdef _SYS7
			maybe_locked(UTMP, "r");
			fd = open(UTMP, O_RDONLY);
#else
			maybe_locked(UTMP_FILE, "r");
			fd = open(UTMP_FILE, O_RDONLY);
#endif

			if (fd == -1) {
#ifdef _SYS7
				nerror("portinfo.c", 83, "port", "Can't read", UTMP);
#else
				nerror("portinfo.c", 83, "port", "Can't read", UTMP_FILE);
#endif

			}
			while (read(fd, (UNSIGNED char *) &US, sizeof(US)) == sizeof(US)) {

			 	if (US.ut_type == USER_PROCESS) {

					sprintf(s, "%s/etc/whatdoes.%s", HOME, US.ut_line);
					fp = fopen( s, "r" );
					if(fp != NULL){
						fgets(s, STRING, fp);
						strcpy(t, (UNSIGNED char *) strcopy(s, 35, 42));
						strcpy(t, (UNSIGNED char *) stripped( t ));
						ok = 0;

						for(i = 1; i < 5; i++){
							if((strcomp(t, SPY[i].port) == 0) && (t[0] != '\0')){
								ok++;

								SPY[i].active = 1;	
								
								strcpy(t, (UNSIGNED char *) strcopy(s, 52, 80));
								strcpy(t, (UNSIGNED char *) stripped(t));

								if(strcomp(t, SPY[i].text[SPY[i].pointer]) != 0){

									if(SPY[i].pointer == (MAX_SCR_LINES - 13)){	
										for(j = 1; j < (MAX_SCR_LINES - 13); j++){
											strcpy(SPY[i].text[j], (UNSIGNED char *)
												SPY[i].text[j+1]);
										}
									}
									else SPY[i].pointer++;

									strcpy(SPY[i].text[SPY[i].pointer], (UNSIGNED char *)
									strcopy(s, 52, 80));
								}	
							}
					}
					if(ok == 0){
						for(j = 4; j > 0; j--){
							if(SPY[j].name[0] == '\0') position = j;
						}
						strcpy(SPY[position].name, (UNSIGNED char *)
							strcopy(s, 0, 32));
						strcpy(SPY[position].port, (UNSIGNED char *)
							t);
						strcpy(SPY[position].text[SPY[position].pointer], (UNSIGNED char *)
							strcopy(s, 52, 80));
						SPY[position].active = 1;	
					}
	
					fclose(fp);
				}
			}
	  	}
		close(fd);

 
		for(i = 1; i < 5; i++){
		
			switch( i ){
				case 1 : x =  1; y =  2; break;
				case 2 : x = 41; y =  2; break;
				case 3 : x =  1; y = 13; break;
				case 4 : x = 41; y = 13; break;
			}
		
			if(USER.terminal == ISO6429){
				ansi2( "X1", 0, 0 );
				ansi2( "cm", x, y );
			}
			else{
				ansi2( "mr", 0, 0 );
				ansi2( "cm", x, y );
			}

			if(SPY[i].active == 0){
				SPY[i].name[0] = '\0';
				SPY[i].port[0] = '\0';
				for(j = 1; j < 13; j++) SPY[i].text[j][0] = '\0';
				SPY[i].pointer = 1;
			}

			SPY[i].active = 0;

			sprintf(s, "[%s] %s", SPY[i].port, (UNSIGNED char *) stripped( SPY[i].name) );
			s[39] = '\0';
			printf("%-39.39s", s);	
			ansi2( "me", 0, 0 );

			for(j = 1; j < (MAX_SCR_LINES - 12); j++){
				ansi2( "cm", x, (y + j) );
				printf(" %-37.37s", (UNSIGNED char *) stripped( SPY[i].text[j] ));
			}	
		
			if(USER.terminal == ISO6429){
					ansi2( "me", 0, 0 );
			}
		}
		ansi2( "cm", 1, 3 );
		sleep( delay );
	}
  } 

  i = getch();
  kill(fpid, SIGKILL);
  (void) wait( &fpid );

  ansi2( "cm", 1, 1 );
  
  if(USER.terminal == ISO6429) ansi2( "mr", 0, 0 );
  printf( "Big Brother is no longer watching you ... \n" ); 
  ansi2( "me", 0, 0 );

  for(i = 1; i <= MAX_SCR_LINES; i++){
	if(ansi2( "al", 0, 0 ) == 0){
		msleep( 20 );
	}
	else{
		printf("                                                                               \n");		
	}
  }
  ansi2( "al", 0, 0 );
  ansi2( "cm", 1, 4 );
}





/* #PO - Show who is doing what ... 
  
   [arg] is a dummy ... no comments, please! */

void port(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *pp;
  int fd;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char terms[STRING];
  UNSIGNED char tmp[STRING];
  UNSIGNED char ex[LONGSTRING];
  struct utmp US;
  struct tm *tmt;
  long ltime;
  int k, l; 

  if(USER.schluessel[3] != 128){
	headblock( POR01_MSG, POR02_MSG );
  }
  else{
	show_raw( ANSI_PORTINFO, 10 );
	strcpy(ex, (UNSIGNED char *) POR02_MSG );
	strcat(ex, (UNSIGNED char *) "                                                                             ");         
	ex[79] = '\0';
	ansi2( "mr", 0, 0 );
	printf("%s\n", ex );
	ansi2( "me", 0, 0 );
  }

  printf("%s ...%c", POR03_MSG, CR);

  sprintf(tmp, "%s/%dps", TMP, getpid());
  sprintf(s, "ps -a > %s", tmp);
  system( s );

#ifdef _SYS7
  maybe_locked(UTMP, "r");
  fd = open(UTMP, O_RDONLY);
#else
  maybe_locked(UTMP_FILE, "r");
  fd = open(UTMP_FILE, O_RDONLY);
#endif

  if (fd == -1) {

#ifdef _SYS7
	nerror("portinfo.c", 83, "port", "Can't read", UTMP);
#else
	nerror("portinfo.c", 83, "port", "Can't read", UTMP_FILE);
#endif

  }
  while (read(fd, (UNSIGNED char *) &US, sizeof(US)) == sizeof(US)) {

 	if (US.ut_type == USER_PROCESS) {
		sprintf(ex, "%.8s <Shell Account>                                                  ",
			US.ut_user);
		ex[33] = '\0';
		strcpy(terms, ex);

		sprintf(ex, "%8.8s   ",
			US.ut_line);
		strcat(terms, ex);

		ltime = US.ut_time;
		tmt = localtime(&ltime);
		sprintf(ex, "%02.2d:%02.2d   ",
			tmt->tm_hour, tmt->tm_min);
		strcat(terms, ex);

		l = atoi(strcopy(US.ut_line, 3, 6));

		sprintf(s, "%s/etc/whatdoes.%s", HOME, US.ut_line);
		fp = fopen( s, "r" );
		if(fp != NULL){
			fgets(terms, STRING, fp);
			fclose(fp);

			if(arg[0] != '$'){
				ansi2( "md", 0, 0 );	
				printf("%s", terms);
				ansi2( "me", 0, 0 ); 
			}
		}
		else{
			pp = fopen(tmp, "r");
			if (pp == NULL) {
				nerror("portinfo.c", 113, "port", "Can't read", tmp);
			}
			while (fgets(s, STRING, pp) != NULL) {
				k = atoi((UNSIGNED char *) strcopy(s, 8, 10));
				if ((k == l) && (s[17] != '-')) {
					strcpy(t, (UNSIGNED char *) strcopy(s, 21, 80));
					strcpy(t, (UNSIGNED char *) stripped( t ));
					t[27] = '\0';
				}
			}
			fclose(pp);
			strcat(terms, t);

			if((arg[0] == '*') || (arg[0] == '$')) printf("%s\n", terms);
		}
	}
	else{
		/*
		sprintf(s, "%s/etc/whatdoes.%s", HOME, US.ut_line);
		fp = fopen( s, "r" );
		if(fp != NULL){
			fgets(terms, STRING, fp);
			fclose(fp);

			if(arg[0] != '$'){
				ansi2( "md", 0, 0 );	
				printf("%s", terms);
				ansi2( "me", 0, 0 ); 
			}
		}
		*/
	}
  }
  close(fd);
  unlink(tmp);

  printf("\n");
}







/* #SL - Show the user levels and permissions. */

void show_level( arg )
UNSIGNED char arg[]; 
{
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char v[STRING];

  int no, in, ex, prot, ar, ar_in, ar_ex;
  int i;

  FILE *fp, *ff;


  if(arg[0] == 0) headblock( POR04_MSG, POR05_MSG );

  if(USER.level < ADMIN_LEV){
	printf("%s (%d)\n", POR06_MSG, GUEST_LEV);
	printf("%s (%d)\n", POR07_MSG, WRITE_IN_LEV);
	printf("%s (%d)\n", POR08_MSG, MAILOUT_LEV);
	printf("%s (%d)\n", POR09_MSG, WRITE_EX_LEV);
	printf("%s (%d)\n", POR10_MSG, WRITE_INTERNAT);
	printf("%s (%d)\n", POR11_MSG, PD_D_LEV);
	printf("%s (%d)\n", POR12_MSG, PD_U_LEV);
	printf("%s (%d)\n", POR13_MSG, EXE_LEV);
	printf("%s (%d)\n", POR14_MSG, ADMIN_LEV);
  	printf("\n%s (%d), %s !\n\n", POR15_MSG, USER.level, USER.name);
  }
  else{

#define TYPINLE( _MSG_, _LEV_ )	printf("\n%s ", _MSG_ ); \
				sprintf(s, "%d", _LEV_); \
				strcpy(s, (UNSIGNED char *) getline(30, 1101, ' ', s)); \
				if(s[0] > 31) _LEV_ = atoi( s );

	if(arg[0] == 0){
		TYPINLE( POR06_MSG, GUEST_LEV );
		TYPINLE( POR07_MSG, WRITE_IN_LEV );
		TYPINLE( POR08_MSG, MAILOUT_LEV );
		TYPINLE( POR09_MSG, WRITE_EX_LEV );
		TYPINLE( POR10_MSG, WRITE_INTERNAT );
		TYPINLE( POR11_MSG, PD_D_LEV );
		TYPINLE( POR12_MSG, PD_U_LEV );
		TYPINLE( POR13_MSG, EXE_LEV );
		TYPINLE( POR14_MSG, ADMIN_LEV );
	}
	else{
		i = 0;
		while(BEF[i].id != -1){
			if(strcomp(arg, BEF[i].befehl) == 0){
				ar = BEF[i].id;
				ar_in = BEF[i].in;
				ar_ex = BEF[i].ex;	
				strcpy(v, (UNSIGNED char *) BEF[i].befehl);
			}
			i++;
		}

		ansi2( "md", 0, 0 );
		printf("\n\n%s <%s> intern: ", "Befehl", v);
		sprintf(s, "%d", ar_in);
		ansi2( "me", 0, 0 );
		strcpy(s, (UNSIGNED char *) getline(30, 1101, ' ', s)); \
		if(s[0] > 31) ar_in = atoi( s );
		ansi2( "md", 0, 0 );
		printf("\n%s <%s> extern: ", "Befehl", v);
		sprintf(s, "%d", ar_ex);
		ansi2( "me", 0, 0 );
		strcpy(s, (UNSIGNED char *) getline(30, 1101, ' ', s)); \
		if(s[0] > 31) ar_ex = atoi( s );
	}

	printf("\n");

	sprintf(s, "%s/src/languages/%s.cmd", HOME, LANGUAGE );
	fp = fopen( s, "r");
	if(fp == NULL){
		exit(0);
	}	

	sprintf(t, "%s/tmp/cmd.%d", HOME, getpid());
	ff = fopen( t, "w" );

	do{
		fgets(s, STRING, fp);
		fprintf(ff, "%s", s);
	}while(s[0] != '=');

	while (fscanf(fp, "%d %d %d %d %s", &no, &in, &ex, &prot, s) > 0) {

		if(no == 160) ex = MAILOUT_LEV;
		if(no == 125) ex = ADMIN_LEV;
		if(no == 230){
			in = WRITE_IN_LEV;
			ex = WRITE_EX_LEV;
		}
		if(no == 998) in = WRITE_INTERNAT;
		if(no == 195){
			in = PD_D_LEV;
			ex = PD_U_LEV;
		}
		if(no == 240) ex = EXE_LEV;
		if(no == 320) in = GUEST_LEV; 

		if(no == ar){
			in = ar_in;
			ex = ar_ex;
		}

		fprintf(ff, "%d%c%d%c%d%c%d%c%s\n", no, 9, in, 9, ex, 9, prot, 9, s );
	}
	
	fclose(fp);
	fclose(ff);	

	sprintf(s, "%s/src/languages/%s.cmd", HOME, LANGUAGE );
	mbrename( t, s );
	unlink( t );

	if(arg[0] != 0) init();
  }
}





/* #UL - Show one of a couple of userlists.

   [arg]    ->  ''    = Username and ID, only
                '*'   = Name, last call etc.
                '#'   = Name, Up- / Download
                '$'   = Fees/Charges
                '%'   = Name, level, newsgroups */

void userliste(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char u[(STRING*2)];
  UNSIGNED char tmp[STRING];
  UNSIGNED char t[STRING];
  int i = 0, z, z1 = 0, z2 = 0;
  int mode = 0;
  int totalusr = 0;
  int totalact = 0;
  int totalgas = 0;
  long kto;
  float pf;

  UNSIGNED char c;

  if (arg[0] == '*') mode = 1;
  if ((arg[0] == '#') && (USER.level >= ADMIN_LEV)) mode = 2;
  if ((arg[0] == '$') && (USER.level >= ADMIN_LEV)) mode = 3;
  if (arg[0] == '%') mode = 4;
  if ((arg[0] > 47) && (mode == 0)){
	finger(arg);
	return;
  }
 
  show(UDBASE, 99, 99); /* RESET */

  if(mode == 0){
	if(USER.schluessel[3] != 128)
		headline( POR15aMSG );
	else
		show_raw( ANSI_USERS, 10 );
  }
  else{
	if(mode == 1)
		headblock( POR15aMSG, POR16_MSG );

	if(mode == 2)
		headblock( POR15aMSG, POR18_MSG );

	if(mode == 3)
		headblock( POR15aMSG, POR18aMSG );

	if(mode == 4)
		headblock( POR15aMSG, POR18bMSG );

	printf("%s", POR17_MSG);
  }
  
  sprintf(tmp, "%s/%d", TMP, getpid());
  fp = fopen(tmp, "w");
  if (fp == NULL) {
	nerror("portinfo.c", 231, "userliste", "Can't write to", tmp);
  }
  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {
	if (mode == 0) {
		sprintf(u, "%s", LOOSER.name);
		sprintf(s, " (%d) ", LOOSER.id);		
		u[26 - strlen(s)] = '\0';
		strcat(u, s); strcat(u, "                                ");	
 		u[26] = '\0';
		fprintf(fp, "%s", u);
		i++;
		if (i == 3) {
			i = 0;
			fprintf(fp, "\n");
		}
	}
	if (mode == 1) {
		sprintf(s, "%s", LOOSER.name);
		s[24] = '\0';
		sprintf(u, "%s [%d]", s, LOOSER.id);

		sprintf(s, "%s", "   ");
		if ((LOOSER.elapsed / 60) > 2) {
			if (LOOSER.wohnort[0] < 48) {
				if (strcomp(GUEST, LOOSER.name) != 0)
					sprintf(s, "%s", "<?>");
			}
		}
		else {
			sprintf(s, "%s", "{-}");
		}
		if (LOOSER.seq == 1) {
			sprintf(s, "%s", "<!>");
		}
		fprintf(fp, "%-30.30s  %10s %s%6d %8ld\"  %5d%10.10s\n",
			u, LOOSER.lastlog, s, LOOSER.seq, (LOOSER.elapsed / 60), LOOSER.level, LOOSER.sh_name);

	}
	if (mode == 2) {
		fprintf(fp, "%-30.30s  %8d kB  %10d kB %8d\"\n",
			LOOSER.name, LOOSER.upratio, LOOSER.downratio, (LOOSER.elapsed / 60));
	}
        if (mode == 3) {
		/*
		if((atoi(LOOSER.account) > 0) && (LOOSER.level >= MAILOUT_LEV)){
		*/
		if(LOOSER.level >= MAILOUT_LEV){
			if(LOOSER.account[0] == '\0') strcpy(LOOSER.account, "00.00.0000");
			strcpy(s, LOOSER.account);
			s[10] = '\0';
			c = ' ';
			if(LOOSER.level >= WRITE_EX_LEV) z2++;
			z1++;
			strcpy(t, (UNSIGNED char *) strcopy(LOOSER.account, 11, 16));
			z = atoi(t);	

			kto = getacctdata( LOOSER.account );
			pf = (float) kto;
			pf /= 100;

			/*
			if(strcomp("01.01.2001", s) != 0L)
			*/
			if(kto != 0L)
				fprintf(fp, "%-30.30s  %5d   %c %s %7.02f $\n",  
					LOOSER.name, LOOSER.id, c, s, (float) pf);
			else
				fprintf(fp, "%-30.30s  %5d   %c %s %7.02f\n",  
					LOOSER.name, LOOSER.id, c, s, (float) pf);
		}
        }
        if (mode == 4) {
		fprintf(fp, "%-15.15s %5d %4d    %s\n",
			LOOSER.name, LOOSER.id, LOOSER.level, LOOSER.newsgrps);
	}       
	totalusr++;
	sprintf(s, "%s", (UNSIGNED char *) mydate( 0 )); 
	if( ((long) dateconv(s) - (long) dateconv(LOOSER.lastlog)) < 30 ) totalact++;
	if(strcomp(GUEST, LOOSER.name) == 0) totalgas = LOOSER.seq;
  }
  close(fd);

  fclose(fp);

  if (mode != 0) {
	printf("%c", CR);
	sprintf(s, "sort -d -o %s %s", tmp, tmp);
	system(s);
	show(tmp, 9999, USER.more + 100);
	if (mode == 1) {
		printf("\n%s\n%s", POR19_MSG, POR20_MSG);
	}
	if (mode == 3) {
		printf("\n(%d/%d)", z1, z2);
	}
  }
  else{
	if(USER.schluessel[3] != 128)
		show(tmp, 9999, USER.more);
	else
		show(tmp, 9999, USER.more + 1000);
  }
  if(mode == 0){
	printf("\n\n%s %d %s %d %s", POR21_MSG, totalusr, POR22_MSG, totalact, POR23_MSG); 
	printf("\n%s %d %s", POR24_MSG, totalgas, POR25_MSG);
  }
  printf("\n");
  unlink(tmp);
}






/* #FI - Get and show information on a user [arg]. 

   [arg] could be a username or a user-id. */

void finger(arg)
UNSIGNED char arg[];
{
  int fd;
  struct userdaten DUMMY, LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  long ll = -1L;
  size_t dummy = sizeof(DUMMY);
  UNSIGNED char c;
  UNSIGNED char ex[LONGSTRING];
  int i, ok, a, b;
  int uid = -1;
  static UNSIGNED char name[STRING];
  static UNSIGNED char domain[STRING];	  


  FILE *fp;

  
  if ((arg[0] > 47) && (arg[0] < 58)) {
	uid = atoi(arg);
  }
  else{
	a = 0; b = 0;
	i = 0;
	while(arg[i] != '\0'){	
		if(arg[i] == '!') a = i;
		if(arg[i] == '@') b = i;
		i++;
	}
	if((a != 0) && (b == 0)){
		if(a != 0){
			strcpy(name, (UNSIGNED char *) strcopy(arg, (a+1), strlen(arg)));
			strcpy(domain, (UNSIGNED char *) strcopy(arg, 0, (a-1)));
		}
		else{
			strcpy(name, (UNSIGNED char *) strcopy(arg, 0, (b-1)));
			strcpy(domain, (UNSIGNED char *) strcopy(arg, (b+1), strlen(arg)));
		}
		strcpy(t, USER.name);
		i = 0;
		while(t[i] != '\0'){
			if(t[i] == ' ') t[i] = '.';
			i++;
		}
		chdir( "/" );
		sprintf(s, "%s %s!%s!\"finger %s\" \\| mail %s@%s", UUX, SMARTHOST, domain, name, t, UUCPID);
		system( s );
		chdir( HOME );
		printf("\n\n%s \"%s\",\n%s \"%s\" %s.", POR25aMSG, name, POR25bMSG, domain, POR25cMSG);
		ansi2( "md", 0, 0 );
		printf("\n%s\n", POR26_MSG);
		ansi2( "me", 0, 0 );
		return;
	}
	else{
		if(b != 0){
			ansi2( "md", 0, 0 );
			printf(" <- %s\n\n", POR26aMSG);
			ansi2( "me", 0, 0 );
			return;
		}
	}
  }
 
  maybe_locked(UDBASE, "r"); mblock(UDBASE);
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 324, "aendern", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &DUMMY, dummy) == dummy) {
	if (uid == DUMMY.id) {
		ll = lseek(fd, 0L, SEEK_CUR) - dummy;
	} 
	else{
		if ((strcomp(arg, DUMMY.name) == 0) ||
		    (strcomp(arg, DUMMY.nick) == 0) ||
		    (strcomp(arg, DUMMY.sh_name) == 0)) {
			ll = lseek(fd, 0L, SEEK_CUR) - dummy;
		}
	}
  }
  lseek(fd, ll, SEEK_SET);
  read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER));
  close(fd);
  mbunlock(UDBASE);

  if (ll == -1L) {
	ansi2( "md", 0, 0 );
	printf(" <- %s\n\n", POR27_MSG);
	ansi2( "me", 0, 0 );
	return;
  }

  sprintf(s, " %s: %s ", POR28_MSG, arg);
  headline( s );

  ansi2( "md", 0, 0 );
  printf("\n%s ", POR29_MSG);
  ansi2( "me", 0, 0 );
  printf("%d\n", LOOSER.id);

  ansi2( "md", 0, 0 );
  printf("%s ", POR30_MSG);
  ansi2( "me", 0, 0);
  printf("%s\n", LOOSER.name);

  if(LOOSER.sh_name[0] != '\0'){
	ansi2( "md", 0, 0 );
	printf("%s ", POR31_MSG);
	ansi2( "me", 0, 0 );
	printf("%s\n", LOOSER.sh_name);
  }

  if(LOOSER.nick[0] != '\0'){
	ansi2( "md", 0, 0 );
  	printf("%s ", POR32_MSG);
	ansi2( "me", 0, 0 );
	printf("%s\n", LOOSER.nick);
  }

  ansi2( "md", 0, 0 );
  printf("%s ", POR33_MSG);
  ansi2( "me", 0, 0 );
  strcpy(s, LOOSER.name);
  i = 0;
  while(s[i] != '\0'){
	if(s[i] == ' ') s[i] = '.';
	i++;
  }
  if(LOOSER.level >= WRITE_INTERNAT)
	printf("%s@%s\n", s, UUCPID2);
  else
	printf("%s@%s\n", s, UUCPID1);

  printf("\n"); ok = 0;

  if(USER.level >= WRITE_EX_LEV){
	if(LOOSER.wohnort[0] != '\0'){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", POR34_MSG);
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.wohnort);
	}
  }

  if(USER.level >= ADMIN_LEV){
	if(LOOSER.strasse[0] != '\0'){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", POR35_MSG);
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.strasse);
	}
	if(LOOSER.telefon1[0] != '\0'){
		ok++;
		ansi2( "md", 0, 0 ); 
		printf("%s ", POR36_MSG);
		ansi2( "me", 0, 0 );
		printf("%s", LOOSER.telefon1);

		if(LOOSER.telefon2[0] != '\0'){
			printf(" // %s\n", LOOSER.telefon2);
		}
		else{
			printf("\n");
		}
	}

	if(ok != 0) printf("\n"); 
	ok = 0;

	if(LOOSER.geburtsdatum[0] != '\0'){
		ok++;
		ansi2( "md", 0, 0 );
		printf("%s ", POR37_MSG);
		ansi2( "me", 0, 0 );
		printf("%s\n", LOOSER.geburtsdatum);
	}
  }

  if(ok != 0) printf("\n");

  if(USER.level >= WRITE_EX_LEV){
	ansi2( "md", 0, 0 );
	printf("%s ", POR38_MSG);
	ansi2( "me", 0, 0 );
	printf("%d\n", LOOSER.seq);
  	ansi2( "md", 0, 0 );
	printf("%s ", POR39_MSG);
	ansi2( "me", 0, 0 );
	printf("%s // %s\n", LOOSER.lastlog, (UNSIGNED char *) timereconv(LOOSER.lasttime));
  }

  ansi2( "md", 0, 0 );
  printf("%s ", POR45_MSG);
  ansi2( "me", 0, 0 );
 
  b = 0;
  sprintf(s, "%s/usr/%c/%d/INDEX", HOME, LOOSER.name[0], LOOSER.id);  
	
  fp = fopen(s, "r");
  if (fp == NULL) {
	nerror("intro.c", 291, "intro", "Can't read", s);
  }
  while (fgets(ex, LONGSTRING, fp) != NULL){
	if(ex[0] < 65) b++;
  }
  fclose(fp);
  printf("%d\n", b-1);

  if(USER.level >= ADMIN_LEV){
	ansi2( "md", 0, 0 );
	printf("%s ", POR40_MSG);
	ansi2( "me", 0, 0 );
	b = LOOSER.elapsed/(3600*24);
	printf("%d %s, ", b, POR41_MSG);
	a = (LOOSER.elapsed - (b*(3600*24)))/3600; 
	printf("%d %s, ", a, POR41aMSG);
        b = (LOOSER.elapsed - (b*(3600*24)) - (a*3600))/360;
   	printf("%d %s\n", b, POR41bMSG);
        ansi2( "md", 0, 0 );
        printf("%s ", POR41cMSG);
        ansi2( "me", 0, 0 );
	strcpy(s, (UNSIGNED char *) LOOSER.account); s[10] = '\0';
        printf("%s\n", s);
	ansi2( "md", 0, 0 );
	printf("%s ", POR42_MSG);
	ansi2( "me", 0, 0 );
	printf("%ld %s\n", LOOSER.upratio, POR43_MSG);
	ansi2( "md", 0, 0 );
	printf("%s ", POR44_MSG);
	ansi2( "me", 0, 0 );
	printf("%ld %s\n", LOOSER.downratio, POR43_MSG);
  }

  printf("\n");

  sprintf(s, "%s/usr/%c/%d/.plan", HOME, LOOSER.name[0], LOOSER.id);  
  fp = fopen( s, "r" );
  if(fp != NULL){
	fclose(fp);
 
	ansi2("mr", 0, 0);
	printf("%c%s [%c, %c] > ", CR, POR46_MSG, GBL06_MSG, GBL07_MSG);
	ansi2("me", 0, 0);

	c = yesno();

	if (c == GBL06_MSG) {
		sprintf(s, " %s: %s ", POR28_MSG, arg);
		headline( s );

		sprintf(s, "%s/usr/%c/%d/.plan", HOME, LOOSER.name[0], LOOSER.id);
		show( s, 9999, USER.more );	
	}
  }

  printf("\n");
}





/* #RA - Add an entry for every user in smails aliases DB */

void new_user_dir()
{
  FILE *fp;
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];

  int i;

  headline( " Updating User Directories " );

  printf("\n");

  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {

	for(i = 'A'; i <= 'Z'; i++){
		sprintf(s, "%s/usr/%c", HOME, i);
#ifndef _LINUX
		mkdir( s );
		chmod( s, 0777 );
#else
		mkdir( s, 0777 );
#endif
	}

	sprintf(s, "%s/usr/%d/.dummy", HOME, LOOSER.id); /* New User-Directory !!! */

	printf("%s (%d)", LOOSER.name, LOOSER.id);

	fp = fopen( s, "w" );
	if(fp != NULL){
		fclose(fp);
		unlink(s);
		sprintf(s, "%s/usr/%c", HOME, LOOSER.name[0]);
#ifndef _LINUX
		mkdir( s );
		chmod( s, 0777 );
#else
		mkdir( s, 0777 );
#endif
		sprintf(s, "%s/usr/%c/%d", HOME, LOOSER.name[0], LOOSER.id);
#ifndef _LINUX
		mkdir( s );
		chmod(s , 0777 );
#else
		mkdir( s, 0777 );
#endif
		sprintf(s, "cp %s/usr/%d/.* %s/usr/%c/%d > /dev/null 2>&1", HOME, LOOSER.id, HOME, LOOSER.name[0], LOOSER.id);
		system( s );
		sprintf(s, "cp %s/usr/%d/* %s/usr/%c/%d > /dev/null 2>&1", HOME, LOOSER.id, HOME, LOOSER.name[0], LOOSER.id);
		system( s );
		sprintf(s, "rm -r %s/usr/%d > /dev/null 2>&1", HOME, LOOSER.id);
		system( s );
	}

	printf("%c                                                                  %c", CR, CR);
  }
  close(fd);

  printf("\n");
}


void rebuild_aliases()
{
  int fd;
  struct userdaten LOOSER;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];

  int i;

  headline( " Rebuilding Aliases Database" );

  printf("\n");

  maybe_locked(UDBASE, "r");
  fd = open(UDBASE, O_RDONLY);
  if (fd == -1) {
	nerror("admin.c", 254, "userliste", "Can't read", UDBASE);
  }
  while (read(fd, (UNSIGNED char *) &LOOSER, sizeof(LOOSER)) == sizeof(LOOSER)) {

	i = 0;
	strcpy(t, (UNSIGNED char *) LOOSER.name);
	while(t[i] != '\0'){
		if(t[i] == ' ') t[i] = '.';
		i++;
	}
	
	sprintf(s, "/bin/sh ./etc/alias.sh \"%s\"", t);
	system( s );
	printf("%s\n", t);
  }
  close(fd);

  printf("\n");
}

