/* ix/MBox (misc2.c) by Volker Schuermann, 04.12.1993

   This C source code contains the following functions:

   #CN chk_newsgrp()       make sure a user is allowed to see this newsgroup
   #SB subb()              is this newsgroup a sub-group?
   #LO loeschen()          delete a certain mail
   #BR brett()             switch to another newsgroup (interactive)
   #FR fetch_reciepy()     find the address of a replies receiver 
   #PU is_premium()        check whether a comand is a "premium" service 
   #CC chk_sigs()          check whether a newsgroup is a "premium" one
   #AE area()		   handle the entire area stuff

   Contact <volkers@unnet.wupper.de> for help! */








#include <stdio.h>
#include <signal.h>

#include "mbox.h"





static int area_fault;



/* #CN - Check if a user is allowed to see a specified newsgroup [s].

   This functions returns -1 if user mustn't enter the group, 0 if he
   has the permission to do so. */

int chk_newsgrp( s )
UNSIGNED char s[];
{
  int i = 1, ok = -1;

  while ((i < MAX_NEWSGRPS) && (newsgrp[i][0] != '\0') && (ok == -1)) {
	if (strcomp(newsgrp[i], s) == 0) ok = 0;
	if (strcomp(newsgrp[i], "all") == 0) ok = 0;
	i++;
  }

  return ok;
}





/* #SB - Is the newsgroup [s] a complete group, or only a sub-group.

   This function returns 0 if the newsgroup is a sub-group (minix), or
   the position of the end of the first sub-group.

   "minix"          is a sub-group of "comp.os.minix"   -> 0
   "comp.os.minix"  is a complete group                 -> 4 
        ^                                                    */


int subb(s)
UNSIGNED char s[];
{
  int a = 0, i = 0;

  while (s[i] != '\0') {
	if ((s[i] == '.') && (a == 0)) a = i;
	i++;
  }
  return a;
}





/* #LO - Delete a certain mail [arg] (number, NOT path!). */

void loeschen(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char entry[STRING];
  UNSIGNED char index[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char ex[LONGSTRING];
  int a = atoi(arg);
  int ok;


  if ((arg[0] < '1') || (arg[0] > '9')) {
	ansi2("md", 0, 0);
	printf(" %s\n", MI201_MSG);
	ansi2("me", 0, 0);
	return;
  }
  if (strcomp(BRETT, "PM") != 0) {
	if(arg[0] < 33) return;
	if(USER.level < ADMIN_LEV){
		if(atoi(arg) < 100000){
			ansi2("md", 0, 0);
			printf(" %s %d ...\n", MI202_MSG, USER.level);
			ansi2("me", 0, 0);
		}
	}
	else{
		sprintf(entry, "%s/%d", BRETT, a);
		unlink(entry);
		if(arg[strlen(arg) -1] != '-'){
			printf("\n\n%s\n", MI203_MSG);		
			sprintf(entry, "%s %s -x", MB_DAEMON, NG);
			system(entry);
		}
	}
	return;
  }

  if(USER.level == GUEST_LEV){
	return;
  }

  sprintf(entry, "%s/usr/%c/%d/%d", HOME, USER.name[0], USER.id, a);
  sprintf(index, "%s/usr/%c/%d/INDEX", HOME, USER.name[0], USER.id);

  sprintf(s, "%s/loe%d", TMP, getpid());
  ff = fopen(s, "w");

  fp = fopen(index, "r");
  if (fp == NULL) {
	nerror("misc2.c", 109, "loeschen", "Can't read", index);
  }
  ok = 0;

  while (fgets(ex, LONGSTRING, fp) != NULL) {
	if (atoi(ex) != a)
		fputs(ex, ff);
	else
		ok = 1;
  }
  fclose(fp);
  fclose(ff);

  sprintf(t, "cp %s %s", s, index);
  system(t);
  unlink(s);
#ifndef _NOBACKUP
  if(a < 100000){
	sprintf(s, "cp %s %s/tmp/%d.%d.DEL", entry, HOME, USER.id, a);
	system(s);
  }
#endif
  unlink(entry);
}



int do_toggle( value )
int value;
{
  if(value == 1){
	if(ansi2( "X2", 0, 0 ) != 0) ansi2( "us", 0, 0 );	
	return 0;
  }
  else{
	ansi2( "me", 0, 0 );
	ansi2( "X3", 0, 0 );
	return 1;
  }
}

static int sigs_fault;


/* #BR - Switch from one newsgroup to another.

   [arg]   ->  '!'        = name of the group and a short description
               ''         = display new groups
               '*'        = display all groups (depends on user level)
               '#'        = display all hierachies
               '..'       = switch to a previous group/level
               '^'        = show all groups (NOT depending on levels)
               'newgroup' = switch to this group */

/*
void brett(arg)  Compiler Bug ???? 
*/
brett(arg)
UNSIGNED char arg[];
{
  FILE *fp;
  FILE *ff;
  UNSIGNED char s[STRING];
  UNSIGNED char o[STRING];
  int a, h;
  UNSIGNED char t[STRING];
  UNSIGNED char org[STRING];
  UNSIGNED char maybe[STRING];
  int this;
  int i, j;
  int subboard = 0;
  UNSIGNED char c;
  int plus = 0;
  int zeile = 0;
  int toggle = 1;
  int wide = 0; 
  int first = 0;
  int fpid;

  if (arg[0] == '!') {
	printf("\n\n");
	ansi2( "md", 0, 0 );
	printf("%s", MI204_MSG);
	ansi2( "me", 0, 0 );
	printf(" %s\n", NG);
	ansi2( "md", 0, 0 );
	printf("%s", MI204aMSG);
	ansi2( "me", 0, 0 );
	printf(" ");	

	if(strcomp(BRETT, "PM") == 0){
		printf("%s", MI204bMSG);
	}
	else{
		fp = fopen( NEWSGROUPS, "r" );
		if(fp == NULL){
			nerror("misc2.c", 190, "brett", "Can't read", NEWSGROUPS);
		}
		h = 0;
		while((h == 0) && (fgets(s, STRING, fp) != NULL)){
			if(strcomp(NG, s) == 0){
				a = 0; 
				while(s[a] > 32) a++;
				while(s[a] < 32) a++;
				strcpy(t, (UNSIGNED char *) strcopy(s, a, STRING)); 
				printf("%s", (UNSIGNED char *) stripped(t));
				h++;
			}
		}
		fclose(fp);
	}
	printf("\n");
	return;
  }
  if ((arg[0] == '+') || (arg[0] == '-')) {
	scanner(arg[0] + 255);
	return;
  }
  if (arg[0] == '\0') {
	maybe_locked(UGROUPS, "r");
	fp = fopen(UGROUPS, "r");
	if (fp == NULL) {
		nerror("misc2.c", 242, "brett", "Can't read", UGROUPS);
	}
	arg[0] = '*';
  }
  else {
	if (arg[0] == '^') {
		maybe_locked(NGROUPS, "r");
		fp = fopen(NGROUPS, "r");
		if (fp == NULL) {
			nerror("misc2.c", 251, "brett", "Can't read", NGROUPS);
		}
	}
	else{
		maybe_locked(SGROUPS, "r");
		fp = fopen(SGROUPS, "r");
		if (fp == NULL) {
			nerror("misc2.c", 258, "brett", "Can't read", SGROUPS);
		}
	}
  }
  if((strcomp(CDROMNG, NG) == 0) && (arg[0] >= 65) && (arg[0] == '~')){
	sprintf(s, "%s/%s/CDDIR.%d", HOME, TMP, getpid());
	if(fp != NULL) fclose(fp);
	fp = fopen(s, "r");
	if (fp == NULL) {
		nerror("misc2.c", 274, "brett", "Can't read", s);
	}
  }

  sigs_fault = 0;
  area_fault = 0;
  strcpy(org, (UNSIGNED char *) arg);

  if (arg[0] == '.') {
	i = 0;
	j = 0;
	strcpy(org, NG);
	while (org[i] != '\0') {
		if (org[i] == '.') j = i;
		i++;
	}
	if (j == 0){
		if(fp != NULL) fclose(fp);
		return;
	}
	org[j] = '\0';
  }
  if (arg[0] == '#') subboard++;

  zeile = 0;

  show(NGROUPS, 99, 99); /* RESET */

  if ((arg[0] == '*') || (arg[0] == '+') || (arg[0] == '#') || (arg[0] == '~') || (arg[0] == '^')) {

	if(USE_AREAS == 0) 
		if(arg[0] != '^'){
			sprintf(s, "%s %d) ", MI205_MSG, USER.level);
		}
		else{
			sprintf(s, "%s 10) ", MI205_MSG);
		}
	else
		if(arg[0] != '^'){
			sprintf(s, "%s %d, %s \"%s\")", MI205_MSG, USER.level, MI209_MSG, AREA);
		}
		else{
			sprintf(s, "%s 10, %s \"%s\")", MI205_MSG, MI209_MSG, AREA);
		}


	headline(s);
	i = 0;
	strcpy(o, (UNSIGNED char *) "OOPS");

	if(USER.terminal == ISO6429)
		toggle = do_toggle( toggle );


	while (fscanf(fp, "%s %d %d %s", s, &a, &h, t) > 0) {
#ifdef _CNEWS
		if(t[0] == '=') 	
			continue; 
#endif
		
		if((chk_area( s ) != 1) && (arg[0] != '^')) continue;
	

		if (arg[0] == '~') {
			if (strcomp(NG, s) != 0) continue;
		}
		if ((strcomp(o, s) != 0) || (subboard == 0)) {
			if (subboard != 0) {
				j = subb(s);
				if (j != 0) s[j] = '\0';
				o[0] = '\0'; strcat(o, s);
			}

			if(first == 0){
				first = 1;
				if(strlen(s) > ((STRING/USER.schluessel[1]) -2)) wide = 1;
			}

			if ((arg[0] == '^') || (arg[0] == '*') || (arg[0] == '~')) {

				if(wide == 0){
					s[((STRING/USER.schluessel[1]) -2)] = '\0';
					strcat(s, "                                   ");
					s[((STRING/USER.schluessel[1]) -1)] = '\0';
					printf("%s", s);
					i++;
					plus++;
				}
				else{
					i = strlen(s);
					while(i < 78){
						s[i] = ' '; i++;
					}
					s[i] = '\0';
					printf("%s", s);
					plus++;
					i = USER.schluessel[1]; 
				}

				if (i == USER.schluessel[1]) {

					strcpy(s, "                                                                               ");
					s[79 - (i * (STRING/USER.schluessel[1] -1))] = '\0';
					printf("%s", s);

					ansi2( "me", 0, 0 );
					printf("\n");
					i = 0;				
					zeile++;
					if (zeile >= MAX_SCR_LINES) {
						zeile = 0;
						if(USER.more != 0){
							if (more() != 0) return (int) 1;
						}
					}
					if(USER.terminal == ISO6429)
						toggle = do_toggle( toggle );
				}
			}
		}
	}
	if(USER.terminal == ISO6429){
		if(i != 0){
			strcpy(s, "                                                                               ");
			s[79 - (i * (STRING/USER.schluessel[1] -1))] = '\0';
			printf("%s", s); 
		}
	}

	ansi2( "me", 0, 0 );
	if (plus == 0) {
		printf("%s", MI206_MSG);
	}
	printf("\n");
  }
  else {
	if (org[0] != '\0') {
	
		while(org[strlen(org) -1] == '.') org[strlen(org) -1] = '\0';
	 	do{
			i = sgrep( org, "..");
			if(i != 0){
				strcpy(s, (UNSIGNED char *) org);
				s[i] = '\0';
				strcat(s, (UNSIGNED char *) strcopy(org, i+1, strlen(org)));
				strcpy(org, (UNSIGNED char *) s);
			}
		}while(i != 0);	
		
		if(strcomp(CDROM_DUMMY, org) == 0){
			sprintf(s, "cdrom%s", strcopy( org, 14, strlen(org)));
			strcpy(org, (UNSIGNED char *) s);	
		}

		SO_WHAT: 

		strcpy(o, (UNSIGNED char *) org);

		i = 0;
		while (org[i] != '\0') {
			t[i] = org[i];
			if (t[i] == '.') t[i] = '/';
			i++;
		}
		t[i] = '\0';

		if(strcomp(CDROMNG, org) == 0){
			strcpy(s, (UNSIGNED char *) strcopy(org, (strlen(org) -4), strlen(org)));
			if(strcomp(".DIR", s) == 0){

				sprintf(s, "/%s", strcopy(t, 0, (strlen(t) - 5)));
				printf("\n");
				cdromB( s, 'I' );
				 
				strcpy(BRETT, s);
				sprintf(NG, "%s", strcopy(org, 0, (strlen(org) -5)));

				sprintf(s, "%s/%s/CDDIR.%d", HOME, TMP, getpid());		
				unlink( s );

				sprintf(INHALT, "%s/%s/CDIDX.%d", HOME, TMP, getpid());
				ff = fopen( INHALT, "r" );
				if(ff == NULL){
					sprintf(INHALT, "%s/%s/CDJNK.%d", HOME, TMP, getpid());
					ff = fopen( INHALT, "r" );
					if(ff == NULL){
						nerror("misc2.c", 403, "brett", "Can't read", INHALT);
					}
				}
				fclose(ff);

				return;	
			}
			else{
				sprintf(s, "/%s", t);
			}
 		} 
		else{
			sprintf(s, "%s/%s", NEWS, t);
		}

		if (chdir(s) != 0) {
			sprintf(o, "%s.%s", NG, org);
			i = 0;
			while (o[i] != '\0') {
				t[i] = o[i];
				if (t[i] == '.') t[i] = '/';
				i++;
			}
			t[i] = '\0';
			sprintf(s, "%s/%s", NEWS, t);
		}
		if (chdir(s) != 0) {
			this = 9999;
			maybe_locked(NGROUPS, "r");
			ff = fopen(NGROUPS, "r");
			if (ff == NULL) {
				nerror("misc2.c", 1001, "brett", "Can't read", NGROUPS);
			}
			maybe[0] = '\0';
			while (fscanf(ff, "%s %d %d %s", s, &i, &i, t) > 0) {
				i = strcomp(org, s);
				if (i < this) {
					this = i;
					strcpy(maybe, s);
				}
			}
			fclose(ff);
			sprintf(s, "%s/%s/CDDIR.%d", HOME, TMP, getpid());		
			ff = fopen(s, "r");
			if (ff != NULL) {
				sprintf(org, "%s.%s", NG, arg);
				while (fscanf(ff, "%s %d %d %s", s, &i, &i, t) > 0) {
					i = strcomp(org, s);
					if (i < this) {
						this = i;
						strcpy(maybe, s);
						INHALT[0] = '\0';
					}
				}
				fclose(ff);
			}
			strcpy(org, maybe);
			printf("\n\n");
			ansi2("mr", 0, 0);
			printf("%s \"%s\" [%c, %c] >", MI207_MSG, maybe, GBL06_MSG, GBL07_MSG);
			ansi2("me", 0, 0);
			printf(" ");

			c = yesno();
			
			if (c != GBL07_MSG) goto SO_WHAT;

			printf("\n");
		}
		else {
			if ((chk_newsgrp(o) == 0) && (chk_adult(o) != -1) &&
			    (chk_sigs(o) != -1)   && (chk_area(o) == 1)) {

				strcpy(BRETT, s); 
				printf("\n");
				sprintf(NG, "%s", o);
				if(strlen(o) > 14){
#ifndef _LONGNAMES
					strcpy(o, (UNSIGNED char *) shortname(o));
#endif
				}
				if((strcomp(CDROMNG, org) == 0) || (strcomp(CDROMNG, NG) == 0)){
					cdromB( BRETT, 'I' );					
				}
				else{
					chdir(HOME);
					sprintf(INHALT, "%s/%s", LIB, o);
					ff = fopen( INHALT, "r" );
					if(ff == NULL){

						sprintf(s, "ls -1 %s > ./tmp/ls.%d", BRETT, getpid());
						system( s );
						sprintf(s, "./tmp/ls.%d", getpid());

						ff = fopen( s, "r" );
						if(ff == NULL){
							nerror("misc2.c", 568, "brett", "Can't read", s);
						}
						fgets(s, STRING, ff);
						fclose(ff);	
						i = 0;	
						if(atoi(s) == 0) i = 1;
						sprintf(s, "./tmp/ls.%d", getpid());
						unlink( s );
						if(i == 1) goto NANG; /* It's just a directory, not a newsgroup! */

						printf("\n%s ..", MI211_MSG);
						switch( (fpid = fork()) ){
							case -1 :
								break;
							case  0 : while(1){
									printf(".");
									sleep(1);
							  	  }	
							break;
						}
						chdir(HOME);
						sprintf(s, "%s %s -x", MB_DAEMON, NG);
						system( s );
						kill( fpid, SIGKILL );
						(void) wait( &fpid );
						printf("\n");	

						NANG:
					}
				 	else fclose(ff);	
				}	
	
				if(strcomp(CDROMNG, NG) != 0){				
					ansi2( "us", 0, 0 );
					sprintf(s, "%s/.mbox", BRETT);
					if(prf(s) != -1) printf("\n");
					show_raw( s, 0 );
					ansi2( "me", 0, 0 );
				}
			} else {
				ansi2("md", 0, 0);
				if(sigs_fault == 1)
					printf(" %s\n", MI212_MSG);
				else
					if(area_fault == 1){
						printf(" %s\n", MI213_MSG);
						intuition( 750 );
					}
					else				
						printf(" %s\n", MI210_MSG);
				ansi2("me", 0, 0);

				if(MENUE_USING != 0){
					printf("\n\n"); 
					fido_prompt( SUB25_MSG );
					(void) getint();
				}
			}
		}
		chdir(HOME);
		CURI_SIZE = 0L;
	}
  }
  fclose(fp);
  ansi2( "me", 0, 0 );
  return;
}





/* #FR - Search the address of the receiver of a reply.

   [REP] contains the path to a reply file.

   This function returns the address of the receiver. */

UNSIGNED char *fetch_reciepy(REP)
UNSIGNED char REP[];
{
  FILE *fp;
  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING];
  UNSIGNED char f[STRING];
  int ok = 0, i;
  int beg = 0;
  int bang = 0, at = 0, strange = 0, stranger = 0, gate = 0;

  fetch_local = 0;
  fetch_subj[0] = '\0';

  fp = fopen(REP, "r");
  if (fp == NULL) {
	nerror("misc2.c", 31, "fetch_reciepy", "Can't read", REP);
  }
  while (fgets(f, STRING, fp) != NULL) {
	if (strcomp("From: ", f) == 0) {
		beg = 6;
		ok = 1;
		strcpy(s, f);
	}
	/*
	if (strcomp("From ", f) == 0) {
		beg = 5; 
		ok = 1;
		strcpy(s, f);
	}
	*/
	if (strcomp("Reply-To: ", f) == 0) {
		beg = 10;
		ok = 1;
		strcpy(s, f);
	}
	if (strcomp("Subject: ", s) == 0) {
		strcpy(fetch_subj, (UNSIGNED char *) strcopy(s, 9, 79));
	}
  }
  fclose(fp);

  if (ok == 0) {
	return (UNSIGNED char *) "OOPS";
  }
  i = beg;
  ok = 0;

  while (s[i] != '\0') {
	if (s[i] == '(') ok = i - 2;
	if (s[i] == '<') strange = i + 1;
	if (s[i] == '>') stranger = i - 1;
	i++;
  }
  if (ok == 0) ok = i;
  strcpy(t, (UNSIGNED char *) strcopy(s, beg, ok));

  if ((strange != 0) && (stranger != 0)) {
	strcpy(t, (UNSIGNED char *) strcopy(s, strange, stranger));
	return (UNSIGNED char *) t;
  }
  i = 0;
  while (t[i] != '\0') {
	if (t[i] == '@') at = i;
	if (t[i] == '!') bang = i;
	if (t[i] == '%') gate = i;
	i++;
  }

  if ((at != 0) && (gate == 0)) {
	strcpy(s, (UNSIGNED char *) strcopy(t, (at + 1), strlen(t)));
	if (strcomp(UUCPSITE, s) == 0) {	/* local user */
		fetch_local = 1;
		strcpy(s, (UNSIGNED char *) strcopy(t, 0, (at - 1)));
		i = 0;
		while (s[i] != '\0') {
			if (s[i] == '.') s[i] = ' ';
			i++;
		}
		return (UNSIGNED char *) s;
	}
  }

  if (beg == 5) {  /* local mail */
	i = 0;
	while((t[i] != '\0') && (t[i] != ' ')) i++;
	t[i] = '\0';
  }

  return (UNSIGNED char *) t;
}


/* #PU - Check whether a comand a is "premium" service.

   [CMD] is the comand to be verified.

   This function returns 1 if the comand is "premium" and the 
   user is allowed to use it. It returns -1 if it is "premium"
   but the user is NOT allowed to use it. A 0 means, the comand
   is not a "premium" service.  */

int is_premium( cmd, mode )
UNSIGNED char cmd[];
int mode;
{
  UNSIGNED char s[STRING];
  FILE *fp;
  int ok = -1;


  sprintf(s, "./etc/sigs+areas/%s.sig", (UNSIGNED char *) lowcased(cmd));

  fp = fopen( s, "r" );
  if(fp == NULL){
	return 0;
  } 

  while(fgets(s, STRING, fp) != NULL){
	if(atoi(s) == USER.id) ok = 1;
  } 
  fclose(fp);

  if((mode == 0) && (ok == -1)){
	ansi2( "md", 0, 0 );
	printf(" %s", MI212_MSG);
	ansi2( "me", 0, 0 );
	printf("\n");
  }

  return (int) ok; 
}


/* #CC - Check whether a newsgroup belongs to a SIG.
 
   This function returns -1 if one is not allowed to enter the group. */

int chk_sigs( group )
UNSIGNED char group[];
{
  UNSIGNED char s[STRING];
  UNSIGNED char p[STRING];
  int ok = 0;

  FILE *fp;

  sprintf(s, "%s/etc/sigs+areas/list.sigs", HOME);

  fp = fopen( s, "r" );
  if (fp == NULL) {
	nerror("misc2.c", 712, "chk_sigs()", "Can't read", s);
  }
  while((fgets(s, STRING, fp) != 0) && (s[0] == '#'));
  while(fgets(s, STRING, fp) != 0){
	if(strlen(s) > 3){
		strcpy(p, (UNSIGNED char *) stripped(s));
		if(strcomp(p, group) == 0){
			ok = -1;
			while((fgets(s, STRING, fp) != 0) && (atoi(s) != 0)){
				if(atoi(s) == USER.id) ok = 0;	
			}
		}
	}
  }
  fclose(fp);
 
  if(ok == -1) sigs_fault++;  

  return ok;
}




/* #AE - Divide the whole "world" intro areas

	 " "		-  Check whether areas should be used, first
			   AREA in list is activated
         ""             -  Name current area
	 "*"		-  List available areas
	 "!"		-  AREA-Mode on/off
	 "area"         -  Change area to "area"

*/

area( arg )
UNSIGNED char arg[];
{
  FILE *fp;

  UNSIGNED char s[STRING];
  UNSIGNED char t[STRING]; 
  int i, j;

 
  USE_AREAS = 0;

  sprintf(t, "%s/etc/sigs+areas/list.areas", HOME);

  fp = fopen( t, "r" );
  if(fp == NULL){
	USER.schluessel[4] = 123;
	return;
  }

  if(USER.schluessel[4] != 123) USE_AREAS = 1;

  if(arg[0] == '!'){
	printf("\n\n");
	ansi2("md", 0, 0 );
	printf("%s: ", MI218_MSG);
	ansi2("me", 0, 0 );

	if(USER.schluessel[4] == 123){
		USER.schluessel[4] = 1;
		printf("%s\n", MI219_MSG);
	}
	else{
		USER.schluessel[4] = 123;
		printf("%s\n", MI220_MSG);
	}
	USE_AREAS = 0; 
	if(USER.schluessel[4] != 123) USE_AREAS = 1;
	return;
  }

  if(arg[0] == '\0'){
	printf("\n\n");
	ansi2( "md", 0, 0 );
	printf("%s: ", MI214_MSG);
	ansi2( "me", 0, 0 );
	printf("%s", AREA );
	if(USE_AREAS != 1) printf(" %s", MI215_MSG);
	printf("\n");
	return; 
  }

  if(arg[0] == '*'){

	if(USE_AREAS != 1)
		sprintf(t, " AREAs Level (%d) - %s", USER.level, MI215_MSG );
	else
		sprintf(t, " AREAs Level (%d) ", USER.level);
	
	headblock( t, MI217_MSG );

	while(fgets(s, STRING, fp) != 0){
		if(strcomp("AREA", s) == 0){
			strcpy(t, (UNSIGNED char *) strcopy(s, 5, strlen(s)));
			i = 1;
			while((t[i] != ' ') && (t[i] != '\0')) i++;
			t[i] = '\0';
			printf("%-20s%s", t,(UNSIGNED char *) strcopy(s, (i+6), strlen(s)));
		}
	}
	fclose(fp);
	return;
  }
  
  sprintf(t, "AREA %s", arg ); if(t[5] == ' ') t[5] = '\0';

  while(fgets(s, STRING, fp) != 0){
	if(strcomp(t, s) == 0){
		strcpy(AREA, (UNSIGNED char *) stripped( strcopy(s, 5, strlen(s))));
		i = 1;
		while((AREA[i] != ' ') && (AREA[i] != '\0')) i++;
		AREA[i] = '\0';
		i = 0;
		while((fgets(s, STRING, fp) != 0) && (strcomp("AREA", s) != 0)){
			strcpy(AREACONT[i], (UNSIGNED char *) stripped(s));
			i++;
			if(i > MAX_AREACONT){
				nerror("misc2.c", 814, "area", "Overflow! Definition MAX_AREACONT ...", "");
				i = MAX_AREACONT;
			}
			for(j = i; j < MAX_AREACONT; j++)
				AREACONT[j][0] = '\0';
		}
		fclose(fp);
		if(arg[0] != ' '){
			scanner( ('+' + 255) );
		}
		return;
	}
  }
 
  ansi2( "md", 0, 0 );
  printf(" %s\n", MI216_MSG);
  ansi2( "me", 0, 0 );
  intuition( 750 );
}


int chk_area( group )
UNSIGNED char group[];
{
  int i = 0, ok = 0;

  if(USE_AREAS == 0) return (int) 1;

  for(i = 0; i < MAX_AREACONT; i++){
	if((strcomp(AREACONT[i], group) == 0) &&
	   (strlen(AREACONT[i]) > 1)) ok = 1;
  }

  area_fault = 1;

  return (int) ok;
}
